/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URL;
import java.util.ArrayList;
import jtp.DirectAssertion;
import jtp.KnowledgeStore;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.fol.rdf.JenaObjectConverter;
import jtp.gmp.ModusPonensProofStep;
import jtp.gmp.Utils;
import jtp.rs.ArrayReasoningStepIterator;

public class JenaStore
extends JenaObjectConverter
implements KnowledgeStore {
    protected Model model;
    protected Reasoner asker;
    protected Reasoner teller;

    public JenaStore() {
        this(ModelFactory.createDefaultModel());
    }

    public JenaStore(Model model) {
        this.model = model;
    }

    public Reasoner getAskingReasoner() {
        if (this.asker == null) {
            this.asker = new Asker();
        }
        return this.asker;
    }

    public Reasoner getTellingReasoner() {
        if (this.teller == null) {
            this.teller = new Teller();
        }
        return this.teller;
    }

    public Property makeProperty(Symbol symbol) {
        return this.model.getProperty(symbol.getPackage() + symbol.getName());
    }

    public RDFNode makeRDFNode(Object object) {
        if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            return this.model.getResource(symbol.getPackage() + symbol.getName());
        }
        return this.model.createLiteral(object);
    }

    private class ReusableDirectAssertion
    extends DirectAssertion {
        public ReusableDirectAssertion(URL uRL) {
            super(null, uRL);
            this.setAsserted(true);
        }

        public void setGoal(Object object) {
            this.goal = object;
        }
    }

    protected class Teller
    implements Reasoner {
        protected Teller() {
        }

        public boolean acceptable(Object object) {
            if (!(object instanceof DirectAssertion)) {
                return false;
            }
            DirectAssertion directAssertion = (DirectAssertion)object;
            if (directAssertion.isAsserted() || !(directAssertion.getGoal() instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)directAssertion.getGoal();
            return literal.isPositive() && literal.getArgs().size() == 2 && !(literal.getArgs() instanceof Unifyable);
        }

        public ReasoningStepIterator process(Object object) throws ReasoningException {
            DirectAssertion directAssertion = (DirectAssertion)object;
            Literal literal = (Literal)directAssertion.getGoal();
            Property property = JenaStore.this.makeProperty(literal.getRelation());
            if (property == null) {
                return ArrayReasoningStepIterator.empty;
            }
            RDFNode rDFNode = JenaStore.this.makeRDFNode(literal.getArgs().get(0));
            if (!(rDFNode instanceof Resource)) {
                return ArrayReasoningStepIterator.empty;
            }
            Resource resource = (Resource)rDFNode;
            rDFNode = JenaStore.this.makeRDFNode(literal.getArgs().get(1));
            if (rDFNode == null) {
                return ArrayReasoningStepIterator.empty;
            }
            try {
                JenaStore.this.model.add(resource, property, rDFNode);
                directAssertion.setAsserted(true);
                return ArrayReasoningStepIterator.empty;
            }
            catch (RDFException rDFException) {
                throw new ReasoningException(rDFException.toString());
            }
        }
    }

    protected class StmtIteratorAdapter
    implements ReasoningStepIterator {
        Literal goal;
        StmtIterator stIt;
        ReusableDirectAssertion rds;
        ModusPonensProofStep mps;
        ArrayList varStack;

        public StmtIteratorAdapter(Literal literal, StmtIterator stmtIterator) {
            this.rds = new ReusableDirectAssertion(null);
            this.mps = null;
            this.varStack = new ArrayList();
            this.goal = literal;
            this.stIt = stmtIterator;
        }

        /*
         * Unable to fully structure code
         */
        public ReasoningStep next() throws ReasoningException {
            if (this.stIt != null) ** GOTO lbl9
            return null;
lbl-1000:
            // 1 sources

            {
                this.rds.setGoal(JenaStore.this.makeLiteral(this.stIt.nextStatement()));
                var1_1 = Utils.deriveFrom(this.goal, this.rds, this.varStack, this.mps);
                if (var1_1 == null) continue;
                if (this.mps == null && var1_1 instanceof ModusPonensProofStep) {
                    this.mps = (ModusPonensProofStep)var1_1;
                }
                return var1_1;
lbl9:
                // 2 sources

                ** while (this.stIt.hasNext())
            }
lbl10:
            // 1 sources

            this.stIt.close();
            this.stIt = null;
            return null;
        }
    }

    protected class Asker
    implements Reasoner {
        protected Asker() {
        }

        public boolean acceptable(Object object) {
            if (!(object instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)object;
            return literal.isPositive() && literal.getArgs().size() == 2;
        }

        public ReasoningStepIterator process(Object object) throws ReasoningException {
            Literal literal = (Literal)object;
            Property property = JenaStore.this.makeProperty(literal.getRelation());
            Resource resource = null;
            Object e = literal.getArgs().get(0);
            if (e instanceof Symbol) {
                resource = (Resource)JenaStore.this.makeRDFNode(e);
            } else if (!(e instanceof Unifyable)) {
                return ArrayReasoningStepIterator.empty;
            }
            RDFNode rDFNode = null;
            e = literal.getArgs().get(1);
            if (!(e instanceof Unifyable) && (rDFNode = JenaStore.this.makeRDFNode(e)) == null) {
                return ArrayReasoningStepIterator.empty;
            }
            if (resource != null && rDFNode != null) {
                if (JenaStore.this.model.contains(resource, property, rDFNode)) {
                    return new ArrayReasoningStepIterator(new DirectAssertion(literal));
                }
                return ArrayReasoningStepIterator.empty;
            }
            return new StmtIteratorAdapter(literal, JenaStore.this.model.listStatements((Selector)new SimpleSelector(resource, property, rDFNode)));
        }
    }
}

