/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.rdf;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.Symbol;

public class JenaObjectConverter {
    protected Map anonIdMap = new HashMap();
    protected int anonCounter = 0;
    protected String anonPrefix;
    static final String DEFAULT_ANON_PREFIX = "Anon_" + System.currentTimeMillis() + '_';

    public JenaObjectConverter(String string) {
        this.anonPrefix = string;
    }

    public JenaObjectConverter() {
        this(DEFAULT_ANON_PREFIX);
    }

    public String getPrettyAnonId(AnonId anonId) {
        String string = (String)this.anonIdMap.get(anonId);
        if (string == null) {
            string = this.anonPrefix + this.anonCounter++;
            this.anonIdMap.put(anonId, string);
        }
        return string;
    }

    public String getPrettyAnonId() {
        return this.anonPrefix + this.anonCounter++;
    }

    public Symbol makeSymbol(Resource resource) {
        return Symbol.newSymbol(resource.isAnon() ? this.getPrettyAnonId(resource.getId()) : resource.getLocalName(), resource.getNameSpace());
    }

    public Object makeConstant(RDFNode rDFNode) {
        if (rDFNode instanceof Resource) {
            return this.makeSymbol((Resource)rDFNode);
        }
        String string = null;
        if (rDFNode instanceof com.hp.hpl.jena.rdf.model.Literal) {
            com.hp.hpl.jena.rdf.model.Literal literal = (com.hp.hpl.jena.rdf.model.Literal)rDFNode;
            Object object = literal.getValue();
            if (!(object instanceof String)) {
                return object;
            }
            string = literal.getString().trim();
        } else {
            string = rDFNode.toString().trim();
        }
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException2) {
                return string;
            }
        }
    }

    public Literal makeLiteral(Statement statement) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(this.makeSymbol(statement.getSubject()));
        arrayList.add(this.makeConstant(statement.getObject()));
        return new DefaultLiteral(this.makeSymbol((Resource)statement.getPredicate()), arrayList, true);
    }
}

