/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.kif;

import antlr.ASTFactory;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtp.fol.Symbol;
import jtp.fol.kif.CNFConverterTokenTypes;

class VariableManager
implements CNFConverterTokenTypes {
    private static final int HASHSIZE = 10;
    private Map names2symbols = new HashMap(10);
    private Set symbols = new HashSet(10);
    private List stack = new ArrayList(5);
    ASTFactory factory;

    public VariableManager(ASTFactory aSTFactory) {
        this.factory = aSTFactory;
    }

    public void clear() {
        this.names2symbols.clear();
        this.symbols.clear();
        this.stack.clear();
    }

    public void push(String string, boolean bl) {
        String string2 = this.register(string, bl);
        this.symbols.add(string2);
        this.stack.add(string);
        AST aST = null;
        if (bl) {
            aST = this.factory.create(30, string2);
        } else {
            AST aST2 = this.factory.create(32, string2);
            aST2.setFirstChild(this.factory.create(33, "Skolem"));
            aST = this.factory.create(25);
            aST.setFirstChild(aST2);
        }
        this.stack.add(aST);
        this.stack.add(this.names2symbols.put(string, aST));
    }

    public void pop() {
        AST aST = (AST)this.stack.remove(this.stack.size() - 1);
        this.stack.remove(this.stack.size() - 1);
        String string = (String)this.stack.remove(this.stack.size() - 1);
        AST aST2 = this.names2symbols.put(string, aST);
    }

    public AST lookup(String string) {
        String string2;
        AST aST = (AST)this.names2symbols.get(string);
        if (aST == null) {
            string2 = this.register(string, true);
            this.symbols.add(string2);
            aST = this.factory.create(30, string2);
            this.names2symbols.put(string, aST);
        }
        this.mention(aST);
        string2 = this.factory.dup(aST);
        string2.setFirstChild(aST.getFirstChild());
        return string2;
    }

    private void mention(AST aST) {
        if (aST.getType() == 25) {
            AST aST2 = aST.getFirstChild().getNextSibling();
            while (aST2 != null) {
                this.mention(aST2);
                aST2 = aST2.getNextSibling();
            }
            return;
        }
        int n = this.stack.size() - 2;
        while (n >= 0) {
            block6: {
                AST aST3 = (AST)this.stack.get(n);
                if (aST.equals(aST3)) break;
                if (aST3.getType() != 30) {
                    AST aST4 = null;
                    aST4 = aST3.getFirstChild();
                    while (aST4.getNextSibling() != null) {
                        if (!aST4.getNextSibling().equals(aST)) {
                            aST4 = aST4.getNextSibling();
                            continue;
                        }
                        break block6;
                    }
                    aST4.setNextSibling(this.factory.dup(aST));
                }
            }
            n -= 3;
        }
    }

    private String register(String string, boolean bl) {
        while (this.symbols.contains(string) || !bl && Symbol.getSymbol(string, "Skolem") != null) {
            string = this.incrementName(string);
        }
        return string;
    }

    private String incrementName(String string) {
        int n = string.lastIndexOf(95);
        if (n == -1) {
            return string + "_0";
        }
        try {
            int n2 = Integer.parseInt(string.substring(n + 1, string.length()));
            return string.substring(0, n + 1) + (n2 + 1);
        }
        catch (NumberFormatException numberFormatException) {
            return string + "_0";
        }
    }
}

