/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.kif;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jtp.fol.Symbol;

public class SymbolFormat
extends Format {
    Map packageNameSpaceMap = new TreeMap();
    Map inversePackageNameSpaceMap = new TreeMap();
    private static final String OTHER_GOOD_CHARS = "$_+-*/@%^&=<>~.";

    public Map getPackageNameSpaceMap() {
        return this.packageNameSpaceMap;
    }

    public void setPackageNameSpaceMap(Map map) {
        this.packageNameSpaceMap = map;
        if (map != null) {
            this.buildInverseNameSpaceMap();
        } else {
            this.inversePackageNameSpaceMap = null;
        }
    }

    private void buildInverseNameSpaceMap() {
        if (this.inversePackageNameSpaceMap == null) {
            this.inversePackageNameSpaceMap = new HashMap();
        } else {
            this.inversePackageNameSpaceMap.clear();
        }
        Iterator iterator = this.packageNameSpaceMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = this.packageNameSpaceMap.get(k);
            if (this.inversePackageNameSpaceMap.containsKey(v)) {
                throw new IllegalArgumentException("Two names (" + k + "," + this.inversePackageNameSpaceMap.get(v) + ") map to the same package " + v);
            }
            this.inversePackageNameSpaceMap.put(v, k);
        }
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Symbol parse(String string) {
        return this.parse(string, new ParsePosition(0));
    }

    public Symbol parse(String string, ParsePosition parsePosition) {
        return null;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Symbol)object, stringBuffer);
    }

    public StringBuffer format(Symbol symbol, StringBuffer stringBuffer) {
        if (symbol.getPackage() != null) {
            String string = symbol.getPackage();
            String string2 = (String)this.inversePackageNameSpaceMap.get(string);
            string = string2 != null ? string2 : string;
            SymbolFormat.printName(string, stringBuffer);
            stringBuffer.append("::");
        }
        SymbolFormat.printName(symbol.getName(), stringBuffer);
        return stringBuffer;
    }

    private static void printName(String string, StringBuffer stringBuffer) {
        int n = 0;
        while (n < string.length()) {
            if (!SymbolFormat.isGoodChar(string.charAt(n))) {
                SymbolFormat.escapeName(string, stringBuffer);
                return;
            }
            ++n;
        }
        stringBuffer.append(string.toLowerCase());
    }

    private static void escapeName(String string, StringBuffer stringBuffer) {
        stringBuffer.append('|');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '|' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append('|');
    }

    private static boolean isGoodChar(char c) {
        return Character.isUpperCase(c) || Character.isDigit(c) || OTHER_GOOD_CHARS.indexOf(c) >= 0;
    }
}

