/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.kif;

import antlr.ANTLRException;
import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jtp.fol.Clause;
import jtp.fol.DefaultClause;
import jtp.fol.kif.CNFConverter;
import jtp.fol.kif.KIFLexer;
import jtp.fol.kif.KIFParser;
import jtp.fol.parser.ClauseIterator;
import jtp.fol.parser.FirstOrderLogicParser;
import jtp.fol.parser.FirstOrderLogicTranslator;
import jtp.fol.parser.ParserBasedTranslator;
import jtp.fol.parser.ParsingException;

public class KIF2CNF
implements FirstOrderLogicParser {
    CNFConverter cnv = new CNFConverter();
    Map nsMap = new HashMap();
    boolean polarity = true;
    boolean defaultUpperCase = false;
    boolean caseSensitiveSymbols = false;

    public KIF2CNF() {
        this.cnv.cg.nsMap = this.nsMap;
    }

    public void addNamespaceMapping(String string, String string2) {
        this.nsMap.put(string, string2);
    }

    public void removeNamespaceMapping(String string) {
        this.nsMap.remove(string);
    }

    public Map getNamespaceMap() {
        return Collections.unmodifiableMap(this.nsMap);
    }

    public ClauseIterator parse(URL uRL) throws ParsingException {
        try {
            return this.parse(new BufferedReader(new InputStreamReader(uRL.openStream())));
        }
        catch (IOException iOException) {
            throw new ParsingException(iOException);
        }
    }

    public ClauseIterator parse(Reader reader) {
        return new Stream(reader);
    }

    public ClauseIterator parse(Reader reader, URL uRL) {
        return this.parse(reader);
    }

    public ClauseIterator parse(URL uRL, URL uRL2) throws ParsingException {
        return this.parse(uRL);
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public void setPolarity(boolean bl) {
        this.polarity = bl;
    }

    public String getLanguage() {
        return "KIF";
    }

    public boolean getDefaultUpperCase() {
        return this.defaultUpperCase;
    }

    public void setDefaultUpperCase(boolean bl) {
        this.defaultUpperCase = bl;
    }

    public boolean isCaseSensitiveSymbols() {
        return this.caseSensitiveSymbols;
    }

    public void setCaseSensitiveSymbols(boolean bl) {
        this.caseSensitiveSymbols = bl;
    }

    public static FirstOrderLogicTranslator createTranslator() {
        return new ParserBasedTranslator(new KIF2CNF());
    }

    class Stream
    implements ClauseIterator {
        Iterator cit = Collections.EMPTY_LIST.iterator();
        KIFParser parser;
        int i = 1;

        public Stream(Reader reader) {
            KIFLexer kIFLexer = new KIFLexer(reader);
            kIFLexer.caseSensitiveSymbols = KIF2CNF.this.isCaseSensitiveSymbols();
            kIFLexer.defaultUpperCase = KIF2CNF.this.getDefaultUpperCase();
            this.parser = new KIFParser(kIFLexer);
        }

        protected boolean fetch() throws ParsingException {
            try {
                if (!this.cit.hasNext()) {
                    if (this.parser.eof()) {
                        return false;
                    }
                    AST aST = this.parser.nextSentence();
                    if (aST == null) {
                        return false;
                    }
                    this.cit = KIF2CNF.this.cnv.toCNF(aST, KIF2CNF.this.polarity).iterator();
                    return true;
                }
                return true;
            }
            catch (ANTLRException aNTLRException) {
                aNTLRException.printStackTrace();
                throw new ParsingException(aNTLRException);
            }
        }

        public boolean hasNext() throws ParsingException {
            return this.cit.hasNext() || this.fetch();
        }

        public Clause next() throws ParsingException {
            Collection collection;
            Clause clause;
            if (!this.cit.hasNext()) {
                this.fetch();
            }
            Clause clause2 = clause = (collection = (Collection)this.cit.next()).size() == 1 ? (Clause)collection.iterator().next() : new DefaultClause(collection);
            if (Boolean.getBoolean("jtp.fol.kif.KIF2CNF.printDebugSentences")) {
                System.out.println("[" + this.i++ + "] " + clause);
            }
            return clause;
        }
    }
}

