/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jtp.fol.SubstUtils;
import jtp.fol.Unifyable;

public class Variable
implements Unifyable,
Comparable,
Serializable {
    private long serialNumber;
    private Object value;
    private String name;
    static int variableCount = 0;
    private static boolean DEBUG_PRINTOUT = false;

    public Variable(String string) {
        this.name = string;
        this.serialNumber = variableCount++;
        this.value = null;
    }

    public Variable(String string, long l) {
        this.name = string;
        this.serialNumber = l;
    }

    public String getName() {
        return this.name;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (this.value != null && object != this.value) {
            throw new IllegalStateException("Trying to bind variable " + this + ", already bound to " + this.value + ", to " + object);
        }
        this.value = object;
        Variable variable = this;
        while (variable.value != null && variable.value instanceof Variable) {
            if (variable.value == this) {
                throw new Error("Circular dependency");
            }
            variable = (Variable)variable.value;
        }
    }

    public void unbind() {
        this.value = null;
    }

    public String toString() {
        if (DEBUG_PRINTOUT) {
            return this.debugPrintout();
        }
        return "?" + this.name;
    }

    public String debugPrintout() {
        StringBuffer stringBuffer = new StringBuffer("?" + this.name);
        stringBuffer.append('_').append(this.getSerialNumber());
        if (this.value != null) {
            stringBuffer.append("=" + this.value);
        }
        return stringBuffer.toString();
    }

    public boolean contains(Variable variable) {
        if (variable == this) {
            return true;
        }
        if (this.value instanceof Unifyable) {
            return ((Unifyable)this.value).contains(variable);
        }
        return false;
    }

    public Object deReferenceVariables() {
        if (this.value == null) {
            return this;
        }
        if (this.value instanceof Unifyable) {
            return ((Unifyable)this.value).deReferenceVariables();
        }
        return this.value;
    }

    public boolean unify(Object object, List list) {
        if (this.value == null) {
            if (object == this) {
                return true;
            }
            if (object instanceof Unifyable && ((Unifyable)object).contains(this)) {
                while (object != null && object != this && object instanceof Variable) {
                    object = ((Variable)object).value;
                }
                return object == this;
            }
            list.add(this);
            this.value = object;
            return true;
        }
        return SubstUtils.unify(this.value, object, list);
    }

    public Object substitute(Map map) {
        if (map.containsKey(this)) {
            return map.get(this);
        }
        if (this.value != null) {
            return SubstUtils.substitute(this.value, map);
        }
        return this;
    }

    public Collection getVariables(Collection collection) {
        if (collection == null) {
            collection = new ArrayList<Variable>();
        }
        collection.add(this);
        if (this.value instanceof Unifyable) {
            collection = ((Unifyable)this.value).getVariables(collection);
        }
        return collection;
    }

    public int compareTo(Object object) {
        return (int)(this.serialNumber - ((Variable)object).serialNumber);
    }

    static {
        try {
            if (Boolean.getBoolean("jtp.fol.Variable.DEBUG_PRINTOUT")) {
                DEBUG_PRINTOUT = true;
            }
        }
        catch (SecurityException securityException) {}
    }

    public static class NameComparator
    implements Comparator {
        public static final Comparator instance = new NameComparator();

        public int compare(Object object, Object object2) {
            return ((Variable)object).getName().compareTo(((Variable)object2).getName());
        }
    }
}

