/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol;

import java.io.Serializable;
import java.util.Hashtable;

public final class Symbol
implements Comparable,
Serializable {
    private static Hashtable symbolTable = new Hashtable();
    private String name;
    private String pkg;
    private transient int hashCode = 0;
    private static final String OTHER_GOOD_CHARS = "+-*/@%^&=<>~.$";

    private Symbol(String string, String string2) {
        this.name = string.intern();
        this.pkg = string2 != null ? string2.intern() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.pkg;
    }

    public static Symbol newSymbol(String string, String string2) {
        Symbol symbol = new Symbol(string, string2);
        Symbol symbol2 = (Symbol)symbolTable.get(symbol);
        if (symbol2 == null) {
            symbolTable.put(symbol, symbol);
            return symbol;
        }
        return symbol2;
    }

    public static Symbol uniqueSymbol(String string, String string2) {
        int n = 0;
        Symbol symbol = new Symbol(string, string2);
        while (symbolTable.get(symbol) != null) {
            symbol = new Symbol(string + '_' + n++, string2);
        }
        symbolTable.put(symbol, symbol);
        return symbol;
    }

    public static Symbol newSymbol(String string) {
        return Symbol.newSymbol(string, null);
    }

    public static Symbol getSymbol(String string, String string2) {
        return (Symbol)symbolTable.get(new Symbol(string, string2));
    }

    public String toString() {
        return this.pkg == null ? Symbol.printSymbol(this.name) : Symbol.printSymbol(this.pkg) + "::" + Symbol.printSymbol(this.name);
    }

    private static boolean isGoodChar(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c) || OTHER_GOOD_CHARS.indexOf(c) >= 0;
    }

    private static String escapeSymbol(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('|');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '|' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append('|');
        return stringBuffer.toString();
    }

    private static String printSymbol(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Symbol.isGoodChar(string.charAt(n))) {
                return Symbol.escapeSymbol(string);
            }
            ++n;
        }
        return string;
    }

    public boolean equals(Object object) {
        return object instanceof Symbol && ((Symbol)object).name == this.name && ((Symbol)object).pkg == this.pkg;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Symbol)) {
            throw new ClassCastException("Trying to compare a symbol with a " + object.getClass());
        }
        Symbol symbol = (Symbol)object;
        if (symbol.name != this.name) {
            return this.name.compareTo(symbol.getName());
        }
        if (this.pkg == null) {
            return symbol.getPackage() == null ? 0 : -1;
        }
        if (symbol.getPackage() == null) {
            return 1;
        }
        return this.pkg.compareTo(symbol.getPackage());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.name.hashCode();
            if (this.pkg != null) {
                this.hashCode += 17 * this.pkg.hashCode() + 7;
            }
        }
        return this.hashCode;
    }

    public Object clone() {
        return this;
    }

    private Object readResolve() {
        Object v;
        this.name = this.name.intern();
        if (this.pkg != null) {
            this.pkg = this.pkg.intern();
        }
        if ((v = symbolTable.get(this)) == null) {
            symbolTable.put(this, this);
            return this;
        }
        return v;
    }
}

