/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import jtp.Substitutable;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.DefaultClause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstitutableList;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.fol.UnifyableList;
import jtp.fol.Variable;
import jtp.fol.kif.SymbolFormat;
import jtp.util.ArrayMap;

public class SubstUtils {
    static SymbolFormat sf = new SymbolFormat();

    protected static Object substitute(Object object, Map map) {
        Object v = map.get(object);
        if (v != null) {
            return v;
        }
        if (object instanceof Substitutable) {
            return ((Substitutable)object).substitute(map);
        }
        return object;
    }

    static Collection substituteCollection(Collection collection, Map map) {
        Object object;
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (SubstUtils.substitute(object, map) == object) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return collection;
        }
        object = new ArrayList(collection.size());
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            ((ArrayList)object).add((Object)SubstUtils.substitute(iterator2.next(), map));
        }
        return object;
    }

    public static Literal substituteLiteral(Literal literal, Map map) {
        Symbol symbol = (Symbol)SubstUtils.substitute(literal.getRelation(), map);
        List list = literal.getArgs();
        if (!(list instanceof SubstitutableList)) {
            list = SubstUtils.createList(list);
        }
        SubstitutableList substitutableList = (SubstitutableList)SubstUtils.substitute(list, map);
        if (symbol != literal.getRelation() || substitutableList != list) {
            return new DefaultLiteral(symbol, substitutableList, literal.isPositive());
        }
        return literal;
    }

    public static final SubstitutableList createList(Collection collection) {
        if (collection instanceof SubstitutableList) {
            return (SubstitutableList)collection;
        }
        return SubstUtils.createList(collection.toArray());
    }

    static final SubstitutableList createList(Object[] objectArray) {
        boolean bl = true;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Substitutable) {
                bl = false;
            }
            if (objectArray[n] instanceof Unifyable) {
                return new UnifyableList(objectArray);
            }
            ++n;
        }
        return new SubstitutableList(objectArray);
    }

    public static final void unbindStack(List list, int n) {
        int n2 = list.size() - 1;
        while (n2 >= n) {
            Variable variable = (Variable)list.remove(n2);
            variable.unbind();
            --n2;
        }
    }

    public static String print(Object object) {
        if (object instanceof Literal) {
            return SubstUtils.printLiteral((Literal)object);
        }
        if (object instanceof Clause) {
            return SubstUtils.printClause((Clause)object);
        }
        if (object instanceof CNFSentence) {
            return SubstUtils.printCNFSentence((CNFSentence)object);
        }
        if (object instanceof Symbol) {
            return SubstUtils.printSymbol((Symbol)object);
        }
        if (object instanceof String) {
            return "\"" + object + '\"';
        }
        return String.valueOf(object);
    }

    public static final String printClause(Clause clause) {
        if (clause.literals().size() == 1) {
            return SubstUtils.printLiteral((Literal)clause.literals().iterator().next());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(or");
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(' ').append(SubstUtils.printLiteral((Literal)iterator.next()));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final String printLiteral(Literal literal) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!literal.isPositive()) {
            stringBuffer.append("(not ");
        }
        stringBuffer.append('(').append(SubstUtils.printSymbol(literal.getRelation()));
        Iterator iterator = literal.getArgs().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(' ').append(SubstUtils.print(iterator.next()));
        }
        stringBuffer.append(')');
        if (!literal.isPositive()) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static final String printCNFSentence(CNFSentence cNFSentence) {
        if (cNFSentence.clauses().size() == 1) {
            return SubstUtils.printClause((Clause)cNFSentence.clauses().iterator().next());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(and");
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(' ').append(SubstUtils.printClause((Clause)iterator.next()));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final String printSymbol(Symbol symbol) {
        return symbol.toString();
    }

    public static final Literal deReferenceLiteral(Literal literal) {
        if (!(literal.getArgs() instanceof Unifyable)) {
            return literal;
        }
        List list = (List)((Unifyable)((Object)literal.getArgs())).deReferenceVariables();
        if (list == literal.getArgs()) {
            return literal;
        }
        DefaultLiteral defaultLiteral = new DefaultLiteral(literal.getRelation(), list, literal.isPositive());
        return defaultLiteral;
    }

    public static final Clause deReferenceClause(Clause clause) {
        if (clause instanceof Literal) {
            return SubstUtils.deReferenceLiteral((Literal)clause);
        }
        boolean bl = false;
        ArrayList<Literal> arrayList = new ArrayList<Literal>(clause.literals().size());
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal;
            Literal literal2 = (Literal)iterator.next();
            if (literal2 != (literal = SubstUtils.deReferenceLiteral(literal2))) {
                bl = true;
            }
            arrayList.add(literal);
        }
        return bl ? new DefaultClause(arrayList) : clause;
    }

    public static final CNFSentence deReferenceSentence(CNFSentence cNFSentence) {
        if (cNFSentence instanceof Clause) {
            return SubstUtils.deReferenceClause((Clause)cNFSentence);
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList(cNFSentence.clauses().size());
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            Clause clause;
            Clause clause2 = (Clause)iterator.next();
            if (clause2 == (clause = SubstUtils.deReferenceClause(clause2))) continue;
            bl = true;
        }
        return bl ? new DefaultCNFSentence(arrayList) : cNFSentence;
    }

    public static Map variableStackToMap(List list, Map abstractMap) {
        int n = list.size();
        if (abstractMap == null) {
            abstractMap = n < 5 ? new ArrayMap(n) : (n < 15 ? new TreeMap<Variable, Object>() : new HashMap(2 * n));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            abstractMap.put(variable, variable.deReferenceVariables());
        }
        return abstractMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object replaceVariables(Unifyable var0) {
        var1_1 = null;
        try {
            var2_2 = new HashSet<E>(30);
            var0.getVariables(var2_2);
            var1_1 = SubstUtils.bindUnboundVarsToReplacements(var2_2);
            var3_3 = var0.deReferenceVariables();
            return var3_3;
        }
        finally {
            if (var1_1 == null) return var3_3;
            var4_4 = var1_1.iterator();
            ** while (var4_4.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((Variable)var4_4.next()).unbind();
            continue;
        }
lbl15:
        // 1 sources

        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CNFSentence replaceVariables(CNFSentence var0) {
        var1_1 = new TreeSet<E>();
        var2_2 = var0.clauses().iterator();
        while (var2_2.hasNext()) {
            var3_3 = (Clause)var2_2.next();
            var4_4 = var3_3.literals().iterator();
            while (var4_4.hasNext()) {
                var5_5 = (Literal)var4_4.next();
                if (!(var5_5.getArgs() instanceof Unifyable)) continue;
                ((Unifyable)var5_5.getArgs()).getVariables(var1_1);
            }
        }
        var3_3 = null;
        try {
            var3_3 = SubstUtils.bindUnboundVarsToReplacements(var1_1);
            var4_4 = SubstUtils.deReferenceSentence(var0);
            return var4_4;
        }
        finally {
            if (var3_3 == null) return var4_4;
            var5_5 = var3_3.iterator();
            ** while (var5_5.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((Variable)var5_5.next()).unbind();
            continue;
        }
lbl24:
        // 1 sources

        return var4_4;
    }

    private static Collection bindUnboundVarsToReplacements(Collection collection) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            if (variable.getValue() != null) continue;
            Variable variable2 = new Variable(variable.getName());
            arrayList.add(variable);
            variable.setValue(variable2);
        }
        return arrayList;
    }

    public static boolean unify(Object object, Object object2, List list) {
        boolean bl = false;
        bl = object instanceof Unifyable ? ((Unifyable)object).unify(object2, list) : (object2 instanceof Unifyable ? ((Unifyable)object2).unify(object, list) : object2.equals(object));
        return bl;
    }

    public static boolean variableIndependentEquals(CNFSentence cNFSentence, CNFSentence cNFSentence2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = cNFSentence2.clauses().iterator();
        Iterator iterator2 = cNFSentence.clauses().iterator();
        while (iterator2.hasNext()) {
            if (!iterator.hasNext()) {
                return false;
            }
            Iterator iterator3 = ((Clause)iterator.next()).literals().iterator();
            Iterator iterator4 = ((Clause)iterator2.next()).literals().iterator();
            while (iterator4.hasNext()) {
                if (!iterator3.hasNext()) {
                    return false;
                }
                Literal literal = (Literal)iterator4.next();
                Literal literal2 = (Literal)iterator3.next();
                if (literal.isPositive() == literal2.isPositive() && literal.getRelation().equals(literal2.getRelation()) && SubstUtils.variableIndependentEquals(literal.getArgs(), literal2.getArgs(), arrayList)) continue;
                return false;
            }
            if (!iterator3.hasNext()) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    private static boolean variableIndependentEquals(List list, List list2, List list3) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            Object e2 = list2.get(n);
            if (e instanceof List) {
                return e2 instanceof List && SubstUtils.variableIndependentEquals((List)e, (List)e2, list3);
            }
            if (e instanceof Variable) {
                if (!(e2 instanceof Variable)) {
                    return false;
                }
                int n2 = list3.indexOf(e);
                int n3 = list3.indexOf(e2);
                if (n2 == -1) {
                    if (n3 != -1) {
                        return false;
                    }
                    list3.add(e);
                    list3.add(e2);
                } else if (n2 % 2 != 0 || n3 != n2 + 1) {
                    return false;
                }
            } else if (e == null ? e2 != null : !e.equals(e2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int variableIndependentHashCode(CNFSentence cNFSentence) {
        int n = 21;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Clause)iterator.next()).literals().iterator();
            while (iterator2.hasNext()) {
                Literal literal = (Literal)iterator2.next();
                n += (literal.isPositive() ? 17 : 11) + literal.getRelation().hashCode() + SubstUtils.variableIndependentHashCode(literal.getArgs(), arrayList);
            }
        }
        return n;
    }

    private static int variableIndependentHashCode(List list, List list2) {
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n2 = 0;
            if (e instanceof List) {
                n2 = SubstUtils.variableIndependentHashCode((List)e, list2);
            } else if (e instanceof Variable) {
                n2 = list2.indexOf(e);
                if (n2 == -1) {
                    n2 = list2.size();
                    list2.add(e);
                }
            } else if (e != null) {
                n2 = e.hashCode();
            }
            n = 31 * n + n2;
        }
        return n;
    }
}

