/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.SubstitutableList;
import jtp.fol.Symbol;

public class DefaultLiteral
implements Literal,
Serializable {
    private boolean polarity;
    private Symbol relation;
    private SubstitutableList args;

    public DefaultLiteral(Symbol symbol, Collection collection, boolean bl) {
        this.relation = symbol;
        this.args = SubstUtils.createList(collection);
        this.polarity = bl;
    }

    public DefaultLiteral(Symbol symbol, SubstitutableList substitutableList, boolean bl) {
        this.relation = symbol;
        this.args = substitutableList;
        this.polarity = bl;
    }

    public Collection literals() {
        return Collections.singleton(this);
    }

    public Collection clauses() {
        return Collections.singleton(this);
    }

    public boolean isPositive() {
        return this.polarity;
    }

    public Symbol getRelation() {
        return this.relation;
    }

    public List getArgs() {
        return this.args;
    }

    public String toString() {
        return SubstUtils.printLiteral(this);
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Literal literal = (Literal)object;
        return literal.isPositive() == this.isPositive() && this.getRelation().equals(literal.getRelation()) && this.getArgs().equals(literal.getArgs());
    }

    public int hashCode() {
        return (this.isPositive() ? 17 : 11) + this.getRelation().hashCode() + this.getArgs().hashCode();
    }

    public Object substitute(Map map) {
        return SubstUtils.substituteLiteral(this, map);
    }
}

