/*
 * Decompiled with CFR 0.152.
 */
package jtp.disp;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jtp.Dispatcher;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.rs.ArrayReasoningStepIterator;

public class SequentialDispatcher
implements Dispatcher {
    protected Ring zero;
    protected int count = 0;
    protected boolean cutoff = false;
    private transient Collection rsnrCollection = null;
    public static final int HEAD_PREFERRED = 1;
    public static final int TAIL_PREFERRED = -1;
    public static final int NO_PREFERENCE = 0;
    static /* synthetic */ Class class$jtp$Reasoner;

    public SequentialDispatcher() {
        this.zero.next = this.zero.prev = (this.zero = new Ring());
    }

    public ReasoningStepIterator process(Object object) {
        return new Steps(object);
    }

    public boolean acceptable(Object object) {
        return true;
    }

    public boolean getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(boolean bl) {
        this.cutoff = bl;
    }

    public boolean addReasoner(Reasoner reasoner) {
        int n = reasoner instanceof LocationPreference ? ((LocationPreference)((Object)reasoner)).getPreferredLocation() : 0;
        Ring ring = new Ring();
        ring.reasoner = reasoner;
        switch (n) {
            case 1: {
                this.zero.insertNext(ring);
                break;
            }
            case -1: {
                this.zero.prev.insertNext(ring);
                break;
            }
            case 0: {
                Ring ring2 = this.zero.prev;
                while (ring2.reasoner instanceof LocationPreference && ((LocationPreference)((Object)ring2.reasoner)).getPreferredLocation() == -1) {
                    ring2 = ring2.prev;
                }
                ring2.insertNext(ring);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal location preference");
            }
        }
        ++this.count;
        return true;
    }

    public boolean removeReasoner(Reasoner reasoner) {
        Ring ring = this.zero.next;
        while (ring != this.zero) {
            if (ring.reasoner == reasoner) {
                ring.prev.removeNext();
                --this.count;
                return true;
            }
            ring = ring.next;
        }
        return false;
    }

    public Class getReasonerClass() {
        return class$jtp$Reasoner == null ? (class$jtp$Reasoner = SequentialDispatcher.class$("jtp.Reasoner")) : class$jtp$Reasoner;
    }

    public Collection getReasoners() {
        if (this.rsnrCollection == null) {
            this.rsnrCollection = new RSNRCollection();
        }
        return this.rsnrCollection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface LocationPreference {
        public int getPreferredLocation();
    }

    private class Steps
    implements ReasoningStepIterator {
        Ring index;
        ReasoningStepIterator currentSteps;
        Object goal;

        Steps(Object object) {
            this.goal = object;
            this.index = SequentialDispatcher.this.zero;
            this.currentSteps = ArrayReasoningStepIterator.empty;
        }

        public ReasoningStep next() throws ReasoningException {
            ReasoningStep reasoningStep = this.currentSteps.next();
            while (reasoningStep == null) {
                this.currentSteps = ArrayReasoningStepIterator.empty;
                do {
                    if (this.index == null || this.index.next == SequentialDispatcher.this.zero) {
                        this.currentSteps = ArrayReasoningStepIterator.empty;
                        this.index = null;
                        return null;
                    }
                    this.index = this.index.next;
                } while (!this.index.reasoner.acceptable(this.goal));
                this.currentSteps = this.index.reasoner.process(this.goal);
                reasoningStep = this.currentSteps.next();
                if (!SequentialDispatcher.this.getCutoff() || reasoningStep == null) continue;
                this.index = null;
            }
            return reasoningStep;
        }
    }

    private class RSNRCollection
    extends AbstractCollection {
        private RSNRCollection() {
        }

        public int size() {
            return SequentialDispatcher.this.count;
        }

        public Iterator iterator() {
            return new Iterator(){
                Ring rg;
                {
                    this.rg = ((RSNRCollection)this).SequentialDispatcher.this.zero;
                }

                public boolean hasNext() {
                    if (this.rg != null && this.rg.next == ((RSNRCollection)this).SequentialDispatcher.this.zero) {
                        this.rg = null;
                    }
                    return this.rg != null;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.rg = this.rg.next;
                    return this.rg.reasoner;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected static class Ring {
        Reasoner reasoner = null;
        Ring next = null;
        Ring prev = null;

        protected Ring() {
        }

        void insertNext(Ring ring) {
            ring.next = this.next;
            ring.prev = this;
            this.next.prev = ring;
            this.next = ring;
        }

        void removeNext() {
            this.next.next.prev = this;
            this.next = this.next.next;
        }
    }
}

