/*
 * Decompiled with CFR 0.152.
 */
package jtp.disp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jtp.Dispatcher;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStepIterator;
import jtp.disp.RelationBasedReasoner;
import jtp.disp.SequentialDispatcher;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.rs.ArrayReasoningStepIterator;

public abstract class RelationBasedDispatcher
implements Dispatcher {
    private Map map = new HashMap();
    private Collection cachedReasonersList = null;

    RelationBasedDispatcher() {
    }

    public ReasoningStepIterator process(Literal literal, Object object) throws ReasoningException {
        Reasoner reasoner = (Reasoner)this.map.get(literal.getRelation());
        if (reasoner == null || !reasoner.acceptable(object)) {
            return ArrayReasoningStepIterator.empty;
        }
        return reasoner.process(object);
    }

    protected boolean addRelationBasedReasoner(RelationBasedReasoner relationBasedReasoner) {
        this.cachedReasonersList = null;
        Symbol symbol = relationBasedReasoner.getRelation();
        Reasoner reasoner = (Reasoner)this.map.get(symbol);
        if (reasoner == null) {
            this.map.put(symbol, relationBasedReasoner);
        } else {
            if (reasoner instanceof Dispatcher) {
                return ((Dispatcher)reasoner).addReasoner(relationBasedReasoner);
            }
            SequentialDispatcher sequentialDispatcher = new SequentialDispatcher();
            sequentialDispatcher.addReasoner(reasoner);
            sequentialDispatcher.addReasoner(relationBasedReasoner);
            this.map.put(symbol, sequentialDispatcher);
        }
        return true;
    }

    protected boolean removeRelationBasedReasoner(RelationBasedReasoner relationBasedReasoner) {
        this.cachedReasonersList = null;
        Symbol symbol = relationBasedReasoner.getRelation();
        if (this.map.get(symbol) == relationBasedReasoner) {
            this.map.remove(symbol);
            return true;
        }
        return false;
    }

    public Collection getReasoners() {
        this.cachedReasonersList = new ArrayList();
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof SequentialDispatcher) {
                this.cachedReasonersList.addAll(((SequentialDispatcher)v).getReasoners());
                continue;
            }
            this.cachedReasonersList.add(v);
        }
        return this.cachedReasonersList;
    }
}

