/*
 * Decompiled with CFR 0.152.
 */
package jtp.demod;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.DefaultClause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.gmp.ClauseOrientation;

public class DemodUtils {
    public static Object lookUp(Object object, Map map) {
        Object v = map.get(object);
        return v != null ? v : object;
    }

    public static CNFSentence substitute(CNFSentence cNFSentence, Map map, Collection collection) {
        if (cNFSentence instanceof Clause) {
            return DemodUtils.substitute((Clause)cNFSentence, map, collection);
        }
        Clause[] clauseArray = new Clause[cNFSentence.clauses().size()];
        boolean bl = false;
        int n = 0;
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            Clause clause2 = DemodUtils.substitute(clause, map, collection);
            if (clause2 != clause) {
                bl = true;
            }
            clauseArray[n++] = clause2;
        }
        return bl ? new DefaultCNFSentence(Arrays.asList(clauseArray)) : cNFSentence;
    }

    public static Clause substitute(Clause clause, Map map, Collection collection) {
        if (clause instanceof Literal) {
            return DemodUtils.substitute((Literal)clause, map, collection);
        }
        Literal[] literalArray = new Literal[clause.literals().size()];
        boolean bl = false;
        int n = 0;
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            Literal literal2 = DemodUtils.substitute(literal, map, collection);
            if (literal2 != literal) {
                bl = true;
            }
            literalArray[n++] = literal2;
        }
        return bl ? new DefaultClause(Arrays.asList(literalArray)) : clause;
    }

    public static ClauseOrientation substituteClauseOrientation(ClauseOrientation clauseOrientation, Map map, Collection collection) {
        Clause clause = clauseOrientation.getClause();
        if (clause instanceof Literal) {
            Literal literal = DemodUtils.substitute((Literal)clause, map, collection);
            if (literal == clause) {
                return clauseOrientation;
            }
            return new ClauseOrientation(literal, literal);
        }
        Literal[] literalArray = new Literal[clause.literals().size()];
        boolean bl = false;
        Literal literal = null;
        int n = 0;
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal2 = (Literal)iterator.next();
            Literal literal3 = DemodUtils.substitute(literal2, map, collection);
            if (literal3 != literal2) {
                bl = true;
            }
            literalArray[n++] = literal3;
            if (literal2 != clauseOrientation.getHead()) continue;
            literal = literal3;
        }
        return bl ? new ClauseOrientation(new DefaultClause(Arrays.asList(literalArray)), literal) : clauseOrientation;
    }

    public static List substituteList(List list, Map map, Collection collection) {
        boolean bl = false;
        Object[] objectArray = new Object[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e != (object = DemodUtils.lookUp(e, map))) {
                bl = true;
                collection.add(e);
            }
            objectArray[n++] = object;
        }
        return bl ? Arrays.asList(objectArray) : list;
    }

    public static Literal substitute(Literal literal, Map map, Collection collection) {
        List list;
        boolean bl = false;
        Symbol symbol = (Symbol)DemodUtils.lookUp(literal.getRelation(), map);
        if (symbol != literal.getRelation()) {
            bl = true;
            collection.add(literal.getRelation());
        }
        if ((list = DemodUtils.substituteList(literal.getArgs(), map, collection)) != literal.getArgs()) {
            bl = true;
        }
        return bl ? new DefaultLiteral(symbol, list, literal.isPositive()) : literal;
    }
}

