/*
 * Decompiled with CFR 0.152.
 */
package jtp.demod;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import jtp.ReasoningStep;
import jtp.demod.DemodulationProofTranslator;
import jtp.util.ArrayMap;

public class CanonicalMapping {
    Map entryMap;
    Map substitutionMap;
    Map equalityClassMap;
    transient UndoManager undoManager;
    DemodulationProofTranslator proofTranslator;

    public CanonicalMapping(Map map, Map map2) {
        this.entryMap = map;
        this.equalityClassMap = map2;
        this.substitutionMap = new SubstitutionMap();
        this.proofTranslator = new DemodulationProofTranslator(this);
    }

    public CanonicalMapping() {
        this(new HashMap(), new HashMap());
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public Map getSubstitutionMap() {
        return this.substitutionMap;
    }

    public ReasoningStep getMappingGrounds(Object object) {
        Object v = this.entryMap.get(object);
        return v == null ? null : ((Entry)this.entryMap.get((Object)object)).grounds;
    }

    public Set getEqualityClass(Object object) {
        return (Set)this.equalityClassMap.get(object);
    }

    public DemodulationProofTranslator getProofTranslator() {
        return this.proofTranslator;
    }

    public void moveEqualityClass(Object object, Object object2, ReasoningStep reasoningStep) {
        Object object3;
        Set set = this.getEqualityClass(object);
        if (set == null) {
            this.addMapping(object, object2, reasoningStep);
            return;
        }
        if (set.contains(object2)) {
            return;
        }
        Object v = this.getSubstitutionMap().get(object);
        ArrayMap arrayMap = new ArrayMap(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object3 == v || object3 == object) continue;
            arrayMap.put(object3, this.getMappingGrounds(object3));
        }
        object3 = this.getMappingGrounds(object);
        this.removeMapping(object);
        this.addMapping(object, object2, reasoningStep);
        object3 = this.proofTranslator.translate((ReasoningStep)object3);
        Iterator iterator2 = arrayMap.keySet().iterator();
        while (iterator2.hasNext()) {
            this.removeMapping(iterator2.next());
        }
        this.removeMapping(v);
        this.addMapping(v, object2, (ReasoningStep)object3);
        Iterator iterator3 = arrayMap.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry entry = iterator3.next();
            this.addMapping(entry.getKey(), object2, this.proofTranslator.translate((ReasoningStep)entry.getValue()));
        }
    }

    void addMapping(Object object, Object object2, ReasoningStep reasoningStep) {
        Entry entry = new Entry();
        entry.grounds = reasoningStep;
        entry.canonicalName = object2;
        Entry entry2 = this.doAdd(object, entry);
        if (this.undoManager != null) {
            if (entry2 != null) {
                this.undoManager.addEdit(new Undo(object, entry2, false));
            }
            this.undoManager.addEdit(new Undo(object, entry, true));
        }
    }

    void removeMapping(Object object) {
        Entry entry = this.doRemove(object);
        if (entry != null && this.undoManager != null) {
            this.undoManager.addEdit(new Undo(object, entry, false));
        }
    }

    private Entry doAdd(Object object, Entry entry) {
        HashSet<Object> hashSet;
        Entry entry2 = this.entryMap.put(object, entry);
        if (entry2 != null) {
            this.removeFromEqualityClass(object, entry2.canonicalName);
        }
        if ((hashSet = this.getEqualityClass(entry.canonicalName)) == null) {
            hashSet = new HashSet<Object>(5);
            hashSet.add(entry.canonicalName);
            this.equalityClassMap.put(entry.canonicalName, hashSet);
        }
        hashSet.add(object);
        this.equalityClassMap.put(object, hashSet);
        return entry2;
    }

    private Entry doRemove(Object object) {
        Entry entry = (Entry)this.entryMap.remove(object);
        if (entry != null) {
            this.removeFromEqualityClass(object, entry.canonicalName);
        }
        return entry;
    }

    private void removeFromEqualityClass(Object object, Object object2) {
        this.equalityClassMap.remove(object);
        Set set = this.getEqualityClass(object2);
        if (set != null) {
            set.remove(object);
            if (set.size() <= 1) {
                this.equalityClassMap.remove(object2);
            }
        }
    }

    class Undo
    extends AbstractUndoableEdit {
        Object from;
        Entry e;
        boolean addition;

        Undo(Object object, Entry entry, boolean bl) {
            this.from = object;
            this.e = entry;
            this.addition = bl;
        }

        protected void addOrRemove(boolean bl) {
            if (bl) {
                CanonicalMapping.this.doAdd(this.from, this.e);
            } else {
                CanonicalMapping.this.doRemove(this.from);
            }
        }

        public void undo() {
            super.undo();
            this.addOrRemove(!this.addition);
        }

        public void redo() {
            super.redo();
            this.addOrRemove(this.addition);
        }
    }

    private static class SMEntry
    implements Map.Entry {
        Map.Entry delegate;

        private SMEntry() {
        }

        public Object getKey() {
            return this.delegate.getKey();
        }

        public Object getValue() {
            return ((Entry)this.delegate.getValue()).canonicalName;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class SMEntrySet
    extends AbstractSet {
        private SMEntrySet() {
        }

        public int size() {
            return CanonicalMapping.this.entryMap.size();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator delegate;
                {
                    this.delegate = ((SMEntrySet)this).CanonicalMapping.this.entryMap.entrySet().iterator();
                }

                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                public Object next() {
                    SMEntry sMEntry = new SMEntry();
                    sMEntry.delegate = (Map.Entry)this.delegate.next();
                    return sMEntry;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class SubstitutionMap
    extends AbstractMap {
        Set eset;

        private SubstitutionMap() {
            this.eset = new SMEntrySet();
        }

        public Set entrySet() {
            return this.eset;
        }

        public Object get(Object object) {
            Object v = CanonicalMapping.this.entryMap.get(object);
            return v == null ? null : ((Entry)v).canonicalName;
        }

        public boolean containsKey(Object object) {
            return CanonicalMapping.this.entryMap.containsKey(object);
        }
    }

    static class Entry {
        ReasoningStep grounds;
        Object canonicalName;

        Entry() {
        }

        public int hashCode() {
            return this.canonicalName.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Entry && ((Entry)object).canonicalName.equals(this.canonicalName);
        }
    }
}

