/*
 * Decompiled with CFR 0.152.
 */
package jtp.context.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.undo.CannotUndoException;
import jtp.ReasoningException;
import jtp.ReasoningStepIterator;
import jtp.context.IterativeDeepening;
import jtp.context.rdf.RDFModelCreator;
import jtp.disp.DispatcherUtils;
import jtp.fol.CNFSentence;
import jtp.fol.Literal;
import jtp.fol.kif.KIF2CNF;
import jtp.fol.parser.FirstOrderLogicParser;
import jtp.fol.rdf.RDFParser;
import jtp.frame.EnumeratingReasoner;
import jtp.frame.HoldsReasoner;
import jtp.frame.listen.Context;
import jtp.func.InEqual;
import jtp.gmp.ClauseOrientationKB;
import jtp.modelim.AskingQueryProcessor;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.undo.Snapshot;
import jtp.undo.SnapshotUndoManager;

public class RDFReasoningContext
extends Context {
    RDFParser rdfParser = new RDFParser();
    KIF2CNF kifParser = new KIF2CNF();
    public static final URL RDF_RULES = (class$jtp$context$rdf$RDFReasoningContext == null ? (class$jtp$context$rdf$RDFReasoningContext = RDFReasoningContext.class$("jtp.context.rdf.RDFReasoningContext")) : class$jtp$context$rdf$RDFReasoningContext).getResource("rdf-rules.xml");
    public static final URL RDF_TRIPLES = (class$jtp$context$rdf$RDFReasoningContext == null ? (class$jtp$context$rdf$RDFReasoningContext = RDFReasoningContext.class$("jtp.context.rdf.RDFReasoningContext")) : class$jtp$context$rdf$RDFReasoningContext).getResource("rdf-assumptions.kif");
    public static final String RDF_REF = "http://www.w3.org/RDF/";
    protected IterativeDeepening idr;
    private RDFModelCreator modelCreator = new RDFModelCreator();
    static /* synthetic */ Class class$jtp$context$rdf$RDFReasoningContext;

    public RDFParser getRDFParser() {
        return this.rdfParser;
    }

    public KIF2CNF getKifParser() {
        return this.kifParser;
    }

    public void setMaxDepth(int n) {
        super.setMaxDepth(n);
        if (this.idr != null) {
            this.idr.setStartingDepth(n);
        }
    }

    public void setUp() {
        try {
            super.setUp();
            this.idr = (IterativeDeepening)this.getAskingReasoner();
            this.getTracer().setVerbosityLevel(0);
            this.setMaxDepth(25);
            this.idr.setTrimShallowSolutions(false);
            URL uRL = new URL(RDF_REF);
            this.loadSpecs(RDF_RULES, uRL);
            this.loadKB(RDF_TRIPLES, uRL, this.kifParser);
            ClauseOrientationKB clauseOrientationKB = new ClauseOrientationKB();
            this.add(clauseOrientationKB);
            AskingQueryProcessor askingQueryProcessor = new AskingQueryProcessor();
            this.add(askingQueryProcessor);
            DispatcherUtils.addToDispatcher(new HoldsReasoner(), this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(new EnumeratingReasoner(), this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(new InEqual(), this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(clauseOrientationKB.getAskingReasoner(), this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(askingQueryProcessor, this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(clauseOrientationKB.getTellingReasoner(), this.getTellingDispatcher());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (ReasoningException reasoningException) {
            throw new RuntimeException(reasoningException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int assertKifString(String string) throws ReasoningException {
        return this.tellKifString(string);
    }

    public int tellKifString(String string) throws ReasoningException {
        return this.tellString(string, this.kifParser);
    }

    public int assertString(String string) throws ReasoningException {
        return this.tellString(string);
    }

    public int tellString(String string) throws ReasoningException {
        return this.tellString(string, null, this.rdfParser);
    }

    public int tellString(String string, URL uRL) throws ReasoningException {
        return this.tellString(string, uRL, this.rdfParser);
    }

    public int tellString(String string, FirstOrderLogicParser firstOrderLogicParser) throws ReasoningException {
        return this.tellString(string, null, firstOrderLogicParser);
    }

    public int tellString(String string, URL uRL, FirstOrderLogicParser firstOrderLogicParser) throws ReasoningException {
        this.setParser(firstOrderLogicParser);
        if (uRL == null) {
            return super.tellString(string);
        }
        return super.tellString(string, uRL);
    }

    public int tell(Object object) throws ReasoningException {
        return super.tell(object);
    }

    public void loadKB(URL uRL, URL uRL2, FirstOrderLogicParser firstOrderLogicParser) throws ReasoningException, IOException {
        this.setParser(firstOrderLogicParser);
        super.loadKB(uRL, uRL2);
    }

    public void loadKB(URL uRL, FirstOrderLogicParser firstOrderLogicParser) throws ReasoningException, IOException {
        this.loadKB(uRL, uRL, firstOrderLogicParser);
    }

    public void loadRDFKB(URL uRL, URL uRL2) throws ReasoningException, IOException {
        this.loadKB(uRL, uRL2, this.rdfParser);
    }

    public void loadRDFKB(Model model, URL uRL) throws ReasoningException, IOException {
        this.loadClauses(this.getRDFParser().parse(model), uRL);
    }

    public void loadKB(URL uRL) throws ReasoningException, IOException {
        this.loadKB(uRL, uRL, this.rdfParser);
    }

    public void loadKifKB(URL uRL) throws ReasoningException, IOException {
        this.loadKB(uRL, uRL, this.kifParser);
    }

    public ReasoningStepIterator ask(URL uRL, String string) throws ReasoningException, IOException {
        if (uRL != null) {
            this.loadKB(uRL);
        }
        return this.ask(string);
    }

    public ReasoningStepIterator ask(String string) throws ReasoningException {
        this.setParser(this.kifParser);
        CNFSentence cNFSentence = this.getTranslator().translate(string);
        if (cNFSentence instanceof Literal) {
            return super.ask(string);
        }
        return this.getAskingReasoner().process(string);
    }

    public void untellString(String string) throws CannotUndoException, ReasoningException {
        this.setParser(this.kifParser);
        CNFSentence cNFSentence = this.getTranslator().translate(string);
        if (!(cNFSentence instanceof Literal)) {
            throw new CannotUndoException();
        }
        this.untell(cNFSentence);
    }

    public void untell(Object object) throws ReasoningException {
        super.untell(object);
    }

    public void writeRDF(Writer writer, Snapshot snapshot, String string, Map map) {
        Model model = this.getModelForAssertions(snapshot);
        if (map != null) {
            model.setNsPrefixes(map);
        }
        model.write(writer, "RDF/XML-ABBREV", string);
    }

    public Model getModelForAssertions(Snapshot snapshot) {
        return this.modelCreator.getModelForAssertions(snapshot, (SnapshotUndoManager)this.getUndoManager());
    }

    public ReasoningStepIterator inconsistencies() {
        return ArrayReasoningStepIterator.empty;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

