/*
 * Decompiled with CFR 0.152.
 */
package jtp.context.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.undo.Snapshot;
import jtp.undo.SnapshotUndoManager;

public class RDFModelCreator {
    private Map anonResources = null;
    private static final String ANON_PREFIX = "Anon_";
    private static final int ANON_PREFIX_LEN = "Anon_".length();
    private static final Symbol HOLDS = Symbol.newSymbol("holds");

    public Model getModelForAssertions(Snapshot snapshot, SnapshotUndoManager snapshotUndoManager) {
        List list = snapshotUndoManager.getObjectsToldSinceSnapshot(snapshot);
        if (this.anonResources == null) {
            this.anonResources = new Hashtable(23);
        }
        Model model = ModelFactory.createDefaultModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Literal)) continue;
            this.addLiteralToModel((Literal)e, model);
        }
        this.anonResources.clear();
        return model;
    }

    protected void addLiteralToModel(Literal literal, Model model) {
        Symbol symbol = null;
        Symbol symbol2 = null;
        Object var5_5 = null;
        int n = 0;
        if (literal.getRelation().equals(HOLDS)) {
            symbol = (Symbol)literal.getArgs().get(0);
            n = 1;
        } else {
            symbol = literal.getRelation();
        }
        if (literal.getArgs().size() - n != 2) {
            return;
        }
        symbol2 = (Symbol)literal.getArgs().get(0 + n);
        var5_5 = literal.getArgs().get(1 + n);
        Property property = model.getProperty(symbol.getPackage(), symbol.getName());
        Resource resource = this.isAnon(symbol2) ? this.getAnonResource(symbol2, model) : model.getResource(symbol2.getPackage() + symbol2.getName());
        Resource resource2 = null;
        if (var5_5 instanceof Symbol) {
            Symbol symbol3 = var5_5;
            Resource resource3 = resource2 = this.isAnon(symbol3) ? this.getAnonResource(symbol3, model) : model.getResource(symbol3.getPackage() + symbol3.getName());
        }
        if (resource2 == null) {
            model.add(resource, property, var5_5);
        } else {
            model.add(resource, property, resource2);
        }
    }

    protected boolean isAnon(Symbol symbol) {
        if (symbol.getPackage() != null) {
            return false;
        }
        if (symbol.getName().length() < ANON_PREFIX_LEN) {
            return false;
        }
        return symbol.getName().substring(0, ANON_PREFIX_LEN).equals(ANON_PREFIX);
    }

    protected Resource getAnonResource(Symbol symbol, Model model) {
        Resource resource = (Resource)this.anonResources.get(symbol.getName());
        if (resource == null) {
            resource = model.getResource(null);
            this.anonResources.put(symbol.getName(), resource);
        }
        return resource;
    }
}

