/*
 * Decompiled with CFR 0.152.
 */
package jtp.context.owl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.classifier.ClassifierTellingReasoner;
import jtp.context.rdf.RDFReasoningContext;
import jtp.disp.DispatcherUtils;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.frame.listen.dl.IntersectionTypeReasoner;
import jtp.frame.vocab.OWL;
import jtp.frame.vocab.RDF;
import jtp.frame.vocab.RDFS;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.IteratorBasedReasoningStepIterator;

public class OWLReasoningContext
extends RDFReasoningContext {
    IntersectionTypeReasoner intersectionTypeReasoner;
    ClassifierTellingReasoner classifierTellingReasoner;
    public static final URL OWL_RULES = (class$jtp$context$owl$OWLReasoningContext == null ? (class$jtp$context$owl$OWLReasoningContext = OWLReasoningContext.class$("jtp.context.owl.OWLReasoningContext")) : class$jtp$context$owl$OWLReasoningContext).getResource("owl-rules.xml");
    public static final URL OWL_TRIPLES = (class$jtp$context$owl$OWLReasoningContext == null ? (class$jtp$context$owl$OWLReasoningContext = OWLReasoningContext.class$("jtp.context.owl.OWLReasoningContext")) : class$jtp$context$owl$OWLReasoningContext).getResource("owl-assumptions.kif");
    public static final String OWL_REF = "http://www.w3.org/2001/sw/WebOnt/";
    static /* synthetic */ Class class$jtp$context$owl$OWLReasoningContext;

    public IntersectionTypeReasoner getIntersectionTypeReasoner() {
        return this.intersectionTypeReasoner;
    }

    public void setIntersectionTypeReasoner(IntersectionTypeReasoner intersectionTypeReasoner) {
        this.intersectionTypeReasoner = intersectionTypeReasoner;
    }

    public ClassifierTellingReasoner getClassifierTellingReasoner() {
        return this.classifierTellingReasoner;
    }

    public void setClassifierTellingReasoner(ClassifierTellingReasoner classifierTellingReasoner) {
        this.classifierTellingReasoner = classifierTellingReasoner;
    }

    public void setUp() {
        try {
            super.setUp();
            URL uRL = new URL(OWL_REF);
            this.loadSpecs(OWL_RULES, uRL);
            this.loadKB(OWL_TRIPLES, uRL, this.getKifParser());
            this.add(this.getIntersectionTypeReasoner());
            this.add(this.getClassifierTellingReasoner());
            DispatcherUtils.addToDispatcher(this.getIntersectionTypeReasoner(), this.getTellingDispatcher());
            DispatcherUtils.addToDispatcher(this.getClassifierTellingReasoner(), this.getTellingDispatcher());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (ReasoningException reasoningException) {
            throw new RuntimeException(reasoningException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void createEmptyContentHolders() {
        super.createEmptyContentHolders();
        this.setIntersectionTypeReasoner(new IntersectionTypeReasoner(OWL.intersectionOf, RDF.type, RDF.item));
        ClassifierTellingReasoner classifierTellingReasoner = new ClassifierTellingReasoner();
        classifierTellingReasoner.setPrimarySubclassRelation(RDFS.subClassOf);
        classifierTellingReasoner.setPrimaryEquivalenceRelation(OWL.equivalentClass);
        classifierTellingReasoner.addConjunctiveRelation(OWL.intersectionOf);
        classifierTellingReasoner.addDisjunctiveRelation(OWL.unionOf);
        classifierTellingReasoner.setListItemRelation(RDF.item);
        this.setClassifierTellingReasoner(classifierTellingReasoner);
    }

    public ReasoningStepIterator inconsistencies() {
        return new ReasoningStepIterator(){
            int current = 0;
            ReasoningStepIterator currentSteps = ArrayReasoningStepIterator.empty;

            public ReasoningStep next() throws ReasoningException {
                ReasoningStep reasoningStep = this.currentSteps.next();
                while (reasoningStep == null) {
                    switch (this.current++) {
                        case 0: {
                            this.currentSteps = OWLReasoningContext.this.nilRestInconsistencies();
                            break;
                        }
                        case 1: {
                            this.currentSteps = OWLReasoningContext.this.nilItemInconsistencies();
                            break;
                        }
                        case 2: {
                            this.currentSteps = OWLReasoningContext.this.nothingInconsistencies();
                            break;
                        }
                        case 3: {
                            this.currentSteps = OWLReasoningContext.this.exceedsMaxCard0Inconsistencies();
                            break;
                        }
                        case 4: {
                            this.currentSteps = OWLReasoningContext.this.equivalenceInconsistencies();
                            break;
                        }
                        case 5: {
                            this.currentSteps = OWLReasoningContext.this.disjointnessInconsistencies();
                            break;
                        }
                        default: {
                            this.currentSteps = ArrayReasoningStepIterator.empty;
                            return null;
                        }
                    }
                    reasoningStep = this.currentSteps.next();
                }
                return reasoningStep;
            }
        };
    }

    public ReasoningStepIterator disjointnessInconsistencies() throws ReasoningException {
        ReasoningStep reasoningStep;
        int n = this.getMaxDepth();
        boolean bl = this.idr.getTrimDeepSolutions();
        this.setMaxDepth(2);
        this.idr.setTrimDeepSolutions(false);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ReasoningStepIterator reasoningStepIterator = this.ask("(" + OWL.disjointWith + " ?c1 ?c2)");
        while ((reasoningStep = reasoningStepIterator.next()) != null) {
            linkedList.add(SubstUtils.replaceVariables(reasoningStep));
        }
        this.setMaxDepth(n);
        this.idr.setTrimDeepSolutions(bl);
        if (linkedList.isEmpty()) {
            return ArrayReasoningStepIterator.empty;
        }
        LinkedList<ConjunctionProofStep> linkedList2 = new LinkedList<ConjunctionProofStep>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ReasoningStep reasoningStep2 = (ReasoningStep)iterator.next();
            Literal literal = SubstUtils.deReferenceLiteral((Literal)reasoningStep2.getGoal());
            Object e = literal.getArgs().get(0);
            Object e2 = literal.getArgs().get(1);
            reasoningStepIterator = this.ask("(and (" + RDF.type + " ?x " + e + ")(" + RDF.type + " ?x " + e2 + "))");
            while ((reasoningStep = reasoningStepIterator.next()) != null) {
                ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(3);
                arrayList.add(reasoningStep2);
                ReasoningStep reasoningStep3 = (ReasoningStep)reasoningStep.getSubProofs().get(0);
                arrayList.add((ReasoningStep)reasoningStep3.getSubProofs().get(1));
                arrayList.add((ReasoningStep)reasoningStep3.getSubProofs().get(2));
                linkedList2.add(new ConjunctionProofStep(arrayList));
            }
        }
        return new IteratorBasedReasoningStepIterator(linkedList2);
    }

    public ReasoningStepIterator equivalenceInconsistencies() throws ReasoningException {
        return this.ask("(and (" + OWL.differentFrom + " ?x ?y)(" + OWL.sameAs + " ?x ?y))");
    }

    public ReasoningStepIterator exceedsMaxCard0Inconsistencies() throws ReasoningException {
        return this.ask("(and (" + OWL.maxCardinality + " ?r 0)(" + OWL.onProperty + " ?r ?p)(" + RDF.type + " ?x ?r)(holds ?p ?x ?v))");
    }

    public ReasoningStepIterator nothingInconsistencies() throws ReasoningException {
        return this.ask("(" + RDF.type + " ?x " + OWL.Nothing + ')');
    }

    public ReasoningStepIterator nilItemInconsistencies() throws ReasoningException {
        return this.ask("(" + RDF.item + ' ' + RDF.nil + " ?x)");
    }

    public ReasoningStepIterator nilRestInconsistencies() throws ReasoningException {
        return this.ask("(" + RDF.rest + ' ' + RDF.nil + " ?l)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ConjunctionProofStep
    extends ReasoningStep {
        ConjunctionProofStep(List list) {
            this.subGoals = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.subGoals.add(((ReasoningStep)iterator.next()).getGoal());
            }
            this.subProofs = list;
            this.goal = new DefaultCNFSentence(this.subGoals);
        }

        public String tracePrint() {
            return "Inferred by proving each literal in the conjunction";
        }
    }
}

