/*
 * Decompiled with CFR 0.152.
 */
package jtp.context.daml;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.classifier.ClassifierTellingReasoner;
import jtp.context.rdf.RDFReasoningContext;
import jtp.disp.DispatcherUtils;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.daml.DAMLParser;
import jtp.frame.listen.dl.IntersectionTypeReasoner;
import jtp.frame.vocab.DAML;
import jtp.frame.vocab.RDF;
import jtp.frame.vocab.RDFS;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.IteratorBasedReasoningStepIterator;
import jtp.undo.Snapshot;

public class DamlReasoningContext
extends RDFReasoningContext {
    IntersectionTypeReasoner intersectionTypeReasoner;
    ClassifierTellingReasoner classifierTellingReasoner;
    public static final URL DAML_RULES = (class$jtp$context$daml$DamlReasoningContext == null ? (class$jtp$context$daml$DamlReasoningContext = DamlReasoningContext.class$("jtp.context.daml.DamlReasoningContext")) : class$jtp$context$daml$DamlReasoningContext).getResource("daml-rules.xml");
    public static final URL DAML_TRIPLES = (class$jtp$context$daml$DamlReasoningContext == null ? (class$jtp$context$daml$DamlReasoningContext = DamlReasoningContext.class$("jtp.context.daml.DamlReasoningContext")) : class$jtp$context$daml$DamlReasoningContext).getResource("daml-assumptions.kif");
    public static final String DAML_AXIOMATIC_SEMANTICS = "http://www.daml.org/2001/03/axiomatic-semantics.html";
    DAMLParser damlParser = new DAMLParser();
    static /* synthetic */ Class class$jtp$context$daml$DamlReasoningContext;

    public IntersectionTypeReasoner getIntersectionTypeReasoner() {
        return this.intersectionTypeReasoner;
    }

    public void setIntersectionTypeReasoner(IntersectionTypeReasoner intersectionTypeReasoner) {
        this.intersectionTypeReasoner = intersectionTypeReasoner;
    }

    public ClassifierTellingReasoner getClassifierTellingReasoner() {
        return this.classifierTellingReasoner;
    }

    public void setClassifierTellingReasoner(ClassifierTellingReasoner classifierTellingReasoner) {
        this.classifierTellingReasoner = classifierTellingReasoner;
    }

    public DAMLParser getDamlParser() {
        return this.damlParser;
    }

    public void setUp() {
        try {
            super.setUp();
            URL uRL = new URL(DAML_AXIOMATIC_SEMANTICS);
            this.loadSpecs(DAML_RULES, uRL);
            this.loadKB(DAML_TRIPLES, uRL, this.getKifParser());
            this.add(this.getIntersectionTypeReasoner());
            this.add(this.getClassifierTellingReasoner());
            DispatcherUtils.addToDispatcher(this.getIntersectionTypeReasoner(), this.getTellingDispatcher());
            DispatcherUtils.addToDispatcher(this.getClassifierTellingReasoner(), this.getTellingDispatcher());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (ReasoningException reasoningException) {
            throw new RuntimeException(reasoningException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void createEmptyContentHolders() {
        super.createEmptyContentHolders();
        this.setIntersectionTypeReasoner(new IntersectionTypeReasoner(DAML.intersectionOf, RDF.type, RDF.item));
        ClassifierTellingReasoner classifierTellingReasoner = new ClassifierTellingReasoner();
        classifierTellingReasoner.setPrimarySubclassRelation(RDFS.subClassOf);
        classifierTellingReasoner.addSubclassRelation(DAML.subClassOf);
        classifierTellingReasoner.setPrimaryEquivalenceRelation(DAML.sameClassAs);
        classifierTellingReasoner.addConjunctiveRelation(DAML.intersectionOf);
        classifierTellingReasoner.addDisjunctiveRelation(DAML.unionOf);
        classifierTellingReasoner.addDisjunctiveRelation(DAML.disjointUnionOf);
        classifierTellingReasoner.setListItemRelation(RDF.item);
        this.setClassifierTellingReasoner(classifierTellingReasoner);
    }

    public void loadDamlKB(URL uRL, URL uRL2) throws ReasoningException, IOException {
        this.loadRDFKB(uRL, uRL2);
    }

    public void loadDamlKB(Model model, URL uRL) throws ReasoningException, IOException {
        this.loadRDFKB(model, uRL);
    }

    public void writeDaml(Writer writer, Snapshot snapshot, String string, Map map) {
        this.writeRDF(writer, snapshot, string, map);
    }

    public ReasoningStepIterator inconsistencies() {
        return new ReasoningStepIterator(){
            int current = 0;
            ReasoningStepIterator currentSteps = ArrayReasoningStepIterator.empty;

            public ReasoningStep next() throws ReasoningException {
                ReasoningStep reasoningStep = this.currentSteps.next();
                while (reasoningStep == null) {
                    switch (this.current++) {
                        case 0: {
                            this.currentSteps = DamlReasoningContext.this.nilRestInconsistencies();
                            break;
                        }
                        case 1: {
                            this.currentSteps = DamlReasoningContext.this.nilItemInconsistencies();
                            break;
                        }
                        case 2: {
                            this.currentSteps = DamlReasoningContext.this.nothingInconsistencies();
                            break;
                        }
                        case 3: {
                            this.currentSteps = DamlReasoningContext.this.exceedsMaxCard0Inconsistencies();
                            break;
                        }
                        case 4: {
                            this.currentSteps = DamlReasoningContext.this.equivalenceInconsistencies();
                            break;
                        }
                        case 5: {
                            this.currentSteps = DamlReasoningContext.this.disjointnessInconsistencies();
                            break;
                        }
                        default: {
                            this.currentSteps = ArrayReasoningStepIterator.empty;
                            return null;
                        }
                    }
                    reasoningStep = this.currentSteps.next();
                }
                return reasoningStep;
            }
        };
    }

    public ReasoningStepIterator disjointnessInconsistencies() throws ReasoningException {
        ReasoningStep reasoningStep;
        int n = this.getMaxDepth();
        boolean bl = this.idr.getTrimDeepSolutions();
        this.setMaxDepth(2);
        this.idr.setTrimDeepSolutions(false);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ReasoningStepIterator reasoningStepIterator = this.ask("(" + DAML.disjointWith + " ?c1 ?c2)");
        while ((reasoningStep = reasoningStepIterator.next()) != null) {
            linkedList.add(SubstUtils.replaceVariables(reasoningStep));
        }
        this.setMaxDepth(n);
        this.idr.setTrimDeepSolutions(bl);
        if (linkedList.isEmpty()) {
            return ArrayReasoningStepIterator.empty;
        }
        LinkedList<ConjunctionProofStep> linkedList2 = new LinkedList<ConjunctionProofStep>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ReasoningStep reasoningStep2 = (ReasoningStep)iterator.next();
            Literal literal = SubstUtils.deReferenceLiteral((Literal)reasoningStep2.getGoal());
            Object e = literal.getArgs().get(0);
            Object e2 = literal.getArgs().get(1);
            reasoningStepIterator = this.ask("(and (" + RDF.type + " ?x " + e + ")(" + RDF.type + " ?x " + e2 + "))");
            while ((reasoningStep = reasoningStepIterator.next()) != null) {
                ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(3);
                arrayList.add(reasoningStep2);
                ReasoningStep reasoningStep3 = (ReasoningStep)reasoningStep.getSubProofs().get(0);
                arrayList.add((ReasoningStep)reasoningStep3.getSubProofs().get(1));
                arrayList.add((ReasoningStep)reasoningStep3.getSubProofs().get(2));
                linkedList2.add(new ConjunctionProofStep(arrayList));
            }
        }
        return new IteratorBasedReasoningStepIterator(linkedList2);
    }

    public ReasoningStepIterator equivalenceInconsistencies() throws ReasoningException {
        return this.ask("(and (" + DAML.differentIndividualFrom + " ?x ?y)(" + DAML.equivalentTo + " ?x ?y))");
    }

    public ReasoningStepIterator exceedsMaxCard0Inconsistencies() throws ReasoningException {
        return this.ask("(and (" + DAML.maxCardinalityQ + " ?r 0)(" + DAML.onProperty + " ?r ?p)(" + DAML.hasClassQ + " ?r ?c)(" + RDF.type + " ?x ?r)(holds ?p ?x ?v)(" + RDF.type + " ?v ?c))");
    }

    public ReasoningStepIterator nothingInconsistencies() throws ReasoningException {
        return this.ask("(" + RDF.type + " ?x " + DAML.Nothing + ')');
    }

    public ReasoningStepIterator nilItemInconsistencies() throws ReasoningException {
        return this.ask("(" + DAML.item + ' ' + DAML.nil + " ?x)");
    }

    public ReasoningStepIterator nilRestInconsistencies() throws ReasoningException {
        return this.ask("(" + DAML.rest + ' ' + DAML.nil + " ?l)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ConjunctionProofStep
    extends ReasoningStep {
        ConjunctionProofStep(List list) {
            this.subGoals = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.subGoals.add(((ReasoningStep)iterator.next()).getGoal());
            }
            this.subProofs = list;
            this.goal = new DefaultCNFSentence(this.subGoals);
        }

        public String tracePrint() {
            return "Inferred by proving each literal in the conjunction";
        }
    }
}

