/*
 * Decompiled with CFR 0.152.
 */
package jtp.context;

import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.context.DefaultDepthMonitor;
import jtp.context.Tracer;
import jtp.modelim.ModelEliminationReasoner;
import jtp.rs.RSUtils;
import jtp.util.PropertyImporter;

public class IterativeDeepening
extends PropertyImporter
implements Reasoner {
    Monitor dm = null;
    int maxIterationDepth = 0;
    int startingDepth = 1;
    int minSolutionDepth = Integer.MAX_VALUE;
    boolean trimShallowSolutions = true;
    boolean trimDeepSolutions = true;
    Tracer tracer;
    Reasoner theoremProver;

    public IterativeDeepening() {
        this.setImportedProperties(new String[]{"tracer", "maxDepth"});
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Reasoner getTheoremProver() {
        return this.theoremProver;
    }

    public void setTheoremProver(Reasoner reasoner) {
        this.theoremProver = reasoner;
    }

    public int getMaxDepth() {
        return this.maxIterationDepth;
    }

    public void setMaxDepth(int n) {
        this.maxIterationDepth = n;
    }

    public int getStartingDepth() {
        return this.startingDepth;
    }

    public void setStartingDepth(int n) {
        this.startingDepth = n;
    }

    public boolean getTrimShallowSolutions() {
        return this.trimShallowSolutions;
    }

    public void setTrimShallowSolutions(boolean bl) {
        this.trimShallowSolutions = bl;
    }

    public boolean getTrimDeepSolutions() {
        return this.trimDeepSolutions;
    }

    public void setTrimDeepSolutions(boolean bl) {
        this.trimDeepSolutions = bl;
    }

    public ReasoningStepIterator process(Object object) throws ReasoningException {
        this.getTracer().setTraceDepth(0);
        this.dm = new Monitor(object, this.getStartingDepth());
        ((ModelEliminationReasoner)this.getTheoremProver()).setDepthMonitor(this.dm);
        return this.dm;
    }

    public boolean acceptable(Object object) {
        return true;
    }

    class Monitor
    extends DefaultDepthMonitor
    implements ReasoningStepIterator {
        ReasoningStepIterator pit = null;
        Object goal;
        int initialTraceDepth;

        public Monitor(Object object, int n) throws ReasoningException {
            super(n);
            this.initialTraceDepth = IterativeDeepening.this.tracer.getTraceDepth();
            this.setCurrentDepth(1);
            this.goal = object;
        }

        public ReasoningStep next() throws ReasoningException {
            if (IterativeDeepening.this.dm != this) {
                throw new IllegalStateException("Attempt to launch concurrent queries");
            }
            if (this.pit == null) {
                this.pit = IterativeDeepening.this.theoremProver.process(this.goal);
            }
            while (this.maxDepth <= IterativeDeepening.this.maxIterationDepth) {
                ReasoningStep reasoningStep;
                if (IterativeDeepening.this.tracer.getVerbosityLevel() > 0) {
                    IterativeDeepening.this.tracer.trace("Setting max depth to " + this.maxDepth);
                }
                if ((reasoningStep = this.pit.next()) != null) {
                    int n = RSUtils.getNestingDepth(reasoningStep);
                    if (IterativeDeepening.this.trimShallowSolutions && n < this.maxDepth) {
                        if (IterativeDeepening.this.tracer.getVerbosityLevel() <= 0) continue;
                        IterativeDeepening.this.tracer.trace("Shallow solution ignored: max depth " + this.maxDepth + ", RS depth " + n);
                        continue;
                    }
                    if (IterativeDeepening.this.trimDeepSolutions && n > this.maxDepth) {
                        if (IterativeDeepening.this.tracer.getVerbosityLevel() > 0) {
                            IterativeDeepening.this.tracer.trace("Solution too expensive; ignored: max depth " + this.maxDepth + ", RS depth " + n);
                        }
                        if (this.maxDepthRequested >= n) continue;
                        this.maxDepthRequested = n;
                        continue;
                    }
                    if (IterativeDeepening.this.tracer.getVerbosityLevel() > 0) {
                        IterativeDeepening.this.tracer.trace("Solution depth: " + n);
                    }
                    return reasoningStep;
                }
                IterativeDeepening.this.tracer.setTraceDepth(this.initialTraceDepth);
                if (this.maxDepthRequested <= this.maxDepth) {
                    if (IterativeDeepening.this.tracer.getVerbosityLevel() > 0) {
                        IterativeDeepening.this.tracer.trace("Search space exhausted");
                    }
                    return null;
                }
                this.maxDepthRequested = 0;
                ++this.maxDepth;
                this.setCurrentDepth(1);
                this.pit = IterativeDeepening.this.theoremProver.process(this.goal);
                if (IterativeDeepening.this.tracer.getVerbosityLevel() <= 0) continue;
                IterativeDeepening.this.tracer.trace("Increasing maximum search depth level to " + this.maxDepth);
            }
            if (IterativeDeepening.this.tracer.getVerbosityLevel() > 0) {
                IterativeDeepening.this.tracer.trace("Search depth limit exhausted.");
            }
            return null;
        }
    }
}

