/*
 * Decompiled with CFR 0.152.
 */
package jtp.classifier;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class Resource
implements Comparable {
    protected static final int _ALL_BITS_ON = -1;
    private static int _nResCount = 1;
    private static HashMap _hmResIDMap = new HashMap();
    public static final Resource _MIN_RESOURCE = new Resource(0);
    public static final Resource _MAX_RESOURCE = new Resource(Integer.MAX_VALUE);
    public static Resource _TOP = new Resource();
    public static Resource _BOTTOM = new Resource();
    public static Resource _GEN = new Resource();
    public static Resource _ME = new Resource();
    public static Resource _MA = new Resource();
    public static Resource _MR = new Resource();
    public static Resource _MI = new Resource();
    public static Resource _CARD = new Resource();
    public static Resource _MIN_CARD = new Resource();
    public static Resource _MAX_CARD = new Resource();
    public static Resource _CARDQ = new Resource();
    public static Resource _MIN_CARDQ = new Resource();
    public static Resource _MAX_CARDQ = new Resource();
    public static Resource _MIN_FP = new Resource();
    public static Resource _MAX_FP = new Resource();
    private Collection _aliases = new LinkedList();
    private int _nID = 0;
    protected long[] _nMarkID = null;
    protected int[] _nMarkPattern = null;
    protected static final int _NUM_MARKER_SETS = 2;
    protected static long[] _nCurrentMarkID = new long[2];
    protected static int[] _nDefaultPattern = new int[2];

    Resource() {
        this(_nResCount++);
    }

    private Resource(int n) {
        this._nID = n;
        if (_nResCount <= this._nID && this._nID != Integer.MAX_VALUE) {
            _nResCount = this._nID + 1;
        }
        _hmResIDMap.put(new Integer(this._nID), this);
        this._nMarkID = new long[2];
        this._nMarkPattern = new int[2];
    }

    public Collection getAliases() {
        return this._aliases;
    }

    public String toString() {
        if (this._aliases.isEmpty()) {
            return "[" + this._nID + ']';
        }
        return this._aliases.iterator().next().toString();
    }

    public int hashCode() {
        return this._nID;
    }

    public int getID() {
        return this._nID;
    }

    public boolean equals(Object object) {
        return object.getClass() == this.getClass() && ((Resource)object)._nID == this._nID;
    }

    public int compareTo(Object object) {
        Resource resource = (Resource)object;
        return this.getID() - resource.getID();
    }

    protected void remapID(int n) {
        _hmResIDMap.remove(new Integer(this._nID));
        this._nID = n;
        _hmResIDMap.put(new Integer(this._nID), this);
    }

    protected static void ClearMarks(int n) {
        int n2 = n;
        _nCurrentMarkID[n2] = _nCurrentMarkID[n2] + 1L;
    }

    protected static void SetDefaultMark(int n, int n2) {
        Resource._nDefaultPattern[n2] = n;
    }

    protected void setMark(int n, int n2) {
        this._nMarkID[n2] = _nCurrentMarkID[n2];
        this._nMarkPattern[n2] = n;
    }

    protected void addMark(int n, int n2) {
        if (this._nMarkID[n2] == _nCurrentMarkID[n2]) {
            int n3 = n2;
            this._nMarkPattern[n3] = this._nMarkPattern[n3] | n;
        } else {
            this._nMarkID[n2] = _nCurrentMarkID[n2];
            this._nMarkPattern[n2] = n | _nDefaultPattern[n2];
        }
    }

    protected int getMark(int n) {
        if (this._nMarkID[n] == _nCurrentMarkID[n]) {
            return this._nMarkPattern[n];
        }
        return _nDefaultPattern[n];
    }

    protected boolean containsMark(int n, int n2) {
        return (this.getMark(n2) | ~n) == -1;
    }

    public void printDef(PrintStream printStream, boolean bl) {
        printStream.println("Resource: '" + this + "' [" + this._nID + "]");
    }

    public static Set GetAllResources() {
        return _hmResIDMap.keySet();
    }

    public static class ResourceComparator
    implements Comparator {
        public boolean equals(Object object) {
            return this == object;
        }

        public int compare(Object object, Object object2) {
            int n = ((Resource)object).getID();
            int n2 = ((Resource)object2).getID();
            return n - n2;
        }
    }
}

