/*
 * Decompiled with CFR 0.152.
 */
package jtp.classifier;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtp.classifier.Resource;

public class Relation
extends Resource {
    public static Relation _MOD = new Relation(null, null);
    public static Relation _INV_MOD = new Relation(_MOD, null);
    public static Relation _SUBSUMED_BY = new Relation(null, _MOD);
    public static Relation _SUBSUMES = new Relation(_SUBSUMED_BY, _MOD);
    public static Relation _MODIFIES = new Relation(null, _MOD);
    public static Relation _MODIFIED_BY = new Relation(_MODIFIES, _INV_MOD);
    public static Class _C_RELATION;
    public Relation _relInverse;
    public boolean _bIsInverse = false;
    protected Collection _alParents;
    protected Collection _alChildren;

    public Relation(Relation relation, Relation relation2) {
        this._relInverse = relation;
        if (relation != null) {
            relation._relInverse = this;
            this._bIsInverse = true;
        }
        if (relation2 != null) {
            this.addParent(relation2);
        }
    }

    public void addParent(Relation relation) {
        if (this._alParents == null) {
            this._alParents = new LinkedList();
        }
        this._alParents.add(relation);
        relation.addChild(this);
    }

    public Collection getParents(boolean bl) {
        if (bl) {
            return this._alParents;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this._alParents);
        Iterator iterator = this._alParents.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Relation)iterator.next()).getParents(false));
        }
        return linkedList;
    }

    public void addChild(Relation relation) {
        if (this._alChildren == null) {
            this._alChildren = new LinkedList();
        }
        this._alChildren.add(relation);
    }

    public Collection getChildren(boolean bl) {
        if (bl) {
            return this._alChildren;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this._alChildren);
        Iterator iterator = this._alChildren.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Relation)iterator.next()).getChildren(false));
        }
        return linkedList;
    }

    public boolean hasParent(Relation relation) {
        if (this.equals(relation) || this._alParents.contains(relation)) {
            return true;
        }
        Iterator iterator = this._alParents.iterator();
        while (iterator.hasNext()) {
            if (!((Relation)iterator.next()).hasParent(relation)) continue;
            return true;
        }
        return false;
    }

    public void printDef(PrintStream printStream, boolean bl) {
        this.printDef(printStream, bl, false);
    }

    public void printDef(PrintStream printStream, boolean bl, boolean bl2) {
        printStream.println("Relation: '" + this + "' [" + this.getID() + "]");
        if (bl) {
            Iterator iterator = this.getParents(!bl2).iterator();
            while (iterator.hasNext()) {
                printStream.println("   +- Par: " + (Relation)iterator.next());
            }
            if (bl2) {
                Iterator iterator2 = this.getChildren(true).iterator();
                while (iterator2.hasNext()) {
                    printStream.println("   +- Dch: " + (Relation)iterator2.next());
                }
            }
            if (this._relInverse != null) {
                printStream.println("   +- Inv: " + this._relInverse);
            }
        }
    }

    public static Relation CastToRelation(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (_C_RELATION.isAssignableFrom(resource.getClass())) {
            return (Relation)resource;
        }
        return null;
    }

    public static boolean IsRelation(Resource resource) {
        return _C_RELATION.isAssignableFrom(resource.getClass());
    }

    static {
        try {
            _C_RELATION = Class.forName("jtp.classifier.Relation");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

