/*
 * Decompiled with CFR 0.152.
 */
package jtp.classifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.ReasoningException;
import jtp.classifier.Classifier;
import jtp.classifier.Modifier;
import jtp.classifier.Relation;
import jtp.classifier.Resource;
import jtp.classifier.Triple;
import jtp.classifier.TripleSet;

public class Kb {
    protected static final int _A_TABLE = 0;
    protected static final int _C_TABLE = 1;
    protected static final int _S_TABLE = 2;
    protected static final int _D_TABLE = 3;
    protected static final int _NUM_TABLES = 4;
    public static final int _A_LINK = 1;
    public static final int _C_LINK = 2;
    public static final int _S_LINK = 4;
    public static final int _D_LINK = 8;
    protected static final int _NKB_MARKER_SET = 1;
    protected static final int _EMPTY = 0;
    protected static final int _VISITED = 1;
    protected static final int _ALL = -1;
    private TripleSet[] _tripleSet;
    private Classifier _classifier;
    private Map _resourceAliasMap = new HashMap(100);
    private UndoManager _undoManager;

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public Kb() {
        this(new Classifier());
    }

    public Kb(Classifier classifier) {
        this._tripleSet = new TripleSet[4];
        int n = 0;
        while (n < 4) {
            this._tripleSet[n] = new TripleSet();
            ++n;
        }
        this._classifier = classifier;
        this._classifier.setKb(this);
        try {
            this.addResourceAlias("MIN-RESOURCE", Resource._MIN_RESOURCE);
            this.addResourceAlias("MAX-RESOURCE", Resource._MAX_RESOURCE);
            this.addResourceAlias("TOP", Resource._TOP);
            this.addResourceAlias("BOTTOM", Resource._BOTTOM);
            this.addResourceAlias("GEN", Resource._GEN);
            this.addResourceAlias("ME", Resource._ME);
            this.addResourceAlias("MA", Resource._MA);
            this.addResourceAlias("MR", Resource._MR);
            this.addResourceAlias("MI", Resource._MI);
            this.addResourceAlias("CARD", Resource._CARD);
            this.addResourceAlias("MIN-CARD", Resource._MIN_CARD);
            this.addResourceAlias("MAX-CARD", Resource._MAX_CARD);
            this.addResourceAlias("CARDQ", Resource._CARDQ);
            this.addResourceAlias("MIN-CARDQ", Resource._MIN_CARDQ);
            this.addResourceAlias("MAX-CARDQ", Resource._MAX_CARDQ);
            this.addResourceAlias("MIN-FP", Resource._MIN_FP);
            this.addResourceAlias("MAX-FP", Resource._MAX_FP);
            this.addResourceAlias("GEN-MOD-TOP", Modifier._GEN_MOD_TOP);
            this.addResourceAlias("MOD", Relation._MOD);
            this.addResourceAlias("INV-MOD", Relation._INV_MOD);
            this.addResourceAlias("SUBSUMED-BY", Relation._SUBSUMED_BY);
            this.addResourceAlias("SUBSUMES", Relation._SUBSUMES);
            this.addResourceAlias("MODIFIES", Relation._MODIFIES);
            this.addResourceAlias("MODIFIED-BY", Relation._MODIFIED_BY);
        }
        catch (ReasoningException reasoningException) {
            // empty catch block
        }
        this.addTripleLink(Resource._BOTTOM, Relation._SUBSUMED_BY, Resource._TOP, 4);
    }

    public Collection addSubclassLink(Object object, Object object2) throws ReasoningException {
        Resource resource;
        Resource resource2 = this.getOrCreateResource(object);
        if (resource2 == (resource = this.getOrCreateResource(object2))) {
            return Collections.EMPTY_LIST;
        }
        boolean bl = this.isTripleLink(resource2, Relation._SUBSUMED_BY, resource, -1);
        this.addTripleLink(resource2, Relation._SUBSUMED_BY, resource, 1);
        if (bl) {
            return Collections.EMPTY_LIST;
        }
        Resource resource3 = this.detectAndCollapseCycle(resource2, Relation._SUBSUMED_BY);
        if (resource3 != null) {
            resource2 = resource3;
            resource = resource3;
        } else {
            this.maintainTopLinks(resource2);
            this.maintainBottomLinks(resource2);
            this.maintainTopLinks(resource);
            this.maintainBottomLinks(resource);
        }
        Collection collection = this.reClassifyDefinedConceptsAboveAndBelow(resource2, resource);
        if (resource3 != null) {
            collection.add(new Classifier.ClassifyInfo(resource3, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true));
        }
        return collection.isEmpty() ? Collections.EMPTY_LIST : collection;
    }

    public Collection addEquivalence(Object object, Object object2) throws ReasoningException {
        Resource resource;
        Resource resource2 = this.getOrCreateResource(object);
        if (resource2 == (resource = this.getOrCreateResource(object2))) {
            return Collections.EMPTY_LIST;
        }
        Resource resource3 = this.collapseCycle(Arrays.asList(resource2, resource));
        return this.reClassifyDefinedConceptsAboveAndBelow(resource3, resource3);
    }

    public Collection addConjunct(Object object, Collection collection) throws ReasoningException {
        Resource resource = this.getOrCreateResource(object);
        Collection collection2 = new ArrayList<Resource>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection2.add(this.getOrCreateResource(iterator.next()));
        }
        collection2 = this.replaceConstituents(resource, collection2, Relation._SUBSUMED_BY, 2);
        Collection collection3 = this.replaceReferences(resource, collection2, Relation._SUBSUMES, 2);
        collection3.add(resource);
        Iterator iterator2 = collection2.iterator();
        while (iterator2.hasNext()) {
            Resource resource2 = (Resource)iterator2.next();
            this.addTripleLink(resource, Relation._SUBSUMED_BY, resource2, 2);
            this.maintainTopLinks(resource2);
            this.maintainBottomLinks(resource2);
        }
        return this.reClassifyDefinedConceptsAbove(collection3);
    }

    public Collection addDisjunct(Object object, Collection collection) throws ReasoningException {
        Object object2;
        LinkedList<Classifier.ClassifyInfo> linkedList = new LinkedList<Classifier.ClassifyInfo>();
        Resource resource = this.getOrCreateResource(object);
        Collection collection2 = new ArrayList<Resource>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection2.add(this.getOrCreateResource(iterator.next()));
        }
        collection2 = this.replaceConstituents(resource, collection2, Relation._SUBSUMES, 8);
        Collection collection3 = this.replaceReferences(resource, collection2, Relation._SUBSUMED_BY, 8);
        collection3.add(resource);
        Iterator iterator2 = collection2.iterator();
        while (iterator2.hasNext()) {
            object2 = (Resource)iterator2.next();
            this.addTripleLink(resource, Relation._SUBSUMES, (Resource)object2, 8);
            this.maintainTopLinks((Resource)object2);
            this.maintainBottomLinks((Resource)object2);
        }
        object2 = collection3.iterator();
        while (object2.hasNext()) {
            Classifier.ClassifyInfo classifyInfo = this._classifier.classifyDisjConcept((Resource)object2.next());
            if (!classifyInfo.isInference()) continue;
            linkedList.add(classifyInfo);
        }
        return linkedList.isEmpty() ? Collections.EMPTY_LIST : linkedList;
    }

    protected Collection classifyConjunctsWithMGSOnly(Collection collection) throws ReasoningException {
        LinkedList<Classifier.ClassifyInfo> linkedList = new LinkedList<Classifier.ClassifyInfo>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            Set set = this._classifier.conceptConjMGS(resource);
            Set set2 = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, -1));
            Classifier.ClassifyInfo classifyInfo = this._classifier.insertConcept(resource, set2, set);
            if (!classifyInfo.isInference()) continue;
            linkedList.add(classifyInfo);
        }
        return linkedList;
    }

    protected Collection classifyDisjunctsWithMSSOnly(Collection collection) throws ReasoningException {
        LinkedList<Classifier.ClassifyInfo> linkedList = new LinkedList<Classifier.ClassifyInfo>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Set set;
            Set set2;
            Resource resource = (Resource)iterator.next();
            Classifier.ClassifyInfo classifyInfo = this._classifier.insertConcept(resource, set2 = this._classifier.conceptDisjMSS(resource), set = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMES, -1)));
            if (!classifyInfo.isInference()) continue;
            linkedList.add(classifyInfo);
        }
        return linkedList;
    }

    protected Collection reClassifyDefinedConceptsAbove(Resource resource) throws ReasoningException {
        return this.classifyConjunctsWithMGSOnly(this.searchUpForConjClasses(resource));
    }

    protected Collection reClassifyDefinedConceptsBelow(Resource resource) throws ReasoningException {
        return this.classifyDisjunctsWithMSSOnly(this.searchDownForDisjClasses(resource));
    }

    protected Collection reClassifyDefinedConceptsAbove(Collection collection) throws ReasoningException {
        return this.classifyConjunctsWithMGSOnly(this.searchUpForConjClasses(collection));
    }

    protected Collection reClassifyDefinedConceptsBelow(Collection collection) throws ReasoningException {
        return this.classifyDisjunctsWithMSSOnly(this.searchDownForDisjClasses(collection));
    }

    protected Collection reClassifyDefinedConceptsAboveAndBelow(Resource resource, Resource resource2) throws ReasoningException {
        Collection collection = this.reClassifyDefinedConceptsAbove(resource2);
        collection.addAll(this.reClassifyDefinedConceptsBelow(resource));
        return collection;
    }

    protected Resource getResource(Object object) {
        return (Resource)this._resourceAliasMap.get(object);
    }

    protected Resource createResource(Object object) throws ReasoningException {
        Resource resource = new Resource();
        this.addResourceAlias(object, resource);
        return resource;
    }

    protected Resource getOrCreateResource(Object object) {
        Resource resource;
        block2: {
            resource = this.getResource(object);
            if (resource != null) break block2;
            try {
                resource = this.createResource(object);
            }
            catch (ReasoningException reasoningException) {}
        }
        return resource;
    }

    protected void deleteResource(Resource resource) throws ReasoningException {
        Iterator iterator = resource.getAliases().iterator();
        while (iterator.hasNext()) {
            this._resourceAliasMap.remove(iterator.next());
        }
    }

    protected void addResourceAlias(Object object, Resource resource) throws ReasoningException {
        if (this._resourceAliasMap.get(object) != null) {
            throw new ReasoningException("A resource with alias '" + object + "' already exists");
        }
        resource.getAliases().add(object);
        this._resourceAliasMap.put(object, resource);
    }

    protected Modifier createModifier(Object object, Relation relation, Resource resource, Resource resource2, int n) throws ReasoningException {
        Modifier modifier = new Modifier(relation, resource, resource2, n);
        this.addResourceAlias(object, modifier);
        return modifier;
    }

    protected Modifier getOrCreateModifier(Object object, Relation relation, Resource resource, Resource resource2, int n) throws ReasoningException {
        Resource resource3 = this.getResource(object);
        Modifier modifier = Modifier.CastToModifier(resource3);
        if (modifier != null) {
            if (modifier._rel != relation || modifier._conc != resource || modifier._type != resource2 || modifier._card_val != n) {
                throw new ReasoningException("Modifier with same name does not have same properties: " + modifier);
            }
            return modifier;
        }
        if (resource3 != null) {
            throw new ReasoningException("Resource with same name is already defined, but it's not a Modifier: " + resource3);
        }
        return this.createModifier(object, relation, resource, resource2, n);
    }

    protected Relation createRelation(Object object, Relation relation, Relation relation2) throws ReasoningException {
        Relation relation3 = new Relation(relation, relation2);
        this.addResourceAlias(object, relation3);
        return relation3;
    }

    protected Relation getOrCreateRelation(Object object, Relation relation, Relation relation2) throws ReasoningException {
        Relation relation3 = Relation.CastToRelation(this.getResource(object));
        if (relation3 == null) {
            relation3 = this.createRelation(object, relation, relation2);
        }
        return relation3;
    }

    protected static int GetTable(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    protected static int GetLink(int n) {
        if (n < 0 || n >= 4) {
            return -1;
        }
        return 1 << n;
    }

    protected void maintainTopLinks(Resource resource) {
        Set set = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, -1));
        if (set.isEmpty() && resource != Resource._TOP) {
            this.addTripleLink(resource, Relation._SUBSUMED_BY, Resource._TOP, 4);
        } else if (set.size() > 1 && set.contains(Resource._TOP)) {
            this.removeTripleLink(resource, Relation._SUBSUMED_BY, Resource._TOP, -1);
        }
    }

    protected void maintainBottomLinks(Resource resource) {
        Set set = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMES, -1));
        if (set.isEmpty() && resource != Resource._BOTTOM) {
            this.addTripleLink(Resource._BOTTOM, Relation._SUBSUMED_BY, resource, 4);
        } else if (set.size() > 1 && set.contains(Resource._BOTTOM)) {
            this.removeTripleLink(Resource._BOTTOM, Relation._SUBSUMED_BY, resource, -1);
        }
    }

    protected Resource detectAndCollapseCycle(Resource resource, Relation relation) throws ReasoningException {
        LinkedList linkedList = new LinkedList();
        this.clearMarks(0);
        this.findCycle(resource, relation, new LinkedList(), linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            if (resource2.containsMark(1, 1)) {
                iterator.remove();
                continue;
            }
            resource2.addMark(1, 1);
        }
        return linkedList.isEmpty() ? null : this.collapseCycle(linkedList);
    }

    protected void findCycle(Resource resource, Relation relation, LinkedList linkedList, Collection collection) {
        if (resource.containsMark(1, 1)) {
            collection.addAll(linkedList);
            return;
        }
        resource.addMark(1, 1);
        linkedList.add(resource);
        Iterator iterator = Triple.GetValues(this.getTripleLinkSet(resource, relation, -1)).iterator();
        while (iterator.hasNext()) {
            this.findCycle((Resource)iterator.next(), relation, linkedList, collection);
        }
        resource.setMark(resource.getMark(1) & 0xFFFFFFFE, 1);
        linkedList.removeLast();
    }

    protected Resource collapseCycle(Collection collection) throws ReasoningException {
        Resource resource;
        this.clearMarks(0);
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            resource.addMark(1, 1);
            linkedList.addAll(resource.getAliases());
            this.deleteResource(resource);
        }
        resource = new Resource();
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            this.addResourceAlias(iterator2.next(), resource);
        }
        if (this._undoManager != null) {
            this._undoManager.addEdit(new UndoResourceCollapse(resource, collection));
        }
        Iterator iterator3 = collection.iterator();
        while (iterator3.hasNext()) {
            Resource resource2 = (Resource)iterator3.next();
            int n = 1;
            while (n <= 8) {
                Iterator iterator4 = this.getTripleLinkSet(resource2, n).iterator();
                while (iterator4.hasNext()) {
                    Triple triple = (Triple)iterator4.next();
                    Relation relation = (Relation)triple._relation;
                    this.removeTripleLink(triple._subject, relation, triple._value, n);
                    if (triple._value.containsMark(1, 1)) continue;
                    this.addTripleLink(resource, relation, triple._value, n);
                }
                n <<= 1;
            }
        }
        this.maintainTopLinks(resource);
        this.maintainBottomLinks(resource);
        return resource;
    }

    protected void addTripleLink(Resource resource, Relation relation, Resource resource2, int n) {
        this.addTripleLink(resource, relation, resource2, n, true);
    }

    protected void addTripleLink(Resource resource, Relation relation, Resource resource2, int n, boolean bl) {
        int n2 = Kb.GetTable(n);
        if (this._tripleSet[n2].isTriple(resource, relation, resource2)) {
            return;
        }
        this._tripleSet[n2].addTriple(resource, relation, resource2);
        if (bl && relation._relInverse != null) {
            this._tripleSet[n2].addTriple(resource2, relation._relInverse, resource);
        }
        if (this._undoManager != null) {
            this._undoManager.addEdit(new UndoTripleSetEdit(resource, relation, resource2, true, n2));
            if (bl && relation._relInverse != null) {
                this._undoManager.addEdit(new UndoTripleSetEdit(resource2, relation._relInverse, resource, true, n2));
            }
        }
    }

    protected Set getTripleLinkSet(Resource resource, int n) {
        TreeSet treeSet = new TreeSet(new Triple.TripleComparator());
        int n2 = 0;
        while (n2 < 4) {
            if ((n & Kb.GetLink(n2)) > 0) {
                treeSet.addAll(this._tripleSet[n2].getTripleSet(resource));
            }
            ++n2;
        }
        return treeSet;
    }

    protected Set getTripleLinkSet(Resource resource, Resource resource2, int n) {
        TreeSet treeSet = new TreeSet(new Triple.TripleComparator());
        int n2 = 0;
        while (n2 < 4) {
            if ((n & Kb.GetLink(n2)) > 0) {
                treeSet.addAll(this._tripleSet[n2].getTripleSet(resource, resource2));
            }
            ++n2;
        }
        return treeSet;
    }

    protected boolean isTripleLink(Resource resource, Relation relation, Resource resource2, int n) {
        int n2 = 0;
        while (n2 < 4) {
            if ((n & Kb.GetLink(n2)) > 0 && this._tripleSet[n2].isTriple(resource, relation, resource2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void removeTripleLink(Resource resource, Relation relation, Resource resource2, int n) {
        int n2 = 0;
        while (n2 < 4) {
            if ((n & Kb.GetLink(n2)) > 0 && this._tripleSet[n2].isTriple(resource, relation, resource2)) {
                this._tripleSet[n2].removeTriple(resource, relation, resource2);
                if (relation._relInverse != null) {
                    this._tripleSet[n2].removeTriple(resource2, relation._relInverse, resource);
                }
                if (this._undoManager != null) {
                    this._undoManager.addEdit(new UndoTripleSetEdit(resource, relation, resource2, false, n2));
                    if (relation._relInverse != null) {
                        this._undoManager.addEdit(new UndoTripleSetEdit(resource2, relation._relInverse, resource, false, n2));
                    }
                }
            }
            ++n2;
        }
    }

    protected Collection replaceConstituents(Resource resource, Collection collection, Relation relation, int n) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            Set set = Triple.GetValues(this.getTripleLinkSet(resource2, relation, n));
            if (set.isEmpty()) {
                linkedList.add(resource2);
                continue;
            }
            linkedList.addAll(set);
            this.addTripleLink(resource, relation, resource2, 4);
        }
        return linkedList;
    }

    protected Collection replaceReferences(Resource resource, Collection collection, Relation relation, int n) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        Iterator iterator = Triple.GetValues(this.getTripleLinkSet(resource, relation, n)).iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            this.removeTripleLink(resource, relation, resource2, n);
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.addTripleLink((Resource)iterator2.next(), relation, resource2, n);
            }
            this.addTripleLink(resource, relation, resource2, 4);
            linkedList.add(resource2);
        }
        return linkedList;
    }

    protected Collection searchUpForConjClasses(Collection collection) {
        this.clearMarks(0);
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 2).isEmpty() && !resource.containsMark(1, 1)) {
                linkedList.add(resource);
            }
            this.searchUpForConjClassesInternal(resource, linkedList);
        }
        return linkedList;
    }

    protected Collection searchUpForConjClasses(Resource resource) {
        this.clearMarks(0);
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        if (!this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 2).isEmpty()) {
            linkedList.add(resource);
        }
        this.searchUpForConjClassesInternal(resource, linkedList);
        return linkedList;
    }

    private void searchUpForConjClassesInternal(Resource resource, Collection collection) {
        Object object;
        resource.addMark(1, 1);
        Iterator iterator = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMES, 2)).iterator();
        while (iterator.hasNext()) {
            object = (Resource)iterator.next();
            if (((Resource)object).containsMark(1, 1)) continue;
            collection.add(object);
            ((Resource)object).addMark(1, 1);
        }
        object = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, -1)).iterator();
        while (object.hasNext()) {
            Resource resource2 = (Resource)object.next();
            if (resource2.containsMark(1, 1)) continue;
            this.searchUpForConjClassesInternal(resource2, collection);
        }
    }

    protected Collection searchDownForDisjClasses(Collection collection) {
        this.clearMarks(0);
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.searchDownForDisjClassesInternal((Resource)iterator.next(), linkedList);
        }
        return linkedList;
    }

    protected Collection searchDownForDisjClasses(Resource resource) {
        this.clearMarks(0);
        LinkedList linkedList = new LinkedList();
        this.searchDownForDisjClassesInternal(resource, linkedList);
        return linkedList;
    }

    private void searchDownForDisjClassesInternal(Resource resource, Collection collection) {
        Object object;
        resource.addMark(1, 1);
        Iterator iterator = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 8)).iterator();
        while (iterator.hasNext()) {
            object = (Resource)iterator.next();
            if (((Resource)object).containsMark(1, 1)) continue;
            collection.add(object);
            ((Resource)object).addMark(1, 1);
        }
        object = Triple.GetValues(this.getTripleLinkSet(resource, Relation._SUBSUMES, -1)).iterator();
        while (object.hasNext()) {
            Resource resource2 = (Resource)object.next();
            if (resource2.containsMark(1, 1)) continue;
            this.searchDownForDisjClassesInternal(resource2, collection);
        }
    }

    protected void clearMarks(int n) {
        Resource.ClearMarks(1);
        Resource.SetDefaultMark(n, 1);
    }

    class UndoResourceCollapse
    extends AbstractUndoableEdit {
        Resource _newResource;
        Collection _deletedResources;

        UndoResourceCollapse(Resource resource, Collection collection) {
            this._newResource = resource;
            this._deletedResources = collection;
        }

        public void undo() {
            try {
                Kb.this.deleteResource(this._newResource);
                Iterator iterator = this._deletedResources.iterator();
                while (iterator.hasNext()) {
                    Resource resource = (Resource)iterator.next();
                    Iterator iterator2 = resource.getAliases().iterator();
                    while (iterator2.hasNext()) {
                        Kb.this._resourceAliasMap.put(iterator2.next(), resource);
                    }
                }
            }
            catch (ReasoningException reasoningException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            try {
                Iterator iterator = this._deletedResources.iterator();
                while (iterator.hasNext()) {
                    Kb.this.deleteResource((Resource)iterator.next());
                }
                Iterator iterator2 = this._newResource.getAliases().iterator();
                while (iterator2.hasNext()) {
                    Kb.this._resourceAliasMap.put(iterator2.next(), this._newResource);
                }
            }
            catch (ReasoningException reasoningException) {
                throw new CannotUndoException();
            }
        }
    }

    class UndoTripleSetEdit
    extends AbstractUndoableEdit {
        Resource _subj;
        Resource _prop;
        Resource _obj;
        boolean _add;
        int _table;

        UndoTripleSetEdit(Resource resource, Resource resource2, Resource resource3, boolean bl, int n) {
            this._subj = resource;
            this._prop = resource2;
            this._obj = resource3;
            this._add = bl;
            this._table = n;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this._add) {
                Kb.this._tripleSet[this._table].removeTriple(this._subj, this._prop, this._obj);
            } else {
                Kb.this._tripleSet[this._table].addTriple(this._subj, this._prop, this._obj);
            }
        }

        public void redo() throws CannotUndoException {
            if (this._add) {
                Kb.this._tripleSet[this._table].addTriple(this._subj, this._prop, this._obj);
            } else {
                Kb.this._tripleSet[this._table].removeTriple(this._subj, this._prop, this._obj);
            }
        }
    }
}

