/*
 * Decompiled with CFR 0.152.
 */
package jtp.classifier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import jtp.ReasoningException;
import jtp.classifier.Kb;
import jtp.classifier.Modifier;
import jtp.classifier.Relation;
import jtp.classifier.Resource;
import jtp.classifier.Triple;

public class Classifier {
    protected static final int _REL_PATTERN = Integer.MIN_VALUE;
    protected static final int _VISITED = 0x40000000;
    protected static final int _CON_PATTERN = 1;
    protected static final int _EMPTY_PATTERN = 0;
    protected static final int _FULL_PATTERN = -1;
    protected static final int _MARKER_SET = 0;
    protected static final int RS = 16;
    protected static final int CS = 8;
    protected static final int CE = 4;
    protected static final int CGE = 2;
    protected static final int CLE = 1;
    protected Kb _pKb = null;
    protected static boolean _bDebugPrint = false;
    protected static HashMap _hmSubsumes = null;

    protected Classifier() {
        _hmSubsumes = new HashMap();
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._GEN), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._ME), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MR), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MA), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MI), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._CARD), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MIN_CARD), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MAX_CARD), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._CARDQ), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MIN_CARDQ), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._GEN, Resource._MAX_CARDQ), new Integer(-1));
        _hmSubsumes.put(new RtXRt(Resource._ME, Resource._ME), new Integer(24));
        _hmSubsumes.put(new RtXRt(Resource._ME, Resource._CARDQ), new Integer(25));
        _hmSubsumes.put(new RtXRt(Resource._ME, Resource._MIN_CARDQ), new Integer(25));
        _hmSubsumes.put(new RtXRt(Resource._MR, Resource._MR), new Integer(24));
        _hmSubsumes.put(new RtXRt(Resource._MI, Resource._MI), new Integer(4));
        _hmSubsumes.put(new RtXRt(Resource._CARD, Resource._CARD), new Integer(19));
        _hmSubsumes.put(new RtXRt(Resource._CARD, Resource._CARDQ), new Integer(19));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARD, Resource._ME), new Integer(17));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARD, Resource._CARD), new Integer(17));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARD, Resource._MIN_CARD), new Integer(17));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARD, Resource._CARDQ), new Integer(17));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARD, Resource._MIN_CARDQ), new Integer(17));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARD, Resource._CARD), new Integer(18));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARD, Resource._MAX_CARD), new Integer(18));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARD, Resource._CARDQ), new Integer(18));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARD, Resource._MAX_CARDQ), new Integer(18));
        _hmSubsumes.put(new RtXRt(Resource._CARDQ, Resource._CARDQ), new Integer(27));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARDQ, Resource._ME), new Integer(25));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARDQ, Resource._CARDQ), new Integer(25));
        _hmSubsumes.put(new RtXRt(Resource._MIN_CARDQ, Resource._MIN_CARDQ), new Integer(25));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARDQ, Resource._CARDQ), new Integer(26));
        _hmSubsumes.put(new RtXRt(Resource._MAX_CARDQ, Resource._MAX_CARDQ), new Integer(26));
    }

    protected void setKb(Kb kb) {
        this._pKb = kb;
    }

    public String toString() {
        return "Kb Intensional Subsumption Classifier using kb: " + this._pKb;
    }

    protected ClassifyInfo classifyConjConcept(Resource resource) throws ReasoningException {
        Set set = this.conceptConjMSS(resource);
        Set set2 = this.conceptConjMGS(resource);
        return this.insertConcept(resource, set, set2);
    }

    protected ClassifyInfo classifyDisjConcept(Resource resource) throws ReasoningException {
        Set set = this.conceptDisjMGS(resource);
        Set set2 = this.conceptDisjMSS(resource);
        return this.insertConcept(resource, set2, set);
    }

    protected Set conceptConjMSS(Resource resource) {
        this.clearMarks(0);
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 2)).iterator();
        while (iterator.hasNext()) {
            treeSet.addAll(this.markTransClosureAndReturnConcDescendants(Relation._SUBSUMED_BY, Resource._TOP, (Resource)iterator.next(), 1, -1));
        }
        if (treeSet.size() == 0) {
            treeSet.add(Resource._TOP);
        }
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        TreeSet<Resource> treeSet2 = new TreeSet<Resource>();
        linkedList.addAll(treeSet);
        while (linkedList.size() > 0) {
            Resource resource2 = (Resource)linkedList.removeFirst();
            if (resource2.containsMark(0x40000000, 0)) continue;
            resource2.addMark(0x40000000, 0);
            boolean bl = false;
            Iterator iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMES, -1)).iterator();
            while (iterator2.hasNext()) {
                Resource resource3 = (Resource)iterator2.next();
                if (!this.allConjConstituentsHaveMark(resource3, 1)) continue;
                bl = true;
                resource3.addMark(1, 0);
                linkedList.addLast(resource3);
            }
            if (bl) continue;
            treeSet2.add(resource2);
        }
        treeSet2.remove(resource);
        treeSet2.removeAll(Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 3)));
        return treeSet2;
    }

    protected Set conceptConjMGS(Resource resource) {
        Object object;
        this.clearMarks(0);
        int n = 1;
        int n2 = 0;
        Set set = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 2));
        if (set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            n2 |= n;
            object = (Resource)iterator.next();
            this.markTransClosure(Relation._SUBSUMES, (Resource)object, n, -1);
            n <<= 1;
        }
        object = new LinkedList();
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        ((LinkedList)object).addLast(set.iterator().next());
        while (((LinkedList)object).size() > 0) {
            Iterator iterator2;
            Resource resource2 = (Resource)((LinkedList)object).removeFirst();
            if (resource2 == resource || resource2.containsMark(0x40000000, 0)) continue;
            resource2.addMark(0x40000000, 0);
            if (resource2.containsMark(n2, 0)) {
                treeSet.add(resource2);
                iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMED_BY, 8)).iterator();
                while (iterator2.hasNext()) {
                    Resource resource3 = (Resource)iterator2.next();
                    boolean bl = true;
                    Iterator iterator3 = Triple.GetValues(this._pKb.getTripleLinkSet(resource3, Relation._SUBSUMES, 8)).iterator();
                    while (iterator3.hasNext()) {
                        if (((Resource)iterator3.next()).containsMark(n2, 0)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    treeSet.remove(resource2);
                    treeSet.add(resource3);
                }
                continue;
            }
            iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMES, -1)).iterator();
            while (iterator2.hasNext()) {
                ((LinkedList)object).addLast(iterator2.next());
            }
        }
        treeSet.remove(resource);
        treeSet.remove(Resource._BOTTOM);
        return treeSet;
    }

    protected Set conceptDisjMGS(Resource resource) {
        this.clearMarks(0);
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMES, 8)).iterator();
        while (iterator.hasNext()) {
            treeSet.addAll(this.markTransClosureAndReturnConcDescendants(Relation._SUBSUMES, Resource._BOTTOM, (Resource)iterator.next(), 1, -1));
        }
        if (treeSet.size() == 0) {
            treeSet.add(Resource._BOTTOM);
        }
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        TreeSet<Resource> treeSet2 = new TreeSet<Resource>();
        linkedList.addAll(treeSet);
        while (linkedList.size() > 0) {
            Resource resource2 = (Resource)linkedList.removeFirst();
            if (resource2.containsMark(0x40000000, 0)) continue;
            resource2.addMark(0x40000000, 0);
            boolean bl = false;
            Iterator iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMED_BY, -1)).iterator();
            while (iterator2.hasNext()) {
                Resource resource3 = (Resource)iterator2.next();
                if (!this.allDisjConstituentsHaveMark(resource3, 1)) continue;
                bl = true;
                resource3.addMark(1, 0);
                linkedList.addLast(resource3);
            }
            if (bl) continue;
            treeSet2.add(resource2);
        }
        treeSet2.remove(resource);
        treeSet2.removeAll(Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMES, 9)));
        return treeSet2;
    }

    protected Set conceptDisjMSS(Resource resource) {
        Object object;
        this.clearMarks(0);
        int n = 1;
        int n2 = 0;
        Set set = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMES, 8));
        if (set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            n2 |= n;
            object = (Resource)iterator.next();
            this.markTransClosure(Relation._SUBSUMED_BY, (Resource)object, n, -1);
            n <<= 1;
        }
        object = new LinkedList();
        TreeSet<Resource> treeSet = new TreeSet<Resource>();
        ((LinkedList)object).addLast(set.iterator().next());
        while (((LinkedList)object).size() > 0) {
            Iterator iterator2;
            Resource resource2 = (Resource)((LinkedList)object).removeFirst();
            if (resource2 == resource || resource2.containsMark(0x40000000, 0)) continue;
            resource2.addMark(0x40000000, 0);
            if (resource2.containsMark(n2, 0)) {
                treeSet.add(resource2);
                iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMES, 2)).iterator();
                while (iterator2.hasNext()) {
                    Resource resource3 = (Resource)iterator2.next();
                    boolean bl = true;
                    Iterator iterator3 = Triple.GetValues(this._pKb.getTripleLinkSet(resource3, Relation._SUBSUMED_BY, 2)).iterator();
                    while (iterator3.hasNext()) {
                        if (((Resource)iterator3.next()).containsMark(n2, 0)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    treeSet.remove(resource2);
                    treeSet.add(resource3);
                }
                continue;
            }
            iterator2 = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, Relation._SUBSUMED_BY, -1)).iterator();
            while (iterator2.hasNext()) {
                ((LinkedList)object).addLast(iterator2.next());
            }
        }
        treeSet.remove(resource);
        treeSet.remove(Resource._TOP);
        return treeSet;
    }

    protected boolean allConjConstituentsHaveMark(Resource resource, int n) {
        if (resource.containsMark(n, 0)) {
            return true;
        }
        Set set = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMED_BY, 2));
        if (set.isEmpty()) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (((Resource)iterator.next()).containsMark(n, 0)) continue;
            return false;
        }
        return true;
    }

    protected boolean allDisjConstituentsHaveMark(Resource resource, int n) {
        if (resource.containsMark(n, 0)) {
            return true;
        }
        Set set = Triple.GetValues(this._pKb.getTripleLinkSet(resource, Relation._SUBSUMES, 8));
        if (set.isEmpty()) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (((Resource)iterator.next()).containsMark(n, 0)) continue;
            return false;
        }
        return true;
    }

    protected void classifyModifier(Modifier modifier) {
        Set set = this.modifierMSS(modifier);
        Set set2 = this.modifierMGS(modifier, set);
        this.insertModifier(modifier, set, set2);
    }

    protected Set modifierMSS(Modifier modifier) {
        this.clearMarks(0);
        this.markUpRelations(modifier._rel, Integer.MIN_VALUE);
        this.markTransClosure(Relation._SUBSUMED_BY, modifier._conc, 1, -1);
        LinkedList<Modifier> linkedList = new LinkedList<Modifier>();
        TreeSet<Modifier> treeSet = new TreeSet<Modifier>();
        linkedList.addLast(Modifier._GEN_MOD_TOP);
        while (linkedList.size() > 0) {
            Modifier modifier2 = Modifier.CastToModifier((Resource)linkedList.removeFirst());
            if (modifier2.containsMark(0x40000000, 0)) continue;
            modifier2.addMark(0x40000000, 0);
            boolean bl = false;
            Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(modifier2, Relation._SUBSUMES, 4)).iterator();
            while (iterator.hasNext()) {
                Modifier modifier3 = (Modifier)iterator.next();
                if (!Classifier.ModSubsumes(modifier3, modifier, Integer.MIN_VALUE, 0, 1, 0)) continue;
                bl = true;
                linkedList.addLast(modifier3);
            }
            if (bl) continue;
            treeSet.add(modifier2);
        }
        treeSet.remove(modifier);
        if (treeSet.size() <= 0) {
            treeSet.add(Modifier._GEN_MOD_TOP);
        }
        return treeSet;
    }

    protected Set modifierMGS(Modifier modifier, Set set) {
        this.clearMarks(0);
        this.markDownRelations(modifier._rel, Integer.MIN_VALUE);
        this.markTransClosure(Relation._SUBSUMES, modifier._conc, 1, -1);
        LinkedList<Modifier> linkedList = new LinkedList<Modifier>();
        TreeSet<Modifier> treeSet = new TreeSet<Modifier>();
        linkedList.addLast((Modifier)set.iterator().next());
        while (linkedList.size() > 0) {
            Modifier modifier2 = Modifier.CastToModifier((Resource)linkedList.removeFirst());
            if (modifier2.containsMark(0x40000000, 0)) continue;
            modifier2.addMark(0x40000000, 0);
            if (Classifier.ModSubsumedBy(modifier2, modifier, Integer.MIN_VALUE, 0, 1, 0)) {
                treeSet.add(modifier2);
                this.markTransClosureAndRemove(Relation._SUBSUMES, modifier2, 0x40000000, treeSet);
                continue;
            }
            Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(modifier2, Relation._SUBSUMES, 4)).iterator();
            while (iterator.hasNext()) {
                linkedList.addLast((Modifier)iterator.next());
            }
        }
        treeSet.remove(modifier);
        return treeSet;
    }

    protected static boolean ModSubsumes(Modifier modifier, Modifier modifier2, int n, int n2, int n3, int n4) {
        Integer n5 = (Integer)_hmSubsumes.get(new RtXRt(modifier._type, modifier2._type));
        if (n5 == null) {
            return false;
        }
        int n6 = n5;
        if (n6 == -1) {
            return true;
        }
        int n7 = 0;
        n7 += modifier._rel.containsMark(n, n2) ? 16 : 0;
        if (modifier._conc != null && modifier2._conc != null) {
            n7 += modifier._conc.containsMark(n3, n4) ? 8 : 0;
            n7 += modifier._conc.equals(modifier2._conc) ? 4 : 0;
        }
        n7 += modifier._card_val >= modifier2._card_val ? 2 : 0;
        return (n6 & (n7 += modifier._card_val <= modifier2._card_val ? 1 : 0)) == n6;
    }

    protected static boolean ModSubsumedBy(Modifier modifier, Modifier modifier2, int n, int n2, int n3, int n4) {
        Integer n5 = (Integer)_hmSubsumes.get(new RtXRt(modifier2._type, modifier._type));
        if (n5 == null) {
            return false;
        }
        int n6 = n5;
        if (n6 == -1) {
            return true;
        }
        int n7 = 0;
        n7 += modifier._rel.containsMark(n, n2) ? 16 : 0;
        if (modifier._conc != null && modifier2._conc != null) {
            n7 += modifier._conc.containsMark(n3, n4) ? 8 : 0;
            n7 += modifier._conc.equals(modifier2._conc) ? 4 : 0;
        }
        n7 += modifier2._card_val >= modifier._card_val ? 2 : 0;
        return (n6 & (n7 += modifier2._card_val <= modifier._card_val ? 1 : 0)) == n6;
    }

    protected void clearMarks(int n) {
        Resource.ClearMarks(0);
        Resource.SetDefaultMark(n, 0);
    }

    private Set markTransClosureAndReturnConcDescendants(Relation relation, Resource resource, Resource resource2, int n, int n2) {
        TreeSet treeSet = new TreeSet();
        this.markTransClosureAndReturnConcDescendantsInternal(relation, resource, resource2, n, n2, treeSet);
        return treeSet;
    }

    private void markTransClosureAndReturnConcDescendantsInternal(Relation relation, Resource resource, Resource resource2, int n, int n2, Set set) {
        if (resource2 == null) {
            return;
        }
        resource2.addMark(n, 0);
        if (this._pKb.isTripleLink(resource2, relation, resource, n2)) {
            set.add(resource2);
        }
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource2, relation, n2)).iterator();
        while (iterator.hasNext()) {
            Resource resource3 = (Resource)iterator.next();
            if (resource3.containsMark(n, 0)) continue;
            this.markTransClosureAndReturnConcDescendantsInternal(relation, resource, resource3, n, n2, set);
        }
    }

    protected void markAllRelationsDelayFullSearch(Resource resource, Relation relation, int n, int n2, int n3) {
        if (resource == null || resource.containsMark(n, 0)) {
            return;
        }
        resource.addMark(n, 0);
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource, relation, n2)).iterator();
        while (iterator.hasNext()) {
            this.markAllRelationsDelayFullSearch((Resource)iterator.next(), relation, n, n3, n3);
        }
    }

    protected void markUpRelations(Relation relation, int n) {
        relation.addMark(n, 0);
        Iterator iterator = relation.getParents(true).iterator();
        while (iterator.hasNext()) {
            Relation relation2 = (Relation)iterator.next();
            if (relation2.containsMark(n, 0)) continue;
            this.markUpRelations(relation2, n);
        }
    }

    protected void markDownRelations(Relation relation, int n) {
        relation.addMark(n, 0);
        Iterator iterator = relation.getChildren(true).iterator();
        while (iterator.hasNext()) {
            Relation relation2 = (Relation)iterator.next();
            if (relation2.containsMark(n, 0)) continue;
            this.markDownRelations(relation2, n);
        }
    }

    protected void markTransClosure(Relation relation, Resource resource, int n, int n2) {
        if (resource == null) {
            return;
        }
        resource.addMark(n, 0);
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource, relation, n2)).iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            if (resource2.containsMark(n, 0)) continue;
            this.markTransClosure(relation, resource2, n, n2);
        }
    }

    protected void markTransClosureAndRemove(Relation relation, Resource resource, int n, Set set) {
        if (resource == null) {
            return;
        }
        resource.addMark(n, 0);
        Iterator iterator = Triple.GetValues(this._pKb.getTripleLinkSet(resource, relation, -1)).iterator();
        while (iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            if (resource2.containsMark(n, 0)) continue;
            set.remove(resource2);
            this.markTransClosureAndRemove(relation, resource2, n, set);
        }
    }

    protected ClassifyInfo insertConcept(Resource resource, Set set, Set set2) throws ReasoningException {
        Object object;
        HashSet<Resource> hashSet = new HashSet<Resource>(set);
        hashSet.retainAll(set2);
        if (!hashSet.isEmpty()) {
            hashSet.add(resource);
            return new ClassifyInfo(this._pKb.collapseCycle(hashSet), Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Resource> linkedList2 = new LinkedList<Resource>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Resource)iterator.next();
            if (this._pKb.isTripleLink(resource, Relation._SUBSUMED_BY, (Resource)object, -1)) continue;
            this._pKb.addTripleLink(resource, Relation._SUBSUMED_BY, (Resource)object, 4);
            this._pKb.maintainBottomLinks((Resource)object);
            linkedList.add(object);
        }
        object = set2.iterator();
        while (object.hasNext()) {
            Resource resource2 = (Resource)object.next();
            if (this._pKb.isTripleLink(resource2, Relation._SUBSUMED_BY, resource, -1)) continue;
            this._pKb.addTripleLink(resource2, Relation._SUBSUMED_BY, resource, 4);
            this._pKb.maintainTopLinks(resource2);
            linkedList2.add(resource2);
        }
        this.pruneSharedSLinks(set, set2);
        this._pKb.maintainTopLinks(resource);
        this._pKb.maintainBottomLinks(resource);
        return new ClassifyInfo(resource, linkedList, linkedList2, false);
    }

    protected void insertModifier(Modifier modifier, Set set, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this._pKb.addTripleLink(modifier, Relation._SUBSUMED_BY, (Modifier)iterator.next(), 4);
        }
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            this._pKb.addTripleLink((Modifier)iterator2.next(), Relation._SUBSUMED_BY, modifier, 4);
        }
        this.pruneSharedSLinks(set, set2);
    }

    protected void pruneSharedSLinks(Set set, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                this._pKb.removeTripleLink((Resource)iterator2.next(), Relation._SUBSUMED_BY, resource, 4);
            }
        }
    }

    protected static class RtXRt {
        protected static int _r2_bitshift = 5;
        protected static int _nr1;
        protected static int _nr2;
        protected static int _hc;

        protected RtXRt(Resource resource, Resource resource2) {
            _nr1 = resource.getID();
            _nr2 = resource2.getID();
            _hc = _nr1 + (_nr2 << _r2_bitshift);
        }

        public boolean equals(Object object) {
            RtXRt cfr_ignored_0 = (RtXRt)object;
            return _hc == _hc;
        }

        public int hashCode() {
            return _hc;
        }
    }

    public static class ClassifyInfo {
        public Resource _conc;
        public Collection _mss;
        public Collection _mgs;
        public boolean _equiv;

        protected ClassifyInfo(Resource resource, Collection collection, Collection collection2, boolean bl) {
            this._conc = resource;
            this._mss = collection;
            this._mgs = collection2;
            this._equiv = bl;
        }

        public boolean isInference() {
            return this._equiv || !this._mss.isEmpty() || !this._mgs.isEmpty();
        }

        public String toString() {
            return "{" + this._conc.toString() + " MSS(S): " + this._mss + " MGS(S): " + this._mgs + " EQUIV?: " + this._equiv + "}";
        }
    }
}

