/*
 * Decompiled with CFR 0.152.
 */
package jtp.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtp.Cut;
import jtp.DirectAssertion;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.cache.Cache;
import jtp.disp.AbstractRelationBasedBCReasoner;
import jtp.disp.AbstractRelationBasedFCReasoner;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.gmp.Utils;
import jtp.proof.Proof;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.DefaultCut;

public class FunctionCache
implements Cache {
    Symbol functionSymbol;
    int arity;
    Reasoner asker;
    Reasoner teller;
    Map cachedResults;
    private boolean UNAEnabled = false;
    boolean storingProofs = false;

    public FunctionCache(Symbol symbol, int n) {
        this.functionSymbol = symbol;
        this.arity = n;
        this.asker = new Asker();
        this.teller = new Teller();
        this.cachedResults = new HashMap();
    }

    public Reasoner getAskingReasoner() {
        return this.asker;
    }

    public Reasoner getTellingReasoner() {
        return this.teller;
    }

    public void flush() throws ReasoningException {
        this.cachedResults.clear();
    }

    public boolean isUNAEnabled() {
        return this.UNAEnabled;
    }

    public void setUNAEnabled(boolean bl) {
        this.UNAEnabled = bl;
    }

    public boolean isStoringProofs() {
        return this.storingProofs;
    }

    public void setStoringProofs(boolean bl) {
        this.storingProofs = bl;
    }

    public Object prepareKey(Literal literal) {
        Object[] objectArray = new Object[this.arity];
        objectArray[0] = this.functionSymbol;
        List list = literal.getArgs();
        int n = 1;
        while (n < this.arity) {
            objectArray[n] = list.get(n - 1);
            ++n;
        }
        return Arrays.asList(objectArray);
    }

    private class Teller
    extends AbstractRelationBasedFCReasoner {
        public Teller() {
            super(FunctionCache.this.functionSymbol, FunctionCache.this.arity, 1);
        }

        public ReasoningStepIterator process(Object object) {
            Literal literal = SubstUtils.deReferenceLiteral((Literal)((ReasoningStep)object).getGoal());
            List list = literal.getArgs();
            if (list instanceof Unifyable) {
                return ArrayReasoningStepIterator.empty;
            }
            Object object2 = null;
            if (FunctionCache.this.isStoringProofs()) {
                object2 = ((Unifyable)object).deReferenceVariables();
            } else if (object instanceof Cut) {
                DefaultCut defaultCut = new DefaultCut("Search space previously exhausted");
                defaultCut.setGoal(literal);
                defaultCut.setExhaustedDepth(((Cut)object).getExhaustedDepth());
                object2 = defaultCut;
            } else {
                object2 = new DirectAssertion(literal);
            }
            FunctionCache.this.cachedResults.put(FunctionCache.this.prepareKey(literal), object2);
            return ArrayReasoningStepIterator.empty;
        }
    }

    private class Asker
    extends AbstractRelationBasedBCReasoner {
        private List varStack = new ArrayList();

        public Asker() {
            super(FunctionCache.this.functionSymbol, FunctionCache.this.arity, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReasoningStepIterator process(Object object) {
            Object object2;
            Literal literal = (Literal)object;
            List list = literal.getArgs();
            boolean bl = false;
            if (list instanceof Unifyable) {
                object2 = list.listIterator();
                while (object2.nextIndex() < this.getArity() - 1) {
                    if (!(object2.next() instanceof Unifyable)) continue;
                    return ArrayReasoningStepIterator.empty;
                }
                bl = true;
            }
            if ((object2 = (ReasoningStep)FunctionCache.this.cachedResults.get(FunctionCache.this.prepareKey(literal))) == null) {
                return ArrayReasoningStepIterator.empty;
            }
            Object object3 = null;
            if (bl) {
                try {
                    object3 = Utils.deriveFrom(literal, (ReasoningStep)object2, this.varStack);
                    Object var8_7 = null;
                    this.varStack.clear();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.varStack.clear();
                    throw throwable;
                }
            } else {
                Literal literal2 = (Literal)((Proof)object2).getGoal();
                Object e = literal2.getArgs().get(this.getArity() - 1);
                if (list.get(this.getArity() - 1).equals(e)) {
                    object3 = object2;
                }
            }
            if (object3 != null) {
                if (literal.isPositive()) {
                    return new ArrayReasoningStepIterator((ReasoningStep)object3, new DefaultCut("Functions have only 1 value"));
                }
                return new ArrayReasoningStepIterator(new DefaultCut("The negation of this sentence was found in cache"));
            }
            if (bl || !FunctionCache.this.isUNAEnabled()) {
                return ArrayReasoningStepIterator.empty;
            }
            if (literal.isPositive()) {
                return new ArrayReasoningStepIterator(new DefaultCut("Functions have only 1 value"));
            }
            return ArrayReasoningStepIterator.empty;
        }
    }
}

