/*
 * Decompiled with CFR 0.152.
 */
package jpl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import jpl.Atom;
import jpl.Compound;
import jpl.Query;
import jpl.Term;
import jpl.Variable;
import jpl.fli.term_t;

public final class Util {
    public static Term termArrayToList(Term[] termArray) {
        Compound compound = new Atom("[]");
        for (int i = termArray.length - 1; i >= 0; --i) {
            compound = new Compound(".", new Term[]{termArray[i], compound});
        }
        return compound;
    }

    public static Term[] bindingsToTermArray(Map map) {
        Term[] termArray = new Term[map.size()];
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            termArray[variable.index] = (Term)map.get(variable);
        }
        return termArray;
    }

    public static String toString(Map map) {
        if (map == null) {
            return "[no solution]";
        }
        Iterator iterator = map.keySet().iterator();
        String string = "Bindings: ";
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + string2 + "=" + map.get(string2).toString() + "; ";
        }
        return string;
    }

    public static Map namevarsToMap(Term term) {
        try {
            Hashtable<term_t, Variable> hashtable = new Hashtable<term_t, Variable>();
            while (term.hasFunctor(".", 2) && term.arg(1).hasFunctor("=", 2)) {
                hashtable.put(((Variable)term.arg((int)1).arg((int)2)).term_, new Variable(term.arg(1).arg(1).name()));
                term = term.arg(2);
            }
            return hashtable;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static Term textToTerm(String string) {
        Query query = new Query(new Compound("atom_to_term", new Term[]{new Atom(string), new Variable("Term"), new Variable("NVdict")}));
        query.open();
        Hashtable hashtable = query.getSubstWithNameVars();
        if (hashtable != null) {
            query.close();
            return (Term)hashtable.get("Term");
        }
        return null;
    }
}

