/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.domain.DomainParser;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.SyntaxFileFilter;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class XMLSaver {
    protected File libDir = DomainParser.getLibraryDirectory();
    protected XMLTranslator xmlt = XML.defaultTranslator();
    protected JFileChooser fileChooser = null;
    protected Component frame;
    protected Class outputObjectClass;

    public XMLSaver(Component component) {
        this(component, Object.class);
    }

    public XMLSaver(Component component, Class clazz) {
        this.frame = component;
        this.outputObjectClass = clazz;
    }

    public XMLTranslator getXMLTranslator() {
        return this.xmlt;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.xmlt = xMLTranslator;
    }

    public void saveObject(Object object) {
        File file;
        while ((file = this.agreeFileToWrite()) != null) {
            try {
                this.writeObjectToFile(object, file);
                return;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                JOptionPane.showMessageDialog(this.frame, new Object[]{"Problem saving to " + Strings.quote(file.getPath()), Debug.foldException(throwable)}, "Trouble saving to file", 0);
                continue;
            }
            break;
        }
        return;
    }

    protected void writeObjectToFile(Object object, File file) throws IOException {
        Debug.noteln("XMLSaver writing object to", file);
        XML.writeObject(object, file.getPath());
    }

    public void saveDocument(Document document) {
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        JFileChooser jFileChooser = new JFileChooser(this.libDir);
        jFileChooser.setFileFilter(new SyntaxFileFilter(fileSyntaxManager.getSyntaxForType("xml")));
        this.fileChooser = jFileChooser;
        File file;
        while ((file = this.agreeFileToWrite()) != null) {
            try {
                this.writeDocumentTo(file, document);
                return;
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this.frame, new Object[]{"Problem saving " + Strings.quote(file.getPath()), Debug.foldException(throwable)}, "Trouble saving to file", 0);
                continue;
            }
            break;
        }
        return;
    }

    protected void writeDocumentTo(File file, Document document) throws IOException {
        Debug.noteln("Writing XML Document to", file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
        xMLOutputter.output(document, (OutputStream)bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
    }

    protected File agreeFileToWrite() {
        File file;
        block4: while (true) {
            if ((file = this.chooseFileToWrite()) == null) {
                return null;
            }
            if (!file.exists()) break;
            switch (JOptionPane.showConfirmDialog(this.frame, "Overwrite " + Strings.quote(file.getPath()), "Confirm", 0)) {
                case 0: {
                    Util.renameToBackup(file);
                    break block4;
                }
                case 1: {
                    continue block4;
                }
            }
            break;
        }
        return file;
    }

    protected File chooseFileToWrite() {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = this.makeFileChooser();
        }
        if ((n = this.fileChooser.showSaveDialog(this.frame)) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public JFileChooser makeFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(this.libDir);
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        TreeSet treeSet = new TreeSet();
        for (FileSyntax fileSyntax : fileSyntaxManager.getAllSyntaxes()) {
            if (!fileSyntaxManager.canWrite(fileSyntax, this.outputObjectClass)) continue;
            treeSet.addAll(fileSyntax.getFileTypes());
            jFileChooser.addChoosableFileFilter(new SyntaxFileFilter(fileSyntax));
        }
        SyntaxFileFilter syntaxFileFilter = new SyntaxFileFilter(this.outputObjectClass, treeSet);
        jFileChooser.setFileFilter(syntaxFileFilter);
        return jFileChooser;
    }
}

