/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.domain.DomainParser;
import ix.util.Debug;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.SyntaxFileFilter;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import org.jdom.Document;

public class XMLLoader {
    protected File libDir = DomainParser.getLibraryDirectory();
    protected XMLTranslator xmlt = XML.defaultTranslator();
    protected JFileChooser fileChooser = null;
    protected Component frame;
    protected Class desiredResultClass;

    public XMLLoader(Component component) {
        this(component, Object.class);
    }

    public XMLLoader(Component component, Class clazz) {
        this.frame = component;
        this.desiredResultClass = clazz;
    }

    public XMLTranslator getXMLTranslator() {
        return this.xmlt;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.xmlt = xMLTranslator;
    }

    public Object loadObject() {
        File file;
        while ((file = this.chooseFileToRead()) != null) {
            try {
                Object object = this.readObjectFrom(file);
                return object;
            }
            catch (Throwable throwable) {
                Debug.displayException(throwable);
                continue;
            }
            break;
        }
        return null;
    }

    protected Object readObjectFrom(File file) throws IOException {
        Debug.noteln("XMLLoader reading object from", file);
        return XML.readObject(this.desiredResultClass, file.toURL());
    }

    public Document loadDocument() {
        File file;
        while ((file = this.chooseFileToRead()) != null) {
            try {
                Document document = this.readDocumentFrom(file);
                return document;
            }
            catch (Throwable throwable) {
                Debug.displayException(throwable);
                continue;
            }
            break;
        }
        return null;
    }

    protected Document readDocumentFrom(File file) throws IOException {
        Debug.noteln("XMLLoader reading document from", file);
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        FileSyntax fileSyntax = fileSyntaxManager.getSyntax(file);
        Debug.noteln("Using syntax", fileSyntax);
        if (fileSyntax == fileSyntaxManager.getSyntaxForType("xml")) {
            return XML.parseXML(file);
        }
        Object object = this.readObjectFrom(file);
        return this.xmlt.objectToDocument(object);
    }

    protected File chooseFileToRead() {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = this.makeFileChooser();
        }
        if ((n = this.fileChooser.showOpenDialog(this.frame)) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public JFileChooser makeFileChooser() {
        Debug.noteln("Library directory", this.libDir);
        JFileChooser jFileChooser = new JFileChooser(this.libDir);
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        TreeSet treeSet = new TreeSet();
        for (FileSyntax fileSyntax : fileSyntaxManager.getAllSyntaxes()) {
            if (!fileSyntaxManager.canRead(fileSyntax, this.desiredResultClass)) continue;
            treeSet.addAll(fileSyntax.getFileTypes());
            jFileChooser.addChoosableFileFilter(new SyntaxFileFilter(fileSyntax));
        }
        SyntaxFileFilter syntaxFileFilter = new SyntaxFileFilter(this.desiredResultClass, treeSet);
        jFileChooser.setFileFilter(syntaxFileFilter);
        return jFileChooser;
    }
}

