/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.Debug;
import ix.util.Duration;
import ix.util.ISODateFormat;
import ix.util.ListOf;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.TwoKeyHashMap;
import ix.util.TypedList;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.FieldMap;
import ix.util.reflect.Stringer;
import ix.util.xml.XML;
import ix.util.xml.XMLSchemaSyntax;
import java.awt.Color;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassSyntax {
    protected ClassFinder classFinder;
    protected Map classToDescdCache = new HashMap();
    protected Map classToStringerMap = new HashMap();
    protected boolean inferElementClasses = false;
    protected TwoKeyHashMap fieldCaseMap = new TwoKeyHashMap();

    public ClassSyntax() {
        this(XML.config().defaultClassFinder());
    }

    public ClassSyntax(ClassFinder classFinder) {
        Debug.expect(classFinder != null, "Null ClassFinder");
        this.classFinder = classFinder;
        this.initFieldCases();
        this.initStringConversions();
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public void setInferElementClasses(boolean bl) {
        this.inferElementClasses = bl;
    }

    public String externalNameForClass(Class clazz) {
        return this.classFinder.nameForClass(clazz);
    }

    public Class classForExternalName(String string) {
        return this.classFinder.classForName(string);
    }

    public String externalNameForField(String string) {
        return this.classFinder.externalFieldName(string);
    }

    public String upperNameForClass(Class clazz) {
        String string = this.externalNameForClass(clazz);
        return string.toUpperCase();
    }

    public ClassDescr getClassDescr(Class clazz) {
        ClassDescr classDescr = (ClassDescr)this.classToDescdCache.get(clazz);
        if (classDescr == null) {
            classDescr = this.makeClassDescr(clazz);
            this.classToDescdCache.put(clazz, classDescr);
        }
        return classDescr;
    }

    protected ClassDescr makeClassDescr(Class clazz) {
        if (TypedList.class.isAssignableFrom(clazz)) {
            return new ClassDescr(this, clazz, ListOf.elementClass(clazz));
        }
        return new ClassDescr(this, clazz);
    }

    public ClassDescr makeClassDescr(Class clazz, Class clazz2) {
        return new ClassDescr(this, clazz, clazz2);
    }

    public ClassDescr makeClassDescr(Class clazz, Class clazz2, Class clazz3) {
        return new ClassDescr(this, clazz, clazz2, clazz3);
    }

    public String xmlSchemaDatatype(Class clazz) {
        String string;
        Stringer stringer = this.getStringer(clazz);
        if (stringer != null && (string = stringer.xmlSchemaDatatype()) != null) {
            return string;
        }
        return XMLSchemaSyntax.getSimpleType(clazz);
    }

    public Stringer getStringer(Class clazz) {
        return (Stringer)this.classToStringerMap.get(clazz);
    }

    protected void setStringer(Class clazz, Stringer stringer) {
        this.classToStringerMap.put(clazz, stringer);
    }

    protected void initStringConversions() {
        this.setStringer(Date.class, new Stringer(){
            ISODateFormat format = new ISODateFormat();

            public String toString(Object object) {
                return this.format.formatDateTime((Date)object);
            }

            public Object fromString(String string) {
                return this.format.parseDateTime(string);
            }

            public String xmlSchemaDatatype() {
                return "dateTime";
            }
        });
        this.setStringer(Duration.class, new Stringer(){

            public String toString(Object object) {
                return ((Duration)object).toISOString();
            }

            public Object fromString(String string) {
                return new Duration(string);
            }

            public String xmlSchemaDatatype() {
                return "duration";
            }
        });
        this.setStringer(Color.class, new Stringer(){

            public String toString(Object object) {
                return Integer.toString(((Color)object).getRGB());
            }

            public Object fromString(String string) {
                try {
                    return Color.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RethrownException(numberFormatException);
                }
            }

            public String xmlSchemaDatatype() {
                return "int";
            }
        });
    }

    public List relevantClasses(Class clazz) {
        return this.relevantClasses(Lisp.list(clazz));
    }

    public List relevantClasses(Class[] classArray) {
        return this.relevantClasses(Arrays.asList(classArray));
    }

    public List relevantClasses(List list) {
        LinkedList linkedList = new LinkedList();
        for (Class clazz : list) {
            this.collectRelevantClasses(clazz, linkedList, (List)Lisp.NIL);
        }
        linkedList.remove(Object.class);
        return linkedList;
    }

    public List expandRelevantClasses(List list) {
        LinkedList linkedList = new LinkedList();
        LList lList = LList.newLList(list);
        while (!lList.isEmpty()) {
            Class clazz = (Class)lList.car();
            Debug.expect(!linkedList.contains(clazz));
            this.collectRelevantClasses(clazz, linkedList, (List)lList.cdr());
            lList = lList.cdr();
        }
        linkedList.remove(Object.class);
        return linkedList;
    }

    protected void collectRelevantClasses(Class clazz, List list, List list2) {
        if (clazz == null || list.contains(clazz) || list2.contains(clazz)) {
            return;
        }
        list.add(clazz);
        ClassDescr classDescr = this.getClassDescr(clazz);
        if (classDescr.isStruct()) {
            for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
                this.collectRelevantClasses(fieldDescr.getTypeDescr(), list, list2);
            }
        }
    }

    protected void collectRelevantClasses(ClassDescr classDescr, List list, List list2) {
        if (classDescr == null) {
            return;
        }
        if (classDescr.isCollection()) {
            this.collectRelevantClasses(classDescr.getEltType(), list, list2);
        } else if (classDescr.isMap()) {
            this.collectRelevantClasses(classDescr.getKeyType(), list, list2);
            this.collectRelevantClasses(classDescr.getValType(), list, list2);
        } else {
            this.collectRelevantClasses(classDescr.getDescribedClass(), list, list2);
        }
    }

    FieldMap makeFieldDescrs(Class clazz) {
        return this.collectFieldInfo(clazz);
    }

    protected FieldDescr makeFieldDescr(String string, Class clazz) {
        return new FieldDescr(this, string, clazz);
    }

    protected void initFieldCases() {
    }

    public ClassDescr getFieldCase(Class clazz, String string) {
        return (ClassDescr)this.fieldCaseMap.get(clazz, string);
    }

    public void setFieldCase(Class clazz, String string, ClassDescr classDescr) {
        this.fieldCaseMap.put(clazz, string, classDescr);
    }

    protected FieldMap collectFieldInfo(Class clazz) {
        FieldMap fieldMap = this.collectFields(clazz, new FieldMap());
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Object object = this.getDeclaredMethods(clazz2);
            for (int i = 0; i < ((Method[])object).length; ++i) {
                Method method = object[i];
                String string = method.getName();
                if (ClassSyntax.isGetName(string)) {
                    this.tryGetMethod(method, fieldMap);
                    continue;
                }
                if (!ClassSyntax.isSetName(string)) continue;
                this.trySetMethod(method, fieldMap);
            }
        }
        for (Object object : LList.newLList(fieldMap.getFields())) {
            if (object.getter == null || object.setter == null) {
                fieldMap.remove((FieldDescr)object);
                continue;
            }
            object.typeDescr = this.makeFieldTypeDescr((FieldDescr)object, clazz);
        }
        return fieldMap;
    }

    protected Method[] getDeclaredMethods(Class clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            Debug.noteln("Problem getting methods of " + clazz);
            Debug.noteException(securityException, false);
            return new Method[0];
        }
    }

    protected ClassDescr makeFieldTypeDescr(FieldDescr fieldDescr, Class clazz) {
        String string;
        Class clazz2;
        String string2 = fieldDescr.getName();
        Class clazz3 = fieldDescr.getType();
        ClassDescr classDescr = this.getFieldCase(clazz, string2);
        if (classDescr != null) {
            return classDescr;
        }
        if (TypedList.class.isAssignableFrom(clazz3)) {
            return this.makeClassDescr(clazz3);
        }
        classDescr = this.getClassDescr(clazz3);
        if (this.inferElementClasses && (classDescr.isList() || classDescr.isSet()) && string2.length() >= 2 && string2.endsWith("s") && (clazz2 = this.classIfExists(clazz, string = Strings.capitalize(string2.substring(0, string2.length() - 1)))) != null) {
            classDescr = this.makeClassDescr(clazz3, clazz2);
        }
        return classDescr;
    }

    protected Class classIfExists(Class clazz, String string) {
        Package package_ = clazz.getPackage();
        String string2 = package_.getName() + "." + string;
        Class clazz2 = ClassFinder.tryClassForName(string2);
        if (clazz2 != null) {
            return clazz2;
        }
        return this.classFinder.classForName(this.classFinder.externalName(string));
    }

    protected void tryGetMethod(Method method, FieldMap fieldMap) {
        Class<?>[] classArray = method.getParameterTypes();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n) || classArray.length != 0) {
            return;
        }
        String string = ClassSyntax.fieldNameFromGetName(method.getName());
        FieldDescr fieldDescr = fieldMap.fieldForName(string);
        if (fieldDescr != null && fieldDescr.getter == null) {
            Class clazz = fieldDescr.getType();
            if (method.getReturnType() == clazz) {
                fieldDescr.getter = method;
            }
        }
    }

    protected void trySetMethod(Method method, FieldMap fieldMap) {
        Class clazz;
        Class<?>[] classArray = method.getParameterTypes();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n) || classArray.length != 1) {
            return;
        }
        String string = ClassSyntax.fieldNameFromSetName(method.getName());
        FieldDescr fieldDescr = fieldMap.fieldForName(string);
        if (fieldDescr != null && fieldDescr.setter == null && classArray[0] == (clazz = fieldDescr.getType())) {
            fieldDescr.setter = method;
        }
    }

    public static final boolean isGetName(String string) {
        return string.length() > 3 && string.startsWith("get");
    }

    public static final boolean isSetName(String string) {
        return string.length() > 3 && string.startsWith("set");
    }

    public static final String fieldNameFromGetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    public static final String fieldNameFromSetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    protected FieldMap collectFields(Class clazz, FieldMap fieldMap) {
        Field[] fieldArray = this.getDeclaredFields(clazz);
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!this.isWanted(fieldArray[i])) continue;
            String string = fieldArray[i].getName();
            Class<?> clazz2 = fieldArray[i].getType();
            if (fieldMap.fieldForName(string) != null) continue;
            fieldMap.add(this.makeFieldDescr(string, clazz2));
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            this.collectFields(clazz3, fieldMap);
        }
        return fieldMap;
    }

    protected Field[] getDeclaredFields(Class clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            Debug.noteln("Problem getting fields of " + clazz);
            Debug.noteException(securityException, false);
            return new Field[0];
        }
    }

    protected boolean isWanted(Field field) {
        int n = field.getModifiers();
        return !Modifier.isFinal(n) && !Modifier.isStatic(n) && !Modifier.isTransient(n);
    }

    public void describeClass(Class clazz) {
        this.describeClass(clazz, System.out);
    }

    public void describeClass(Class clazz, PrintStream printStream) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        List list = classDescr.getFieldDescrs();
        printStream.println(classDescr.toString());
        printStream.println("Java name: " + classDescr.theClass.getName());
        printStream.println("External name: " + classDescr.getExternalName());
        printStream.println(list.isEmpty() ? "No fields" : "Fields:");
        for (FieldDescr fieldDescr : list) {
            printStream.println(fieldDescr.getName() + ": " + fieldDescr.getTypeDescr());
            printStream.println("   getter: " + fieldDescr.getter);
            printStream.println("   setter: " + fieldDescr.setter);
        }
    }

    public static void main(String[] stringArray) {
        ClassSyntax classSyntax = new ClassSyntax();
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            Class clazz = classSyntax.classFinder.classForName(string);
            System.out.println(clazz);
            if (clazz == null) continue;
            classSyntax.describeClass(clazz, System.out);
            System.out.println("");
        }
        return;
    }
}

