/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassFinder {
    protected List imports = new LinkedList();
    protected Map nameToClass = new HashMap();
    protected Map classToName = new HashMap();
    protected Map nameToClassCache = new HashMap();
    protected Map classToNameCache = new HashMap();

    public ClassFinder() {
        this.addInitialNames();
        this.addInitialImports();
    }

    public ClassFinder(ClassFinder classFinder) {
        this.addInitialNames();
        this.imports = classFinder.imports;
    }

    protected void addInitialNames() {
    }

    protected void addInitialImports() {
        this.addImport("java.lang.*");
        this.addImport("java.util.*");
    }

    public void addImport(String string) {
        if (!this.haveImport(string)) {
            this.imports.add(new Import(string));
        }
        this.nameToClassCache.clear();
        this.classToNameCache.clear();
    }

    private boolean haveImport(String string) {
        for (Import import_ : this.imports) {
            if (!import_.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addName(String string, Class clazz) {
        this.nameToClass.put(string, clazz);
        this.classToName.put(clazz, string);
        this.nameToClassCache.remove(string);
        this.classToNameCache.remove(clazz);
    }

    protected void cacheBothWays(String string, Class clazz) {
        this.nameToClassCache.put(string, clazz);
        this.classToNameCache.put(clazz, string);
    }

    public void preLoad(List list) {
        for (Class clazz : list) {
            this.nameForClass(clazz);
        }
    }

    public String javaName(String string) {
        return string;
    }

    public String javaFieldName(String string) {
        return this.javaName(string);
    }

    public String externalName(String string) {
        return string;
    }

    public String externalFieldName(String string) {
        return this.externalName(string);
    }

    public Class classForName(String string) {
        Class clazz = (Class)this.nameToClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)this.nameToClass.get(string);
        if (clazz != null) {
            this.nameToClassCache.put(string, clazz);
            return clazz;
        }
        String string2 = this.javaName(string);
        boolean bl = string2.indexOf(".") >= 0;
        Debug.expect(clazz == null);
        clazz = bl ? ClassFinder.tryClassForName(string2) : this.findImportClass(string2);
        if (clazz != null) {
            this.nameToClassCache.put(string, clazz);
        }
        return clazz;
    }

    protected Class findImportClass(String string) {
        Class clazz = null;
        Import import_ = null;
        for (Import import_2 : this.imports) {
            Class clazz2 = import_2.tryName(string);
            if (clazz2 == null) continue;
            if (clazz == null) {
                clazz = clazz2;
                import_ = import_2;
                continue;
            }
            throw new RuntimeException("Ambiguous name " + Util.quote(string) + " imported via both " + import_ + " and " + import_2);
        }
        return clazz;
    }

    public static Class tryClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            if (Parameters.isApplet()) {
                Debug.noteException(securityException, false);
                if (securityException.getMessage().startsWith("Prohibited package name")) {
                    return null;
                }
            }
            throw securityException;
        }
        catch (ClassFormatError classFormatError) {
            if (Parameters.isApplet()) {
                Debug.noteException(classFormatError, false);
                return null;
            }
            throw classFormatError;
        }
    }

    public String nameForClass(Class clazz) {
        String string = (String)this.classToNameCache.get(clazz);
        if (string != null) {
            return string;
        }
        string = (String)this.classToName.get(clazz);
        if (string != null) {
            Debug.expect(this.nameToClass.get(string) == clazz);
            this.classToNameCache.put(clazz, string);
            return string;
        }
        String string2 = clazz.getName();
        if (string2.startsWith("[")) {
            throw new RuntimeException("Can't handle array class" + string2);
        }
        String string3 = Strings.afterLast(".", string2);
        String string4 = this.externalName(string3);
        if (this.classHasShortName(clazz, string4)) {
            string = string4;
        } else {
            string = this.externalName(string2);
            Debug.expect(this.classForName(string) == clazz || clazz.isPrimitive(), "Can't get back class when using name", string);
        }
        this.cacheBothWays(string, clazz);
        return string;
    }

    protected boolean classHasShortName(Class clazz, String string) {
        Class clazz2 = (Class)this.nameToClassCache.get(string);
        if (clazz2 != null) {
            return clazz == clazz2;
        }
        Class clazz3 = (Class)this.nameToClass.get(string);
        if (clazz3 != null) {
            return clazz == clazz3;
        }
        String string2 = Strings.beforeLast(".", clazz.getName());
        String string3 = Strings.afterLast(".", clazz.getName());
        String string4 = this.javaName(string);
        if (!string4.equals(string3) && !clazz.isPrimitive()) {
            throw new ConsistencyException("External name maps to " + string4 + " but the actual class name is " + string3);
        }
        for (Import import_ : this.imports) {
            if (!import_.packageName().equals(string2)) continue;
            Class clazz4 = import_.tryName(string4);
            if (clazz4 == clazz) {
                return true;
            }
            if (clazz4 == null) continue;
            throw new ConsistencyException(import_ + " found " + clazz4 + " instead of " + clazz);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        ClassFinder.do_main(new ClassFinder());
    }

    protected static void do_main(ClassFinder classFinder) {
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            Class clazz = classFinder.classForName(string);
            System.out.println(clazz);
            if (clazz == null) continue;
            System.out.println("Best name is " + Util.quote(classFinder.nameForClass(clazz)));
        }
        return;
    }

    protected static class Import {
        boolean star;
        String name;
        String prefix;

        public Import(String string) {
            this.name = string;
            this.star = string.endsWith("*");
            if (this.star) {
                this.prefix = string.substring(0, string.length() - 1);
                Debug.expect(this.prefix.endsWith("."), "invalid import", string);
            } else {
                this.prefix = string;
            }
        }

        public String packageName() {
            Debug.expect(this.name.indexOf(".") > 0, "Bogus import name", this.name);
            return Strings.beforeLast(".", this.name);
        }

        public Class tryName(String string) {
            if (this.star) {
                return ClassFinder.tryClassForName(this.prefix + string);
            }
            if (this.prefix.equals(string)) {
                return ClassFinder.tryClassForName(this.prefix);
            }
            if (this.prefix.endsWith("." + string)) {
                return ClassFinder.tryClassForName(this.prefix);
            }
            return null;
        }

        public String toString() {
            return "import[" + this.name + "]";
        }
    }
}

