/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.EqMap;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.util.ArrayList;
import java.util.List;

public class ObjectHash {
    protected EqMap objectToHash = new EqMap();
    protected List hashToObject = new ArrayList();

    public int hash(Object object) {
        Integer n = (Integer)this.objectToHash.get(object);
        if (n == null) {
            n = new Integer(this.hashToObject.size());
            this.objectToHash.put(object, n);
            this.hashToObject.add(object);
        }
        return n;
    }

    public Object unhash(int n) {
        return this.hashToObject.get(n);
    }

    public String hashName(Object object) {
        Class<?> clazz = object.getClass();
        String string = XML.nameForClass(clazz);
        return "{" + string + "-" + this.hash(object) + "}";
    }

    public Object parseHashName(String string) {
        int n;
        int n2 = -1;
        if (string.startsWith("{") && string.endsWith("}") && (n = string.lastIndexOf("-")) > 0) {
            String string2 = string.substring(n + 1, string.length() - 1);
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n2 >= 0 && n2 < this.hashToObject.size()) {
            return this.unhash(n2);
        }
        throw new IllegalArgumentException("Can't find an object ref in " + Strings.quote(string));
    }

    public static void main(String[] stringArray) {
        ObjectHash objectHash = new ObjectHash();
        String string;
        while (!(string = Util.askLine("Object:")).equals("bye")) {
            Object object = Lisp.readFromString(string);
            Debug.noteln("Read", object);
            String string2 = objectHash.hashName(object);
            Debug.noteln("Hash name", string2);
            Object object2 = objectHash.parseHashName(string2);
            Debug.noteln("Back to", object2);
            Debug.noteln("Eq " + (object2 == object));
        }
        return;
    }
}

