/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.util.Debug;
import ix.util.IPC;
import ix.util.ipc.WrapperStrategy;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;

public class TracingStrategy
extends WrapperStrategy {
    XMLTranslator xmlt = XML.config().makeXMLTranslator();

    public TracingStrategy() {
        this.xmlt.setOmitImplAttributes(false);
    }

    public TracingStrategy(IPC.CommunicationStrategy communicationStrategy) {
        super(communicationStrategy);
        this.xmlt.setOmitImplAttributes(false);
    }

    public void sendObject(Object object, Object object2) {
        this.traceSend(object, object2);
        super.sendObject(object, object2);
    }

    public void setupServer(Object object, final IPC.MessageListener messageListener) {
        this.innerStrategy.setupServer(object, new IPC.MessageListener(){

            public void messageReceived(IPC.InputMessage inputMessage) {
                TracingStrategy.this.traceReceive(inputMessage);
                messageListener.messageReceived(inputMessage);
            }
        });
    }

    protected void traceSend(Object object, Object object2) {
        Debug.noteln("Sending to", object);
        Debug.noteln("Contents as XML:", this.xmlt.objectToXMLString(object2));
    }

    protected void traceReceive(IPC.InputMessage inputMessage) {
        Debug.noteln("Message received, as XML:", this.xmlt.objectToXMLString(inputMessage.getContents()));
    }
}

