/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.iface.util.SelectionPanel;
import ix.iface.util.ValueComboBox;
import ix.ip2.Ip2;
import ix.ispace.AgentData;
import ix.ispace.ContactManager;
import ix.ispace.ISpaceTool;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Strings;
import ix.util.Util;
import ix.util.ipc.ParameterizedCommStrategy;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DispatchingStrategy
implements ParameterizedCommStrategy {
    IXAgent agent;
    StrategyPanel strategyPanel;
    Strategy defaultStrategy;
    List strategies = new LinkedList();
    Map destinationToStrategyMap = new TreeMap();

    public IPC.CommunicationStrategy apply(String[] stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("No communication strategies listed for dispatching.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("default:")) {
                if (this.defaultStrategy != null) {
                    throw new IllegalArgumentException("Two defaults specified for dispatching strategy.");
                }
                this.defaultStrategy = new Strategy(Strings.afterFirst("default:", string));
                this.strategies.add(this.defaultStrategy);
                continue;
            }
            this.strategies.add(new Strategy(string));
        }
        if (this.defaultStrategy == null) {
            throw new IllegalArgumentException("No default specified for dispatching strategy");
        }
        return this;
    }

    public void sendObject(Object object, Object object2) {
        Debug.expect(!this.strategies.isEmpty(), "No strategies for dispatching");
        Strategy strategy = this.ensureStrategy(object);
        this.agent.getContactManager().noteAgent((String)object);
        strategy.getStrategy().sendObject(object, object2);
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        Debug.expect(!this.strategies.isEmpty(), "No strategies for dispatching");
        this.agent = IXAgent.getAgent();
        Debug.expectEquals(object, this.agent.getAgentSymbolName(), "Symbol name changed before server setup:");
        this.ispaceSetup();
        boolean bl = true;
        for (Strategy strategy : this.strategies) {
            Debug.noteln("Calling setupServer for", strategy);
            strategy.setupServer(object, messageListener);
            String string = this.agent.getAgentSymbolName();
            if (!string.equals(object)) {
                if (bl) {
                    object = string;
                } else {
                    throw new IllegalStateException("Strategy " + strategy + " attempted to change " + "the agent's symbol name, but only the " + "first-listed strategy is allowed to do so.");
                }
            }
            bl = false;
        }
    }

    synchronized Map getDestinationToStrategyMap() {
        return this.destinationToStrategyMap;
    }

    synchronized Strategy getStrategy(Object object) {
        Debug.expect(object instanceof String);
        return (Strategy)this.destinationToStrategyMap.get(object);
    }

    synchronized void setStrategy(Object object, Strategy strategy) {
        Debug.expect(object instanceof String);
        if (strategy == null) {
            this.destinationToStrategyMap.remove(object);
        } else {
            this.destinationToStrategyMap.put(object, strategy);
        }
    }

    synchronized Strategy ensureStrategy(Object object) {
        Strategy strategy = this.getStrategy(object);
        if (strategy == null) {
            strategy = this.defaultStrategy;
            this.setStrategy(object, strategy);
            Debug.noteln("Assigned default strategy " + strategy + " to " + object);
        }
        return strategy;
    }

    synchronized Strategy findStrategy(String string) {
        for (Strategy strategy : this.strategies) {
            if (!strategy.getName().equals(string)) continue;
            return strategy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usingStrategy(final String string, final Strategy strategy) {
        Strategy strategy2;
        DispatchingStrategy dispatchingStrategy = this;
        synchronized (dispatchingStrategy) {
            strategy2 = this.getStrategy(string);
            if (strategy2 == strategy) {
                return;
            }
            this.setStrategy(string, strategy);
        }
        Util.swingAndWait(new Runnable(){

            public void run() {
                DispatchingStrategy.this.strategyPanel.nowUsingStrategy(string, strategy2, strategy);
            }
        });
    }

    void ispaceSetup() {
        Ip2 ip2 = (Ip2)IXAgent.getAgent();
        ISpaceTool iSpaceTool = (ISpaceTool)ip2.ensureTool("I-Space");
        ContactManager contactManager = ip2.getContactManager();
        for (AgentData agentData : contactManager.getAgentData()) {
            this.ensureStrategy(agentData.getName());
        }
        this.strategyPanel = new StrategyPanel(iSpaceTool);
        contactManager.addContactListener(this.strategyPanel);
        iSpaceTool.addTab("Communication", this.strategyPanel);
    }

    class StrategyComboBox
    extends ValueComboBox {
        public StrategyComboBox() {
            for (Strategy strategy : DispatchingStrategy.this.strategies) {
                this.addItem(strategy);
            }
            this.setSelectedValue(DispatchingStrategy.this.defaultStrategy);
        }

        public Object getSelectedValue() {
            return (Strategy)this.getSelectedItem();
        }

        public void setSelectedValue(Object object) {
            Strategy strategy = (Strategy)object;
            this.setSelectedItem(strategy);
        }
    }

    class StrategyPanel
    extends SelectionPanel
    implements ContactListener {
        ISpaceTool ispace;
        ContactManager contactManager;

        StrategyPanel(ISpaceTool iSpaceTool) {
            super(iSpaceTool.getFrame(), "Agent", "Strategy");
            this.ispace = iSpaceTool;
            this.contactManager = DispatchingStrategy.this.agent.getContactManager();
            this.load();
        }

        void nowUsingStrategy(String string, Strategy strategy, Strategy strategy2) {
            Debug.expect(strategy2 != strategy);
            if (strategy != null) {
                Util.displayAndWait(this.ispace.getFrame(), "Discovered " + string + " using strategy " + strategy2 + " instead of " + strategy);
            }
            this.reload();
        }

        protected ValueComboBox makeValueComboBox() {
            return new StrategyComboBox();
        }

        protected Map getCurrentValueMap() {
            return new TreeMap(DispatchingStrategy.this.getDestinationToStrategyMap());
        }

        protected void entryDeleted(String string) {
            Debug.expect(false, "Delete shouldn't be possible");
        }

        protected void valueChanged(String string, Object object) {
            Strategy strategy = DispatchingStrategy.this.getStrategy(string);
            Debug.expect(strategy != null, "no old value to change");
            DispatchingStrategy.this.setStrategy(string, (Strategy)object);
        }

        protected void entryAdded(String string, Object object) {
            Strategy strategy = DispatchingStrategy.this.getStrategy(string);
            if (strategy != null) {
                throw new IllegalArgumentException("Agent " + string + " is already in the table");
            }
            DispatchingStrategy.this.setStrategy(string, (Strategy)object);
            this.contactManager.noteAgent(string);
        }

        public void contactChange(ContactEvent contactEvent) {
            if (contactEvent.isNewContact()) {
                String string = contactEvent.getNewData().getName();
                DispatchingStrategy.this.ensureStrategy(string);
            } else if (contactEvent.isDeletion()) {
                String string = contactEvent.getOldData().getName();
                DispatchingStrategy.this.setStrategy(string, null);
            }
            this.reload();
        }
    }

    class Strategy
    implements IPC.MessageListener {
        String name;
        IPC.CommunicationStrategy strategy;
        IPC.MessageListener agentsListener;

        Strategy(String string) {
            this.name = string;
            this.strategy = IPC.makeCommunicationStrategy(string);
        }

        String getName() {
            return this.name;
        }

        IPC.CommunicationStrategy getStrategy() {
            return this.strategy;
        }

        public String toString() {
            return this.name;
        }

        public void setupServer(Object object, IPC.MessageListener messageListener) {
            Debug.expect(this.agentsListener == null);
            this.agentsListener = messageListener;
            this.strategy.setupServer(object, this);
        }

        public void messageReceived(IPC.InputMessage inputMessage) {
            Object object = inputMessage.getContents();
            if (object instanceof Sendable) {
                Sendable sendable = (Sendable)object;
                Name name = sendable.getSenderId();
                if (name == null) {
                    Debug.noteln("Strategy " + this + " received" + " a message with no sender-id");
                } else {
                    DispatchingStrategy.this.usingStrategy(name.toString(), this);
                }
            }
            this.agentsListener.messageReceived(inputMessage);
        }
    }
}

