/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.context.Context;
import ix.util.context.ContextChangeException;
import ix.util.context.ContextHolder;
import ix.util.context.ContextLink;
import ix.util.context.ContextMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContextHashMap
extends AbstractMap
implements ContextMap {
    protected static final Object UNDEF = new Object();
    protected ContextHolder holder;
    protected HashMap map;
    protected Entry keyChain;
    protected Entry keyChainLast;

    public ContextHashMap() {
        this(Context.getContextHolder());
    }

    public ContextHashMap(int n) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = Context.getContextHolder();
        this.map = new HashMap(n);
    }

    public ContextHashMap(int n, float f) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = Context.getContextHolder();
        this.map = new HashMap(n, f);
    }

    public ContextHashMap(Map map) {
        this(Context.getContextHolder(), map);
    }

    public ContextHashMap(ContextHolder contextHolder) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = contextHolder;
        this.map = new HashMap();
    }

    public ContextHashMap(ContextHolder contextHolder, final Map map) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = contextHolder;
        this.map = new HashMap();
        Context.inContext(contextHolder, Context.rootContext, new Runnable(){

            public void run() {
                ContextHashMap.this.putAll(map);
            }
        });
    }

    public Object put(Object object, Object object2) {
        Entry entry = (Entry)this.map.get(object);
        Context context = this.holder.getContext();
        if (entry == null) {
            Entry entry2 = new Entry(object, new ContextLink(context, object2));
            entry2.linkAfter(this.keyChainLast);
            this.keyChainLast = entry2;
            this.map.put(object, entry2);
            return null;
        }
        ContextLink contextLink = entry.valLink;
        Object object3 = Context.getInContext(contextLink, context);
        Context.setInContext(contextLink, context, object2);
        return object3 == UNDEF ? null : object3;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            return null;
        }
        ContextLink contextLink = entry.valLink;
        Object object2 = Context.getInContext(contextLink, this.holder.getContext());
        return object2 == UNDEF ? null : object2;
    }

    public Set entrySet() {
        return new EntrySet(this.keyChain);
    }

    public boolean containsKey(Object object) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            return false;
        }
        ContextLink contextLink = Context.getValueLinkInContext(entry.valLink, this.holder.getContext());
        return contextLink != null && contextLink.value != UNDEF;
    }

    public void clearCompletely() {
        this.map.clear();
        this.keyChainLast = this.keyChain = new Entry(null, null);
    }

    public Object remove(Object object) {
        return this.put(object, UNDEF);
    }

    public void clear() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            ((Map.Entry)iterator.next()).setValue(UNDEF);
        }
    }

    protected class IteratorContextException
    extends ContextChangeException {
        IteratorContextException(Context context, Context context2) {
            super("The iterator for a ContextHashMap entry-set created in " + context + " was used in " + context2);
        }
    }

    protected class EntrySetIterator
    implements Iterator {
        Context setCreationContext;
        Entry chain;
        Entry next = null;

        EntrySetIterator(Entry entry, Context context) {
            Debug.expect(entry != null);
            this.chain = entry;
            this.setCreationContext = context;
            this.findNext();
        }

        private void findNext() {
            Context context = ContextHashMap.this.holder.getContext();
            if (context != this.setCreationContext) {
                throw new IteratorContextException(this.setCreationContext, context);
            }
            while ((this.next = this.chain.getNext()) != null) {
                this.chain = this.next;
                ContextLink contextLink = Context.getValueLinkInContext(this.next.valLink, context);
                if (contextLink == null || contextLink.value == UNDEF) continue;
                return;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new ConsistencyException("next is null");
            }
            Entry entry = this.next;
            this.findNext();
            return entry;
        }

        public void remove() {
            throw new UnsupportedOperationException(this + " does not support remove()");
        }
    }

    protected class EntrySet
    extends AbstractSet {
        Context creationContext;
        Entry chain;
        int size = -1;

        EntrySet(Entry entry) {
            this.chain = entry;
            this.creationContext = ContextHashMap.this.holder.getContext();
        }

        public int size() {
            if (this.size < 0) {
                this.size = this.calcSize();
            }
            return this.size;
        }

        public Iterator iterator() {
            return new EntrySetIterator(this.chain, this.creationContext);
        }

        protected int calcSize() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }
    }

    protected class Entry
    implements Map.Entry {
        Object key;
        ContextLink valLink;
        Entry nextEntry = null;

        Entry(Object object, ContextLink contextLink) {
            this.key = object;
            this.valLink = contextLink;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return Context.getInContext(this.valLink, ContextHashMap.this.holder.getContext());
        }

        public Object setValue(Object object) {
            return ContextHashMap.this.put(this.key, object);
        }

        Entry getNext() {
            return this.nextEntry;
        }

        void linkAfter(Entry entry) {
            Debug.expect(entry.nextEntry == null, "pre already linked");
            Debug.expect(this.nextEntry == null, "this already linked");
            entry.nextEntry = this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object object2 = this.key;
            Object object3 = this.getValue();
            return (object2 == null ? k == null : object2.equals(k)) && (object3 == null ? v == null : object3.equals(v));
        }

        public int hashCode() {
            Object object = this.key;
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public String toString() {
            return "CtxtMapEntry[" + this.getKey() + "-->" + this.getValue() + "]";
        }
    }
}

