/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.Release;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.xml.XML;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void printGreeting(String string) {
        System.out.println(string + ", I-X version " + Release.version + ", " + Release.date);
        System.out.println("");
    }

    public static void displayAndWait(final Component component, final Object object) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(component, object, "Message", -1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void swingAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                Debug.noteln("Invocation target exception", invocationTargetException);
                Debug.noteException(Debug.getExceptionCause(invocationTargetException));
                throw new RethrownException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                throw new RethrownException(interruptedException);
            }
        }
    }

    public static void notImplemented(Component component, String string) {
        JOptionPane.showMessageDialog(component, string + " is not yet supported.");
    }

    public static String showInputDialog(Component component, Object object, Object object2) {
        return (String)JOptionPane.showInputDialog(component, object, null, 3, null, null, object2);
    }

    public static boolean dialogConfirms(final Component component, final Object object) {
        if (SwingUtilities.isEventDispatchThread()) {
            return Util.do_dialogConfirms(component, object);
        }
        final boolean[] blArray = new boolean[]{true};
        Util.swingAndWait(new Runnable(){

            public void run() {
                blArray[0] = Util.do_dialogConfirms(component, object);
            }
        });
        return blArray[0];
    }

    private static boolean do_dialogConfirms(Component component, Object object) {
        switch (JOptionPane.showConfirmDialog(component, object, "Confirm", 0)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new Error("Confirm dialog failed to return YES or NO");
    }

    public static void sleepSeconds(int n) {
        if (n > 0) {
            int n2 = n * 1000;
            Debug.noteln("Sleeping", n2);
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static Reader openURLReader(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRLConnection.getContentEncoding();
        if (string == null) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, string);
    }

    public static ImageIcon getImageIcon(String string) {
        URL uRL = XML.toURL(string);
        if (uRL == null && string.indexOf(47) < 0) {
            uRL = XML.toURL("resources/images/" + string);
        }
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        throw new RuntimeException("Can't find image resource named " + Strings.quote(string));
    }

    public static ImageIcon resourceImageIcon(String string) {
        String string2 = string.indexOf(47) > -1 ? string : "resources/images/" + string;
        URL uRL = XML.toURL(string2);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        throw new RuntimeException("Can't find image resource named " + Strings.quote(string));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getHostName() throws UnknownHostException {
        return Parameters.haveParameter("host") ? Parameters.getParameter("host") : InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static void run(Runnable runnable) {
        runnable.run();
    }

    public static void runHooks(String string, List list) {
        Debug.noteln("Running " + string + " hooks");
        for (Runnable runnable : list) {
            Debug.noteln("Running " + string + " hook", runnable);
            runnable.run();
        }
    }

    public static Class classForNameElseNull(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Object makeInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Cannot make 0-arg instance of " + clazz + " because " + Debug.describeException(exception));
        }
    }

    public static Object makeInstance(Class clazz, Object object) {
        Class[] classArray = new Class[1];
        try {
            for (Class<?> clazz2 = object.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Constructor constructor;
                classArray[0] = clazz2;
                try {
                    constructor = clazz.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                return constructor.newInstance(object);
            }
            throw new NoSuchMethodException("Can't find constructor");
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Cannot make an instance of " + clazz + " with one " + object.getClass() + " parameter" + " because " + Debug.describeException(exception));
        }
    }

    public static Object clone(Object object) {
        return Fn.apply(object, "clone", new Object[0]);
    }

    public static Object cloneBySerializing(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectOutputStream.close();
            byteArrayOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            byteArrayInputStream.close();
            objectInputStream.close();
            return object2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RethrownException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
    }

    public static <T> T mustBe(Class<T> clazz, Object object) {
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (object == null) {
            throw new ClassCastException("Required " + Util.aClass(clazz) + " but found null");
        }
        throw new ClassCastException("Required " + Util.aClass(clazz) + " but found " + Util.aClass(object.getClass()) + ": " + object);
    }

    public static String aClass(Class clazz) {
        return Strings.indefinite(XML.nameForClass(clazz));
    }

    public static Object appendArrays(Object[] objectArray) {
        if (objectArray.length < 1) {
            throw new IllegalArgumentException("Attempt to append zero arrays.");
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n += Array.getLength(objectArray[i]);
        }
        Class<?> clazz = objectArray[0].getClass().getComponentType();
        Object object = Array.newInstance(clazz, n);
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n3 = Array.getLength(objectArray[i]);
            for (int j = 0; j < n3; ++j) {
                Array.set(object, n2++, Array.get(objectArray[i], j));
            }
        }
        return object;
    }

    public static Object appendArrays(Object object, Object object2) {
        return Util.appendArrays(new Object[]{object, object2});
    }

    public static void printLines(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public static String askLine(String string) {
        System.out.print(string + " ");
        System.out.flush();
        try {
            while (System.in.available() == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            return "";
        }
        return Util.readLine(System.in);
    }

    public static String askLines(String string) {
        System.out.print(string + " ");
        System.out.flush();
        return Util.readLines(System.in);
    }

    public static String readLine() {
        return Util.readLine(System.in);
    }

    public static String readLine(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(80);
        while (true) {
            int n;
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                Debug.warn("IOException reading line from " + inputStream);
                break;
            }
            if (n == 10 || n == -1) break;
            if (n == 13) continue;
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toString();
    }

    public static String readLines() {
        return Util.readLines(System.in);
    }

    public static String readLines(InputStream inputStream) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string;
        while (!(string = Util.readLine(inputStream)).equals("")) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }

    public static void renameToBackup(File file) {
        Debug.expect(file.exists(), "No file", file);
        String string = file.getName();
        String[] stringArray = Strings.breakAtLast(".", string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = string2 + ".bak";
        File file2 = new File(file.getParentFile(), string4);
        if (file2.exists()) {
            Debug.noteln("Deleting existing backup", file2);
            file2.delete();
        }
        Debug.noteln("Renameing " + file + " to " + file2);
        file.renameTo(file2);
    }
}

