/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ConsistencyException;
import ix.util.Debug;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StableHashMap
extends AbstractMap
implements Serializable {
    protected HashMap map;
    protected Entry keyChain;
    protected Entry keyChainLast;

    public StableHashMap() {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.map = new HashMap();
    }

    public StableHashMap(int n) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.map = new HashMap(n);
    }

    public StableHashMap(int n, float f) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.map = new HashMap(n, f);
    }

    public StableHashMap(Map map) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.map = new HashMap();
        this.putAll(map);
    }

    public Object put(Object object, Object object2) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            Entry entry2 = new Entry(object, object2);
            entry2.linkAfter(this.keyChainLast);
            this.keyChainLast = entry2;
            this.map.put(object, entry2);
            return null;
        }
        Object object3 = entry.value;
        entry.value = object2;
        return object3;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.map.get(object);
        return entry == null ? null : entry.value;
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean containsKey(Object object) {
        return this.map.get(object) != null;
    }

    public void clear() {
        this.map.clear();
        this.keyChainLast = this.keyChain = new Entry(null, null);
    }

    public Object remove(Object object) {
        Entry entry = (Entry)this.map.remove(object);
        if (entry == null) {
            return null;
        }
        Entry entry2 = this.keyChain;
        while (entry2 != null) {
            Entry entry3 = entry2.nextEntry;
            if (entry3 == entry) {
                entry2.nextEntry = entry3.nextEntry;
                if (entry3 == this.keyChainLast) {
                    Debug.expect(entry2.nextEntry == null);
                    this.keyChainLast = entry2;
                }
                return entry.value;
            }
            entry2 = entry3;
        }
        throw new ConsistencyException("Couldn't find entry to delete");
    }

    protected class EntrySetIterator
    implements Iterator {
        Entry chain;

        EntrySetIterator(Entry entry) {
            this.chain = entry;
        }

        public boolean hasNext() {
            return this.chain.next() != null;
        }

        public Object next() {
            this.chain = this.chain.next();
            return this.chain;
        }

        public void remove() {
            throw new UnsupportedOperationException(this + " does not support remove()");
        }
    }

    protected class EntrySet
    extends AbstractSet {
        Entry chain;

        EntrySet() {
            this.chain = StableHashMap.this.keyChain;
        }

        public int size() {
            return StableHashMap.this.map.size();
        }

        public Iterator iterator() {
            return new EntrySetIterator(this.chain);
        }

        public boolean contains(Object object) {
            return StableHashMap.this.containsKey(object);
        }

        public void clear() {
            StableHashMap.this.clear();
            this.chain = StableHashMap.this.keyChain;
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }
    }

    protected class Entry
    implements Map.Entry,
    Serializable {
        Object key;
        Object value;
        Entry nextEntry = null;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        Entry next() {
            return this.nextEntry;
        }

        void linkAfter(Entry entry) {
            Debug.expect(entry.nextEntry == null, "pre already linked");
            Debug.expect(this.nextEntry == null, "this already linked");
            entry.nextEntry = this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object object2 = this.key;
            Object object3 = this.getValue();
            return (object2 == null ? k == null : object2.equals(k)) && (object3 == null ? v == null : object3.equals(v));
        }

        public int hashCode() {
            Object object = this.key;
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }
    }
}

