/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Collector;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Predicate1;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public abstract class Seq {
    private Seq() {
    }

    public static Vector toVector(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public static Vector fillVector(Vector vector, Enumeration enumeration) {
        vector.removeAllElements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public static Object[] toArray(Enumeration enumeration) {
        Vector vector = Seq.toVector(enumeration);
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static LList toLList(Enumeration enumeration) {
        if (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            return new Cons(e, Seq.toLList(enumeration));
        }
        return Lisp.NIL;
    }

    public static Enumeration elements(Vector vector) {
        return vector.elements();
    }

    public static Enumeration elements(LList lList) {
        return lList.elements();
    }

    public static Enumeration elements(final Object[] objectArray) {
        return new Enumeration(){
            int i = 0;

            public boolean hasMoreElements() {
                return this.i < objectArray.length;
            }

            public Object nextElement() {
                return objectArray[this.i++];
            }
        };
    }

    public static Enumeration elements(Collection collection) {
        return new IteratorEnumeration(collection.iterator());
    }

    public static void forEach(Enumeration enumeration, Function1 function1) {
        while (enumeration.hasMoreElements()) {
            function1.funcall(enumeration.nextElement());
        }
    }

    public static Enumeration map(final Enumeration enumeration, final Function1 function1) {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                return function1.funcall(enumeration.nextElement());
            }
        };
    }

    public static Enumeration filter(final Enumeration enumeration, final Predicate1 predicate1) {
        return new Enumeration(){
            Object elt = null;
            {
                this.findNext();
            }

            public boolean hasMoreElements() {
                return this.elt != null;
            }

            public Object nextElement() {
                Debug.expect(this.elt != null);
                Object object = this.elt;
                this.findNext();
                return object;
            }

            private void findNext() {
                while (enumeration.hasMoreElements()) {
                    this.elt = enumeration.nextElement();
                    if (!predicate1.trueOf(this.elt)) continue;
                    return;
                }
                this.elt = null;
            }
        };
    }

    public static void addEnumeration(Collector collector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collector.addElement(enumeration.nextElement());
        }
    }

    public static Function1 elementAdder(final Collector collector) {
        return new Function1(){

            public Object funcall(Object object) {
                collector.addElement(object);
                return null;
            }
        };
    }

    public static Vector shuffleVector(Vector vector) {
        Random random = new Random();
        for (int i = vector.size() - 1; i >= 0; --i) {
            int n = random.nextInt(i + 1);
            if (i == n) continue;
            Object e = vector.elementAt(i);
            vector.setElementAt(vector.elementAt(n), i);
            vector.setElementAt(e, n);
        }
        return vector;
    }

    public static final class IteratorEnumeration
    implements Enumeration {
        Iterator i;

        public IteratorEnumeration(Iterator iterator) {
            this.i = iterator;
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return this.i.next();
        }
    }
}

