/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Seq;
import ix.util.Strings;
import ix.util.xml.XML;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class Parameters {
    private static boolean isApplet = false;
    private static boolean isInteractive = true;
    private static AccessRecordingProperties parameters = new AccessRecordingProperties();

    public static void setParameter(String string, String string2) {
        parameters.put(string, string2);
        Debug.processParameter(string, string2);
        if (Debug.on) {
            Debug.noteln("Set parameter \"" + string + "\" = " + "\"" + string2 + "\"");
        }
    }

    public static Properties getParameters() {
        return parameters;
    }

    public static boolean isInteractive() {
        return isInteractive;
    }

    public static void setIsInteractive(boolean bl) {
        isInteractive = bl;
    }

    public static String getParameter(String string) {
        return parameters.getProperty(string);
    }

    public static String getParameter(String string, String string2) {
        return parameters.getProperty(string, string2);
    }

    public static boolean haveParameter(String string) {
        return parameters.getProperty(string) != null;
    }

    public static String requireParameter(String string) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            throw new RuntimeException("The required parameter " + Strings.quote(string) + " has not been supplied.");
        }
        return string2;
    }

    public static boolean usedParameter(String string) {
        return parameters.accessedProperty(string);
    }

    public static int getInt(String string) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            throw Parameters.bogusParameter("int", string, "null");
        }
        try {
            return Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.noteException(numberFormatException);
            throw Parameters.bogusParameter("int", string, string2);
        }
    }

    public static int getInt(String string, int n) {
        if (Parameters.haveParameter(string)) {
            return Parameters.getInt(string);
        }
        return n;
    }

    public static int getInt(String string, int n, int n2) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.noteException(numberFormatException);
            throw Parameters.bogusParameter("int", string, string2);
        }
    }

    public static boolean getBoolean(String string) {
        return Parameters.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("")) {
            return true;
        }
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw Parameters.bogusParameter("boolean", string, string2);
    }

    public static Dimension getDimension(String string) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = Strings.breakAtFirst("x", string2);
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            return new Dimension(n, n2);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw Parameters.bogusParameter("Dimension", string, string2);
        }
    }

    public static List getList(String string) {
        return Parameters.getList(string, Collections.EMPTY_LIST);
    }

    public static List getList(String string, List list) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return list;
        }
        return Strings.breakAt(",", string2);
    }

    public static Class getClass(String string) {
        return Parameters.getClass(string, null);
    }

    public static Class getClass(String string, Class clazz) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return clazz;
        }
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.noteException(classNotFoundException);
            throw Parameters.bogusParameter("Class", string, string2);
        }
    }

    private static RuntimeException bogusParameter(String string, String string2, String string3) {
        return new RuntimeException("Parameter \"" + string2 + "\" " + "has a non-" + string + " value: " + string3);
    }

    public static void checkParameterUse() {
        if (!Parameters.allParametersWereUsed()) {
            Vector<String> vector = new Vector<String>();
            Enumeration<?> enumeration = parameters.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (parameters.accessedProperty(string)) continue;
                vector.addElement(string);
            }
            Debug.expect(!vector.isEmpty());
            Debug.noteln("");
            Debug.noteln("Warning: The following parameters have not yet been used:");
            Debug.noteElements(vector.elements(), "   ");
            Debug.noteln("");
        }
    }

    public static boolean allParametersWereUsed() {
        Enumeration<?> enumeration = parameters.propertyNames();
        while (enumeration.hasMoreElements()) {
            if (parameters.accessedProperty((String)enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static void processCommandLineArguments(String[] stringArray) {
        Enumeration enumeration = Seq.elements(stringArray);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = Strings.breakAtFirst("=", string);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (!string2.startsWith("-")) {
                Parameters.complain(string2, "does not start with \"-\"");
            } else {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("n") && (string2.equals("not") || string2.equals("no"))) {
                if (!string3.equals("")) {
                    Parameters.complain(string, "has " + string2 + " with =");
                    continue;
                }
                if (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    Parameters.setParameter(string2, "false");
                    continue;
                }
                Parameters.complain(string2, "was not followed by a parameter name");
                continue;
            }
            if (string2.equals("load")) {
                if (!string3.equals("")) {
                    Parameters.complain(string, "has " + string2 + " with =");
                    continue;
                }
                if (enumeration.hasMoreElements()) {
                    try {
                        Parameters.loadParameters((String)enumeration.nextElement());
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.displayException(exception);
                        if (Parameters.isInteractive()) continue;
                        throw new RethrownException(exception);
                    }
                }
                Parameters.complain(string2, "was not followed by a resource name");
                continue;
            }
            Parameters.setParameter(string2, string3);
        }
    }

    private static void complain(String string, String string2) {
        Debug.warn("Parameter \"" + string + "\" " + string2);
    }

    public static void loadParameters(String string) {
        Properties properties = new Properties();
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find a property file named " + Strings.quote(string));
        }
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Parameters.setParameter(string2, (String)properties.get(string2));
        }
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void setIsApplet(boolean bl) {
        isApplet = bl;
    }

    static class AccessRecordingProperties
    extends Properties {
        Hashtable accessTable = new Hashtable();

        public synchronized String getProperty(String string) {
            this.accessTable.put(string, Boolean.TRUE);
            return super.getProperty(string);
        }

        public synchronized String getProperty(String string, String string2) {
            this.accessTable.put(string, Boolean.TRUE);
            return super.getProperty(string, string2);
        }

        public synchronized boolean accessedProperty(String string) {
            return this.accessTable.get(string) != null;
        }
    }
}

