/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.ObjectMapper;
import ix.util.xml.LiteralDocument;
import ix.util.xml.XML;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectCopier
implements ObjectMapper {
    protected ClassSyntax syntax;

    public ObjectCopier() {
        this(XML.config().defaultClassSyntax());
    }

    public ObjectCopier(ClassSyntax classSyntax) {
        this.syntax = classSyntax;
    }

    public Object copy(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.syntax.getClassDescr(clazz);
        return classDescr.mapObject(object, this);
    }

    public Object mapElement(Object object) {
        return object;
    }

    public Object mapPrimitive(Object object, ClassDescr classDescr) {
        return object;
    }

    public Object mapStruct(Object object, ClassDescr classDescr) {
        Object object2 = Util.makeInstance(classDescr.theClass);
        List list = classDescr.getFieldDescrs();
        try {
            for (FieldDescr fieldDescr : list) {
                fieldDescr.setValue(object2, this.mapElement(fieldDescr.getValue(object)));
            }
            return object2;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Can't copy struct because " + Debug.describeException(exception));
        }
    }

    public Object mapXML(LiteralDocument literalDocument, ClassDescr classDescr) {
        return literalDocument;
    }

    public Object mapList(List list, ClassDescr classDescr) {
        if (LList.class.isInstance(list)) {
            return this.copyLList((LList)list);
        }
        List list2 = (List)Util.makeInstance(list.getClass());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            list2.add(this.mapElement(iterator.next()));
        }
        return list2;
    }

    public LList copyLList(LList lList) {
        Cons cons;
        if (lList == Lisp.NIL) {
            return Lisp.NIL;
        }
        Cons cons2 = cons = Cons.typedCons(lList.getClass(), null, Lisp.NIL);
        Cons cons3 = (Cons)lList;
        while (true) {
            Object object = this.mapElement(cons3.car());
            cons2.setCar(object);
            LList lList2 = cons3.cdr();
            if (lList2 == Lisp.NIL) {
                return cons;
            }
            Cons cons4 = Cons.typedCons(lList2.getClass(), null, Lisp.NIL);
            cons2.setCdr(cons4);
            cons2 = cons4;
            cons3 = (Cons)lList2;
        }
    }

    public Object mapSet(Set set, ClassDescr classDescr) {
        Set set2 = (Set)Util.makeInstance(set.getClass());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            set2.add(this.mapElement(iterator.next()));
        }
        return set2;
    }

    public Object mapMap(Map map, ClassDescr classDescr) {
        Map map2 = (Map)Util.makeInstance(map.getClass());
        for (Map.Entry entry : map.entrySet()) {
            map2.put(this.mapElement(entry.getKey()), this.mapElement(entry.getValue()));
        }
        return map2;
    }

    public static void main(String[] stringArray) {
        ObjectCopier objectCopier = new ObjectCopier(){

            public Object mapElement(Object object) {
                Debug.noteln("Mapping", object);
                return object;
            }
        };
        String string;
        while (!(string = Util.askLine("Object:")).equals("bye")) {
            Object object = Lisp.readFromString(string);
            Debug.noteln("Copy:", objectCopier.copy(object));
        }
        return;
    }
}

