/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.BoundedGraph;
import ix.util.Collect;
import ix.util.DAGTransitiveClosure;
import ix.util.DirectedGraph;
import ix.util.FullTransitiveClosure;
import ix.util.Function0;
import ix.util.Function1;
import ix.util.IntRef;
import ix.util.StableHashMap;
import ix.util.TopologicalSorter;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Graphs {
    private Graphs() {
    }

    public static DirectedGraph makeDirectedGraph(final Map map) {
        return new DirectedGraph(){

            public Collection getAllNodes() {
                return map.keySet();
            }

            public Collection getRoots() {
                return map.keySet();
            }

            public Collection getSuccessors(Object object) {
                return (Collection)map.get(object);
            }

            public boolean isBefore(Object object, Object object2) {
                return this.getSuccessors(object).contains(object2);
            }
        };
    }

    public static DirectedGraph makeDirectedGraph(final Collection collection, final Function1 function1) {
        return new DirectedGraph(){
            Collection allNodes = null;

            public Collection getAllNodes() {
                if (this.allNodes == null) {
                    this.allNodes = Graphs.topologicalSort(this);
                }
                return this.allNodes;
            }

            public Collection getRoots() {
                return collection;
            }

            public Collection getSuccessors(Object object) {
                return (Collection)function1.funcall(object);
            }

            public boolean isBefore(Object object, Object object2) {
                return this.getSuccessors(object).contains(object2);
            }
        };
    }

    public static Map toMap(Map map, DirectedGraph directedGraph) {
        for (Object e : directedGraph.getAllNodes()) {
            map.put(e, directedGraph.getSuccessors(e));
        }
        return map;
    }

    public static Set minimalElements(DirectedGraph directedGraph) {
        Collection collection = directedGraph.getAllNodes();
        HashSet hashSet = new HashSet(collection);
        for (Object e : collection) {
            hashSet.removeAll(directedGraph.getSuccessors(e));
        }
        return hashSet;
    }

    public static Set maximalElements(DirectedGraph directedGraph) {
        HashSet hashSet = new HashSet();
        for (Object e : directedGraph.getAllNodes()) {
            Collection collection = directedGraph.getSuccessors(e);
            if (collection != null && !collection.isEmpty()) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public static DirectedGraph makeReflexive(DirectedGraph directedGraph) {
        StableHashMap stableHashMap = new StableHashMap();
        for (Object e : directedGraph.getAllNodes()) {
            Collection collection = directedGraph.getSuccessors(e);
            stableHashMap.put(e, Collect.union(collection, Lisp.list(e)));
        }
        return Graphs.makeDirectedGraph(stableHashMap);
    }

    public static DirectedGraph transpose(DirectedGraph directedGraph) {
        StableHashMap stableHashMap = new StableHashMap();
        Collection collection = directedGraph.getAllNodes();
        for (Object e : collection) {
            for (Object e2 : directedGraph.getSuccessors(e)) {
                LinkedList linkedList = (LinkedList)stableHashMap.get(e2);
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    stableHashMap.put(e2, linkedList);
                }
                linkedList.add(e);
            }
        }
        for (Object e : collection) {
            List list = (List)stableHashMap.get(e);
            if (list != null) continue;
            stableHashMap.put(e, new ArrayList(0));
        }
        return Graphs.makeDirectedGraph(stableHashMap);
    }

    public static List topologicalSort(final DirectedGraph directedGraph) {
        return new TopologicalSorter(){

            protected Collection getChildren(Object object) {
                return directedGraph.getSuccessors(object);
            }
        }.sort(directedGraph.getRoots());
    }

    public static DAGTransitiveClosure dagTransitiveClosure(DirectedGraph directedGraph) {
        return new DAGTransitiveClosure(directedGraph);
    }

    public static FullTransitiveClosure transitiveClosure(DirectedGraph directedGraph) {
        return new FullTransitiveClosure(directedGraph);
    }

    public static Map findLongestPathLengths(DirectedGraph directedGraph) {
        HashMap hashMap = new HashMap();
        List list = Graphs.topologicalSort(directedGraph);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), new IntRef(0));
        }
        for (Object e : list) {
            IntRef intRef = (IntRef)hashMap.get(e);
            int n = intRef.get() + 1;
            for (Object e2 : directedGraph.getSuccessors(e)) {
                IntRef intRef2 = (IntRef)hashMap.get(e2);
                if (n <= intRef2.get()) continue;
                intRef2.set(n);
            }
        }
        return hashMap;
    }

    public static BoundedGraph makeBoundedGraph(DirectedGraph directedGraph) {
        return Graphs.makeBoundedGraph(directedGraph, new Function0(){

            public Object funcall() {
                return new Object();
            }
        });
    }

    public static BoundedGraph makeBoundedGraph(final DirectedGraph directedGraph, Function0 function0) {
        final Object object = function0.funcall();
        final Object object2 = function0.funcall();
        return new BoundedGraph(){

            public Object getStartNode() {
                return object;
            }

            public Object getFinishNode() {
                return object2;
            }

            public Collection getAllNodes() {
                LList lList = LList.newLList(directedGraph.getAllNodes());
                return new Cons(object, new Cons(object2, lList));
            }

            public Collection getRoots() {
                return Lisp.list(object);
            }

            public Collection getSuccessors(Object object3) {
                if (object3 == object) {
                    Collection collection = directedGraph.getRoots();
                    return collection.isEmpty() ? Lisp.list(object2) : collection;
                }
                if (object3 == object2) {
                    return Lisp.NIL;
                }
                Collection collection = directedGraph.getSuccessors(object3);
                return collection.isEmpty() ? Lisp.list(object2) : collection;
            }

            public boolean isBefore(Object object3, Object object22) {
                return this.getSuccessors(object3).contains(object22);
            }

            public String toString() {
                return "BoundedGraph[" + directedGraph + "]";
            }
        };
    }
}

