/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Function1;
import ix.util.Predicate1;
import ix.util.Predicate2;
import ix.util.Proc;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collect {
    private Collect() {
    }

    public static final boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static final Iterator iterator(Collection collection) {
        return collection == null ? Lisp.NIL.iterator() : collection.iterator();
    }

    public static List ensureList(List list) {
        return list == null ? new ArrayList(0) : list;
    }

    public static <E> E randomth(List<E> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public static boolean containsEq(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != object) continue;
            return true;
        }
        return false;
    }

    public static Object findIf(Collection collection, Predicate1 predicate1) {
        for (Object e : collection) {
            if (!predicate1.trueOf(e)) continue;
            return e;
        }
        return null;
    }

    public static List replaceFirst(Object object, Object object2, List list) {
        ListIterator<Object> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != object) continue;
            listIterator.set(object2);
            break;
        }
        return list;
    }

    public static boolean equalAsSets(Collection collection, Collection collection2) {
        return collection.size() == collection2.size() && collection.containsAll(collection2);
    }

    public static boolean haveCommonElements(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!collection2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        Collection collection3 = Collect.initResult(collection);
        collection3.addAll(collection);
        collection3.retainAll(collection2);
        return Collect.getResult(collection3, collection);
    }

    public static Collection union(Collection collection, Collection collection2) {
        Collection collection3 = Collect.initResult(collection);
        collection3.addAll(collection);
        for (Object e : collection2) {
            if (collection.contains(e)) continue;
            collection3.add(e);
        }
        return Collect.getResult(collection3, collection);
    }

    public static Collection difference(Collection collection, Collection collection2) {
        Collection collection3 = Collect.initResult(collection);
        collection3.addAll(collection);
        collection3.removeAll(collection2);
        return Collect.getResult(collection3, collection);
    }

    public static List append(List list, List list2) {
        List list3 = (List)Collect.initResult(list);
        list3.addAll(list);
        list3.addAll(list2);
        return (List)Collect.getResult(list3, list);
    }

    public static List insertBeforeFirst(Object object, List list, List list2) {
        List list3 = (List)Collect.initResult(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!object.equals(e)) {
                list3.add(e);
                continue;
            }
            list3.addAll(list2);
            list3.add(e);
            while (iterator.hasNext()) {
                list3.add(iterator.next());
            }
            return (List)Collect.getResult(list3, list);
        }
        throw new IllegalArgumentException("Target " + object + " did not appear in " + list);
    }

    private static final Collection initResult(Collection collection) {
        return collection instanceof LList ? new LListCollector() : (Collection)Util.makeInstance(collection.getClass());
    }

    private static final Collection getResult(Collection collection, Collection collection2) {
        return collection2 instanceof LList ? ((LListCollector)collection).contents() : collection;
    }

    public static Collection map(Collection collection, Function1 function1) {
        return Collect.getResult(Collect.map(Collect.initResult(collection), collection, function1), collection);
    }

    public static Collection map(Collection collection, Collection collection2, Function1 function1) {
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            collection.add(function1.funcall(iterator.next()));
        }
        return collection;
    }

    public static boolean some(Collection collection, Predicate1 predicate1) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!predicate1.trueOf(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean every(Collection collection, Predicate1 predicate1) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (predicate1.trueOf(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static Collection filter(Collection collection, Predicate1 predicate1) {
        return Collect.getResult(Collect.filter(Collect.initResult(collection), collection, predicate1), collection);
    }

    public static Collection filter(Collection collection, Collection collection2, Predicate1 predicate1) {
        for (Object e : collection2) {
            if (!predicate1.trueOf(e)) continue;
            collection.add(e);
        }
        return collection;
    }

    public static String elementsToString(Collection collection, Function1 function1) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (function1 != null) {
                object = function1.funcall(object);
            }
            stringBuffer.append(object.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String elementsToString(Collection collection) {
        return Collect.elementsToString(collection, null);
    }

    public static void walkTriangle(List list, Proc proc) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            ListIterator listIterator2 = list.listIterator(listIterator.nextIndex());
            while (listIterator2.hasNext()) {
                Object e2 = listIterator2.next();
                proc.call(e, e2);
            }
        }
    }

    public static List powerset(List list) {
        ArrayList arrayList = new ArrayList(1 << list.size());
        LList lList = Lisp.NIL;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            lList = new Cons(iterator.next(), lList);
        }
        Collect.powerset1(arrayList, lList, Lisp.NIL);
        Collections.sort(arrayList, new ShortestFirstComparator());
        return arrayList;
    }

    private static void powerset1(List list, LList lList, LList lList2) {
        if (lList == Lisp.NIL) {
            list.add(lList2);
        } else {
            Object object = lList.car();
            LList lList3 = lList.cdr();
            Collect.powerset1(list, lList3, lList2);
            Collect.powerset1(list, lList3, new Cons(object, lList2));
        }
    }

    public static final boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static Map ensureMap(Map map) {
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public static boolean areConsistent(Map map, Map map2) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = map2.get(k);
            if (v2 == null || v2.equals(v)) continue;
            return false;
        }
        return true;
    }

    public static Function1 toFunction(final Map map) {
        return new Function1(){

            public Object funcall(Object object) {
                return map.get(object);
            }
        };
    }

    public static Map extendMap(Map map, Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext() & iterator2.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (map.get(e) != null) {
                throw new IllegalArgumentException("key already present");
            }
            map.put(e, e2);
        }
        Debug.expect(!iterator.hasNext() && !iterator2.hasNext());
        return map;
    }

    public static Map transposeMap(Map map) {
        Map map2 = (Map)Util.makeInstance(map.getClass());
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            map2.put(v, k);
        }
        return map2;
    }

    public static Map difference(Map map, Map map2) {
        Map map3 = (Map)Util.makeInstance(map.getClass());
        map3.putAll(map);
        Collect.removeAll(map3, map2);
        return map3;
    }

    public static boolean removeAll(Map map, Map map2) {
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = map2.get(k);
            if ((v != null || v2 != null || !map2.containsKey(k)) && (v2 == null || !v.equals(v2))) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static Map filter(Map map, Predicate2 predicate2) {
        return Collect.filter((Map)Util.makeInstance(map.getClass()), map, predicate2);
    }

    public static Map filter(Map map, Map map2, Predicate2 predicate2) {
        for (Map.Entry entry : map2.entrySet()) {
            Object v;
            Object k = entry.getKey();
            if (!predicate2.trueOf(k, v = entry.getValue())) continue;
            map.put(k, v);
        }
        return map;
    }

    public static class ShortestFirstComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Collection collection = (Collection)object;
            Collection collection2 = (Collection)object2;
            return collection.size() - collection2.size();
        }
    }
}

