/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.plan.Plan;
import ix.icore.plan.build.ExamplePlanBuilder;
import ix.icore.plan.build.PlanBuilder;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.LiteralDocument;
import ix.util.xml.XML;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class PlanBuilderTest {
    protected XMLOutputter out = XML.makePrettyXMLOutputter();

    public static void main(String[] stringArray) throws IOException {
        Parameters.processCommandLineArguments(stringArray);
        Class clazz = Parameters.getClass("plan-builder-class", ExamplePlanBuilder.class);
        PlanBuilder planBuilder = PlanBuilderTest.makePlanBuilder(clazz);
        new PlanBuilderTest().test(planBuilder);
    }

    public static PlanBuilder makePlanBuilder(Class clazz) {
        return (PlanBuilder)Util.makeInstance(clazz);
    }

    public void test(PlanBuilder planBuilder) throws IOException {
        Plan plan = this.makeExamplePlan(planBuilder);
        Document document = XML.objectToDocument(plan);
        this.out.output(document, (OutputStream)System.out);
    }

    public Plan makeExamplePlan(PlanBuilder planBuilder) {
        Issue issue = new Issue("why do that");
        planBuilder.addIssue(issue);
        planBuilder.addSubissue(issue, new Issue("why start"));
        planBuilder.addSubissue(issue, new Issue("why finish"));
        Issue issue2 = new Issue("why not");
        planBuilder.addIssue(issue2);
        Activity activity = new Activity("do something");
        planBuilder.addActivity(activity);
        planBuilder.addSubactivity(activity, new Activity("step one"));
        Activity activity2 = new Activity("step two");
        planBuilder.addSubactivity(activity, activity2);
        planBuilder.addSubactivity(activity2, new Activity("step two part one"));
        Activity activity3 = new Activity("do something else");
        planBuilder.addActivity(activity3);
        Constraint constraint = new Constraint(Symbol.intern("plan-validity"), Symbol.intern("use-before"), (List)Lisp.list("10 Mar 2004"));
        planBuilder.addConstraint(constraint);
        Constraint constraint2 = new Constraint("plan-validity", "ix-version", (List)Lisp.list("3.0"));
        constraint2.setAnnotation("status", "just an example");
        planBuilder.addConstraint(constraint2);
        planBuilder.setAnnotation("generated-by", this.getClass().getName());
        planBuilder.setAnnotation("plan-builder-class", planBuilder.getClass().getName());
        planBuilder.setAnnotation("an example document", new LiteralDocument(new Element("test-element").setAttribute("test-attrib", "attrib-value").addContent((Content)new Element("test-subelement"))));
        return planBuilder.getPlan();
    }
}

