/*
 * Decompiled with CFR 0.152.
 */
package ix.postix;

import ix.ichat.ChatFrame;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.util.IFUtil;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.ip2.ActivityTableViewer;
import ix.ip2.Ip2Frame;
import ix.ispace.ISpaceTool;
import ix.postix.Postix;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.PatternParser;
import ix.util.lisp.LList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PostixFrame
extends Ip2Frame
implements ActionListener {
    final JTextField active = new JTextField(15);
    Postix postix;

    public PostixFrame(Postix postix) {
        super(postix);
        this.postix = postix;
    }

    public void setUp() {
        JComponent jComponent;
        this.setIconImage(IconImage.getIconImage(this));
        this.activityViewer = this.postix.getActivityViewer();
        this.contentPane = this.getContentPane();
        this.setSize(540, 240);
        this.setJMenuBar(this.makeMenuBar());
        if (this.activityViewer instanceof ActivityTableViewer) {
            jComponent = (ActivityTableViewer)this.activityViewer;
            jComponent.removeColumn(jComponent.findColumn("Annotations"));
            jComponent.findColumn("Description").setHeaderValue("Item");
        }
        jComponent = new ThingEditorPanel(null, true, "ToDo", (JComponent)((Object)this.activityViewer));
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setPreferredSize(new Dimension(120, 100));
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.active);
        JButton jButton = new JButton("Add");
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton("Clear");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                Debug.noteln("I-P2 action:", string);
                Debug.expect(string.equals("Add"));
                String string2 = PostixFrame.this.active.getText().trim();
                if (!string2.equals("")) {
                    LList lList = PatternParser.parse(string2);
                    PostixFrame.this.activityViewer.addItem(PostixFrame.this.activityViewer.makeItem(lList));
                    PostixFrame.this.active.setText("");
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                Debug.noteln("I-P2 action:", string);
                Debug.expect(string.equals("Clear"));
                PostixFrame.this.active.setText("");
            }
        });
        this.contentPane.add((Component)jPanel, "North");
        this.contentPane.add(jScrollPane);
        this.logoPanel = this.postix.makeLogoPanel();
        this.contentPane.add((Component)this.logoPanel, "South");
    }

    protected void becomeVisible() {
        if (Parameters.haveParameter("frame-size")) {
            Dimension dimension = Parameters.getDimension("frame-size");
            this.pack();
            this.setSize(dimension);
        }
        this.setVisible(true);
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = super.makeMenuBar();
        jMenuBar.remove(IFUtil.getMenuBarMenu(jMenuBar, "New", true));
        return jMenuBar;
    }

    protected void addIp2Tools() {
        this.addTool(new ToolController("Domain Editor"){

            public Object createTool() {
                return PostixFrame.this.makeDomainEditor(PostixFrame.this.ip2, PostixFrame.this.ip2.getDomain());
            }
        });
        this.addTool(new ToolController("I-Space"){

            public Object createTool() {
                return new ISpaceTool(PostixFrame.this.ip2);
            }
        });
        this.addTool(new ToolController("Messenger"){

            public Object createTool() {
                return new ChatFrame(PostixFrame.this.ip2, PostixFrame.this.ip2.getAgentDisplayName() + " Messenger");
            }
        });
        this.addTool(new ToolController("HTML Viewer"){

            public Object createTool() {
                return PostixFrame.this.makeHTMLViewer();
            }
        });
    }
}

