/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.util;

import ix.iview.IDESymbols;
import ix.util.lisp.Symbol;

public class IDEUtil
implements IDESymbols {
    public static Symbol constPrefToSymbol(String string) {
        return Symbol.valueOf(string);
    }

    public static Symbol constPrefToSymbol(int n) {
        if (n == 1) {
            return C_ORDER_ONLY;
        }
        if (n == 10) {
            return C_CONDITIONS_ONLY;
        }
        if (n == 11) {
            return C_ORDER_CONDITIONS;
        }
        if (n == 100) {
            return C_OTHER_ONLY;
        }
        if (n == 101) {
            return C_ORDER_OTHER;
        }
        if (n == 110) {
            return C_CONDITIONS_OTHER;
        }
        if (n == 111) {
            return C_ALL;
        }
        return C_NONE;
    }

    public static String constPrefToString(int n) {
        return IDEUtil.constPrefToSymbol(n).toString();
    }

    public static int constPrefToInt(Symbol symbol) {
        if (symbol == C_NONE) {
            return 0;
        }
        if (symbol == C_ORDER_ONLY) {
            return 1;
        }
        if (symbol == C_CONDITIONS_ONLY) {
            return 10;
        }
        if (symbol == C_ORDER_CONDITIONS) {
            return 11;
        }
        if (symbol == C_OTHER_ONLY) {
            return 100;
        }
        if (symbol == C_ORDER_OTHER) {
            return 101;
        }
        if (symbol == C_CONDITIONS_OTHER) {
            return 110;
        }
        return 111;
    }

    public static int makeConstPrefInt(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 10;
        }
        if (bl3) {
            n += 100;
        }
        return n;
    }

    public static Symbol makeConstPrefSymbol(boolean bl, boolean bl2, boolean bl3) {
        int n = IDEUtil.makeConstPrefInt(bl, bl2, bl3);
        return IDEUtil.constPrefToSymbol(n);
    }

    public static boolean showOrder(int n) {
        return 1 == n % 10;
    }

    public static boolean showOther(int n) {
        return n >= 100;
    }

    public static boolean showConditions(int n) {
        return n % 100 >= 10;
    }

    public static boolean showOrder(Symbol symbol) {
        return IDEUtil.showOrder(IDEUtil.constPrefToInt(symbol));
    }

    public static boolean showOther(Symbol symbol) {
        return IDEUtil.showOther(IDEUtil.constPrefToInt(symbol));
    }

    public static boolean showConditions(Symbol symbol) {
        return IDEUtil.showConditions(IDEUtil.constPrefToInt(symbol));
    }

    public static boolean showConstraints(String string, String string2) {
        return IDEUtil.showConstraints(string, IDEUtil.constPrefToSymbol(string2));
    }

    public static boolean showConstraints(String string, Symbol symbol) {
        return IDEUtil.showConstraints(string, IDEUtil.constPrefToInt(symbol));
    }

    public static boolean showConstraints(String string, int n) {
        if (string.equals("order") || string.equals("orderings")) {
            return IDEUtil.showOrder(n);
        }
        if (string.equals("conditions") || string.equals("conditions/effects")) {
            return IDEUtil.showConditions(n);
        }
        if (string.equals("other") || string.equals("other constraints")) {
            return IDEUtil.showOther(n);
        }
        return false;
    }
}

