/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.igraph;

import ix.icore.domain.NodeSpec;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IXToolItem;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.CatchingActionListener;
import ix.iview.AConstructEditorPanel;
import ix.iview.ActionEditorPanel;
import ix.iview.ConstructEditing;
import ix.iview.UndoEditing;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.igraph.CompositeRectangularNode;
import ix.iview.igraph.ExpansionModel;
import ix.iview.igraph.IGraph;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import lt.monarch.graph.GraphModel;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.GraphViewPlugin;
import lt.monarch.graph.plugins.LinkDragger;
import lt.monarch.graph.plugins.MouseEventDistributor;
import lt.monarch.graph.plugins.NodeBoxSelector;
import lt.monarch.graph.plugins.NodeDragger;
import lt.monarch.graph.plugins.NodeSelectionManager;
import lt.monarch.graph.plugins.NodeSelector;
import lt.monarch.graph.plugins.SelectedNodeEmphasizer;
import lt.monarch.graph.swing.GraphPanel;
import lt.monarch.graph.view.NodeView;
import lt.monarch.graph.view.NodeViewFactory;
import lt.monarch.graph.view.ViewObject;
import lt.monarch.graph.view.looks.NodeViewBase;
import lt.monarch.graph.view.looks.RectangularPin;

public class GExpansionEditor
extends AConstructEditorPanel
implements ConstructEditing,
ActionListener,
UndoEditing {
    private String editorName = "Expansion Editor";
    private final ExpansionModel model = new ExpansionModel();
    protected ActionEditorPanel parent;
    protected NodeViewBase currentNode = null;
    private JPopupMenu nodePopup;
    private JMenu constructMenu;
    private JMenu expansionsMenu;
    private JTextField nameField;
    private JTextField patternField;
    private final GraphView graphView = new GraphView();
    private final MouseEventDistributor eventForwarder = new MouseEventDistributor();
    private final GraphPanel graphPanel = new GraphPanel(this.graphView);
    private final NodeSelectionManager selection = new NodeSelectionManager((GraphModel)this.model);
    private final CatchingActionListener catchingListener = new CatchingActionListener(this);
    JToolBar toolBar = new JToolBar();
    ImageIcon newGNodeIcon = Util.resourceImageIcon("ide-add-node.gif");
    ImageIcon deleteGNodesIcon = Util.resourceImageIcon("ide-delete-nodes.gif");
    ImageIcon layoutIcon = Util.resourceImageIcon("ide-layout.gif");
    ImageIcon layoutLeftIcon = Util.resourceImageIcon("ide-layout-left.gif");
    public IXToolItem newGNodeItem = new IXToolItem(this.toolBar, (ActionListener)this, "newGNode", "Add Node", this.newGNodeIcon, "Add a new node");
    public IXToolItem deleteGNodesItem = new IXToolItem(this.toolBar, (ActionListener)this, "deleteGNodes", "Delete", this.deleteGNodesIcon, "Delete selected node(s)");
    public IXToolItem layoutItem = new IXToolItem(this.toolBar, (ActionListener)this, "layout", "Layout", this.layoutIcon, "Layout graph");
    public IXToolItem layoutLeftItem = new IXToolItem(this.toolBar, (ActionListener)this, "layoutLeft", "Layout Left", this.layoutLeftIcon, "Layout graph left-aligned");
    final Point newNodeLocation = new Point(100, 100);

    public GExpansionEditor() {
        this.parent = null;
        Debug.noteln("ERROR: ******** Do not use constructor GExpansionEditor() - give it a parent!");
    }

    public GExpansionEditor(ActionEditorPanel actionEditorPanel) {
        this.setLayout(new BorderLayout());
        this.model.setPanel(actionEditorPanel);
        this.parent = actionEditorPanel;
        this.graphView.setModel((GraphModel)this.model);
        this.graphView.addPlugin((GraphViewPlugin)new SelectedNodeEmphasizer(this.selection));
        this.graphView.addPlugin((GraphViewPlugin)new NodeSelector(this.selection));
        LinkDragger linkDragger = new LinkDragger(this.model.getLinkStrategy());
        linkDragger.setInputModifierMask(0);
        this.graphView.addPlugin((GraphViewPlugin)linkDragger);
        this.graphView.addPlugin((GraphViewPlugin)new NodeBoxSelector(this.selection));
        this.graphView.addPlugin((GraphViewPlugin)new NodeDragger(this.selection));
        this.graphView.addPlugin((GraphViewPlugin)this.eventForwarder);
        this.graphView.setNodeViewFactory((NodeViewFactory)new ExpansionNodeViewFactory());
        this.graphPanel.setBackground(new Color(240, 240, 240));
        this.graphPanel.setPreferredSize(new Dimension(500, 500));
        this.add("Center", new JScrollPane((Component)this.graphPanel));
        this.nodePopup = this.makePopup(this.catchingListener);
        this.populateExpansionsMenu();
        this.makeToolbar();
    }

    private void makeToolbar() {
        this.toolBar.setAlignmentX(0.0f);
        this.newGNodeItem.show();
        this.deleteGNodesItem.show();
        this.toolBar.addSeparator();
        this.layoutItem.show();
        this.layoutLeftItem.show();
        this.toolBar.addSeparator();
        Box box = new Box(1);
        this.nameField = new JTextField(10);
        this.patternField = new JTextField(10);
        MouseAdapter mouseAdapter = new MouseAdapter(){};
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)mouseAdapter, "Name  ", this.nameField);
        box.add(thingEditorPanel);
        thingEditorPanel = new ThingEditorPanel((EventListener)mouseAdapter, "Pattern", this.patternField);
        box.add(thingEditorPanel);
        this.toolBar.add(box);
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GExpansionEditor.this.noteName();
            }
        });
        this.patternField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GExpansionEditor.this.notePattern();
            }
        });
        this.add("North", this.toolBar);
    }

    private JPopupMenu makePopup(CatchingActionListener catchingActionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Load graph");
        jMenuItem.addActionListener(catchingActionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Properties");
        jMenuItem.addActionListener(catchingActionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.expansionsMenu = new JMenu("Expansions");
        jPopupMenu.add(this.expansionsMenu);
        jMenuItem = new JMenuItem("New Expansion");
        jMenuItem.addActionListener(catchingActionListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void populateExpansionsMenu() {
        ArrayList arrayList = new ArrayList();
        if (this.currentNode != null) {
            NodeSpec nodeSpec = (NodeSpec)this.currentNode.getModelNode();
            arrayList = this.parent.getAllExpansions(nodeSpec);
        }
        UIUtil.populateMenu(this, this.expansionsMenu, "Expansions", arrayList);
    }

    public void setAction(UIRefinement uIRefinement) {
        this.uiConstruct = uIRefinement;
        this.loadFromObject();
    }

    public void layoutFromGraph(IGraph iGraph) {
        Iterator iterator = this.model.getNodes();
        if (iGraph.view == null || iterator == null || !iterator.hasNext()) {
            iGraph.layoutFromCanvasPoints(this.graphView);
        } else {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Point point = iGraph.getPosition(e);
                if (point != null) {
                    NodeView nodeView = (NodeView)this.graphView.nodeRegistry.getViewFor(e);
                    nodeView.setPosition(point);
                    continue;
                }
                Debug.noteln("GEE: node without position");
            }
        }
    }

    private void shiftLeft(GraphView graphView) {
        if (this.model == null) {
            return;
        }
        Iterator iterator = this.model.getNodes();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            NodeView nodeView = (NodeView)graphView.nodeRegistry.getViewFor(e);
            if (nodeView != null) {
                Rectangle rectangle = nodeView.getBounds();
                if (rectangle != null) {
                    rectangle.setLocation(20, (int)rectangle.getY());
                    Point point = new Point();
                    point.setLocation(rectangle.getCenterX(), rectangle.getCenterY());
                    nodeView.setPosition(point);
                    continue;
                }
                Debug.noteln("GEE: node without bounds", e);
                continue;
            }
            Debug.noteln("GEE: node without view", e);
        }
    }

    public void expandNode() {
        if (this.currentNode == null) {
            return;
        }
        ExpansionModel.NodeComponent nodeComponent = (ExpansionModel.NodeComponent)this.currentNode.getModelNode();
        this.model.expandNode(nodeComponent);
    }

    public void saveExpansionGraph(UIRefinement uIRefinement) {
        if (uIRefinement == null || uIRefinement.isUndefined() || uIRefinement.isEmpty()) {
            return;
        }
        String string = uIRefinement.getName();
        IGraph iGraph = uIRefinement.getGraph();
        if (iGraph == null) {
            iGraph = new IGraph(string, this.graphView);
            uIRefinement.setGraph(iGraph);
        } else {
            iGraph.refreshGraph(this.graphView);
        }
    }

    public void undoSetValue(String string, Object object) {
        Debug.noteln("Undo set: field " + string + ", value", object);
        if (string == null) {
            return;
        }
        if (string.equals("name")) {
            this.nameField.setText(object.toString());
        } else if (string.equals("pattern")) {
            String string2 = "";
            if (object != null) {
                string2 = UIUtil.listToDisplay((LList)object);
            }
            this.patternField.setText(string2);
        } else if (string.equals("graph")) {
            Debug.noteln(" Graph value class", object.getClass());
        }
    }

    public Object undoGetValue(String string) {
        Debug.noteln("Undo get: field", string);
        return null;
    }

    public void setUIConstruct(UIObject uIObject) {
        this.setUIConstructOnly(uIObject);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        UIObject uIObject2 = this.getUIConstruct();
        this.setAction((UIRefinement)uIObject);
        this.parent.fireConstructChanged(uIObject2, uIObject, this);
    }

    public void saveToObject(EditableObject editableObject) {
        UIRefinement uIRefinement = (UIRefinement)editableObject;
        this.saveToGivenObject(uIRefinement);
    }

    private void noteName() {
        UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
        uIRefinement.setName(this.nameField.getText().trim());
        this.nameField.setText(uIRefinement.getName());
    }

    private void notePattern() {
        UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
        uIRefinement.setPattern(Lisp.elementsFromString(this.patternField.getText().trim()));
    }

    public void saveToGivenObject(UIRefinement uIRefinement) {
        this.noteName();
        this.notePattern();
        this.model.updateAction(uIRefinement);
        this.saveExpansionGraph(uIRefinement);
    }

    public void loadFromObject() {
        UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
        this.nameField.setText("");
        this.patternField.setText("");
        this.model.setAction(uIRefinement);
        if (uIRefinement != null) {
            this.nameField.setText(uIRefinement.getName());
            this.patternField.setText(UIUtil.listToDisplay(uIRefinement.getPattern()));
            IGraph iGraph = uIRefinement.getGraph();
            if (iGraph != null) {
                this.layoutFromGraph(iGraph);
            } else {
                this.autoAutoLayout(this.graphView);
            }
        }
    }

    public void displayFieldData(String string) {
        if (string == null) {
            return;
        }
        UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
        this.model.setAction(uIRefinement);
        IGraph iGraph = (IGraph)this.parent.getUIDomain().getNamedGraph(uIRefinement.getName());
        if (iGraph != null) {
            this.layoutFromGraph(iGraph);
        } else {
            this.autoAutoLayout(this.graphView);
        }
    }

    public void autoAutoLayout(GraphView graphView) {
        this.autoLayout(graphView);
    }

    public void userAutoLayout(GraphView graphView) {
        this.autoLayout(graphView);
    }

    public void userAutoLayoutLeft(GraphView graphView) {
        this.autoLayoutLeft(graphView);
    }

    public void autoLayout(GraphView graphView) {
        graphView.layoutGraph();
        this.updateURIAutoGraph(graphView);
    }

    public void autoLayoutLeft(GraphView graphView) {
        graphView.layoutGraph();
        this.shiftLeft(graphView);
        this.updateURIAutoGraph(graphView);
    }

    private void updateURIAutoGraph(GraphView graphView) {
        UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
        if (uIRefinement != null) {
            IGraph iGraph = new IGraph(uIRefinement.getName(), graphView);
            iGraph.refreshGraph(graphView);
            uIRefinement.setAutoPoints(iGraph.getGraphCanvasPoints());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("GEE got action command", string);
        if (string.equals("New Expansion")) {
            this.expandNode();
        } else if (string.equals("Expansions")) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.parent.setUIConstruct((UIObject)this.parent.getNamedConstruct(string2));
        } else if (string.equals("newGNode")) {
            Object object = this.model.addNewNode();
            if (object != null) {
                NodeView nodeView = (NodeView)this.graphView.nodeRegistry.getViewFor(object);
                nodeView.setPosition(this.newNodeLocation);
                this.newNodeLocation.x += 20;
                this.newNodeLocation.y += 20;
            }
        } else if (string.equals("deleteGNodes")) {
            Iterator iterator = this.selection.getSelectedNodes();
            while (iterator.hasNext()) {
                this.model.deleteNode((NodeSpec)iterator.next());
            }
        } else if (string.equals("layout")) {
            this.userAutoLayout(this.graphView);
        } else if (string.equals("layoutLeft")) {
            this.userAutoLayoutLeft(this.graphView);
        } else {
            UIUtil.notImplemented(this.parent, string);
        }
    }

    private class ExpansionNodeViewFactory
    implements NodeViewFactory {
        private ExpansionNodeViewFactory() {
        }

        public NodeView createViewFor(Object object) {
            int n;
            ExpansionModel.NodeComponent nodeComponent = (ExpansionModel.NodeComponent)object;
            CompositeRectangularNode compositeRectangularNode = new CompositeRectangularNode(GExpansionEditor.this.graphView, GExpansionEditor.this.graphPanel, nodeComponent){

                protected RectangularPin createPinFor(Object object, String string) {
                    RectangularPin rectangularPin = super.createPinFor(object, string);
                    rectangularPin.setBackground(Color.green);
                    return rectangularPin;
                }
            };
            compositeRectangularNode.setOrientation(1);
            compositeRectangularNode.setBackground(Color.white);
            compositeRectangularNode.setLabel(nodeComponent.id + ": " + nodeComponent.label);
            for (n = 0; n < nodeComponent.inputPins.length; ++n) {
                compositeRectangularNode.addInputPin(nodeComponent.inputPins[n], nodeComponent.inputPins[n].label);
            }
            for (n = 0; n < nodeComponent.outputPins.length; ++n) {
                compositeRectangularNode.addOutputPin(nodeComponent.outputPins[n], nodeComponent.outputPins[n].label);
            }
            CompositeRectangularNode compositeRectangularNode2 = compositeRectangularNode;
            GExpansionEditor.this.eventForwarder.addMouseListener((ViewObject)compositeRectangularNode, (MouseListener)new MouseAdapter((NodeViewBase)compositeRectangularNode2){
                final /* synthetic */ NodeViewBase val$targetNode;
                {
                    this.val$targetNode = nodeViewBase;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    GExpansionEditor.this.currentNode = this.val$targetNode;
                    GExpansionEditor.this.populateExpansionsMenu();
                    GExpansionEditor.this.nodePopup.show((Component)GExpansionEditor.this.graphPanel, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            return compositeRectangularNode;
        }
    }
}

