/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.ListOfRefinement;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.SchemaTerms;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.util.UIUtil;
import ix.iview.domain.DomainReferenceException;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.igraph.IGraph;
import ix.iview.util.IVUtil;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.match.SimpleMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.swing.tree.TreeNode;

public class UIRefinement
implements UIObject,
Named,
SchemaTerms,
TreeNode {
    public String name;
    public LList pattern = Lisp.NIL;
    public List nodes = new ArrayList();
    public List orderings = new ArrayList();
    public List constraints = new ArrayList();
    public List issues = new ArrayList();
    public String comments = "";
    public List variableDeclarations;
    protected UIDomain uiDomain;
    protected Refinement baseObject;
    protected String baseReference = "";
    protected IGraph graph;
    protected List autoPoints;
    private boolean initing = false;
    HashSet dataChangeListeners = new HashSet();
    private static final int NOFIND = -1;

    public UIRefinement(UIDomain uIDomain) {
        this.uiDomain = uIDomain;
    }

    public UIRefinement(UIDomain uIDomain, Refinement refinement) {
        this.initing = true;
        this.uiDomain = uIDomain;
        try {
            this.baseObject = (Refinement)refinement.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.baseReference = refinement.getName();
        this.loadFromDomain();
        uIDomain.addedObject(this, refinement);
        this.initing = false;
    }

    public UIRefinement cloneThis() {
        UIRefinement uIRefinement;
        try {
            uIRefinement = (UIRefinement)this.clone();
            uIRefinement.baseObject = null;
            uIRefinement.baseReference = "";
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            uIRefinement = new UIRefinement(this.uiDomain);
            uIRefinement.pattern = this.pattern;
            uIRefinement.nodes = this.nodes;
            uIRefinement.orderings = this.orderings;
            uIRefinement.constraints = this.constraints;
            uIRefinement.issues = this.issues;
            uIRefinement.comments = this.comments;
            uIRefinement.variableDeclarations = this.variableDeclarations;
            uIRefinement.graph = this.graph;
        }
        return uIRefinement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!IVUtil.sameString(string, this.name)) {
            this.uiDomain.changeName(this, string);
        }
    }

    public void setLegalName(String string) {
        String string2 = this.name;
        this.name = string;
        this.fireDataChange("name", string2, string);
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        LList lList2 = this.pattern;
        this.pattern = lList;
        this.fireDataChange("pattern", lList2, lList);
    }

    public void clearPattern() {
        this.setPattern(Lisp.NIL);
    }

    public List getNodes() {
        return this.nodes;
    }

    public void setNodes(List list) {
        ArrayList arrayList = new ArrayList(this.nodes);
        this.nodes = IVUtil.sortNodeCollection(list);
        this.fireDataChange("nodes", arrayList, this.nodes);
    }

    public void updateNodes(List list) {
        ArrayList arrayList = new ArrayList(this.nodes);
        ArrayList<NodeSpec> arrayList2 = new ArrayList<NodeSpec>();
        if (arrayList == null || arrayList.size() == 0) {
            this.setNodes(list);
        } else if (list == null || arrayList.size() == 0) {
            this.setNodes(list);
        } else {
            Serializable serializable;
            Object object22;
            ArrayList arrayList3 = new ArrayList(this.nodes);
            boolean bl = false;
            ArrayList arrayList4 = new ArrayList();
            for (Object object22 : list) {
                LList serializable2 = ((NodeSpec)object22).getPattern();
                serializable = this.findNode(arrayList3, serializable2);
                if (serializable != null) {
                    arrayList2.add((NodeSpec)serializable);
                    int n = arrayList3.indexOf(serializable);
                    arrayList3.remove(n);
                    continue;
                }
                bl = true;
                arrayList4.add(object22);
            }
            ArrayList arrayList5 = new ArrayList();
            for (NodeSpec nodeSpec : arrayList4) {
                serializable = nodeSpec.getPattern();
                NodeSpec nodeSpec2 = UIRefinement.findEditedNode(arrayList3, (LList)serializable);
                if (nodeSpec2 != null) {
                    arrayList2.add(new UINodeSpec(this.getUIDomain(), nodeSpec2.getId(), (LList)serializable));
                    int n = arrayList3.indexOf(nodeSpec2);
                    arrayList3.remove(n);
                    continue;
                }
                bl = true;
                arrayList5.add(nodeSpec);
            }
            object22 = arrayList5.iterator();
            while (object22.hasNext()) {
                arrayList2.add((NodeSpec)object22.next());
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                bl = true;
            }
            if (bl) {
                this.setNodes(arrayList2);
            }
        }
    }

    public void clearNodes() {
        this.setNodes(new ArrayList());
    }

    public List getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List list) {
        ArrayList arrayList = new ArrayList(this.orderings);
        this.orderings = new ArrayList(list);
        this.fireDataChange("orderings", arrayList, this.orderings);
    }

    public void clearOrderings() {
        this.setOrderings(new ArrayList());
    }

    public void updateOrderings() {
        ArrayList<Ordering> arrayList = new ArrayList<Ordering>();
        boolean bl = false;
        for (Ordering ordering : this.orderings) {
            if (IVUtil.checkNodeRefConsistency(this, ordering)) {
                arrayList.add(ordering);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.setOrderings(arrayList);
        }
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List list) {
        ArrayList arrayList = new ArrayList(this.getConditions());
        ArrayList arrayList2 = new ArrayList(this.constraints);
        this.constraints = IVUtil.sortConstraintCollection(new ArrayList(list));
        this.fireDataChange("constraints", arrayList2, this.constraints);
        this.fireDataChange("conditions", arrayList, this.getConditions());
    }

    public void clearConstraints() {
        this.setConstraints(new ArrayList());
    }

    public boolean deleteConstraint(Constraint constraint) {
        List list = this.getConstraints();
        if (!list.contains(constraint)) {
            return false;
        }
        list.remove(constraint);
        return true;
    }

    public List getConditions() {
        List list = this.getConstraints();
        return UIRefinement.filterForConditions(list);
    }

    public void setConditions(List list) {
        ArrayList arrayList = new ArrayList(this.getConstraints());
        List list2 = this.getConstraints();
        List list3 = UIRefinement.filterOutConditions(list2);
        list3.addAll(list);
        this.setConstraints(list3);
        this.fireDataChange("conditions", arrayList, this.constraints);
    }

    public List getTypeConstraints() {
        List list = this.getConstraints();
        return IVUtil.filterClassConstraints(list);
    }

    public void setTypeConstraints(List list) {
        List list2 = this.getConstraints();
        List list3 = IVUtil.filterClassConstraints(list2);
        ArrayList arrayList = list2 == null ? new ArrayList() : new ArrayList(list2);
        if (list3 != null) {
            arrayList.removeAll(list3);
        }
        arrayList.addAll(list);
        this.setConstraints(arrayList);
        this.fireDataChange("constraints", list2, this.constraints);
    }

    public Constraint getTypeConstraint(ItemVar itemVar) {
        return IVUtil.findClassConstraint(itemVar, this.getConstraints());
    }

    public void setTypeConstraint(ItemVar itemVar, Constraint constraint) {
        Constraint constraint2 = this.getTypeConstraint(itemVar);
        List list = this.getConstraints();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>(list);
        if (constraint2 != null) {
            arrayList.remove(constraint2);
        }
        arrayList.add(constraint);
        this.setConstraints(arrayList);
        this.fireDataChange("constraints", list, this.constraints);
    }

    public List getVariableConstraints(ItemVar itemVar) {
        if (itemVar == null) {
            return null;
        }
        SortedSet sortedSet = this.getVariablesUsed();
        if (sortedSet == null || !sortedSet.contains(itemVar)) {
            return null;
        }
        List list = this.getConstraints();
        List list2 = UIRefinement.filterForVariable(itemVar, list);
        return list2;
    }

    public void setVariableConstraints(ItemVar itemVar, List list) {
        if (itemVar == null) {
            return;
        }
        List list2 = this.getConstraints();
        List list3 = UIRefinement.filterForVariable(itemVar, list2);
        ArrayList arrayList = list2 == null ? new ArrayList() : new ArrayList(list2);
        if (list3 != null) {
            arrayList.removeAll(list3);
        }
        arrayList.addAll(list);
        this.setConstraints(arrayList);
        this.fireDataChange("constraints", list2, this.constraints);
    }

    public static List filterForConditions(List list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Constraint constraint = (Constraint)iterator.next();
                    if (!constraint.getType().equals(Refinement.S_WORLD_STATE) || !constraint.getRelation().equals(Refinement.S_CONDITION) && !constraint.getRelation().equals(Refinement.S_EFFECT)) continue;
                    arrayList.add(constraint);
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    private static List filterOutConditions(List list) {
        if (list == null) {
            return null;
        }
        List list2 = UIRefinement.filterForConditions(list);
        ArrayList arrayList = new ArrayList(list);
        if (list2 != null) {
            arrayList.removeAll(list2);
        }
        return arrayList;
    }

    public static List filterForVariable(ItemVar itemVar, List list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    LList lList;
                    Constraint constraint = (Constraint)iterator.next();
                    PatternAssignment patternAssignment = constraint.getPatternAssignment();
                    if (patternAssignment == null || !IVUtil.isSubjectInPattern(itemVar, lList = patternAssignment.getPattern())) continue;
                    arrayList.add(constraint);
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    public List getOtherConstraints() {
        List list = this.getConstraints();
        return UIRefinement.filterOutConditions(list);
    }

    public void setOtherConstraints(List list) {
        ArrayList arrayList = new ArrayList(this.getConstraints());
        List list2 = this.getConstraints();
        List list3 = UIRefinement.filterForConditions(list2);
        list3.addAll(list);
        this.setConstraints(list3);
        this.fireDataChange("constraints", arrayList, this.constraints);
    }

    public boolean hasOrderings() {
        return this.orderings != null && this.orderings.size() != 0;
    }

    public boolean hasConditions() {
        List list = this.getConditions();
        return list != null && list.size() != 0;
    }

    public boolean hasAnonConstraints() {
        List list = this.getOtherConstraints();
        return list != null && list.size() != 0;
    }

    public List getIssues() {
        return this.issues;
    }

    public void setIssues(List list) {
        ArrayList arrayList = new ArrayList(this.issues);
        this.issues = IVUtil.sortTICollection(list);
        this.fireDataChange("issues", arrayList, this.issues);
    }

    public void deleteIssue(Issue issue) {
        ArrayList arrayList = new ArrayList(this.issues);
        arrayList.remove(issue);
        this.setIssues(arrayList);
    }

    public void clearIssues() {
        this.setIssues(new ArrayList());
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        String string2 = this.comments;
        this.comments = string;
        this.fireDataChange("comments", string2, this.comments);
    }

    public Domain getDomain() {
        return this.uiDomain.getDomain();
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public void moveToUIDomain(UIDomain uIDomain) {
        if (this.uiDomain == null) {
            this.uiDomain = uIDomain;
        } else {
            this.uiDomain = uIDomain;
            uIDomain.addedObject(this, this.getBaseObject());
        }
    }

    public Object getBaseReference() {
        return this.baseReference;
    }

    public void setBaseReference(Object object) {
        this.baseReference = (String)object;
    }

    public IXObject getBaseObject() {
        return this.baseObject;
    }

    public IXObject makeBaseObject() {
        return new Refinement();
    }

    public void setBaseObject(IXObject iXObject) {
        this.baseObject = (Refinement)iXObject;
    }

    public Class getBaseClass() {
        return Refinement.class;
    }

    public boolean hasOriginal() {
        return this.getBaseReference() != null && !this.getBaseReference().equals("");
    }

    public void saveToDomain() {
        if (this.baseObject == null) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.saveToDomain(this.baseObject);
    }

    public void saveToDomain(Object object) {
        Refinement refinement = (Refinement)object;
        refinement.setName(this.name);
        refinement.setPattern(this.pattern);
        this.writeNodes(refinement);
        if (this.orderings.isEmpty()) {
            refinement.setOrderings(null);
        } else {
            refinement.setOrderings(this.orderings);
        }
        if (this.constraints.isEmpty()) {
            refinement.setConstraints(null);
        } else {
            refinement.setConstraints(this.constraints);
        }
        if (this.issues.isEmpty()) {
            refinement.setIssues(null);
        } else {
            refinement.setIssues(this.issues);
        }
        refinement.setComments(this.comments);
        refinement.setVariableDeclarations(this.variableDeclarations);
        this.saveCanvasPositionGraphToDomain(refinement);
    }

    public void loadFromDomain() {
        if (this.baseObject == null) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.name = this.baseObject.getName();
        this.pattern = this.baseObject.getPattern() == null ? Lisp.NIL : this.baseObject.getPattern();
        this.makeNodes(this.baseObject.getNodes());
        this.orderings = this.baseObject.getOrderings() == null ? new ArrayList() : new ArrayList(this.baseObject.getOrderings());
        this.constraints = this.baseObject.getConstraints() == null ? new ArrayList() : new ArrayList(this.baseObject.getConstraints());
        if (this.baseObject.getIssues() == null) {
            this.issues = new ArrayList();
        } else {
            this.setIssues(this.baseObject.getIssues());
        }
        this.comments = this.baseObject.getComments();
        this.variableDeclarations = this.baseObject.getVariableDeclarations();
        this.loadCanvasPositionGraphFromDomain(this.baseObject);
        this.fireDataChange("all", null, null);
    }

    public List getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public void setVariableDeclarations(List list) {
        List list2 = this.variableDeclarations;
        this.variableDeclarations = list;
        this.fireDataChange("variableDeclarations", list2, this.variableDeclarations);
    }

    public SortedSet getVariablesUsed() {
        Refinement refinement = new Refinement();
        this.saveToDomain(refinement);
        return refinement.getVariablesUsed();
    }

    public void loadFromDomain(Object object) {
        this.baseObject = (Refinement)object;
        this.loadFromDomain();
    }

    public void saveMGraphToDomain(Refinement refinement) {
        refinement.setAnnotation("mGraph", this.graph);
    }

    public void saveCanvasPositionGraphToDomain(Refinement refinement) {
        if (this.graph != null) {
            List list = this.graph.getGraphCanvasPoints();
            if (list == null || list.isEmpty()) {
                list = this.graph.getCanvasPoints();
            }
            if (!(list == null || list.isEmpty() || this.autoPoints != null && Collect.equalAsSets(list, this.autoPoints))) {
                refinement.setAnnotation("canvasPositionGraph", list);
            } else {
                Object object = refinement.getAnnotation("canvasPositionGraph");
                if (object != null) {
                    refinement.setAnnotation("canvasPositionGraph", null);
                }
            }
        }
    }

    public void loadMGraphFromDomain(Refinement refinement) {
        this.graph = (IGraph)refinement.getAnnotation("mGraph");
    }

    public void loadCanvasPositionGraphFromDomain(Refinement refinement) {
        Object object = refinement.getAnnotation("canvasPositionGraph");
        if (object == null) {
            this.graph = null;
        } else {
            IGraph iGraph = this.graphFromPosition(refinement, object);
            if (iGraph != null) {
                this.graph = iGraph;
                this.uiDomain.addGraph(iGraph);
            }
        }
    }

    public IGraph graphFromPosition(Refinement refinement, Object object) {
        IGraph iGraph = null;
        if (object instanceof HashMap) {
            if (!((HashMap)object).isEmpty()) {
                iGraph = new IGraph(refinement.getName(), (HashMap)object);
            }
        } else if (object instanceof List && !((List)object).isEmpty()) {
            iGraph = new IGraph(refinement.getName(), (List)object);
        }
        return iGraph;
    }

    public IXObject getOriginal() {
        Object object = this.getBaseReference();
        return this.getDomain().getNamedRefinement((String)object);
    }

    public void loadFromOriginal() {
        if (this.hasOriginal()) {
            Refinement refinement = (Refinement)this.getOriginal();
            try {
                this.setBaseObject((Refinement)refinement.clone());
                this.loadFromDomain();
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                Debug.noteln("Continuing with new object as the original");
                this.setBaseObject(this.makeBaseObject());
                this.loadFromDomain();
            }
        } else {
            this.setBaseObject(this.makeBaseObject());
            this.loadFromDomain();
        }
    }

    private void makeNodes(List list) {
        ArrayList<UINodeSpec> arrayList = new ArrayList<UINodeSpec>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new UINodeSpec(this.uiDomain, (NodeSpec)iterator.next()));
            }
        }
        this.setNodes(arrayList);
    }

    private void writeNodes(Refinement refinement) {
        if (this.nodes == null || this.nodes.isEmpty()) {
            refinement.setNodes(null);
        } else {
            LListCollector lListCollector = new LListCollector();
            for (NodeSpec nodeSpec : this.nodes) {
                lListCollector.add(new NodeSpec(nodeSpec.getId(), nodeSpec.getPattern()));
            }
            refinement.setNodes(lListCollector);
        }
    }

    public boolean sameNodes(List list, List list2) {
        if (list == null) {
            return list2 == null || list2.size() == 0;
        }
        if (list2 == null) {
            return list == null || list.size() == 0;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Hashtable<Name, LList> hashtable = new Hashtable<Name, LList>();
        for (NodeSpec nodeSpec : list) {
            hashtable.put(nodeSpec.getId(), nodeSpec.getPattern());
        }
        for (NodeSpec nodeSpec : list2) {
            LList lList = (LList)hashtable.get(nodeSpec.getId());
            LList lList2 = nodeSpec.getPattern();
            if (!(lList2 == null ? lList != null : !lList2.equal(lList))) continue;
            return false;
        }
        return true;
    }

    private boolean sameIssues(List list, List list2) {
        if (IVUtil.bothEmpty(list, list2)) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        HashSet<LList> hashSet = new HashSet<LList>();
        for (Issue issue : list) {
            hashSet.add(issue.getPattern());
        }
        for (Issue issue : list2) {
            if (hashSet.contains(issue.getPattern())) continue;
            return false;
        }
        return true;
    }

    private boolean sameOrderings(Object object, Object object2) {
        try {
            return IVUtil.sameSet((Collection)object, (Collection)object2);
        }
        catch (ClassCastException classCastException) {
            try {
                return ((String)object).equals((String)object2);
            }
            catch (ClassCastException classCastException2) {
                try {
                    if (object instanceof String) {
                        return object.equals(this.getOrderingType());
                    }
                    if (object2 instanceof String) {
                        return object2.equals(this.getOrderingType((Collection)object));
                    }
                    return object.equals(object2);
                }
                catch (Exception exception) {
                    Debug.noteln("Failure to compare ordering values; assuming values differ.");
                    Debug.describeException(exception);
                    return false;
                }
            }
        }
    }

    private boolean emptyPositions(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        return object instanceof Map && ((Map)object).isEmpty();
    }

    private boolean sameGraph(IGraph iGraph, Object object) {
        if (iGraph == null) {
            return true;
        }
        if (this.emptyPositions(object) && iGraph.isSameLayout(this.autoPoints)) {
            return true;
        }
        return iGraph.isSameLayout(object);
    }

    public void addToDomain() {
        this.addToDomain(this.getDomain());
    }

    public void addToDomain(Domain domain) {
        if (this.baseObject == null) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.saveToDomain();
        String string = this.baseObject.getName();
        Refinement refinement = domain.getNamedRefinement(string);
        if (refinement != null) {
            if (this.baseObject.equals(refinement)) {
                return;
            }
            Debug.noteln("UIR: Trying to add refinement that is already there");
            this.saveToDomain(refinement);
            return;
        }
        domain.addRefinement(this.baseObject);
    }

    public void updateInDomain() throws DomainReferenceException {
        this.updateInDomain(this.getDomain());
    }

    public void updateInDomain(Domain domain) throws DomainReferenceException {
        String string = (String)this.getBaseReference();
        Refinement refinement = this.getReferredObject(domain, string, this.name);
        if (refinement == null) {
            Debug.noteln("Update refinement: cannot find base object called", string);
            Debug.noteln(" Domain is", domain);
            return;
        }
        this.saveToDomain();
        domain.replaceRefinement(refinement, this.baseObject);
    }

    public void removeFromDomain() throws DomainReferenceException {
        this.removeFromDomain(this.getDomain());
    }

    public void removeFromDomain(Domain domain) throws DomainReferenceException {
        String string = (String)this.getBaseReference();
        Refinement refinement = this.getReferredObject(domain, string, this.name);
        if (refinement == null) {
            Debug.noteln("Remove refinement: Cannot find a base object called ", string);
            return;
        }
        domain.deleteRefinement(refinement);
    }

    private Refinement getReferredObject(Domain domain, String string, String string2) throws DomainReferenceException {
        String string3 = string == null || string.equals("") ? string2 : string;
        Refinement refinement = domain.getNamedRefinement(string3);
        if (refinement == null) {
            ListOfRefinement listOfRefinement = domain.getRefinements();
            throw new DomainReferenceException("Cannot find Refinement " + string3 + " in domain " + domain.toString() + " with refinements " + IVUtil.namedListToDisplay(listOfRefinement));
        }
        return refinement;
    }

    public void noteChange() {
        if (this.isEmpty() && !this.hasOriginal()) {
            this.uiDomain.removeConstruct(this);
        } else if (this.hasChanged()) {
            this.saveToDomain();
            this.uiDomain.updateConstruct(this);
        }
    }

    public boolean isUndefined() {
        return !(this.name != null && !this.name.equals("") && !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.variableDeclarations != null && !this.variableDeclarations.isEmpty() || this.graph != null || this.comments != null && !this.comments.equals(""));
    }

    public boolean isEmpty() {
        return !(this.name != null && !this.name.equals("") && !this.name.equals("Undefined") && !this.name.equals("undefined") || this.pattern != null && !this.pattern.isEmpty() || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.variableDeclarations != null && !this.variableDeclarations.isEmpty() || this.graph != null || this.comments != null && !this.comments.equals(""));
    }

    public boolean isEmpty(Refinement refinement) {
        if (refinement == null) {
            return true;
        }
        return !(refinement.getName() != null && !refinement.getName().equals("") || refinement.getPattern() != null && !refinement.getPattern().isEmpty() || refinement.getNodes() != null && !refinement.getNodes().isEmpty() || refinement.getOrderings() != null && !refinement.getOrderings().isEmpty() || refinement.getVariableDeclarations() != null && !refinement.getVariableDeclarations().isEmpty() || refinement.getIssues() != null && !refinement.getIssues().isEmpty() || refinement.getComments() != null && !refinement.getComments().equals(""));
    }

    public boolean hasChanged() {
        return this.hasChangedNoDebug((Refinement)this.getBaseObject());
    }

    public List collectChanges(Refinement refinement) {
        return this.collectChanges(refinement, "old");
    }

    public List collectChanges(Refinement refinement, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEmpty(refinement) && this.isEmpty()) {
            return arrayList;
        }
        if (!(!this.isEmpty(refinement) || this.name != null && !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.constraints != null && !this.constraints.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals("") || this.variableDeclarations != null || this.graph != null)) {
            return arrayList;
        }
        if (refinement == null) {
            if (this.isEmpty()) {
                return arrayList;
            }
            arrayList.add("The " + string + " refinement is empty, this panel is not:");
            arrayList.add("  " + this.print());
            return arrayList;
        }
        if (this.nameHasChanged(refinement.getName())) {
            arrayList.add("Name has changed from " + refinement.getName() + " to " + this.getName());
        }
        if (!IVUtil.sameList(this.pattern, refinement.getPattern())) {
            arrayList.add("Pattern has changed from " + refinement.getPattern() + " to " + this.pattern);
        }
        if (!this.sameNodes(this.nodes, refinement.getNodes())) {
            arrayList.add("Nodes have changed from " + IVUtil.printNodes(refinement.getNodes()) + " to " + IVUtil.printNodes(this.nodes));
        }
        if (!IVUtil.sameSet(this.orderings, refinement.getOrderings())) {
            arrayList.add("Orderings have changed from " + IVUtil.printOrderings(refinement.getOrderings()) + " to " + IVUtil.printOrderings(this.orderings));
        }
        if (!IVUtil.sameList(this.constraints, refinement.getConstraints())) {
            arrayList.add("Constraints have changed from " + IVUtil.printConstraints(refinement.getConstraints()) + " to " + IVUtil.printConstraints(this.constraints));
        }
        if (!this.sameIssues(this.issues, refinement.getIssues())) {
            arrayList.add("Issues have changed from " + IVUtil.textRenderPatterns(refinement.getIssues()) + " to " + IVUtil.textRenderPatterns(this.getIssues()));
        }
        if (!IVUtil.sameString(this.comments, refinement.getComments())) {
            arrayList.add("Comments have changed from " + refinement.getComments() + " to " + this.comments);
        }
        if (!IVUtil.sameList(this.variableDeclarations, refinement.getVariableDeclarations())) {
            arrayList.add("Variable declarations have changed from " + IVUtil.printVarDecs(refinement.getVariableDeclarations()) + " to " + IVUtil.printVarDecs(this.getVariableDeclarations()));
        }
        if (!this.sameGraph(this.graph, refinement.getAnnotation("canvasPositionGraph"))) {
            arrayList.add("Graph has changed");
        }
        Debug.noteln("Changes are:", arrayList);
        return arrayList;
    }

    public List collectChanges() {
        return this.collectChanges((Refinement)this.getBaseObject(), "draft");
    }

    public List collectChangesFromOriginal() {
        Refinement refinement = this.getDomain().getNamedRefinement(this.baseReference);
        return this.collectChanges(refinement, "published");
    }

    public boolean hasChangedNoDebug(Refinement refinement) {
        if (!(!this.isEmpty(refinement) || this.name == null || !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.constraints != null && !this.constraints.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals("") || this.variableDeclarations != null || this.graph != null)) {
            return false;
        }
        if (refinement == null) {
            return !this.isEmpty();
        }
        return this.nameHasChanged(refinement.getName()) || !IVUtil.sameList(this.pattern, refinement.getPattern()) || !this.sameNodes(this.nodes, refinement.getNodes()) || !IVUtil.sameSet(this.orderings, refinement.getOrderings()) || !IVUtil.sameList(this.constraints, refinement.getConstraints()) || !this.sameIssues(this.issues, refinement.getIssues()) || !IVUtil.sameString(this.comments, refinement.getComments()) || !IVUtil.sameList(this.variableDeclarations, refinement.getVariableDeclarations()) || !this.sameGraph(this.graph, refinement.getAnnotation("canvasPositionGraph"));
    }

    public boolean hasChanged(Refinement refinement) {
        Debug.noteln("UIR: Checking hasChanged for ", this.print());
        if (this.isEmpty(refinement)) {
            Debug.noteln(" against an empty one");
        } else {
            Debug.noteln(" against", refinement.toString());
        }
        if (this.isEmpty(refinement) && this.isEmpty()) {
            Debug.noteln(" -no change");
            return false;
        }
        if (!(!this.isEmpty(refinement) || this.name == null || !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.constraints != null && !this.constraints.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals("") || this.variableDeclarations != null || this.graph != null)) {
            Debug.noteln("Empty sub-node editing - no change");
            return false;
        }
        if (refinement == null) {
            Debug.noteln("UIR hasChanged from null original");
            return !this.isEmpty();
        }
        if (!this.nameHasChanged(refinement.getName())) {
            if (IVUtil.sameList(this.pattern, refinement.getPattern())) {
                if (this.sameNodes(this.nodes, refinement.getNodes())) {
                    if (IVUtil.sameSet(this.orderings, refinement.getOrderings())) {
                        if (IVUtil.sameList(this.constraints, refinement.getConstraints())) {
                            if (this.sameIssues(this.issues, refinement.getIssues())) {
                                if (IVUtil.sameString(this.comments, refinement.getComments())) {
                                    if (IVUtil.sameList(this.variableDeclarations, refinement.getVariableDeclarations())) {
                                        if (this.sameGraph(this.graph, refinement.getAnnotation("canvasPositionGraph"))) {
                                            Debug.noteln("***No Change");
                                            return false;
                                        }
                                        Debug.noteln("UIR hasChanged graph");
                                    } else {
                                        Debug.noteln("UIR hasChanged variable declarations");
                                    }
                                } else {
                                    Debug.noteln("UIR hasChanged comments");
                                }
                            } else {
                                Debug.noteln("UIR hasChanged issues");
                            }
                        } else {
                            Debug.noteln("UIR hasChanged constraints");
                        }
                    } else {
                        Debug.noteln("UIR hasChanged orderings");
                    }
                } else {
                    Debug.noteln("UIR hasChanged nodes");
                }
            } else {
                Debug.noteln("UIR hasChanged pattern");
            }
        } else {
            Debug.noteln("UIR hasChanged name from", refinement.getName());
        }
        Debug.noteln(" - no change");
        return true;
    }

    public boolean hasChangedFromOriginal() {
        if (!this.hasOriginal()) {
            return true;
        }
        Refinement refinement = this.getDomain().getNamedRefinement(this.baseReference);
        return this.hasChangedNoDebug(refinement);
    }

    public boolean nameHasChanged(Object object) {
        String string = (String)object;
        return (this.name != null && !this.name.equals("") || string != null && !string.equals("")) && (this.name == null || !this.name.equals(string));
    }

    public boolean sameValue(String string, Object object, Object object2) {
        if (string == null) {
            return false;
        }
        if (object == null) {
            return UIUtil.isEmptyThing(object2);
        }
        if (object2 == null) {
            return false;
        }
        if (string.equals("name") || string.equals("comments")) {
            return object.equals(object2);
        }
        if (string.equals("nodes")) {
            return this.sameNodes((List)object, (List)object2);
        }
        if (string.equals("constraints") || string.equals("conditions") || string.equals("variableDeclarations")) {
            return IVUtil.sameSet((Collection)object, (Collection)object2);
        }
        if (string.equals("orderings")) {
            return this.sameOrderings(object, object2);
        }
        if (string.equals("issues")) {
            return this.sameIssues((List)object, (List)object2);
        }
        if (string.equals("pattern")) {
            return IVUtil.sameList((List)object, (List)object2);
        }
        return false;
    }

    public boolean setValue(String string, Object object) {
        if (string == null) {
            return false;
        }
        try {
            if (string.equals("name")) {
                this.setName((String)object);
            } else if (string.equals("comments")) {
                this.setComments((String)object);
            } else if (string.equals("nodes")) {
                this.updateNodes((List)object);
            } else if (string.equals("orderings")) {
                this.setOrderings((List)object);
            } else if (string.equals("issues")) {
                this.setIssues((List)object);
            } else if (string.equals("pattern")) {
                this.setPattern((LList)object);
            } else if (string.equals("constraints")) {
                this.setConstraints((List)object);
            } else if (string.equals("miniConstraints")) {
                this.setOrderingType((String)object);
            } else if (string.equals("conditions")) {
                this.setConditions((List)object);
            } else if (string.equals("variableDeclarations")) {
                this.setVariableDeclarations((List)object);
            } else {
                Debug.noteln("UIRefinement cannot set value for field", string);
                if (object != null) {
                    Debug.noteln(" value class is", object.getClass());
                }
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Debug.describeException(exception);
            return false;
        }
    }

    public void checkConsistency() {
        Refinement refinement = new Refinement();
        this.saveToDomain(refinement);
        refinement.checkConsistency();
    }

    public static List parseNodes(UIDomain uIDomain, String string) {
        ArrayList<UINodeSpec> arrayList = new ArrayList<UINodeSpec>();
        long l = 1L;
        while (!string.equals("")) {
            String[] stringArray = UIUtil.breakStringAtFirst(string, "\n");
            Long l2 = new Long(l);
            LList lList = Lisp.elementsFromString(stringArray[0]);
            if (!lList.isNull()) {
                arrayList.add(new UINodeSpec(uIDomain, l2, lList));
                ++l;
            }
            string = stringArray[1];
        }
        return arrayList;
    }

    public static List parseIssues(UIDomain uIDomain, String string) {
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        long l = 1L;
        while (!string.equals("")) {
            String[] stringArray = UIUtil.breakStringAtFirst(string, "\n");
            LList lList = Lisp.elementsFromString(stringArray[0]);
            if (!lList.isNull()) {
                Issue issue = new Issue(lList);
                arrayList.add(issue);
            }
            string = stringArray[1];
        }
        return arrayList;
    }

    public void deleteNode(NodeSpec nodeSpec) {
        this.deleteNodeConstraints(nodeSpec);
        ArrayList arrayList = new ArrayList(this.nodes);
        arrayList.remove(nodeSpec);
        this.setNodes(arrayList);
    }

    protected void deleteNodeConstraints(NodeSpec nodeSpec) {
        Name name = nodeSpec.getId();
        ArrayList<Ordering> arrayList = new ArrayList<Ordering>();
        for (Ordering ordering : this.orderings) {
            if (UIRefinement.constraintMentionsNode(ordering, name)) continue;
            arrayList.add(ordering);
        }
        this.setOrderings(arrayList);
    }

    public boolean matchesPattern(LList lList) {
        if (lList == null && this.getPattern() == null || lList.equal(this.getPattern()) || lList.equals(this.getPattern())) {
            return true;
        }
        return null != SimpleMatcher.match(lList, this.getPattern());
    }

    public NodeSpec findNode(Name name) {
        for (NodeSpec nodeSpec : this.nodes) {
            if (!name.equals(nodeSpec.getId())) continue;
            return nodeSpec;
        }
        return null;
    }

    public NodeSpec findNode(LList lList) {
        for (NodeSpec nodeSpec : this.nodes) {
            if (!lList.equals(nodeSpec.getPattern())) continue;
            return nodeSpec;
        }
        return null;
    }

    public NodeSpec findNode(List list, LList lList) {
        for (NodeSpec nodeSpec : list) {
            if (!lList.equals(nodeSpec.getPattern())) continue;
            return nodeSpec;
        }
        return null;
    }

    public static NodeSpec findEditedNode(List list, LList lList) {
        if (list == null) {
            return null;
        }
        for (NodeSpec nodeSpec : list) {
            if (!UIRefinement.similarPattern(lList, nodeSpec.getPattern())) continue;
            return nodeSpec;
        }
        return null;
    }

    public static boolean similarPattern(LList lList, LList lList2) {
        String string;
        String string2 = lList.toString();
        if (string2 == (string = lList2.toString())) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string2.matches(string)) {
            return true;
        }
        return string2.equalsIgnoreCase(string);
    }

    public static boolean constraintMentionsNode(Constraint constraint, Name name) {
        Debug.noteln("*****UIRef: cannot see whether constraint mentions node");
        return false;
    }

    public static boolean constraintMentionsNode(Ordering ordering, Name name) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        if (nodeEndRef != null && name.equals(nodeEndRef.getNode())) {
            return true;
        }
        nodeEndRef = ordering.getTo();
        return nodeEndRef != null && name.equals(nodeEndRef.getNode());
    }

    public Name getNewNodeId() {
        Name name = this.getHighestNodeId();
        Integer n = new Integer(name.toString());
        int n2 = n;
        return Name.valueOf("" + ++n2);
    }

    public Name getHighestNodeId() {
        return UIRefinement.getHighestNodeId(this.getNodes());
    }

    public static Name getHighestNodeId(List list) {
        Integer n = new Integer(0);
        Name name = Name.valueOf(n.toString());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Name name2 = ((NodeSpec)iterator.next()).getId();
            try {
                Integer n2 = new Integer(name2.toString());
                int n3 = n.compareTo(n2);
                if (n3 > 0) continue;
                name = name2;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return name;
    }

    public void addNode(NodeSpec nodeSpec) {
        ArrayList<NodeSpec> arrayList = new ArrayList<NodeSpec>(this.nodes);
        arrayList.add(nodeSpec);
        this.setNodes(arrayList);
    }

    public void addIssue(Issue issue) {
        ArrayList<Issue> arrayList = new ArrayList<Issue>(this.issues);
        arrayList.add(issue);
        this.setIssues(arrayList);
    }

    public void addConstraint(Object object) throws ConstraintTypeException {
        Object var2_2 = null;
        if (object instanceof Constraint) {
            ArrayList<Constraint> arrayList = new ArrayList<Constraint>(this.getConstraints());
            arrayList.add((Constraint)object);
            this.setConstraints(arrayList);
        } else if (object instanceof Ordering) {
            this.addOrdering((Constraint)object);
        } else {
            String string = "Cannot recognise this as a constraint: \n" + object.toString();
            throw new ConstraintTypeException(string);
        }
    }

    public void addOrdering(Constraint constraint) {
        ArrayList arrayList = new ArrayList(this.orderings);
        this.orderings.add(constraint);
        this.fireDataChange("orderings", arrayList, this.orderings);
    }

    public void addOrdering(Ordering ordering) {
        ArrayList arrayList = new ArrayList(this.orderings);
        this.orderings.add(ordering);
        this.fireDataChange("orderings", arrayList, this.orderings);
    }

    public String getOrderingType() {
        if (this.nodes == null || this.nodes.size() < 2) {
            return "none";
        }
        if (this.orderings == null || this.orderings.isEmpty()) {
            return "parallel";
        }
        if (this.orderingsAreSequential()) {
            return "sequential";
        }
        return "other";
    }

    public String getOrderingType(Collection collection) {
        if (this.nodes == null || this.nodes.size() < 2) {
            return "none";
        }
        if (collection == null || collection.isEmpty()) {
            return "parallel";
        }
        if (this.orderingsAreSequential(collection)) {
            return "sequential";
        }
        return "other";
    }

    public void setOrderingType(String string) {
        String string2 = this.getOrderingType();
        if ("other".equals(string2)) {
            if (!string2.equals(string)) {
                Debug.warn("I-DE: Cannot change complex orderings in the minimal view.");
            }
            return;
        }
        if ("none".equals(string) || "parallel".equals(string)) {
            this.clearOrderings();
        } else if ("sequential".equals(string)) {
            this.setOrderings(this.makeSequence());
        } else {
            Debug.noteln("UIR: cannot recognise simple ordering:", string);
        }
    }

    public boolean orderingsAreSequential() {
        HashSet hashSet = new HashSet(this.makeSequence());
        return new HashSet(this.orderings).equals(hashSet);
    }

    public boolean orderingsAreSequential(Collection collection) {
        HashSet hashSet = new HashSet(this.makeSequence());
        return new HashSet(collection).equals(hashSet);
    }

    public List makeSequence() {
        List list = this.getNodes();
        Iterator iterator = list.iterator();
        NodeSpec nodeSpec = null;
        NodeSpec nodeSpec2 = null;
        ArrayList<Ordering> arrayList = new ArrayList<Ordering>();
        while (iterator.hasNext()) {
            nodeSpec2 = (NodeSpec)iterator.next();
            if (nodeSpec != null) {
                Ordering ordering = new Ordering(new NodeEndRef(End.END, nodeSpec.getId()), new NodeEndRef(End.BEGIN, nodeSpec2.getId()));
                arrayList.add(ordering);
            }
            nodeSpec = nodeSpec2;
        }
        return arrayList;
    }

    public static boolean isRef(NodeSpec nodeSpec, Object object) {
        if (nodeSpec.equals(object) || nodeSpec.getId().toString().equals(object.toString()) || nodeSpec.getPattern().toString().equals(object.toString())) {
            return true;
        }
        if (object instanceof NodeSpec && nodeSpec.getId().equals(((NodeSpec)object).getId()) && nodeSpec.getPattern().equals(((NodeSpec)object).getPattern())) {
            return true;
        }
        return object instanceof NodeEndRef && UIRefinement.isRef(nodeSpec, ((NodeEndRef)object).getNode());
    }

    public String print() {
        String string = this.name + " " + this.pattern.toString();
        String string2 = IVUtil.printNodes(this.nodes);
        String string3 = IVUtil.printOrderings(this.orderings);
        List list = this.getVariableDeclarations();
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        String string4 = IVUtil.printVarDecs(list);
        return "Refinement: " + string + "\n" + "  Nodes: " + string2 + "\n" + "  Orderings: " + string3 + "\n" + "  " + n + " Variable Declarations: " + string4;
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.add(dataChangeListener);
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.remove(dataChangeListener);
    }

    private void fireDataChange(String string, Object object, Object object2) {
        if (this.sameValue(string, object, object2)) {
            return;
        }
        if (string.equals("nodes")) {
            this.updateOrderings();
        }
        if (!this.initing) {
            this.uiDomain.updateConstruct(this);
        }
        for (DataChangeListener dataChangeListener : this.dataChangeListeners) {
            dataChangeListener.dataChanged(this, string, object, object2);
        }
    }

    public void setGraph(IGraph iGraph) {
        IGraph iGraph2 = this.graph;
        this.graph = iGraph;
        this.fireDataChange("graph", iGraph2, this.graph);
    }

    public IGraph getGraph() {
        return this.graph;
    }

    public void removeGraph(IGraph iGraph) {
        this.setGraph(null);
    }

    public void setAutoPoints(List list) {
        this.autoPoints = list;
    }

    public Enumeration children() {
        return new Enumeration(){
            int i;
            {
                this.i = UIRefinement.this.nodes.size() - 1;
            }

            public boolean hasMoreElements() {
                return this.i >= 0;
            }

            public Object nextElement() {
                return UIRefinement.this.nodes.get(this.i--);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        if (this.getNodes() == null) {
            return 0;
        }
        return this.getNodes().size();
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public class ConstraintTypeException
    extends Exception {
        public ConstraintTypeException() {
        }

        public ConstraintTypeException(String string) {
            super(string);
        }
    }

    public class NodeTypeException
    extends Exception {
        public NodeTypeException() {
        }

        public NodeTypeException(String string) {
            super(string);
        }
    }
}

