/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.Annotations;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfObjectProperty;
import ix.icore.domain.ListOfObjectClass;
import ix.icore.domain.ListOfObjectProperty;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.iface.ui.EditableObject;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.tree.IXNode;
import ix.iface.ui.util.UIUtil;
import ix.iview.domain.DomainReferenceException;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.util.IVUtil;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.lisp.LinkedListOfSymbol;
import ix.util.lisp.ListOfSymbol;
import ix.util.lisp.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class UIObjectClass
extends AbstractAnnotatedObject
implements Named,
EditableObject,
UIObject,
IXNode,
TreeNode {
    private Symbol oldName;
    public Symbol name;
    public ListOfSymbol superClassNames = new LinkedListOfSymbol();
    public ListOfSymbol subClassNames = new LinkedListOfSymbol();
    public ListOfObjectProperty objectProperties = new LinkedListOfObjectProperty();
    public Annotations annotations;
    protected UIDomain uiDomain;
    protected ObjectClass baseObject;
    protected String baseReference = "";
    private HashMap propertyMap = new HashMap();
    private static final int NOFIND = -1;
    HashSet dataChangeListeners = new HashSet();

    public UIObjectClass(UIDomain uIDomain, String string) {
        this(uIDomain, Symbol.intern(string));
    }

    public UIObjectClass(UIDomain uIDomain, Symbol symbol) {
        this.name = symbol;
        this.uiDomain = uIDomain;
    }

    public UIObjectClass(UIDomain uIDomain, ObjectClass objectClass) {
        this.name = Symbol.intern(objectClass.getName());
        this.uiDomain = uIDomain;
        try {
            this.baseObject = (ObjectClass)objectClass.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.baseObject = (ObjectClass)this.makeBaseObject();
        }
        this.baseReference = objectClass.getName();
        this.loadFromDomain();
        uIDomain.addedObject(this, objectClass);
    }

    public UIObjectClass cloneThis() {
        UIObjectClass uIObjectClass;
        try {
            uIObjectClass = (UIObjectClass)this.clone();
            uIObjectClass.baseObject = null;
            uIObjectClass.baseReference = "";
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            uIObjectClass = new UIObjectClass(this.uiDomain, this.getName());
            uIObjectClass.setSuperClassNames(new LinkedListOfSymbol((Collection)this.superClassNames));
            uIObjectClass.setSubClassNames(new LinkedListOfSymbol((Collection)this.subClassNames));
            uIObjectClass.setObjectProperties(new LinkedListOfObjectProperty((Collection)this.objectProperties));
            uIObjectClass.setAnnotations(this.getAnnotations());
        }
        return uIObjectClass;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name.toString();
    }

    public void setName(String string) {
        if (Symbol.intern(string) != this.name) {
            this.uiDomain.changeName(this, string);
        }
    }

    public void setLegalName(String string) {
        Symbol symbol;
        if (Symbol.intern(string) == this.name) {
            return;
        }
        this.oldName = this.name;
        this.name = symbol = Symbol.intern(string);
        this.fireDataChange("name", this.oldName, symbol);
    }

    public List getObjectProperties() {
        return this.objectProperties;
    }

    public List getSuperClassNames() {
        return this.superClassNames;
    }

    public List getSubClassNames() {
        return this.subClassNames;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    public boolean isProperty(String string) {
        Object v = this.propertyMap.get(Symbol.intern(string));
        return v != null;
    }

    public boolean isProperty(ObjectProperty objectProperty) {
        HashSet hashSet = this.getAllProperties();
        if (hashSet == null) {
            return false;
        }
        return hashSet.contains(objectProperty);
    }

    public boolean isOwnProperty(ObjectProperty objectProperty) {
        HashSet hashSet = this.getOwnProperties();
        if (hashSet == null) {
            return false;
        }
        return hashSet.contains(objectProperty);
    }

    public HashSet getOwnProperties() {
        return new HashSet(this.objectProperties);
    }

    public HashSet getAllProperties() {
        HashSet hashSet = new HashSet(this.getOwnProperties());
        HashSet hashSet2 = this.getAncestorProperties();
        if (hashSet2 != null) {
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }

    public HashSet getAncestorProperties() {
        List list = this.getParents();
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashSet hashSet = new HashSet();
        for (Object e : list) {
            HashSet hashSet2;
            UIObjectClass uIObjectClass = null;
            if (e instanceof ObjectClass) {
                uIObjectClass = (UIObjectClass)this.getUIDomain().getUIObject((ObjectClass)e);
            } else if (e instanceof UIObjectClass) {
                uIObjectClass = (UIObjectClass)e;
            }
            if (uIObjectClass == null || (hashSet2 = uIObjectClass.getAllProperties()) == null) continue;
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }

    public boolean setValue(String string, Object object) {
        try {
            if (string == null) {
                return false;
            }
            if (string.equals("name")) {
                this.setName((String)object);
            } else if (string.equals("superClassNames")) {
                this.setSuperClassNames((List)object);
            } else if (string.equals("objectProperties")) {
                this.setObjectProperties((List)object);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return false;
        }
    }

    public boolean sameValue(String string, Object object, Object object2) {
        if (string == null) {
            return false;
        }
        if (object == null) {
            return UIUtil.isEmptyThing(object2);
        }
        if (object2 == null) {
            return false;
        }
        if (string.equals("name")) {
            IVUtil.sameSymbol(object, object2);
        }
        if (string.equals("name") || string.equals("comments") || string.equals("annotations")) {
            return object.equals(object2);
        }
        if (string.equals("superClassNames") || string.equals("objectProperties")) {
            return IVUtil.sameSet((Collection)object, (Collection)object2);
        }
        return false;
    }

    public boolean isEmpty() {
        return !(!this.isUndefined() || this.objectProperties != null && !this.objectProperties.isEmpty() || this.subClassNames != null && !this.subClassNames.isEmpty() || this.annotations != null && !this.annotations.isEmpty());
    }

    public boolean isUndefined() {
        return this.getName() == "" || this.getName().equals("undefined") || this.getName().equals("Undefined");
    }

    public boolean isEmpty(ObjectClass objectClass) {
        return !(objectClass != null && (objectClass.getName() != "" && !objectClass.getName().equals("undefined") && !objectClass.getName().equals("Undefined") || objectClass.getObjectProperties() != null && !objectClass.getObjectProperties().isEmpty() || objectClass.getSuperClassNames() != null && !objectClass.getSuperClassNames().isEmpty() || objectClass.getAnnotations() != null && !objectClass.getAnnotations().isEmpty()));
    }

    public void updateSuperClasses() {
        String string = this.getName();
        List list = this.getSuperClassNames();
        boolean bl = false;
        if (list != null && list.size() != 0) {
            bl = true;
        }
        List list2 = this.uiDomain.getAllObjectClasses();
        for (Object e : list2) {
            UIObjectClass uIObjectClass;
            if (!(e instanceof UIObjectClass) || this.equals(uIObjectClass = (UIObjectClass)e)) continue;
            Symbol symbol = Symbol.intern(uIObjectClass.getName());
            if (bl && !list.contains(symbol)) {
                uIObjectClass.removeChild(string);
            }
            if (!bl || !list.contains(symbol)) continue;
            uIObjectClass.addChild(string);
        }
    }

    public void setSuperClassNames(List list) {
        Object object;
        String string;
        ListOfSymbol listOfSymbol = this.superClassNames;
        Collection collection = Collect.difference(listOfSymbol, list);
        Collection collection2 = Collect.difference(list, listOfSymbol);
        String string2 = this.getName();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            object = this.uiDomain.getNamedObjectClass(string);
            if (object != null && object instanceof UIObjectClass) {
                ((UIObjectClass)object).removeChild(string2);
                continue;
            }
            Debug.noteln("UIOC: temporary missing super class", string);
        }
        if (list == null) {
            this.superClassNames = new LinkedListOfSymbol();
        } else {
            this.superClassNames = new LinkedListOfSymbol((Collection)list);
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                object = this.uiDomain.getNamedObjectClass(string);
                if (object != null && object instanceof UIObjectClass) {
                    ((UIObjectClass)object).addChild(string2);
                    continue;
                }
                Debug.noteln("UIOC: temporary missing super class", string);
            }
        }
        this.fireDataChange("superClassNames", listOfSymbol, list);
    }

    private void addParent(Symbol symbol) {
        if (symbol != null && !this.superClassNames.contains(symbol)) {
            LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol((Collection)this.superClassNames);
            this.superClassNames.add(symbol);
            this.fireDataChange("superClassNames", linkedListOfSymbol, this.superClassNames);
            this.updateSuperClasses();
        }
    }

    private void addParent(String string) {
        if (string == null || !string.equals("")) {
            // empty if block
        }
        this.addParent(Symbol.intern(string));
    }

    public void addParent(IXNode iXNode) {
        if (iXNode != null) {
            this.addParent(Symbol.intern(((Named)((Object)iXNode)).getName()));
        }
    }

    public void addParents(List list) {
        LinkedListOfSymbol linkedListOfSymbol = UIObjectClass.collectClassNames(list);
        LinkedListOfSymbol linkedListOfSymbol2 = new LinkedListOfSymbol((Collection)this.getSuperClassNames());
        linkedListOfSymbol.removeAll(linkedListOfSymbol2);
        linkedListOfSymbol2.addAll(linkedListOfSymbol);
        this.setSuperClassNames(linkedListOfSymbol2);
    }

    public void removeParent(Symbol symbol) {
        if (this.superClassNames.contains(symbol)) {
            LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol((Collection)this.superClassNames);
            this.superClassNames.remove(symbol);
            this.fireDataChange("superClassNames", linkedListOfSymbol, this.superClassNames);
            this.updateSuperClasses();
        }
    }

    public void removeParent(String string) {
        this.removeParent(Symbol.intern(string));
    }

    public void removeParent(IXNode iXNode) {
        this.removeParent(Symbol.intern(((Named)((Object)iXNode)).getName()));
    }

    protected void tidyParents(Symbol symbol, Symbol symbol2) {
        List list = this.getSuperClassNames();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            int n;
            List list2;
            Object object = this.uiDomain.getNamedObjectClass(e.toString());
            if (object == null || (list2 = ((UIObjectClass)object).getSubClassNames()) == null || (n = list2.indexOf(symbol)) == -1) continue;
            list2.set(n, symbol2);
        }
    }

    protected void tidyChildren(Symbol symbol, Symbol symbol2) {
        List list = this.getSubClassNames();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            int n;
            List list2;
            Object object = this.uiDomain.getNamedObjectClass(e.toString());
            if (object == null || (list2 = ((UIObjectClass)object).getSuperClassNames()) == null || (n = list2.indexOf(symbol)) == -1) continue;
            list2.set(n, symbol2);
        }
    }

    public static LinkedListOfSymbol collectClassNames(List list) {
        LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol();
        for (UIObjectClass uIObjectClass : list) {
            if (uIObjectClass == null) continue;
            linkedListOfSymbol.add(Symbol.intern(uIObjectClass.getName()));
        }
        return linkedListOfSymbol;
    }

    public void setSubClassNames(List list) {
        ListOfSymbol listOfSymbol = this.subClassNames;
        this.subClassNames = list == null ? new LinkedListOfSymbol() : new LinkedListOfSymbol((Collection)list);
        this.subClassNames.remove(Symbol.intern(""));
        this.fireDataChange("subClassNames", listOfSymbol, list);
    }

    public void addChild(Symbol symbol) {
        if (!this.subClassNames.contains(symbol) && symbol != null && symbol != Symbol.intern("")) {
            LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol((Collection)this.subClassNames);
            this.subClassNames.add(symbol);
            this.fireDataChange("subClassNames", linkedListOfSymbol, this.subClassNames);
        }
    }

    public void addChild(String string) {
        if (string != null && !string.equals("")) {
            this.addChild(Symbol.intern(string));
        }
    }

    public void addChild(IXNode iXNode) {
        this.addChild(Symbol.intern(((Named)((Object)iXNode)).getName()));
    }

    public void addChildren(List list) {
        LinkedListOfSymbol linkedListOfSymbol = UIObjectClass.collectClassNames(list);
        LinkedListOfSymbol linkedListOfSymbol2 = new LinkedListOfSymbol((Collection)this.getSubClassNames());
        linkedListOfSymbol.removeAll(linkedListOfSymbol2);
        linkedListOfSymbol2.addAll(linkedListOfSymbol);
        this.setSubClassNames(linkedListOfSymbol2);
    }

    public void removeChild(Symbol symbol) {
        if (this.subClassNames.contains(symbol)) {
            LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol((Collection)this.subClassNames);
            this.subClassNames.remove(symbol);
            this.fireDataChange("subClassNames", linkedListOfSymbol, this.subClassNames);
        }
    }

    public void removeChild(String string) {
        this.removeChild(Symbol.intern(string));
    }

    public void removeChild(IXNode iXNode) {
        this.removeChild(Symbol.intern(((Named)((Object)iXNode)).getName()));
    }

    public void setObjectProperties(List list) {
        ListOfObjectProperty listOfObjectProperty = this.objectProperties;
        this.propertyMap.clear();
        if (list == null) {
            this.objectProperties = new LinkedListOfObjectProperty();
        } else {
            this.objectProperties = new LinkedListOfObjectProperty((Collection)list);
            for (ObjectProperty objectProperty : list) {
                this.propertyMap.put(objectProperty.getName(), objectProperty);
            }
        }
        this.fireDataChange("objectProperties", listOfObjectProperty, list);
    }

    public void addProperty(Symbol symbol, ObjectProperty.Syntax syntax) {
        if (symbol == null) {
            return;
        }
        if (this.propertyMap.containsKey(symbol)) {
            this.handlePropertyOverwrite(symbol, syntax, (ObjectProperty)this.propertyMap.get(symbol));
        } else {
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.setName(symbol);
            if (syntax != null) {
                objectProperty.setSyntax(syntax);
            }
            this.addToProps(objectProperty);
        }
    }

    private void addToProps(ObjectProperty objectProperty) {
        LinkedListOfObjectProperty linkedListOfObjectProperty = new LinkedListOfObjectProperty((Collection)this.getObjectProperties());
        this.objectProperties.add(objectProperty);
        this.propertyMap.put(objectProperty.getName(), objectProperty);
        this.fireDataChange("objectProperties", linkedListOfObjectProperty, this.objectProperties);
    }

    public void addProperty(String string, ObjectProperty.Syntax syntax) {
        this.addProperty(Symbol.intern(string), syntax);
    }

    public void addProperty(String string, String string2) {
        this.addProperty(Symbol.intern(string), ObjectProperty.Syntax.valueOf(string2));
    }

    public void addProperty(Symbol symbol) {
        this.addProperty(symbol, null);
    }

    public void addProperty(String string) {
        this.addProperty(Symbol.intern(string));
    }

    public void addProperty(ObjectProperty objectProperty) {
        this.addProperty(objectProperty.getName(), objectProperty.getSyntax());
    }

    public void replaceProperty(ObjectProperty objectProperty, ObjectProperty objectProperty2) {
        LinkedListOfObjectProperty linkedListOfObjectProperty = new LinkedListOfObjectProperty((Collection)this.getObjectProperties());
        int n = this.objectProperties.indexOf(objectProperty);
        this.objectProperties.remove(n);
        this.objectProperties.add(n, objectProperty2);
        this.propertyMap.remove(objectProperty.getName());
        this.propertyMap.put(objectProperty2.getName(), objectProperty2);
        this.fireDataChange("objectProperties", linkedListOfObjectProperty, this.objectProperties);
    }

    public void removeProperty(Object object) {
        if (object instanceof ObjectProperty) {
            LinkedListOfObjectProperty linkedListOfObjectProperty = new LinkedListOfObjectProperty((Collection)this.getObjectProperties());
            this.objectProperties.remove(object);
            this.propertyMap.remove(((ObjectProperty)object).getName());
            this.fireDataChange("objectProperties", linkedListOfObjectProperty, this.objectProperties);
        } else {
            UIUtil.notImplemented(null, "UIObjectClass: Removing properties");
        }
    }

    private boolean isLoading() {
        return this.getUIDomain().isLoading();
    }

    private void handlePropertyOverwrite(Symbol symbol, ObjectProperty.Syntax syntax, ObjectProperty objectProperty) {
        String string = "There already is a property " + symbol.toString();
        ObjectProperty.Syntax syntax2 = objectProperty.getSyntax();
        if (IVUtil.sameObject(syntax, syntax2)) {
            if (!this.isLoading()) {
                String[] stringArray = new String[]{string + " [" + syntax.toString() + "]", "Nothing done."};
                JOptionPane.showMessageDialog(null, stringArray);
            }
        } else {
            String[] stringArray;
            Object[] objectArray;
            int n = 0;
            if (!this.isLoading()) {
                objectArray = new Object[]{"Replace", "Change Name", "Cancel"};
                stringArray = new String[]{string + " Do you want to", "Replace the existing property?", "Change the name of the new property?", "Cancel, i.e. ignore the new property and keep the exitsting one?"};
                n = JOptionPane.showOptionDialog(null, stringArray, "WARNING: Name clash", -1, 2, null, objectArray, objectArray[0]);
            }
            if (n == 0) {
                objectArray = new ObjectProperty();
                objectArray.setName(symbol);
                objectArray.setSyntax(syntax);
                this.replaceProperty(objectProperty, (ObjectProperty)objectArray);
            } else if (n == 1 && (stringArray = JOptionPane.showInputDialog(objectArray = "Please enter the new name of the property")) != null) {
                this.addProperty((String)stringArray, syntax);
            }
        }
    }

    public Domain getDomain() {
        return this.uiDomain.getDomain();
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public void moveToUIDomain(UIDomain uIDomain) {
        if (this.uiDomain == null) {
            this.uiDomain = uIDomain;
        } else {
            this.uiDomain = uIDomain;
            uIDomain.addedObject(this, this.getBaseObject());
        }
    }

    public Object getBaseReference() {
        return this.baseReference;
    }

    public void setBaseReference(Object object) {
        this.baseReference = (String)object;
    }

    public IXObject getBaseObject() {
        return this.baseObject;
    }

    public IXObject makeBaseObject() {
        ObjectClass objectClass = new ObjectClass();
        objectClass.setName(this.name.toString());
        return objectClass;
    }

    public void setBaseObject(IXObject iXObject) {
        this.baseObject = (ObjectClass)iXObject;
        this.baseReference = this.baseObject.getName();
    }

    public Class getBaseClass() {
        return ObjectClass.class;
    }

    public boolean hasOriginal() {
        return this.getBaseReference() != null && !this.getBaseReference().equals("");
    }

    public void saveToDomain() {
        if (this.baseObject == null) {
            this.baseObject = (ObjectClass)this.makeBaseObject();
        }
        this.saveToDomain(this.baseObject);
        this.oldName = this.name;
    }

    public void saveToDomain(Object object) {
        ObjectClass objectClass = (ObjectClass)object;
        objectClass.setName(this.getName());
        objectClass.setSuperClassNames(this.superClassNames);
        objectClass.setObjectProperties(this.objectProperties);
        objectClass.setAnnotations(this.getAnnotations());
    }

    public void addToDomain() {
        this.addToDomain(this.getDomain());
    }

    public void addToDomain(Domain domain) {
        if (this.baseObject == null) {
            this.baseObject = (ObjectClass)this.makeBaseObject();
        }
        this.saveToDomain();
        String string = this.baseObject.getName();
        ObjectClass objectClass = domain.getNamedObjectClass(string);
        if (objectClass != null) {
            if (this.baseObject.equals(objectClass)) {
                return;
            }
            Debug.noteln("UIOC: Trying to add object class that is already there");
            this.saveToDomain(objectClass);
            return;
        }
        domain.addObjectClass(this.baseObject);
    }

    public void updateInDomain(Domain domain) throws DomainReferenceException {
        String string = (String)this.getBaseReference();
        ObjectClass objectClass = this.getReferredObject(domain, string, this.getName());
        if (objectClass == null) {
            Debug.noteln("UIOC -Update object class: cannot find base object", string);
            Debug.noteln(" Domain is", domain);
            return;
        }
        if (this.isEmpty()) {
            domain.deleteNamedObjectClass(objectClass.getName());
        } else {
            this.saveToDomain();
            domain.replaceObjectClass(objectClass, this.baseObject);
        }
    }

    public void loadFromDomain() {
        if (this.baseObject == null) {
            this.baseObject = (ObjectClass)this.makeBaseObject();
        }
        this.name = Symbol.intern(this.baseObject.getName());
        this.setSuperClassNames(this.baseObject.getSuperClassNames());
        this.updateSuperClasses();
        this.setObjectProperties(this.baseObject.getObjectProperties());
        this.setAnnotations(this.baseObject.getAnnotations());
        this.fireDataChange("all", null, null);
    }

    public void loadFromDomain(Object object) {
        this.baseObject = (ObjectClass)object;
        this.loadFromDomain();
    }

    public void removeFromDomain() throws DomainReferenceException {
        this.removeFromDomain(this.getDomain());
    }

    public void removeFromDomain(Domain domain) throws DomainReferenceException {
        String string = (String)this.getBaseReference();
        ObjectClass objectClass = this.getReferredObject(domain, string, this.getName());
        if (objectClass == null) {
            Debug.noteln("Remove ObjectClass: Cannot find base object called ", string);
            return;
        }
        domain.deleteObjectClass(objectClass);
    }

    private ObjectClass getReferredObject(Domain domain, String string, String string2) throws DomainReferenceException {
        String string3 = string == null || string.equals("") ? string2 : string;
        ObjectClass objectClass = domain.getNamedObjectClass(string3);
        if (objectClass == null) {
            ListOfObjectClass listOfObjectClass = domain.getObjectClasses();
            if ((listOfObjectClass == null || listOfObjectClass.isEmpty()) && "Root".equals(string2)) {
                return null;
            }
            throw new DomainReferenceException("Cannot find object Class " + string3 + " in domain " + domain.toString() + " with classes " + IVUtil.namedListToDisplay(listOfObjectClass));
        }
        return objectClass;
    }

    public IXObject getOriginal() {
        Object object = this.getBaseReference();
        return this.getDomain().getNamedObjectClass((String)object);
    }

    public void loadFromOriginal() {
        if (this.hasOriginal()) {
            ObjectClass objectClass = (ObjectClass)this.getOriginal();
            try {
                this.setBaseObject((ObjectClass)objectClass.clone());
                this.loadFromDomain();
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                Debug.noteln("Continuing with new object as the original");
                this.setBaseObject(this.makeBaseObject());
                this.loadFromDomain();
            }
        } else {
            this.setBaseObject(this.makeBaseObject());
            this.loadFromDomain();
        }
    }

    public void noteChange() {
        if (this.isEmpty() && !this.hasOriginal()) {
            this.uiDomain.removeConstruct(this);
        } else if (this.oldName != null && this.nameHasChanged(this.oldName.toString())) {
            this.tidyParents(this.oldName, this.name);
            this.tidyChildren(this.oldName, this.name);
            this.oldName = this.name;
            this.saveToDomain();
            this.uiDomain.updateConstruct(this);
        } else if (this.hasChanged()) {
            this.saveToDomain();
            this.uiDomain.updateConstruct(this);
        }
    }

    public boolean hasChanged() {
        return this.hasChanged((ObjectClass)this.getBaseObject());
    }

    public boolean hasChanged(ObjectClass objectClass) {
        List list = this.collectChanges(objectClass);
        return list != null && !list.isEmpty();
    }

    public boolean hasChangedFromOriginal() {
        if (!this.hasOriginal()) {
            return true;
        }
        return this.hasChanged((ObjectClass)this.getOriginal());
    }

    public List collectChanges() {
        return this.collectChanges((ObjectClass)this.getBaseObject(), "draft");
    }

    public List collectChangesFromOriginal() {
        return this.collectChanges((ObjectClass)this.getOriginal(), "published");
    }

    public List collectChanges(ObjectClass objectClass) {
        return this.collectChanges(objectClass, "old");
    }

    public List collectChanges(ObjectClass objectClass, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEmpty(objectClass) && this.isEmpty()) {
            return arrayList;
        }
        if (this.isEmpty(objectClass) && (this.getName() == null || this.getName().equals("Undefined") || this.getName().equals("undefined")) && (this.objectProperties == null || this.objectProperties.isEmpty())) {
            return arrayList;
        }
        if (objectClass == null) {
            if (this.isEmpty()) {
                return arrayList;
            }
            arrayList.add("The " + string + " ObjectClass is empty, this panel is not:");
            arrayList.add("  " + this.print());
            return arrayList;
        }
        if (this.nameHasChanged(objectClass.getName())) {
            arrayList.add("Name has changed from " + objectClass.getName() + " to " + this.getName());
        }
        if (!IVUtil.sameSet(this.superClassNames, objectClass.getSuperClassNames())) {
            arrayList.add("Parent set has changed from " + UIUtil.show(objectClass.getSuperClassNames()) + " to " + UIUtil.show(this.superClassNames));
        }
        if (!IVUtil.sameSet(this.objectProperties, objectClass.getObjectProperties())) {
            arrayList.add("Properties have changed from " + UIUtil.show(objectClass.getObjectProperties()) + " to " + UIUtil.show(this.objectProperties));
        }
        if (!IVUtil.sameStableMap(this.getAnnotations(), objectClass.getAnnotations())) {
            arrayList.add("Annotations have changed from " + objectClass.getAnnotations().entrySet() + " to " + this.getAnnotations().entrySet());
        }
        return arrayList;
    }

    public boolean nameHasChanged(Object object) {
        String string;
        if (object == null) {
            return this.getName() == null || this.getName().equals("");
        }
        try {
            string = (String)object;
        }
        catch (Exception exception) {
            try {
                string = object.toString();
            }
            catch (Exception exception2) {
                string = "";
            }
        }
        return (this.getName() != null && !this.getName().equals("") || string != null && !string.equals("")) && (this.getName() == null || !this.getName().equals(string));
    }

    public String toString() {
        return this.getName();
    }

    public String superString() {
        return super.toString();
    }

    public String print() {
        return "ObjectClass: " + this.getName() + "\n" + " SuperClassNames: " + UIUtil.show(this.superClassNames) + "\n" + " SubClassNames: " + UIUtil.show(this.subClassNames) + "\n" + " ObjectProperties: " + UIUtil.show(this.objectProperties);
    }

    public Enumeration children() {
        this.subClassNames.remove(null);
        this.subClassNames.remove("");
        return new Enumeration(){
            int i;
            {
                this.i = UIObjectClass.this.subClassNames.size() - 1;
            }

            public boolean hasMoreElements() {
                return this.i >= 0;
            }

            public Object nextElement() {
                String string = UIObjectClass.this.subClassNames.get(this.i).toString();
                --this.i;
                Object object = null;
                if (string != "") {
                    object = UIObjectClass.this.uiDomain.getNamedObjectClass(string);
                }
                return object;
            }
        };
    }

    public List getChildren() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.subClassNames.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.uiDomain.getNamedObjectClass(iterator.next().toString()));
        }
        return arrayList;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        Object e = this.getSubClassNames().get(n);
        return (TreeNode)this.uiDomain.getNamedObjectClass(e.toString());
    }

    public int getChildCount() {
        if (this.getSubClassNames() == null) {
            return 0;
        }
        return this.getSubClassNames().size();
    }

    public int getIndex(TreeNode treeNode) {
        if (treeNode instanceof UIObjectClass) {
            List list = this.getSubClassNames();
            if (list == null) {
                return -1;
            }
            return list.indexOf(Symbol.intern(((Named)((Object)treeNode)).getName()));
        }
        return -1;
    }

    public TreeNode getParent() {
        List list = this.getSuperClassNames();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object e : list) {
            if (!(e instanceof TreeNode)) continue;
            return (TreeNode)e;
        }
        return null;
    }

    public List getParents() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.getSuperClassNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.uiDomain.getNamedObjectClass(iterator.next().toString()));
        }
        return arrayList;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean checkLegalParent(UIObjectClass uIObjectClass) {
        return uIObjectClass != null && !this.isNodeAncestor(uIObjectClass) && !uIObjectClass.isNodeAncestor(this);
    }

    public String reportLegalParent(UIObjectClass uIObjectClass) {
        String string = "";
        if (uIObjectClass == null) {
            string = "null is not a legal parent for " + this.toString();
        } else {
            if (uIObjectClass.isParentOf(this)) {
                return string;
            }
            if (this.isNodeAncestor(uIObjectClass)) {
                string = uIObjectClass.toString() + " is not a legal parent of " + this.toString() + " because it is already an ancestor";
            } else if (uIObjectClass.isNodeAncestor(this)) {
                string = uIObjectClass.toString() + " is not a legal parent of " + this.toString() + " because it is a descendant";
            }
        }
        return string;
    }

    public String reportLegalChild(UIObjectClass uIObjectClass) {
        String string = "";
        if (uIObjectClass == null) {
            string = "null is not a legal child for " + this.toString();
        } else {
            if (this.isParentOf(uIObjectClass)) {
                return string;
            }
            if (this.isNodeAncestor(uIObjectClass)) {
                string = uIObjectClass.toString() + " is not a legal child of " + this.toString() + " because it is an ancestor";
            } else if (uIObjectClass.isNodeAncestor(this)) {
                string = uIObjectClass.toString() + " is not a legal child of " + this.toString() + " because it is already a descendant";
            }
        }
        return string;
    }

    public boolean isParentOf(UIObjectClass uIObjectClass) {
        if (uIObjectClass == null) {
            return false;
        }
        List list = uIObjectClass.getParents();
        return list.contains(this);
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (this.equals(treeNode)) {
            return true;
        }
        List list = this.getParents();
        if (list.contains(treeNode)) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!((UIObjectClass)iterator.next()).isNodeAncestor(treeNode)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addDataChangeListener(DataChangeListener dataChangeListener) {
        if (this.dataChangeListeners != null && !this.dataChangeListeners.contains(dataChangeListener)) {
            this.dataChangeListeners.add(dataChangeListener);
        }
    }

    public synchronized void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.remove(dataChangeListener);
    }

    private synchronized void fireDataChange(String string, Object object, Object object2) {
        if (this.sameValue(string, object, object2)) {
            return;
        }
        if (this.dataChangeListeners == null || this.dataChangeListeners.isEmpty()) {
            return;
        }
        for (DataChangeListener dataChangeListener : this.dataChangeListeners) {
            dataChangeListener.dataChanged(this, string, object, object2);
        }
    }
}

