/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.LinkedListOfObjectClass;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.iview.AbstractUISetEditor;
import ix.iview.DomainObjectManager;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.util.LinkedList;
import java.util.List;

public class UIObjectClassSetEditor
extends AbstractUISetEditor {
    boolean doRehooks = false;

    public UIObjectClassSetEditor(DomainObjectManager domainObjectManager, LinkedList linkedList) {
        super(domainObjectManager, linkedList);
        this.label = "object class";
    }

    public void setObjects(LinkedList linkedList) {
        Object object;
        Object object22;
        LinkedList linkedList2 = this.getAllConstructs();
        this.clear();
        this.removed.addAll(linkedList2);
        if (linkedList == null) {
            return;
        }
        for (Object object22 : linkedList) {
            if (!this.isOwnObject(object22)) {
                object = (UIObject)this.makeOwnObject(object22);
                this.addConstruct(object);
                this.originals.put(object22, object);
                continue;
            }
            this.addConstruct((UIObject)object22);
        }
        for (Object object22 : linkedList) {
            object = (UIObjectClass)this.members.get(object22.getName());
            ((UIObjectClass)object).updateSuperClasses();
        }
        LinkedList linkedList3 = this.getAllConstructs();
        if (linkedList3 == null || linkedList3.isEmpty()) {
            return;
        }
        object22 = this.getOriginals();
        if (object22 == null || object22.isEmpty()) {
            return;
        }
        object = linkedList3.iterator();
        while (object.hasNext()) {
            Named named = (Named)object.next();
            if (!this.isOwnObject(named)) {
                this.added.remove(named);
                continue;
            }
            if (this.getOriginal(named) == null) continue;
            this.added.remove(named);
        }
    }

    public void setLegalName(Object object, String string) {
        try {
            ((UIObjectClass)object).setLegalName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOwnObject(Object object) {
        return object instanceof UIObjectClass;
    }

    public boolean sameConstruct(Object object, Object object2) {
        if (object instanceof ObjectClass && object2 instanceof ObjectClass) {
            ObjectClass objectClass = (ObjectClass)object;
            ObjectClass objectClass2 = (ObjectClass)object2;
            return objectClass.getName().equals(objectClass2.getName()) && objectClass.getObjectProperties().equals(objectClass2.getObjectProperties()) && objectClass.getSuperClassNames().equals(objectClass2.getSuperClassNames()) && objectClass.getAnnotations().equals(objectClass2.getAnnotations());
        }
        return false;
    }

    private void handleOrphan(UIObjectClass uIObjectClass) {
        List list = uIObjectClass.getParents();
        if (list == null || list.size() == 0) {
            Debug.noteln(" ****ClassSetEd:found orphan, cannot deal with this yet:", uIObjectClass);
        }
    }

    public void removeConstruct(Named named) {
        UIObjectClass uIObjectClass = (UIObjectClass)named;
        List list = uIObjectClass.getChildren();
        List list2 = uIObjectClass.getParents();
        Symbol symbol = Symbol.intern(named.getName());
        if (list != null) {
            for (UIObjectClass uIObjectClass2 : list) {
                if (uIObjectClass2 == null) continue;
                uIObjectClass2.removeParent(symbol);
                if (this.doRehooks) {
                    uIObjectClass2.addParents(list2);
                }
                this.handleOrphan(uIObjectClass2);
            }
        }
        if (list2 != null) {
            for (UIObjectClass uIObjectClass2 : list2) {
                if (uIObjectClass2 == null) continue;
                uIObjectClass2.removeChild(symbol);
                if (!this.doRehooks) continue;
                uIObjectClass2.addChildren(list);
            }
        }
        super.removeConstruct(named);
    }

    public Object makeOwnObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ObjectClass) {
            return new UIObjectClass(((DomainObjectManager)this.manager).getUIDomain(), (ObjectClass)object);
        }
        Debug.noteln("WARNING - UIOCE: cannot make own object from", object);
        return null;
    }

    public LinkedList makeOriginalList() {
        return new LinkedListOfObjectClass();
    }

    public Named getStringOriginal(String string) {
        ObjectClass objectClass = null;
        if (this.getDomain() != null) {
            objectClass = this.getDomain().getNamedObjectClass(string);
        }
        return objectClass;
    }

    public void fireConstructAdded(UIObject uIObject) {
        ((UIObjectClass)uIObject).updateSuperClasses();
        super.fireConstructAdded(uIObject);
    }

    public void fireConstructEdited(UIObject uIObject) {
        super.fireConstructEdited(uIObject);
    }

    public void fireConstructRemoved(Object object) {
        if (object instanceof UIObjectClass) {
            super.fireConstructRemoved((UIObject)object);
        }
    }
}

