/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.ToggleEditorPanel;
import ix.iface.ui.table.IXTable;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstraintEditor;
import ix.iview.PropertyConstraintsListener;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.table.PropertyTableModel;
import ix.iview.tree.ObjectClassTreeNode;
import ix.iview.util.IVUtil;
import ix.iview.util.NodeNameRenderer;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;

public class ObjectConstraintEditor
extends ConstraintEditor
implements ListSelectionListener,
MouseListener,
PropertyConstraintsListener {
    protected ListEditorPanel varNameEd;
    protected ListEditorPanel classEd;
    protected ListEditorPanel propConstraintEd;
    protected ToggleEditorPanel propModePan;
    private PropertyTableModel tableModel;
    private JComboBox vasBox;
    protected UIDomain uiDomain;
    protected UIObjectClass objectClass;
    private List oldConstraints;
    protected Constraint typeConstraint;
    protected ItemVar variable;
    protected HashMap propertyConstraints = new HashMap();
    protected HashMap varConstraints = new HashMap();
    private int mode = ALL;
    private ObjectClassTreeNode root;
    boolean isAdjusting = false;
    private static int OWN = 1;
    private static int ANCESTOR = 2;
    private static int ALL = 3;

    public ObjectConstraintEditor(Frame frame, UIDomain uIDomain) {
        super(frame, "Object Constraint Editor", "Please specify object constraints");
        this.setDomain(uIDomain);
    }

    public ObjectConstraintEditor(Frame frame, UIRefinement uIRefinement) {
        this(frame, uIRefinement.getUIDomain());
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.makeVarPanel();
        this.makeClassPanel();
        this.makePropModePanel();
        this.makePropPanel();
        if (this.label == null) {
            this.label = new JLabel();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.varNameEd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.classEd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.propConstraintEd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.propModePan, gridBagConstraints);
        return jPanel;
    }

    private ListEditorPanel makeActPanel(JComponent jComponent) {
        ListEditorPanel listEditorPanel = new ListEditorPanel((EventListener)this, "Attach to node", jComponent);
        if (jComponent instanceof JList) {
            ((JList)jComponent).setAutoscrolls(true);
            ((JList)jComponent).setSelectionMode(0);
        }
        listEditorPanel.setRenderer(new NodeNameRenderer(false));
        return listEditorPanel;
    }

    private IXEditorPanel makeVarPanel() {
        Set set = this.getVariables();
        JComboBox<Object> jComboBox = set == null ? new JComboBox() : new JComboBox<Object>(set.toArray());
        jComboBox.setEditable(true);
        this.varNameEd = new ListEditorPanel((EventListener)this, "Variable (e.g. ?x)", jComboBox);
        jComboBox.setSelectedItem(" ");
        PopupMenuListener popupMenuListener = new PopupMenuListener(){
            private final ObjectConstraintEditor oce;
            {
                this.oce = ObjectConstraintEditor.this;
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                this.oce.varNameEd.setData(this.oce.getVariables());
            }
        };
        jComboBox.addPopupMenuListener(popupMenuListener);
        return this.varNameEd;
    }

    private IXEditorPanel makeTextVarPanel() {
        JTextField jTextField = new JTextField();
        jTextField.setText(" ");
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ObjectConstraintEditor.this.updateVariable();
            }
        });
        IVUtil.enableVars(this, jTextField);
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)this, "Variable name", jTextField);
        jTextField.setText("");
        return thingEditorPanel;
    }

    private IXEditorPanel makeClassPanel() {
        List list = this.getObjectClasses();
        JComboBox<Object> jComboBox = list == null ? new JComboBox() : new JComboBox<Object>(list.toArray());
        this.classEd = new ListEditorPanel((EventListener)this, "Type (Object Class)", jComboBox);
        this.updateClassEdSelection();
        return this.classEd;
    }

    private IXEditorPanel makePropPanel() {
        this.tableModel = new PropertyTableModel();
        IXTable iXTable = new IXTable(this.tableModel);
        this.tableModel.adjustTable(iXTable);
        this.propConstraintEd = new ListEditorPanel((EventListener)this, "Property Constraints", iXTable);
        this.tableModel.setObjectClass(this.objectClass);
        this.tableModel.addPropertyConstraintsListener(this);
        return this.propConstraintEd;
    }

    private ToggleEditorPanel makePropModePanel() {
        JCheckBox jCheckBox = new JCheckBox("Own", true);
        JCheckBox jCheckBox2 = new JCheckBox("Ancestors", true);
        jCheckBox.setActionCommand("propMode");
        jCheckBox2.setActionCommand("propMode");
        JToggleButton[] jToggleButtonArray = new JToggleButton[]{jCheckBox, jCheckBox2};
        this.propModePan = new ToggleEditorPanel((EventListener)this, "Show Properties", jToggleButtonArray);
        return this.propModePan;
    }

    protected JComponent getFocusComponent() {
        return this.varNameEd.getItemComponent();
    }

    private Set getVariables() {
        if (this.currentObject == null) {
            return null;
        }
        return ((UIRefinement)this.currentObject).getVariablesUsed();
    }

    public void moreInitFromObject() throws NullPointerException {
    }

    protected void initFromObject() throws NullPointerException {
        this.isAdjusting = true;
        this.moreBut.setEnabled(false);
        this.setPropertyMode(ALL);
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        this.oldConstraints = uIRefinement.getConstraints();
        Debug.noteln("OCE noted old constraints");
        LinkedList<UIRefinement> linkedList = new LinkedList<UIRefinement>(uIRefinement.getNodes());
        linkedList.add(0, uIRefinement);
        this.makeActList(linkedList.toArray());
        this.variable = null;
        this.updateClasses();
        this.isAdjusting = false;
        this.focus();
    }

    protected void setFromObject(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Constraint)) {
            String string = "Condition/Effect editor can only deal with constraints not objects of class " + object.getClass().getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        Constraint constraint = (Constraint)object;
        if (constraint.getType() != Refinement.S_WORLD_STATE) {
            String string = "Condition/Effect editor cannot deal with constraints Of type " + constraint.getType().toString();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        this.propConstraintEd.setSelectedObject(constraint);
    }

    public void setObject(Object object) {
        this.clear();
        if (object instanceof UIObject) {
            this.setDomain(((UIObject)object).getUIDomain());
        }
        super.setObject(object);
    }

    private void setDomain(UIDomain uIDomain) {
        if (this.uiDomain == null || !this.uiDomain.equals(uIDomain)) {
            // empty if block
        }
        this.uiDomain = uIDomain;
        if (this.uiDomain != null) {
            // empty if block
        }
    }

    public void clear() {
        this.variable = null;
        this.varNameEd.removeData();
        this.updateVariable();
    }

    private void updateClasses() {
        List list = this.getObjectClasses();
        list.add("new Class");
        this.classEd.setData(list);
        this.updateClassEdSelection();
    }

    private void updateClassEdSelection() {
        if (this.root != null && this.root.getUserObject() != null) {
            this.classEd.setSelectedObject(this.root.getUserObject());
        } else {
            this.classEd.setSelectedIndex(0);
        }
        Object object = this.classEd.getSelectedObject();
        if (object instanceof UIObjectClass) {
            this.objectClass = (UIObjectClass)object;
        } else {
            this.objectClass = null;
            if (object != null) {
                Debug.noteln("OCE: object class of wrong type:", object.getClass());
            } else {
                Debug.noteln("OCE: object class is", object);
            }
        }
        this.noteType();
        if (this.tableModel != null) {
            this.tableModel.setObjectClass(this.objectClass);
        }
    }

    private void updateProperties() {
        Object object = this.classEd.getSelectedObject();
        if (object instanceof UIObjectClass) {
            this.tableModel.setObjectClass((UIObjectClass)object);
        } else {
            Debug.noteln("Selected object class of type", object.getClass());
        }
    }

    protected void updateVariable() {
        Object object = this.varNameEd.getSelectedObject();
        if (object == null) {
            this.variable = null;
        } else if (object instanceof String) {
            String string = object.toString().trim();
            try {
                this.variable = (ItemVar)Symbol.intern(string);
            }
            catch (Exception exception) {
                this.variable = null;
            }
        } else if (object instanceof ItemVar) {
            this.variable = (ItemVar)object;
        } else {
            Debug.noteln("OCE: problem with variable of class", object.getClass());
            this.variable = null;
        }
        this.loadObjectConstraints(this.variable, (UIRefinement)this.currentObject);
        if (this.tableModel != null) {
            this.tableModel.setConstraints(this.variable, this.objectClass, this.propertyConstraints);
        }
    }

    public void variableConstraintsChanged(ItemVar itemVar, HashMap hashMap) {
        Debug.noteln("OCE: got new constraints for", itemVar);
        Debug.noteln("  :", IVUtil.printConstraints(UIUtil.getFlatValues(hashMap)));
        this.varConstraints.put(itemVar, hashMap);
    }

    public void variableNameChanged(ItemVar itemVar, ItemVar itemVar2) {
        Debug.noteln("OCE: ************Cannot deal with var name change*********");
    }

    public void variableTypeChanged(ItemVar itemVar, UIObjectClass uIObjectClass, UIObjectClass uIObjectClass2) {
        this.objectClass = uIObjectClass2;
        this.classEd.setSelectedObject(this.objectClass);
        this.tableModel.setObjectClass(uIObjectClass2);
    }

    private void updateRefinement() {
        Debug.noteln("OCE: updating refinement");
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        Debug.noteln(" setting constraints");
        Set set = this.varConstraints.keySet();
        if (set != null) {
            for (ItemVar itemVar : set) {
                HashMap hashMap = (HashMap)this.varConstraints.get(itemVar);
                List list = UIUtil.getFlatValues(hashMap);
                uIRefinement.setVariableConstraints(itemVar, list);
            }
        }
    }

    protected void noteType() {
        Constraint constraint = this.makeConstraint(this.variable, this.objectClass, IVUtil.TYPE_STRING_a);
        try {
            if (constraint != null) {
                UIRefinement uIRefinement = (UIRefinement)this.currentObject;
                if (this.typeConstraint != null && uIRefinement != null) {
                    uIRefinement.deleteConstraint(this.typeConstraint);
                }
                uIRefinement.addConstraint(constraint);
                this.typeConstraint = constraint;
                List list = uIRefinement.getVariableConstraints(this.variable);
                this.constraintsToProperty(this.variable, this.objectClass, list);
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    protected Object collectConstraint() {
        this.updateRefinement();
        return null;
    }

    private int getPropertiesMode() {
        try {
            Object object = this.propModePan.getData();
            boolean[] blArray = new boolean[]{false, false};
            if (object instanceof Boolean[]) {
                Boolean[] booleanArray = (Boolean[])object;
                blArray[0] = booleanArray[0];
                blArray[1] = booleanArray[1];
            } else {
                blArray = (boolean[])object;
            }
            int n = 0;
            if (blArray.length == 2) {
                if (blArray[0]) {
                    n += OWN;
                }
                if (blArray[1]) {
                    n += ANCESTOR;
                }
            } else {
                Debug.noteln("ObCE: wrong prop mode data length", blArray.length);
            }
            if (n == 0) {
                return ALL;
            }
            return n;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return ALL;
        }
    }

    private void setPropertyMode(int n) {
        Boolean[] booleanArray = new Boolean[]{new Boolean(false), new Boolean(false)};
        if (n == 1 || n == 3) {
            booleanArray[0] = new Boolean(true);
        }
        if (n == 2 || n == 3) {
            booleanArray[1] = new Boolean(true);
        }
        this.propModePan.setData(booleanArray);
    }

    private void makeActList(Object[] objectArray) {
    }

    protected Constraint makeConstraint(ItemVar itemVar, UIObjectClass uIObjectClass, String string) {
        if (itemVar == null || uIObjectClass == null || string == null || string == "") {
            return null;
        }
        Cons cons = Lisp.list(Symbol.intern(string), itemVar);
        PatternAssignment patternAssignment = new PatternAssignment(cons, uIObjectClass.getName());
        Constraint constraint = new Constraint(Refinement.S_WORLD_STATE, Refinement.S_CONDITION, (List)Lisp.list(patternAssignment));
        return constraint;
    }

    protected void deleteConstraint(ObjectProperty objectProperty, Constraint constraint) {
        Debug.noteln("OCE: deleting constraint", constraint);
        Set set = (Set)this.propertyConstraints.get(objectProperty);
        if (set != null) {
            Debug.noteln(" from", UIUtil.show(set));
            set.remove(constraint);
            if (set.isEmpty()) {
                this.propertyConstraints.remove(objectProperty);
            }
        }
        ((UIRefinement)this.currentObject).deleteConstraint(constraint);
        this.tableModel.setConstraints(this.propertyConstraints);
    }

    private void replaceConstraint(Constraint constraint, Constraint constraint2) {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            uIRefinement.deleteConstraint(constraint);
            uIRefinement.addConstraint(constraint2);
            this.loadObjectConstraints(this.variable, uIRefinement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void constraintsToProperty(ItemVar itemVar, UIObjectClass uIObjectClass, List list) {
        this.propertyConstraints.clear();
        if (itemVar == null || list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ObjectProperty objectProperty;
                Constraint constraint = (Constraint)iterator.next();
                PatternAssignment patternAssignment = constraint.getPatternAssignment();
                if (patternAssignment == null || (objectProperty = IVUtil.propertyFromPattern((List)patternAssignment.getPattern(), uIObjectClass)) == null || !IVUtil.isSubjectInPattern(itemVar, patternAssignment.getPattern())) continue;
                if (IVUtil.isSimplePropertyAssignment(patternAssignment, objectProperty, itemVar)) {
                    this.propertyConstraints = PropertyTableModel.noteProperty(this.propertyConstraints, uIObjectClass, objectProperty, constraint);
                    continue;
                }
                Debug.noteln("OCE: not a simple assignment:", patternAssignment.getPattern());
            }
            catch (Exception exception) {}
        }
    }

    private void loadObjectConstraints(ItemVar itemVar, UIRefinement uIRefinement) {
        if (uIRefinement != null) {
            this.loadObjectConstraints(itemVar, uIRefinement.getVariableConstraints(itemVar));
        }
    }

    private void loadObjectConstraints(ItemVar itemVar, List list) {
        if (this.propertyConstraints != null) {
            this.propertyConstraints.clear();
        }
        this.typeConstraint = null;
        if (itemVar == null) {
            return;
        }
        this.typeConstraint = IVUtil.findClassConstraint(itemVar, list);
        UIObjectClass uIObjectClass = null;
        if (this.typeConstraint == null) {
            if (this.root != null) {
                uIObjectClass = (UIObjectClass)this.root.getUserObject();
            }
        } else {
            UIDomain uIDomain = ((UIRefinement)this.currentObject).getUIDomain();
            Object object = IVUtil.extractType(this.typeConstraint, uIDomain);
            if (object instanceof UIObjectClass) {
                uIObjectClass = (UIObjectClass)object;
            }
        }
        if (uIObjectClass != null) {
            this.objectClass = uIObjectClass;
            this.classEd.setSelectedObject(uIObjectClass);
            this.tableModel.setObjectClass(uIObjectClass);
        }
        this.constraintsToProperty(itemVar, uIObjectClass, list);
    }

    private List getObjectClasses() {
        if (this.uiDomain != null) {
            return this.uiDomain.getObjectClassTree();
        }
        return new LinkedList();
    }

    protected List getObjectProperties() {
        return ObjectConstraintEditor.getObjectProperties(this.mode, this.objectClass);
    }

    protected static List getObjectProperties(int n, UIObjectClass uIObjectClass) {
        if (uIObjectClass == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        if (n == OWN) {
            HashSet hashSet = uIObjectClass.getOwnProperties();
            if (hashSet != null) {
                linkedList.addAll(hashSet);
            }
        } else if (n == ANCESTOR) {
            HashSet hashSet = uIObjectClass.getAncestorProperties();
            if (hashSet != null) {
                linkedList.addAll(hashSet);
            }
        } else {
            HashSet hashSet = uIObjectClass.getAllProperties();
            if (hashSet != null) {
                linkedList.addAll(hashSet);
            }
        }
        return linkedList;
    }

    protected void finishEdits() {
        try {
            JTable jTable = (JTable)this.propConstraintEd.getItemComponent();
            if (jTable.isEditing()) {
                Debug.noteln("OCE: finishing edits");
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                tableCellEditor.stopCellEditing();
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == null) {
            return;
        }
        if (mouseEvent.getSource() == this.okBut) {
            this.finishEdits();
            this.tableModel.noteOldConstraints();
            this.processConstraint();
            this.closeEditor();
            return;
        }
        if (mouseEvent.getSource() == this.cancelBut) {
            if (this.currentObject == null) {
                this.closeEditor();
                return;
            }
            String[] stringArray = new String[]{"Cancelling this editor will set all constraints", "for this refinement back to when you started", "the Object Constraint Editor.", "(NOTE: changes to the ObjectClass specifications", "will NOT be undone.)"};
            int n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm Cancel", 2);
            if (n == 0) {
                ((UIRefinement)this.currentObject).setConstraints(this.oldConstraints);
                this.closeEditor();
                this.clear();
                return;
            }
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    private void cannotChangeAtNode() {
        String string = "Sofar, conditions and effects can only be attached to refinements (i.e. self)";
        JOptionPane.showMessageDialog(this, string);
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        Debug.noteln("OCE: got data change");
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isAdjusting || listSelectionEvent.getSource() == null) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object instanceof AbstractButton && ((AbstractButton)object).getActionCommand().equals("propMode")) {
            this.mode = this.getPropertiesMode();
            this.tableModel.setMode(this.mode);
        } else if (this.classEd != null && listSelectionEvent.getSource().equals(this.classEd.getItemComponent())) {
            this.updateProperties();
            Object object2 = this.classEd.getSelectedObject();
            if (object2 instanceof UIObjectClass) {
                this.objectClass = (UIObjectClass)object2;
                this.noteType();
                this.tableModel.setObjectClass(this.objectClass);
            } else {
                Debug.noteln("OCe: Problem with object class of type", object2.getClass());
            }
        } else if (this.varNameEd != null && listSelectionEvent.getSource().equals(this.varNameEd.getItemComponent())) {
            this.updateVariable();
        }
    }
}

