/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.icore.domain.event.DomainEvent;
import ix.iface.ui.EditableObject;
import ix.iface.ui.JObjectPopup;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.NamedRenderer;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTable;
import ix.iface.ui.util.UIUtil;
import ix.ip2.ObjectView;
import ix.iview.ConditionEffectEditor;
import ix.iview.ConstraintEditor;
import ix.iview.PropertyConstraintsListener;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.table.PropertyTableModel;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DeclarationEditor
extends ConstraintEditor
implements PropertyConstraintsListener,
ListSelectionListener,
UIDomainListener,
DataChangeListener {
    protected VarTypeTableModel varTableMod;
    protected VarListEditor varEd;
    protected JRadioButton any;
    protected JRadioButton given;
    protected JRadioButton none;
    private ButtonGroup group;
    protected JButton otherEdBut;
    private JSplitPane tableSplit;
    private JPanel topPanel;
    private JPanel propTablePan;
    private ListEditorPanel propConstraintEd;
    private PropertyTableModel propTableModel;
    private HashMap varTypeMap = new HashMap();
    private HashMap varConstMap = new HashMap();
    private HashMap noObConstMap = new HashMap();
    private HashMap varTypeConstraints = new HashMap();
    private HashMap oldVars = new HashMap();
    private boolean saving = false;
    private ObjectProperty typeProp = new ObjectProperty();
    ObjectView.ValueParser vp = new ObjectView.ValueParser();
    private JComboBox typeBox;
    private UIDomain uiDomain;
    public ConditionEffectEditor conditionEditor;
    private ActionListener popListener;
    private JObjectPopup varTabPopup;
    private JObjectPopup propTabPopup;

    public DeclarationEditor(Frame frame) {
        super(frame, "Variable Declaration Editor", "Please specify variable declarations, variable types, and property constraints");
        this.typeProp.setName(Symbol.intern(IVUtil.TYPE_STRING_a));
        this.typeProp.setSyntax(ObjectProperty.Syntax.OBJECT);
    }

    public DeclarationEditor(Frame frame, UIRefinement uIRefinement) {
        this(frame);
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel();
        this.topPanel = new JPanel(new GridBagLayout());
        this.propTablePan = new JPanel(new BorderLayout());
        this.tableSplit = new JSplitPane(0);
        this.tableSplit.setOneTouchExpandable(true);
        this.tableSplit.setTopComponent(this.topPanel);
        this.tableSplit.setBottomComponent(this.propTablePan);
        this.tableSplit.setResizeWeight(0.5);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tableSplit, "Center");
        JLabel jLabel = new JLabel("Variable declarations");
        this.makeDeclarationButtons();
        this.varTableMod = new VarTypeTableModel();
        IXTable iXTable = new IXTable(this.varTableMod);
        iXTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        TableColumn tableColumn = iXTable.getColumnModel().getColumn(this.varTableMod.TYPE_COL);
        tableColumn.setCellRenderer(new NamedRenderer(false));
        this.typeBox = new JComboBox();
        this.typeBox.addItem(" ");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.typeBox);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = iXTable.getColumnModel().getColumn(this.varTableMod.CONSTRAINTS_COL);
        iXTable.setToolTipText(this.varTableMod.CONSTRAINTS_COL, "Has property constraints?");
        tableColumn.setResizable(false);
        tableColumn.setPreferredWidth(35);
        tableColumn.setMaxWidth(35);
        tableColumn.setMinWidth(35);
        tableColumn = iXTable.getColumnModel().getColumn(this.varTableMod.NOCONST_COL);
        iXTable.setToolTipText(this.varTableMod.NOCONST_COL, "Has constraints outside type?");
        tableColumn.setResizable(false);
        tableColumn.setPreferredWidth(35);
        tableColumn.setMaxWidth(35);
        tableColumn.setMinWidth(35);
        iXTable.doLayout();
        this.varTabPopup = new JObjectPopup();
        this.propTabPopup = new JObjectPopup();
        this.popListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Container container = ((Component)actionEvent.getSource()).getParent();
                    String string = actionEvent.getActionCommand();
                    if (container instanceof JObjectPopup) {
                        Object object = ((JObjectPopup)container).getObject();
                        if (object == null) {
                            String[] stringArray = new String[]{"Please select a row to " + string};
                            JOptionPane.showMessageDialog(null, stringArray);
                        } else if (object instanceof ItemVar) {
                            DeclarationEditor.this.userShowNoDecs((ItemVar)object);
                        } else if (object instanceof Constraint) {
                            if (IVUtil.isEmptyConstraint((Constraint)object)) {
                                String[] stringArray = new String[]{"Selected row is empty. ", string + " cannot be done."};
                                JOptionPane.showMessageDialog(null, stringArray);
                            } else {
                                DeclarationEditor.this.removeConstraint((Constraint)object);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                    String[] stringArray = new String[]{"Problem during " + actionEvent.getActionCommand() + ":", Debug.foldException(exception)};
                    JOptionPane.showMessageDialog(null, stringArray);
                }
            }
        };
        JMenuItem jMenuItem = new JMenuItem("Show constraints outside type");
        jMenuItem.addActionListener(this.popListener);
        this.varTabPopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete selected constraint");
        jMenuItem.addActionListener(this.popListener);
        this.propTabPopup.add(jMenuItem);
        this.varEd = new VarListEditor(this, "Variables and Types", (JComponent)iXTable);
        this.propConstraintEd = this.makePropPanel();
        this.otherEdBut = new JButton("Use Simple Constraint Editor");
        this.otherEdBut.addMouseListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 12), 0, 0);
        this.topPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        this.topPanel.add((Component)this.any, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        this.topPanel.add((Component)this.given, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        this.topPanel.add((Component)this.none, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 2, 0, 2), 0, 0);
        this.topPanel.add((Component)this.varEd, gridBagConstraints);
        this.propTablePan.add((Component)this.propConstraintEd, "Center");
        this.propTablePan.add((Component)this.otherEdBut, "South");
        return jPanel;
    }

    private ListEditorPanel makePropPanel() {
        this.propTableModel = new PropertyTableModel();
        IXTable iXTable = new IXTable(this.propTableModel);
        this.propTableModel.adjustTable(iXTable);
        iXTable.addFocusListener(this.propTableModel);
        this.propConstraintEd = new ListEditorPanel((EventListener)this, "Property Constraints", iXTable);
        this.propTableModel.addPropertyConstraintsListener(this);
        this.propConstraintEd.removeListSelectionListener(this);
        return this.propConstraintEd;
    }

    private void makeDeclarationButtons() {
        this.any = new JRadioButton("Any");
        this.none = new JRadioButton("None");
        this.given = new JRadioButton("As Given Here");
        this.group = new ButtonGroup();
        this.group.add(this.any);
        this.group.add(this.none);
        this.group.add(this.given);
        this.any.setActionCommand("Any");
        this.any.setToolTipText("Allow any variables");
        this.none.setActionCommand("None");
        this.none.setToolTipText("Allow no variables");
        this.given.setActionCommand("As Given Here");
        this.given.setToolTipText("Allow only given variables");
        this.any.addMouseListener(this);
        this.none.addMouseListener(this);
        this.given.addMouseListener(this);
        this.any.setSelected(true);
    }

    protected void initFromObject() throws NullPointerException {
        this.propConstraintEd.setLabel("Property Constraints");
        this.propTableModel.clear();
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        uIRefinement.addDataChangeListener(this);
        if (uIRefinement.getUIDomain() != null) {
            uIRefinement.getUIDomain().addUIDomainListener(this);
            this.loadObjectClasses(uIRefinement.getUIDomain());
        }
        HashSet<ItemVar> hashSet = new HashSet<ItemVar>();
        List list = uIRefinement.getVariableDeclarations();
        SortedSet sortedSet = uIRefinement.getVariablesUsed();
        if (sortedSet != null) {
            hashSet = new HashSet(sortedSet);
        }
        boolean bl = true;
        if (list != null) {
            for (VariableDeclaration variableDeclaration : list) {
                if (!bl) continue;
                bl = !hashSet.add(variableDeclaration.getName());
            }
        }
        this.setListData(uIRefinement, hashSet);
        if (list == null) {
            this.any.setSelected(true);
        } else if (list.size() == 0) {
            this.none.setSelected(true);
        } else {
            this.given.setSelected(true);
        }
    }

    public void setListData(UIRefinement uIRefinement, Collection collection) {
        this.varEd.removeData();
        this.loadObjectConstraints(uIRefinement);
        if (collection != null) {
            this.varEd.setData(uIRefinement, collection);
        }
    }

    protected void setFromObject(Object object) {
    }

    protected void loadVarType(UIRefinement uIRefinement, ItemVar itemVar) {
        if (itemVar == null || uIRefinement == null) {
            return;
        }
        Constraint constraint = IVUtil.findClassConstraint(itemVar, uIRefinement.getConstraints());
        if (constraint != null) {
            Object object = IVUtil.extractType(constraint, uIRefinement.getUIDomain());
            if (object != null && !object.toString().equals("")) {
                this.varTypeMap.put(itemVar, object);
            }
            this.varTypeConstraints.put(itemVar, constraint);
        }
    }

    protected void saveVarType(UIRefinement uIRefinement, ItemVar itemVar) {
        ItemVar itemVar2;
        if (itemVar == null) {
            return;
        }
        Constraint constraint = this.getVarTypeConstraint(itemVar);
        if (constraint == null) {
            constraint = this.makeTypeConstraint(itemVar);
        }
        if ((itemVar2 = this.getOldVar(itemVar)) != null) {
            uIRefinement.setTypeConstraint(itemVar2, null);
        }
        uIRefinement.setTypeConstraint(itemVar, constraint);
    }

    protected void noteVarType(ItemVar itemVar, UIObjectClass uIObjectClass) {
        if (itemVar == null) {
            return;
        }
        if (uIObjectClass != null) {
            uIObjectClass.addDataChangeListener(this);
        }
        this.varTypeMap.put(itemVar, uIObjectClass);
        this.reloadVarConstraints(itemVar);
        this.propTableModel.setConstraints(itemVar, uIObjectClass, this.getVarConstraints(itemVar));
        this.propConstraintEd.setLabel("Property Constraints for variable " + itemVar.toString());
    }

    protected UIObjectClass getVarType(ItemVar itemVar) {
        Object v = this.varTypeMap.get(itemVar);
        if (v instanceof UIObjectClass) {
            return (UIObjectClass)v;
        }
        if (v == null) {
            return null;
        }
        String string = v.toString();
        UIDomain uIDomain = ((UIRefinement)this.currentObject).getUIDomain();
        if (uIDomain != null) {
            Object object = uIDomain.getNamedObjectClass(string);
            UIObjectClass uIObjectClass = null;
            if (object instanceof UIObjectClass) {
                uIObjectClass = (UIObjectClass)object;
            } else {
                Debug.noteln("DeclarationEditor found class", object);
            }
            if (uIObjectClass != null) {
                this.varTypeMap.put(itemVar, uIObjectClass);
                return uIObjectClass;
            }
        }
        Debug.noteln("DecEd: var type is of class", v.getClass());
        return null;
    }

    protected void removeVarType(ItemVar itemVar) {
        this.varTypeMap.remove(itemVar);
    }

    protected Constraint getVarTypeConstraint(ItemVar itemVar) {
        return (Constraint)this.varTypeConstraints.get(itemVar);
    }

    protected void noteVarTypeConstraint(ItemVar itemVar, Constraint constraint) {
        if (itemVar == null) {
            return;
        }
        this.varTypeConstraints.put(itemVar, constraint);
    }

    protected void noteVarTypeConstraint(ItemVar itemVar, UIObjectClass uIObjectClass) {
        if (itemVar == null) {
            return;
        }
        Constraint constraint = this.makeTypeConstraint(itemVar);
        this.varTypeConstraints.put(itemVar, constraint);
    }

    protected Constraint makeTypeConstraint(ItemVar itemVar) {
        Serializable serializable;
        if (itemVar == null) {
            return null;
        }
        Object v = this.varTypeMap.get(itemVar);
        UIObjectClass uIObjectClass = null;
        if (v instanceof String) {
            serializable = ((UIRefinement)this.currentObject).getUIDomain();
            if (serializable != null) {
                uIObjectClass = (UIObjectClass)serializable.getNamedObjectClass((String)v);
            }
            if (uIObjectClass == null) {
                JOptionPane.showMessageDialog(null, "Unknown variable type: " + v);
            }
        } else if (v instanceof UIObjectClass) {
            uIObjectClass = (UIObjectClass)v;
        }
        if (uIObjectClass == null) {
            return null;
        }
        serializable = Lisp.list(Symbol.intern(IVUtil.TYPE_STRING_a), itemVar);
        Object object = this.vp.read(this.typeProp, uIObjectClass.getName(), null);
        Debug.noteln("DecEd: type syntax is", object.getClass());
        PatternAssignment patternAssignment = new PatternAssignment((LList)serializable, object);
        Constraint constraint = new Constraint(Refinement.S_WORLD_STATE, Refinement.S_CONDITION, (List)Lisp.list(patternAssignment));
        return constraint;
    }

    protected void loadVarConstraints(UIRefinement uIRefinement, ItemVar itemVar) {
        UIObjectClass uIObjectClass = this.getVarType(itemVar);
        List list = uIRefinement.getVariableConstraints(itemVar);
        HashMap hashMap = this.constraintsToProperty(itemVar, uIObjectClass, list);
        if (list != null && !list.isEmpty()) {
            this.noteVarConstraints(itemVar, hashMap);
        }
    }

    protected void reloadAllVarConstraints() {
        Set set = this.varConstMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.reloadVarConstraints((ItemVar)iterator.next());
        }
    }

    protected void reloadVarConstraints(ItemVar itemVar) {
        UIObjectClass uIObjectClass = this.getVarType(itemVar);
        Object v = this.noObConstMap.get(itemVar);
        this.noObConstMap.remove(itemVar);
        HashSet hashSet = v != null ? new HashSet((Collection)v) : new HashSet();
        List list = UIUtil.getFlatValues(this.getVarConstraints(itemVar));
        if (list != null && !list.isEmpty()) {
            hashSet.addAll(list);
        }
        HashMap hashMap = this.constraintsToProperty(itemVar, uIObjectClass, hashSet);
        if (hashSet != null && !hashSet.isEmpty()) {
            this.noteVarConstraints(itemVar, hashMap);
        }
    }

    protected void saveVarConstraints(UIRefinement uIRefinement, ItemVar itemVar) {
        ItemVar itemVar2 = this.getOldVar(itemVar);
        if (itemVar2 != null) {
            uIRefinement.setVariableConstraints(itemVar2, new ArrayList());
        }
        ArrayList arrayList = UIUtil.getFlatValues((HashMap)this.varConstMap.get(itemVar));
        Set set = this.getNoObjectConstraints(itemVar);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (set != null) {
            arrayList.addAll(set);
        }
        uIRefinement.setVariableConstraints(itemVar, arrayList);
    }

    protected void noteVarConstraints(ItemVar itemVar, HashMap hashMap) {
        if (itemVar != null) {
            this.varConstMap.put(itemVar, hashMap);
        }
    }

    protected HashMap getVarConstraints(ItemVar itemVar) {
        if (itemVar == null) {
            return null;
        }
        return (HashMap)this.varConstMap.get(itemVar);
    }

    protected void removeVarConstraints(ItemVar itemVar) {
        this.varConstMap.remove(itemVar);
    }

    protected void removeVarTypeConstraint(ItemVar itemVar) {
        this.varTypeConstraints.remove(itemVar);
    }

    protected boolean removeConstraint(Constraint constraint) {
        if (constraint == null) {
            return false;
        }
        return this.removeConstraint(IVUtil.variableFromConstraint(constraint), constraint);
    }

    protected boolean removeConstraint(ItemVar itemVar, Constraint constraint) {
        if (itemVar != null) {
            return this.removeConstraint(itemVar, this.getVarType(itemVar), constraint);
        }
        Debug.noteln("DecEd: remove constraint - no var in", constraint);
        return false;
    }

    protected boolean removeConstraint(ItemVar itemVar, UIObjectClass uIObjectClass, Constraint constraint) {
        Object var4_4 = null;
        if (uIObjectClass != null) {
            return this.removeConstraint(itemVar, uIObjectClass, IVUtil.propertyFromConstraint(uIObjectClass, constraint), constraint);
        }
        Debug.noteln("DecEd: remove constraint - no type in", constraint);
        return false;
    }

    protected boolean removeConstraint(ItemVar itemVar, UIObjectClass uIObjectClass, ObjectProperty objectProperty, Constraint constraint) {
        if (itemVar == null || uIObjectClass == null || constraint == null) {
            return false;
        }
        boolean bl = false;
        if (objectProperty != null) {
            Object v;
            HashMap hashMap = this.getVarConstraints(itemVar);
            if (hashMap != null && (v = hashMap.get(objectProperty)) != null) {
                Set set = (Set)v;
                int n = set.size();
                Set set2 = IVUtil.removeConstraint(set, constraint);
                if (set2 == null) {
                    bl = n == 1;
                } else {
                    boolean bl2 = bl = n > set2.size();
                }
                if (bl) {
                    hashMap.put(objectProperty, set2);
                }
            }
        } else {
            Debug.noteln("DecEd: remove constraint - no prop in", constraint);
        }
        if (bl) {
            this.propTableModel.setConstraints(itemVar, uIObjectClass, this.getVarConstraints(itemVar));
        }
        return bl;
    }

    private ItemVar getOldVar(ItemVar itemVar) {
        return (ItemVar)this.oldVars.get(itemVar);
    }

    private void noteOldVar(ItemVar itemVar, ItemVar itemVar2) {
        Object v = this.oldVars.get(itemVar2);
        if (v != null) {
            this.oldVars.remove(itemVar2);
            this.oldVars.put(itemVar, v);
        } else {
            this.oldVars.put(itemVar, itemVar2);
        }
    }

    protected void replaceNotes(ItemVar itemVar, ItemVar itemVar2) {
        HashMap hashMap;
        UIObjectClass uIObjectClass = this.getVarType(itemVar);
        if (uIObjectClass != null) {
            this.removeVarType(itemVar);
            this.noteVarType(itemVar2, uIObjectClass);
        }
        if ((hashMap = this.getVarConstraints(itemVar)) != null) {
            this.removeVarConstraints(itemVar);
            HashMap hashMap2 = IVUtil.replaceVarInConstraints(itemVar, itemVar2, hashMap);
            this.noteVarConstraints(itemVar2, hashMap);
            this.propTableModel.setConstraints(itemVar2, uIObjectClass, hashMap);
        }
        if ((uIObjectClass = this.varTypeConstraints.get(itemVar)) != null) {
            this.varTypeConstraints.remove(itemVar);
            this.varTypeConstraints.put(itemVar2, uIObjectClass);
        }
    }

    private HashMap constraintsToProperty(ItemVar itemVar, UIObjectClass uIObjectClass, Collection collection) {
        if (itemVar == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        if (collection == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                Constraint constraint = (Constraint)iterator.next();
                PatternAssignment patternAssignment = constraint.getPatternAssignment();
                if (patternAssignment == null) continue;
                ObjectProperty objectProperty = IVUtil.propertyFromPattern((List)patternAssignment.getPattern(), uIObjectClass);
                if (objectProperty != null && IVUtil.isSubjectInPattern(itemVar, patternAssignment.getPattern()) && IVUtil.isSimplePropertyAssignment(patternAssignment, objectProperty, itemVar)) {
                    hashMap = PropertyTableModel.noteProperty(hashMap, uIObjectClass, objectProperty, constraint);
                    continue;
                }
                if (IVUtil.isClassConstraint(itemVar, constraint)) continue;
                Debug.noteln("DecEd: not a property constraint:", patternAssignment.getPattern());
                this.noteNoObjectConstraint(itemVar, constraint);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    private void noteNoObjectConstraint(ItemVar itemVar, Constraint constraint) {
        if (itemVar == null || constraint == null) {
            return;
        }
        Object v = this.noObConstMap.get(itemVar);
        Set<Constraint> set = new HashSet<Constraint>();
        if (v != null && v instanceof Set) {
            set = (Set)v;
        }
        set.add(constraint);
        this.noObConstMap.put(itemVar, set);
    }

    protected Set getNoObjectConstraints(ItemVar itemVar) {
        return (Set)this.noObConstMap.get(itemVar);
    }

    protected Object collectConstraint() {
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        this.saving = true;
        this.updateRefinementConstraints(uIRefinement);
        ButtonModel buttonModel = this.group.getSelection();
        if (buttonModel.getActionCommand() == null || buttonModel.getActionCommand().equals("Any")) {
            this.setAllConstraints((UIRefinement)this.currentObject);
            uIRefinement.setVariableDeclarations(null);
            this.saving = false;
            return "any";
        }
        if (buttonModel.getActionCommand().equals("None")) {
            ArrayList arrayList = new ArrayList();
            uIRefinement.setVariableDeclarations(arrayList);
            this.saving = false;
            return arrayList;
        }
        if (buttonModel.getActionCommand().equals("Given") || buttonModel.getActionCommand().equals("As Given Here")) {
            ArrayList arrayList = new ArrayList(this.setAllConstraints(uIRefinement));
            uIRefinement.setVariableDeclarations(arrayList);
            this.saving = false;
            return arrayList;
        }
        uIRefinement.setVariableDeclarations(null);
        this.saving = false;
        return "any";
    }

    private void updateRefinementConstraints(UIRefinement uIRefinement) {
        if (uIRefinement == null) {
            return;
        }
        Set set = this.varConstMap.keySet();
        if (set != null) {
            for (ItemVar itemVar : set) {
                this.saveVarConstraints(uIRefinement, itemVar);
            }
        }
    }

    protected void loadObjectConstraints(UIRefinement uIRefinement) {
        this.varConstMap.clear();
        this.varTypeMap.clear();
        this.varTypeConstraints.clear();
        SortedSet sortedSet = uIRefinement.getVariablesUsed();
        if (sortedSet == null) {
            return;
        }
        for (ItemVar itemVar : sortedSet) {
            this.loadVarType(uIRefinement, itemVar);
            this.loadVarConstraints(uIRefinement, itemVar);
        }
    }

    protected Set setAllConstraints(UIRefinement uIRefinement) {
        HashSet<VariableDeclaration> hashSet = new HashSet<VariableDeclaration>();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        List<Object> list = Arrays.asList((Object[])this.varEd.getData());
        if (list != null) {
            for (Object e : list) {
                VariableDeclaration variableDeclaration = null;
                if (e instanceof ItemVar) {
                    variableDeclaration = new VariableDeclaration((ItemVar)e);
                } else if (e instanceof VariableDeclaration) {
                    variableDeclaration = (VariableDeclaration)e;
                } else {
                    try {
                        variableDeclaration = new VariableDeclaration((ItemVar)Symbol.intern(e.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (variableDeclaration == null) continue;
                hashSet.add(variableDeclaration);
                arrayList.add(this.makeTypeConstraint(variableDeclaration.getName()));
            }
        }
        uIRefinement.setTypeConstraints(arrayList);
        return hashSet;
    }

    private void loadObjectClasses(UIDomain uIDomain) {
        if (uIDomain == null) {
            return;
        }
        this.uiDomain = uIDomain;
        List list = uIDomain.getObjectClassTree();
        this.typeBox.removeAllItems();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.typeBox.addItem(iterator.next());
            }
            this.typeBox.addItem("");
        }
        if (this.propTableModel != null) {
            this.propTableModel.updatePropertyBox();
        }
    }

    protected void handleVariables() {
    }

    protected Object noteNewValue(Object object) {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            List list = uIRefinement.getVariableDeclarations();
            return list;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return object;
        }
    }

    public void userShowNoDecs(ItemVar itemVar) {
        if (itemVar == null) {
            return;
        }
        Object v = this.noObConstMap.get(itemVar);
        if (v == null || ((Collection)v).isEmpty()) {
            JOptionPane.showMessageDialog(this, "All of the constraints for " + itemVar + " fit its class");
        } else {
            Collection collection = (Collection)v;
            String[] stringArray = (String[])Array.newInstance(String.class, collection.size() + 1);
            String[] stringArray2 = UIUtil.listToTextArray(collection);
            stringArray[0] = "The constraints for " + itemVar + " that do not fit its class are:";
            System.arraycopy(stringArray2, 0, stringArray, 1, collection.size());
            JOptionPane.showMessageDialog(this, stringArray);
        }
    }

    protected void finishEdits() {
        try {
            TableCellEditor tableCellEditor;
            JTable jTable = (JTable)this.propConstraintEd.getItemComponent();
            if (jTable.isEditing()) {
                tableCellEditor = jTable.getCellEditor();
                tableCellEditor.stopCellEditing();
            }
            if ((jTable = (JTable)this.varEd.getItemComponent()).isEditing()) {
                tableCellEditor = jTable.getCellEditor();
                tableCellEditor.stopCellEditing();
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public void start(String string, Object object, Point point) {
        this.setTitle(string);
        super.start(object, point);
    }

    public void start() {
        this.moreBut.setText("Note Edits");
        super.start();
    }

    public void closeEditor() {
        if (this.currentObject != null) {
            ((EditableObject)this.currentObject).removeDataChangeListener(this);
        }
        if (this.conditionEditor != null) {
            this.conditionEditor.setVisible(false);
        }
        super.closeEditor();
    }

    public void ensureConditionEditor() {
        if (this.conditionEditor == null) {
            this.conditionEditor = new ConditionEffectEditor((Frame)this.getOwner());
            this.conditionEditor.setVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.none)) {
            SortedSet sortedSet = ((UIRefinement)this.currentObject).getVariablesUsed();
            if (sortedSet != null && sortedSet.size() != 0) {
                String[] stringArray = new String[]{"This will clear all declarations and constraints", "in this editor.", "Are you sure you want to do this?"};
                int n = JOptionPane.showConfirmDialog(this, stringArray, "Warning", 2);
                if (n == 0) {
                    this.varEd.removeData();
                } else {
                    this.any.setSelected(true);
                }
            }
        } else {
            if (mouseEvent.getSource().equals(this.okBut)) {
                this.finishEdits();
                this.propTableModel.noteOldConstraints();
                this.processConstraint();
                this.closeEditor();
                return;
            }
            if (mouseEvent.getSource().equals(this.otherEdBut)) {
                this.ensureConditionEditor();
                this.conditionEditor.start(this.currentObject);
            } else if (mouseEvent.getSource().equals(this.moreBut)) {
                this.finishEdits();
                this.propTableModel.noteOldConstraints();
                this.processConstraint();
            } else {
                super.mouseClicked(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component;
        if (SwingUtilities.isRightMouseButton(mouseEvent) && (component = mouseEvent.getComponent()) instanceof IXTable) {
            TableModel tableModel = ((IXTable)component).getModel();
            if (tableModel instanceof VarTypeTableModel) {
                this.showTablePopup(this.varTabPopup, mouseEvent);
            } else if (tableModel instanceof PropertyTableModel) {
                this.showTablePopup(this.propTabPopup, mouseEvent);
            }
        }
    }

    private void showTablePopup(JObjectPopup jObjectPopup, MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof IXTable) {
            IXTable iXTable = (IXTable)component;
            Object object = iXTable.getSelectedObject();
            jObjectPopup.setObject(object);
            jObjectPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            Debug.noteln("DecEd: WARNING show popup from odd component!", component);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.finishEdits();
        ListSelectionModel listSelectionModel = ((IXTable)this.varEd.getItemComponent()).getSelectionModel();
        if (listSelectionEvent.getSource() == listSelectionModel) {
            ItemVar itemVar = (ItemVar)this.varEd.getSelectedObject();
            if (itemVar == null) {
                this.propConstraintEd.setLabel("Property Constraints");
                this.propTableModel.clear();
                return;
            }
            UIObjectClass uIObjectClass = this.getVarType(itemVar);
            HashMap hashMap = this.getVarConstraints(itemVar);
            HashMap hashMap2 = hashMap instanceof HashMap ? hashMap : this.constraintsToProperty(itemVar, uIObjectClass, (Collection)((Object)hashMap));
            this.noteVarConstraints(itemVar, hashMap2);
            this.propConstraintEd.setLabel("Property Constraints for variable " + itemVar.toString());
            this.propTableModel.setConstraints(itemVar, uIObjectClass, hashMap2);
        }
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        if (!this.isVisible() || editableObject == null) {
            return;
        }
        if (editableObject instanceof UIObjectClass) {
            this.updatePropertiesList(((UIRefinement)this.currentObject).getUIDomain());
            this.reloadAllVarConstraints();
            this.updateTables();
        } else if (editableObject.equals(this.currentObject)) {
            this.updateData();
        }
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        if (this.isVisible() && uIDomainEvent.getObject() instanceof UIObjectClass) {
            this.updateClassesList(uIDomainEvent);
        }
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (uIDomainEvent.getObject() instanceof UIObjectClass) {
            this.updatePropertiesList(uIDomainEvent);
            this.reloadAllVarConstraints();
            this.updateTables();
        } else if (uIDomainEvent.getObject() instanceof UIRefinement && this.currentObject != null && this.currentObject.equals(uIDomainEvent.getObject())) {
            this.updateData();
        }
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (uIDomainEvent.getObject() instanceof UIObjectClass) {
            this.updateClassesList(uIDomainEvent);
            String[] stringArray = new String[]{"Object class removed: " + uIDomainEvent.getObject(), "Please ensure no variable declarations use it", "(No automatic recovery yet)"};
            JOptionPane.showMessageDialog(this, stringArray);
        } else if (uIDomainEvent.getObject() instanceof UIRefinement && this.currentObject != null && this.currentObject.equals(uIDomainEvent.getObject())) {
            String[] stringArray = new String[]{"Current refinement removed: " + uIDomainEvent.getObject(), "Closing editor."};
            JOptionPane.showMessageDialog(this, stringArray);
            this.closeEditor();
        }
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.updateClassesList(uIDomainEvent);
        this.closeEditor();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.updateClassesList(uIDomainEvent);
        this.updateData();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.updateClassesList(uIDomainEvent);
        this.updateData();
    }

    private void updateTables() {
        this.finishEdits();
    }

    private void updateClassesList(UIDomainEvent uIDomainEvent) {
        this.loadObjectClasses(uIDomainEvent.getDomain());
        this.updatePropertiesList(uIDomainEvent);
    }

    private void updatePropertiesList(UIDomainEvent uIDomainEvent) {
        this.updatePropertiesList(uIDomainEvent.getDomain());
    }

    private void updatePropertiesList(UIDomain uIDomain) {
        this.propTableModel.updatePropertyBox();
        this.loadObjectClasses(uIDomain);
    }

    private void updateData() {
        if (this.saving || !this.isVisible()) {
            return;
        }
        this.initFromObject();
    }

    public void variableConstraintsChanged(ItemVar itemVar, HashMap hashMap) {
        this.noteVarConstraints(itemVar, hashMap);
    }

    public void variableNameChanged(ItemVar itemVar, ItemVar itemVar2) {
        Debug.noteln("DecEd: **********Cannot deal with var name change*********");
    }

    public void variableTypeChanged(ItemVar itemVar, UIObjectClass uIObjectClass, UIObjectClass uIObjectClass2) {
        this.noteVarType(itemVar, uIObjectClass2);
    }

    public class VarTypeTableModel
    extends AbstractIXTableModel {
        String[] columns;
        Class[] classes;
        private int VAR_COL;
        private int TYPE_COL;
        private int CONSTRAINTS_COL;
        private int NOCONST_COL;
        UIRefinement refinement;

        VarTypeTableModel() {
            super(false);
            this.columns = new String[]{"Variable", "Type (Object Class)", "Cs", "OCs"};
            this.classes = new Class[]{String.class, ObjectClass.class, Boolean.class, Boolean.class};
            this.VAR_COL = 0;
            this.TYPE_COL = 1;
            this.CONSTRAINTS_COL = 2;
            this.NOCONST_COL = 3;
            this.setColumnNames(this.columns);
            this.setColumnClasses(this.classes);
        }

        public void clear() {
            this.rows.clear();
            this.clearMarks();
        }

        public void setData(UIRefinement uIRefinement, Collection collection) {
            this.rows.clear();
            this.clearMarks();
            this.refinement = uIRefinement;
            if (collection != null) {
                for (Object e : collection) {
                    if (!(e instanceof ItemVar)) continue;
                    this.rows.add(e);
                }
            }
            this.rows.add(null);
            this.fireTableDataChanged();
        }

        public void addData(ItemVar itemVar) {
            if (itemVar == null) {
                return;
            }
            int n = this.getObjectRow(null);
            this.rows.remove(null);
            this.rows.add(itemVar);
            this.rows.add(null);
            this.fireTableDataChanged();
        }

        public Object getCellValueAt(Object object, int n) {
            ItemVar itemVar = (ItemVar)object;
            if (n == this.VAR_COL) {
                if (itemVar == null) {
                    return "";
                }
                return itemVar.toString();
            }
            if (n == this.TYPE_COL) {
                return DeclarationEditor.this.varTypeMap.get(itemVar);
            }
            if (n == this.CONSTRAINTS_COL) {
                HashMap hashMap = DeclarationEditor.this.getVarConstraints(itemVar);
                return hashMap != null && (hashMap instanceof Collection && !((Collection)((Object)hashMap)).isEmpty() || hashMap instanceof Map && !((Map)hashMap).isEmpty());
            }
            if (n == this.NOCONST_COL) {
                Set set = DeclarationEditor.this.getNoObjectConstraints(itemVar);
                return set != null && set instanceof Collection && !((Collection)set).isEmpty();
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != this.NOCONST_COL && n2 != this.CONSTRAINTS_COL;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getRowObject(n);
            if (n2 == this.VAR_COL) {
                Symbol symbol = Symbol.intern(object.toString());
                if (!(symbol instanceof ItemVar)) {
                    String[] stringArray = new String[]{object.toString() + " is not a valid variable name", "Please specify a name like this: ?person", "(Nothing done)"};
                    JOptionPane.showMessageDialog(null, stringArray);
                    return;
                }
                if (object2 == null) {
                    this.addData((ItemVar)symbol);
                } else {
                    this.replaceData((ItemVar)object2, (ItemVar)symbol);
                    DeclarationEditor.this.replaceNotes((ItemVar)object2, (ItemVar)symbol);
                }
            } else if (n2 == this.TYPE_COL) {
                if (object2 == null || object2.toString().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please set the variable name first");
                } else if (object == null || object instanceof UIObjectClass) {
                    DeclarationEditor.this.noteVarType((ItemVar)object2, (UIObjectClass)object);
                } else {
                    Debug.noteln("DecEd: new value of class", object.getClass());
                }
            }
        }

        protected void updateConstCols() {
            TableModelEvent tableModelEvent = new TableModelEvent(this, 1, this.getRowCount(), this.CONSTRAINTS_COL);
            this.fireTableChanged(tableModelEvent);
            tableModelEvent = new TableModelEvent(this, 1, this.getRowCount(), this.NOCONST_COL);
            this.fireTableChanged(tableModelEvent);
        }
    }

    public class VarListEditor
    extends ListEditorPanel {
        public VarListEditor(MouseListener mouseListener, String string, JComponent jComponent) {
            super((EventListener)mouseListener, string, jComponent);
        }

        public VarListEditor() {
        }

        public void setData(UIRefinement uIRefinement, Collection collection) {
            IXTable iXTable = (IXTable)this.getItemComponent();
            VarTypeTableModel varTypeTableModel = (VarTypeTableModel)iXTable.getModel();
            varTypeTableModel.setData(uIRefinement, collection);
        }
    }
}

