/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.SchemaTerms;
import ix.icore.domain.event.DomainEvent;
import ix.iface.ui.EditableObject;
import ix.iface.ui.GenericIFormModel;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.table.AbstractTreeTableModel;
import ix.iface.ui.table.IXTNTreeTableNode;
import ix.iface.ui.table.IXTreeTableNode;
import ix.iface.ui.tree.EditableTree;
import ix.iface.ui.tree.IXNode;
import ix.iface.ui.tree.IXTreeNode;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.ConstructEditing;
import ix.iview.DomainEditorFrame;
import ix.iview.IDESymbols;
import ix.iview.ObjectClassGenerator;
import ix.iview.PanelSearcher;
import ix.iview.PropertyEditor;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.tree.ObjectClassTreeModel;
import ix.iview.tree.ObjectClassTreeNode;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.LinkedListOfSymbol;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AROEditorPanel
extends AConstructFramePanel
implements ActionListener,
TreeSelectionListener,
UIDomainListener,
IDESymbols {
    private JSplitPane split = new JSplitPane(1);
    private JScrollPane scrollTree = new JScrollPane();
    private EditableTree classTree;
    private ObjectClassTreeModel classTreeModel;
    public PanelSearcher searcher;
    PropertyEditor propEditor;
    private Point mousePoint = new Point(100, 100);

    public AROEditorPanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
        this.setupClassTree();
        this.refresh();
    }

    protected void populateARO() {
        UIDomain uIDomain = this.getUIDomain();
        List list = uIDomain.getAllObjectClasses();
        if (list != null && !list.isEmpty() && this.classTreeModel != null) {
            this.classTreeModel.reloadData();
        }
    }

    public UIObjectClass newUIObjectClass(String string) {
        UIObjectClass uIObjectClass = new UIObjectClass(this.getUIDomain(), string);
        this.getUIDomain().addConstruct(uIObjectClass);
        return uIObjectClass;
    }

    public UIObjectClass newUIObjectClass(String string, UIObjectClass uIObjectClass) {
        UIObjectClass uIObjectClass2 = new UIObjectClass(this.getUIDomain(), string);
        LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol();
        linkedListOfSymbol.add(Symbol.intern(uIObjectClass.getName()));
        uIObjectClass2.setSuperClassNames(linkedListOfSymbol);
        this.getUIDomain().addConstruct(uIObjectClass2);
        return uIObjectClass2;
    }

    protected JPanel setupMainPanel() {
        GenericIFormModel genericIFormModel = new GenericIFormModel(UIObjectClass.class){

            public void setValue(String string, Object object) {
                Debug.noteln("AROEd: field is", string);
                if (this.baseObject == null) {
                    AROEditorPanel.this.beforeSwitching();
                    AROEditorPanel.this.refresh();
                } else {
                    this.setValue(this.baseObject, string, object);
                }
            }

            public boolean setValue(EditableObject editableObject, String string, Object object) {
                if (editableObject != null && object != null && string.equals("objectProperties")) {
                    try {
                        UIObjectClass uIObjectClass = (UIObjectClass)editableObject;
                        HashSet hashSet = uIObjectClass.getAncestorProperties();
                        LinkedList linkedList = new LinkedList();
                        for (Object e : (Collection)object) {
                            if (hashSet.contains(e)) continue;
                            linkedList.add(e);
                        }
                        return super.setValue(editableObject, string, linkedList);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.setValue(editableObject, string, object);
            }

            public Object getValue(String string) {
                if (string.equals("objectProperties")) {
                    return this.getValue(this.baseObject, string);
                }
                return super.getValue(string);
            }

            public Object getValue(EditableObject editableObject, String string) {
                if (string.equals("objectProperties")) {
                    if (editableObject == null) {
                        return null;
                    }
                    return new LinkedList(((UIObjectClass)editableObject).getAllProperties());
                }
                return super.getValue(editableObject, string);
            }
        };
        this.formPanel = new AROFormPanel(this, genericIFormModel);
        AROMouseAdapter aROMouseAdapter = new AROMouseAdapter();
        this.formPanel.addFormMouseListener(aROMouseAdapter);
        return this.formPanel;
    }

    protected void setupClassTree() {
        this.split.setRightComponent(this.scrollPane);
        this.split.setLeftComponent(this.scrollTree);
        this.split.setResizeWeight(0.3);
        this.add((Component)this.split, "Center");
        JPanel jPanel = new JPanel();
        this.scrollTree.add(jPanel);
        ObjectClassTreeNode objectClassTreeNode = new ObjectClassTreeNode(new UIObjectClass(this.getUIDomain(), "Dummy Root"));
        this.classTreeModel = new ObjectClassTreeModel(this.getUIDomain(), null);
        this.classTreeModel.reloadData();
        this.classTree = new EditableTree(this.classTreeModel);
        this.classTree.addTreeSelectionListener(this);
        this.scrollTree.getViewport().add(this.classTree);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(170);
        Object object = this.classTreeModel.getUserRoot();
        if (object != null) {
            this.setUIConstruct((UIObjectClass)object);
        }
    }

    public void refresh() {
        this.resetTree();
        if (this.classTree != null) {
            this.classTree.treeDidChange();
        }
    }

    public void updateTree() {
        if (this.classTreeModel != null) {
            this.classTreeModel.reload();
        }
        if (this.classTree != null) {
            this.updateTreeSelection();
        }
    }

    public void resetTree() {
        if (this.classTreeModel != null) {
            this.classTreeModel.reloadData();
            if (!this.getUIDomain().isCurrentObject(this.getUIConstruct())) {
                UIObject uIObject = (UIObject)this.classTreeModel.getUserRoot();
                if (!this.getUIDomain().isCurrentObject(uIObject)) {
                    uIObject = null;
                }
                this.setUIConstruct(uIObject);
            }
        } else {
            Debug.noteln("AROed: no class tree model");
        }
        if (this.classTree != null) {
            this.updateTreeSelection();
        }
    }

    public void updateTreeSelection() {
        this.classTree.showUserNode(this.getUIConstruct());
    }

    public UIObject makeNewConstruct() {
        return new UIObjectClass(this.getUIDomain(), "");
    }

    public void saveConstruct() {
        this.noteConstruct();
        this.setUIConstructPanel(this.getUIConstruct());
    }

    public UIObject noteConstruct() {
        UIObject uIObject = this.getUIConstruct();
        if (uIObject == null) {
            uIObject = (UIObjectClass)this.makeNewConstruct();
        }
        this.formPanel.saveToObject(uIObject);
        uIObject.noteChange();
        if (!this.getUIDomain().equals(uIObject.getUIDomain())) {
            uIObject.moveToUIDomain(this.getUIDomain());
        }
        this.getUIDomain().updateConstruct(uIObject);
        return uIObject;
    }

    public Named getNamedConstruct(String string) {
        if (this.getUIDomain() == null) {
            return null;
        }
        Object object = this.getUIDomain().getNamedObjectClass(string);
        if (object != null && object instanceof UIObject) {
            return (Named)object;
        }
        return this.getUIDomain().newUIObject((IXObject)object);
    }

    public boolean checkConstruct() {
        UIUtil.notImplemented(this, "Checking Object Classes");
        return true;
    }

    public List getAllConstructs() {
        if (this.getUIDomain() == null) {
            return null;
        }
        List list = this.getUIDomain().getAllObjectClasses();
        return new LinkedList(list);
    }

    public void clear() {
        this.resetTree();
    }

    public void clearUIConstruct() {
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return ((UIObjectClass)uIObject).cloneThis();
    }

    public void setUIConstructPanel(UIObject uIObject) {
        UIObject uIObject2 = this.getUIConstruct();
        ((ConstructEditing)((Object)this.formPanel)).setUIConstruct(uIObject);
    }

    public void setUIConstruct(UIObject uIObject) {
        UIObject uIObject2 = this.getUIConstruct();
        if (uIObject != null && !uIObject.equals(uIObject2) && this.beforeSwitching()) {
            this.setUIConstructPanel(uIObject);
            this.afterSwitching();
        } else {
            super.setUIConstruct(uIObject);
        }
    }

    public boolean beforeClosing() {
        if (this.propEditor != null) {
            this.propEditor.setVisible(false);
        }
        if (this.searcher != null) {
            this.searcher.close();
        }
        return this.beforeSwitching();
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        if (uIDomainEvent.getObject().equals(this.getUIConstruct())) {
            this.deleteConstruct();
        }
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.clear();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.populateARO();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.populateARO();
    }

    protected UIObjectClass getClassFromUser(UIObjectClass uIObjectClass) {
        return this.getClassFromUser("Select an ObjectClass", uIObjectClass);
    }

    protected UIObjectClass getClassFromUser(String string, UIObjectClass uIObjectClass) {
        List list = this.getUIDomain().getObjectClassTree();
        list.add(0, new String("New class"));
        return this.getClassFromUser(list, string, uIObjectClass);
    }

    protected UIObjectClass getClassFromUser(List list, UIObjectClass uIObjectClass) {
        return this.getClassFromUser(list, "Select an ObjectClass", uIObjectClass);
    }

    protected UIObjectClass getClassFromUser(List list, String string, UIObjectClass uIObjectClass) {
        Object object = JOptionPane.showInputDialog(this.parent, string, "Input", 3, null, list.toArray(), null);
        return this.processClassFromUser(object, uIObjectClass);
    }

    private UIObjectClass processClassFromUser(Object object, UIObjectClass uIObjectClass) {
        if (object == null) {
            return null;
        }
        if (object instanceof UIObjectClass) {
            return (UIObjectClass)object;
        }
        if (object.equals("New class")) {
            return this.userNewClass(uIObjectClass);
        }
        return (UIObjectClass)this.getUIDomain().getNamedObjectClass(object.toString());
    }

    private UIObjectClass userNewClass(UIObjectClass uIObjectClass) {
        UIObjectClass uIObjectClass2;
        String string = JOptionPane.showInputDialog("Please enter the name of the new class");
        if (string == null) {
            return null;
        }
        UIDomain uIDomain = this.getUIDomain();
        boolean bl = uIDomain.addConstruct(uIObjectClass2 = new UIObjectClass(uIDomain, string));
        if (bl) {
            if (uIObjectClass == null) {
                uIObjectClass = this.getClassFromUser("Please enter the parent of the new class", uIObjectClass);
            }
            if (uIObjectClass == null) {
                uIDomain.removeConstruct(uIObjectClass2);
                return null;
            }
            uIObjectClass2.addDataChangeListener(this.classTreeModel);
            uIObjectClass2.addParent(uIObjectClass);
            return uIObjectClass2;
        }
        return null;
    }

    public void userNewChild() {
        UIObjectClass uIObjectClass = (UIObjectClass)this.getUIConstruct();
        if (uIObjectClass != null) {
            UIObjectClass uIObjectClass2 = (UIObjectClass)this.makeNewConstruct();
            uIObjectClass2.addParent(uIObjectClass);
            if (this.getUIDomain().addConstruct(uIObjectClass2)) {
                uIObjectClass.addChild(uIObjectClass2);
                this.setUIConstruct(uIObjectClass2);
            }
        }
    }

    public void userAddChild() {
        UIObjectClass uIObjectClass;
        UIObjectClass uIObjectClass2 = (UIObjectClass)this.getUIConstruct();
        if (uIObjectClass2 != null && (uIObjectClass = this.getClassFromUser(uIObjectClass2)) != null) {
            String string = uIObjectClass2.reportLegalChild(uIObjectClass);
            if (string == "") {
                uIObjectClass2.addChild(uIObjectClass);
                uIObjectClass.addParent(uIObjectClass2);
            } else {
                JOptionPane.showMessageDialog(this, string);
            }
        }
    }

    public void userDeleteChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("subClassNames");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub class to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string = object.toString();
                UIObjectClass uIObjectClass = (UIObjectClass)this.getUIDomain().getNamedObjectClass(string);
                if (uIObjectClass != null) {
                    uIObjectClass.removeParent((UIObjectClass)this.getUIConstruct());
                }
                ((UIObjectClass)this.getUIConstruct()).removeChild(object.toString());
            }
            jList.clearSelection();
        }
    }

    public void userEditChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("subClassNames");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub class to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            Object object = objectArray[0];
            UIObjectClass uIObjectClass = (UIObjectClass)this.getUIDomain().getNamedObjectClass(object.toString());
            if (uIObjectClass != null) {
                this.setUIConstruct(uIObjectClass);
            } else {
                Debug.noteln("Cannot find object class", object);
            }
        }
    }

    public void userAddParent() {
        UIObjectClass uIObjectClass;
        UIObjectClass uIObjectClass2 = (UIObjectClass)this.getUIConstruct();
        if (uIObjectClass2 != null && (uIObjectClass = this.getClassFromUser(null)) != null) {
            String string = uIObjectClass2.reportLegalParent(uIObjectClass);
            if (string == "") {
                uIObjectClass2.addParent(uIObjectClass);
            } else {
                JOptionPane.showMessageDialog(this, string);
            }
        }
    }

    public void userDeleteParent() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("superClassNames");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a super class to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ((UIObjectClass)this.getUIConstruct()).removeParent(object.toString());
            }
            jList.clearSelection();
        }
    }

    public void userEditParent() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("superClassNames");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a super class to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            Object object = objectArray[0];
            UIObjectClass uIObjectClass = (UIObjectClass)this.getUIDomain().getNamedObjectClass(object.toString());
            if (uIObjectClass != null) {
                this.setUIConstruct(uIObjectClass);
            } else {
                Debug.noteln("Cannot find object class", object);
            }
        }
    }

    public void ensureSearcher() {
        if (this.searcher == null) {
            this.searcher = new PanelSearcher(this);
            this.searcher.setVisible(false);
        }
    }

    public void userSearch() {
        this.ensureSearcher();
        this.searcher.setVisible(true);
    }

    private void searchOld() {
        String string = JOptionPane.showInputDialog(this, (Object)"Search string (regex)");
        if (string == null || string.equals("")) {
            Debug.noteln("No search string");
        } else {
            Set set = this.getUIDomain().getMatchingObjectClasses(string);
            Debug.noteln("Matching classes:", set);
        }
    }

    public void ensurePropEditor() {
        if (this.propEditor == null) {
            this.propEditor = new PropertyEditor(this.parent);
            this.propEditor.setVisible(false);
        }
    }

    private Point getEditorLocation() {
        Point point = this.getLocation();
        Point point2 = this.parent.getLocation();
        point.translate((int)point2.getX(), (int)point2.getY());
        Point point3 = new Point(point);
        point3.translate((int)this.mousePoint.getX(), (int)this.mousePoint.getY());
        return point3;
    }

    public void userAddProperty() {
        this.ensurePropEditor();
        this.propEditor.start((Object)this.getUIConstruct(), this.getEditorLocation());
    }

    public void userDeleteProperty() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("objectProperties");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a property to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Debug.noteln("AROEd: user deleting property");
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                UIObjectClass uIObjectClass = (UIObjectClass)this.getUIConstruct();
                try {
                    if (uIObjectClass.isOwnProperty((ObjectProperty)object)) {
                        uIObjectClass.removeProperty(object);
                        continue;
                    }
                    String[] stringArray = new String[]{((ObjectProperty)object).getName() + " is an inherited property.", "It cannot be deleted from here.", "(Nothing done)"};
                    JOptionPane.showMessageDialog(this, stringArray);
                    continue;
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                }
            }
            jList.clearSelection();
        }
    }

    public void userEditProperty() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("objectProperties");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a property to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            Object object = objectArray[0];
            UIObjectClass uIObjectClass = (UIObjectClass)this.getUIConstruct();
            try {
                if (uIObjectClass.isOwnProperty((ObjectProperty)object)) {
                    this.ensurePropEditor();
                    this.propEditor.start(this.getUIConstruct(), objectArray[0], this.getEditorLocation());
                } else {
                    String[] stringArray = new String[]{((ObjectProperty)object).getName() + " is an inherited property.", "It cannot be edited from here.", "(Nothing done)"};
                    JOptionPane.showMessageDialog(this, stringArray);
                }
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
    }

    public void deleteConstruct() {
        this.deleteConstruct((IXNode)((Object)this.getUIConstruct()));
    }

    private void deleteConstruct(IXNode iXNode) {
        if (iXNode == null) {
            return;
        }
        if ((iXNode.getParents() == null || iXNode.getParents().isEmpty()) && iXNode.equals(this.classTreeModel.getUserRoot())) {
            JOptionPane.showMessageDialog(this.parent, "Cannot delete root node. Nothing done.");
            return;
        }
        IXTreeNode iXTreeNode = this.getCurrentTreeNode();
        IXTreeNode iXTreeNode2 = null;
        if (iXTreeNode != null && !iXTreeNode.equals(this.classTreeModel.getRoot())) {
            iXTreeNode2 = iXNode.equals(iXTreeNode.getUserObject()) ? (IXTreeNode)iXTreeNode.getParent() : iXTreeNode;
        }
        if (iXTreeNode2 == null) {
            iXTreeNode2 = (IXTreeNode)this.classTreeModel.getRoot();
        }
        Object object = iXTreeNode2.getUserObject();
        this.classTree.showUserNode(object, iXNode);
        this.getUIDomain().removeConstruct((Named)((Object)iXNode));
        this.setUIConstruct((UIObject)object);
    }

    protected IXTreeNode getCurrentTreeNode() {
        if (!this.classTree.isSelectionEmpty()) {
            return (IXTreeNode)this.classTree.getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    private void generateObjectSystem() {
        ObjectClassGenerator objectClassGenerator = new ObjectClassGenerator();
        objectClassGenerator.generateObjectClasses(this.getUIDomain());
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newEdit" || string == "newChild") {
            this.userNewChild();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "saveConstruct" || string == "modify") {
            this.saveConstruct();
        } else if (string == "checkConstruct" || string == "check") {
            this.checkConstruct();
        } else if (string == "generateOS") {
            this.generateObjectSystem();
        } else if (string == "search") {
            this.userSearch();
        } else if (string == "cut") {
            this.deleteConstruct();
        } else if (string == "copy") {
            this.copyConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("ARO Editor: Got action command", string);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.classTree.isSelectionEmpty()) {
            TreePath treePath = treeSelectionEvent.getPath();
            Object object = treePath.getLastPathComponent();
            if (object instanceof IXTreeNode) {
                Object object2 = ((IXTreeNode)object).getUserObject();
                this.setUIConstruct((UIObject)object2);
            } else {
                Debug.noteln("AROEd: cannot process selection", object);
            }
        }
    }

    public class ClassTreeTableModel
    extends AbstractTreeTableModel {
        protected UIDomain uiDomain;

        public ClassTreeTableModel(UIDomain uIDomain) {
            super(false);
            this.setColumnNames();
            this.setDomain(uIDomain);
        }

        public void setDomain(UIDomain uIDomain) {
            this.uiDomain = uIDomain;
            this.uiDomain.addUIDomainListener(AROEditorPanel.this);
            List list = this.uiDomain.getAllObjectClasses();
            this.updateData(list);
        }

        public IXTreeTableNode makeIXTreeTableNode(Object object) {
            TreeNode treeNode = null;
            if (object != null) {
                if (TreeNode.class.isInstance(object)) {
                    treeNode = (TreeNode)object;
                } else if (IXObject.class.isInstance(object)) {
                    treeNode = (TreeNode)((Object)this.uiDomain.getUIObject((IXObject)object));
                }
            } else {
                Debug.noteln("ARO/CTTM: Trying to make tree node from null");
            }
            if (treeNode == null) {
                return null;
            }
            return new IXTNTreeTableNode((AbstractTreeTableModel)this, treeNode);
        }

        public Object getCellValueAt(Object object, int n) {
            return null;
        }

        public String getNameString(TreeNode treeNode) {
            IXTNTreeTableNode iXTNTreeTableNode = (IXTNTreeTableNode)treeNode;
            List list = this.getProperties(iXTNTreeTableNode);
            String string = ((Named)((Object)iXTNTreeTableNode.node)).getName() + " " + UIUtil.show(list);
            return string;
        }

        void setColumnNames() {
            Class[] classArray = new Class[]{String.class, String.class};
            String[] stringArray = new String[]{"Name(properties)"};
            super.setColumnClasses(classArray);
            super.setColumnNames(stringArray);
        }

        protected List getProperties(IXTNTreeTableNode iXTNTreeTableNode) {
            TreeNode treeNode = iXTNTreeTableNode.node;
            List list = null;
            if (treeNode instanceof UIObjectClass) {
                HashSet hashSet = ((UIObjectClass)treeNode).getAllProperties();
                Debug.noteln("AROEd: props for " + treeNode + " are", UIUtil.show(hashSet));
                if (hashSet != null) {
                    list = new LinkedList(hashSet);
                }
            } else if (ObjectClass.class.isInstance(treeNode)) {
                list = ((ObjectClass)((Object)treeNode)).getObjectProperties();
            } else {
                return null;
            }
            return list;
        }

        public void reloadData() {
            List list = this.uiDomain.getAllObjectClasses();
            list = (List)IVUtil.sortNamedCollection(new ArrayList(list));
            ArrayList arrayList = new ArrayList(list);
            this.updateData(arrayList);
        }
    }

    class AROMouseAdapter
    extends MouseAdapter
    implements SchemaTerms {
        AROMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!AbstractButton.class.isInstance(component)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            IXEditorPanel iXEditorPanel = (IXEditorPanel)((Object)abstractButton.getParent().getParent());
            if (iXEditorPanel.getName().equals("SuperClassNames")) {
                if (abstractButton.getText() == "Add") {
                    AROEditorPanel.this.userAddParent();
                } else if (abstractButton.getText() == "Delete") {
                    AROEditorPanel.this.userDeleteParent();
                } else if (abstractButton.getText() == "Edit") {
                    AROEditorPanel.this.userEditParent();
                } else {
                    UIUtil.notImplemented(null, abstractButton.getText() + " for nodes");
                }
                return;
            }
            if (iXEditorPanel.getName().equals("SubClassNames")) {
                if (abstractButton.getText() == "Add") {
                    AROEditorPanel.this.userAddChild();
                } else if (abstractButton.getText() == "Delete") {
                    AROEditorPanel.this.userDeleteChild();
                } else if (abstractButton.getText() == "Edit") {
                    AROEditorPanel.this.userEditChild();
                } else {
                    UIUtil.notImplemented(null, abstractButton.getText() + " for nodes");
                }
                return;
            }
            if (iXEditorPanel.getName().equals("ObjectProperties")) {
                if (abstractButton.getText() == "Add") {
                    AROEditorPanel.this.userAddProperty();
                } else if (abstractButton.getText() == "Delete") {
                    AROEditorPanel.this.userDeleteProperty();
                } else if (abstractButton.getText() == "Edit") {
                    AROEditorPanel.this.userEditProperty();
                } else {
                    UIUtil.notImplemented(null, abstractButton.getText() + " for issues");
                }
                return;
            }
            UIUtil.notImplemented(null, "Command " + abstractButton.getText());
        }
    }

    public class AROFormPanel
    extends IFormPanel
    implements ConstructEditing {
        private UIObject uiConstruct;
        private AConstructFramePanel parent;
        HashSet actionListeners;

        public AROFormPanel(AConstructFramePanel aConstructFramePanel, IFormModel iFormModel) {
            super(iFormModel);
            this.actionListeners = new HashSet();
            this.parent = aConstructFramePanel;
            IXLabelRenderer iXLabelRenderer = new IXLabelRenderer(false){

                public void setInfo(Object object) {
                    ObjectProperty objectProperty = (ObjectProperty)object;
                    if (objectProperty == null) {
                        this.setText("");
                    } else {
                        String string = "";
                        String string2 = "";
                        if (objectProperty.getName() != null) {
                            string = objectProperty.getName().toString();
                        }
                        if (objectProperty.getSyntax() != null) {
                            string2 = objectProperty.getSyntax().toString();
                        }
                        this.setText(string + " [" + string2 + "]");
                        UIObjectClass uIObjectClass = (UIObjectClass)AROFormPanel.this.getUIConstruct();
                        if (uIObjectClass == null) {
                            return;
                        }
                        this.makeBold(uIObjectClass.isOwnProperty(objectProperty));
                    }
                }

                private void makeBold(boolean bl) {
                    Font font = this.getFont();
                    Font font2 = null;
                    font2 = bl ? new Font(font.getName(), 1, font.getSize()) : new Font(font.getName(), 0, font.getSize());
                    this.setFont(font2);
                }
            };
            this.setRenderer("objectProperties", iXLabelRenderer);
        }

        public UIDomain getUIDomain() {
            return this.parent.getUIDomain();
        }

        public void setConstruct(IXObject iXObject) {
            this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
        }

        public IXObject getConstruct() {
            if (this.uiConstruct == null) {
                return null;
            }
            return this.uiConstruct.getBaseObject();
        }

        public void setUIConstruct(UIObject uIObject) {
            if (this.uiConstruct != null) {
                this.uiConstruct.removeDataChangeListener(AROEditorPanel.this);
            }
            this.setUIConstructOnly(uIObject);
        }

        public void setUIConstructOnly(UIObject uIObject) {
            UIObject uIObject2 = this.uiConstruct;
            this.uiConstruct = uIObject;
            this.getModel().setObject(uIObject);
            this.parent.fireConstructChanged(uIObject2, uIObject, this);
            AROEditorPanel.this.classTree.showUserNode(this.uiConstruct, uIObject2);
            if (uIObject != null) {
                uIObject.addDataChangeListener(AROEditorPanel.this);
            }
        }

        public UIObject getUIConstruct() {
            return this.uiConstruct;
        }

        public void loadFromObject() {
            this.displayModelData();
        }

        public void undoSetValue(String string, Object object) {
            this.getModel().setValue(string, object);
        }

        public Object undoGetValue(String string) {
            return this.getModel().getValue(string);
        }
    }
}

