/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.VariableDeclaration;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXButPanel;
import ix.iface.ui.JObjectPopup;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstructEditing;
import ix.iview.ConstructFraming;
import ix.iview.DomainEditorFrame;
import ix.iview.UndoEditing;
import ix.iview.UndoManager;
import ix.iview.VarSpecifier;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.event.CurrentConstructListener;
import ix.iview.event.UndoChangeListener;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public abstract class AConstructFramePanel
extends JPanel
implements ConstructFraming,
VarSpecifier,
ActionListener,
UndoEditing,
DataChangeListener {
    public DomainEditorFrame parent;
    protected JScrollPane scrollPane = new JScrollPane();
    protected JPanel mainPanel;
    protected IFormPanel formPanel;
    private String alwaysSave = "always";
    private boolean doSwitch = true;
    protected boolean switching = false;
    private JModifyDialog modifyDialog;
    private UndoManager undoManager;
    HashSet currentConstructListeners = new HashSet();

    public AConstructFramePanel() {
    }

    public AConstructFramePanel(DomainEditorFrame domainEditorFrame) {
        this.parent = domainEditorFrame;
        this.setupEditor();
        if (this.mainPanel instanceof UndoEditing) {
            this.undoManager = new UndoManager(this);
            this.undoManager.addUndoListener(this.parent);
            this.addCurrentConstructListener(this.undoManager);
            this.undoManager.setConstruct(this.getUIConstruct());
        }
    }

    public void undoSetValue(String string, Object object) {
        if (this.mainPanel instanceof UndoEditing) {
            ((UndoEditing)((Object)this.mainPanel)).undoSetValue(string, object);
        } else {
            Debug.noteln("AFP: got undo set for field " + string + " val", object);
            Debug.noteln("Panel " + this.mainPanel.getName() + " cannot undoEdit");
        }
    }

    public Object undoGetValue(String string) {
        if (this.mainPanel instanceof UndoEditing) {
            return ((UndoEditing)((Object)this.mainPanel)).undoGetValue(string);
        }
        Debug.noteln("AFP: got undo get for field", string);
        return null;
    }

    protected void setupEditor() {
        this.setupOuterPanel();
        this.mainPanel = this.setupMainPanel();
        this.scrollPane.getViewport().add(this.mainPanel);
    }

    protected void setupOuterPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    protected abstract JPanel setupMainPanel();

    public ConstructEditing getEditingPanel() {
        if (this.mainPanel instanceof ConstructEditing) {
            return (ConstructEditing)((Object)this.mainPanel);
        }
        if (this instanceof ConstructEditing) {
            return (ConstructEditing)((Object)this);
        }
        if (this.formPanel instanceof ConstructEditing) {
            return (ConstructEditing)((Object)this.formPanel);
        }
        return null;
    }

    public void registerListKeys(JComponent jComponent, String string) {
        String string2 = "add " + string;
        AbstractAction abstractAction = new AbstractAction(string2){

            public void actionPerformed(ActionEvent actionEvent) {
                Debug.noteln("ACFP: Got key action");
                AConstructFramePanel.this.actionPerformed(actionEvent);
            }
        };
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(string2, abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), string2);
        inputMap.put(KeyStroke.getKeyStroke(155, 0), string2);
        string2 = "delete " + string;
        abstractAction = new AbstractAction(string2){

            public void actionPerformed(ActionEvent actionEvent) {
                AConstructFramePanel.this.actionPerformed(actionEvent);
            }
        };
        actionMap.put(string2, abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), string2);
    }

    public ConstructEditing getMainPanel() {
        return (ConstructEditing)((Object)this.mainPanel);
    }

    public void editConstruct(Object object) {
        if (object instanceof UIObject) {
            this.setUIConstruct((UIObject)object);
        } else if (object instanceof IXObject) {
            this.setConstruct((IXObject)object);
        } else if (object instanceof NodeSpec) {
            UIRefinement uIRefinement = new UIRefinement(this.getUIDomain());
            uIRefinement.setPattern(((NodeSpec)object).getPattern());
            if (uIRefinement.getName() == null) {
                uIRefinement.setName("undefined");
            }
            this.setUIConstruct(uIRefinement);
        }
    }

    public void deleteConstruct() {
        this.getUIDomain().removeConstruct(this.getUIConstruct());
        this.newConstruct();
    }

    public void copyConstruct() {
        UIObject uIObject = this.getUIConstruct();
        if (!uIObject.isEmpty() && this.beforeSwitching()) {
            UIObject uIObject2 = this.cloneConstruct(uIObject);
            if (uIObject2 == null) {
                UIUtil.notImplemented(this, "Copying this kind of construct");
            } else {
                String string = JOptionPane.showInputDialog(null, "Please enter the new name", uIObject.getName());
                uIObject2.setName(string);
                uIObject2.saveToDomain();
                this.getUIDomain().addConstruct(uIObject2);
                this.setUIConstructPanel(uIObject2);
                this.afterSwitching();
            }
        }
    }

    public void setUIConstructPanel(UIObject uIObject) {
        this.setUIConstruct(uIObject);
    }

    public Set search(String string) {
        List list = this.getAllConstructs();
        return IVUtil.findNameMatches(string, list);
    }

    public void viewChangesFromOriginal() {
        UIObject uIObject = this.getUIConstruct();
        if (uIObject == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIObject.collectChangesFromOriginal();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIObject.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void viewChanges() {
        UIObject uIObject = this.getUIConstruct();
        if (uIObject == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIObject.collectChanges();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIObject.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void saveConstruct() {
        UIObject uIObject = this.noteConstruct();
        this.setUIConstructPanel(uIObject);
    }

    public void revertConstruct() {
        UIObject uIObject = this.getUIConstruct();
        uIObject.loadFromDomain();
        this.setUIConstructPanel(uIObject);
    }

    public void revertOConstruct() {
        UIObject uIObject = this.getUIConstruct();
        uIObject.loadFromOriginal();
        this.setUIConstructPanel(uIObject);
    }

    public void setConstruct(IXObject iXObject) {
        UIObject uIObject = this.getUIConstruct();
        ((ConstructEditing)((Object)this.mainPanel)).setConstruct(iXObject);
        UIObject uIObject2 = this.getUIConstruct();
    }

    public void setUIConstruct(UIObject uIObject) {
        ConstructEditing constructEditing = (ConstructEditing)((Object)this.mainPanel);
        UIObject uIObject2 = constructEditing.getUIConstruct();
        if (uIObject2 != null && uIObject2.equals(uIObject)) {
            constructEditing.loadFromObject();
            if (this.undoManager != null) {
                this.undoManager.fireUndoChange();
            }
        } else {
            constructEditing.setUIConstruct(uIObject);
        }
    }

    public void OLDsetUIConstruct(UIObject uIObject) {
        ConstructEditing constructEditing = (ConstructEditing)((Object)this.mainPanel);
        UIObject uIObject2 = constructEditing.getUIConstruct();
        if (uIObject2 != null && uIObject2.equals(uIObject)) {
            constructEditing.loadFromObject();
            if (this.undoManager != null) {
                this.undoManager.fireUndoChange();
            }
        } else {
            constructEditing.setUIConstruct(uIObject);
        }
    }

    public UIObject getUIConstruct() {
        return ((ConstructEditing)((Object)this.mainPanel)).getUIConstruct();
    }

    public Domain getDomain() {
        return this.getUIDomain().getDomain();
    }

    public UIDomain getUIDomain() {
        return this.parent.getUIDomain();
    }

    public void setUIDomain(UIDomain uIDomain) {
        if (uIDomain.equals(this.getUIDomain())) {
            return;
        }
        this.parent.setUIDomain(uIDomain);
    }

    public void clear() {
        this.newConstruct();
    }

    public boolean canUndo() {
        if (this.undoManager == null) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        if (this.undoManager == null) {
            return false;
        }
        return this.undoManager.canRedo();
    }

    public boolean undo() {
        if (this.undoManager == null) {
            return false;
        }
        return this.undoManager.undo();
    }

    public boolean redo() {
        if (this.undoManager == null) {
            return false;
        }
        return this.undoManager.redo();
    }

    public void populatePopup(JObjectPopup jObjectPopup, Object object) {
    }

    public void addUndoListener(UndoChangeListener undoChangeListener) {
        if (this.undoManager != null) {
            this.undoManager.addUndoListener(undoChangeListener);
        }
    }

    public void addCurrentConstructListener(CurrentConstructListener currentConstructListener) {
        this.currentConstructListeners.add(currentConstructListener);
    }

    public void removeCurrentConstructListener(CurrentConstructListener currentConstructListener) {
        this.currentConstructListeners.add(currentConstructListener);
    }

    public void fireConstructChanged(UIObject uIObject, UIObject uIObject2, Component component) {
        if (this instanceof DataChangeListener && uIObject2 != null) {
            uIObject2.addDataChangeListener(this);
        }
        if (uIObject == null ? uIObject2 == null : uIObject == uIObject2) {
            return;
        }
        for (CurrentConstructListener currentConstructListener : this.currentConstructListeners) {
            currentConstructListener.constructChanged(component, uIObject, uIObject2);
        }
    }

    public boolean beforeClosing() {
        return this.beforeSwitching();
    }

    public boolean beforeOpening() {
        if (ConstructEditing.class.isInstance(this.mainPanel)) {
            this.setUIConstruct(this.getUIConstruct());
        }
        this.afterSwitching();
        return true;
    }

    public void afterSwitching() {
        if (this.undoManager != null) {
            this.undoManager.fireUndoChange();
        }
    }

    public boolean beforeSwitching() {
        if (!this.isVisible()) {
            return true;
        }
        this.switching = true;
        if (this.alwaysSave.equals("never")) {
            this.switching = false;
            return true;
        }
        UIObject uIObject = this.getUIConstruct();
        if (uIObject == null) {
            uIObject = this.makeNewConstruct();
        }
        ((ConstructEditing)((Object)this.mainPanel)).saveToObject(uIObject);
        ((ConstructEditing)((Object)this.mainPanel)).setUIConstruct(uIObject);
        if (!uIObject.hasChanged()) {
            this.switching = false;
            return true;
        }
        if (this.alwaysSave.equals("always")) {
            this.noteDraftConstruct(uIObject);
            this.switching = false;
            return true;
        }
        this.doSwitch = true;
        this.askModifyOptions(uIObject);
        this.switching = false;
        return this.doSwitch;
    }

    protected void askModifyOptions(UIObject uIObject) {
        Debug.noteln(this.getName() + " panel: Asking modify options for", uIObject);
        String[] stringArray = new String[]{"You have made changes in the panel.", "Do you want to modify the draft?"};
        Object[] objectArray = new Object[]{"Modify Draft", "Discard Changes", "Always Modify", "Always Discard"};
        Object object = JOptionPane.showInputDialog(this.parent, stringArray, "Confirm", 3, null, objectArray, objectArray[0]);
        if (object == null) {
            this.doSwitch = false;
        } else if (object.equals("Modify Draft")) {
            this.noteDraftConstruct(uIObject);
            this.doSwitch = true;
        } else if (object.equals("Discard Changes")) {
            uIObject.loadFromDomain();
            ((ConstructEditing)((Object)this.mainPanel)).setUIConstructOnly(uIObject);
            ((ConstructEditing)((Object)this.mainPanel)).loadFromObject();
            this.doSwitch = true;
        } else if (object.equals("Always Modify")) {
            this.alwaysSave = "always";
            this.noteDraftConstruct(uIObject);
            this.doSwitch = true;
        } else if (object.equals("Always Discard")) {
            this.alwaysSave = "never";
            uIObject.loadFromDomain();
            ((ConstructEditing)((Object)this.mainPanel)).setUIConstructOnly(uIObject);
            ((ConstructEditing)((Object)this.mainPanel)).loadFromObject();
            this.doSwitch = true;
        }
    }

    protected void askModifyDialog(UIObject uIObject) {
        if (this.modifyDialog == null) {
            this.modifyDialog = new JModifyDialog(this.parent, this, this.parent.modifyIcon);
        }
        this.modifyDialog.ask(uIObject);
    }

    protected void noteDraftConstruct(UIObject uIObject) {
        uIObject.noteChange();
        if (!this.getUIDomain().equals(uIObject.getUIDomain())) {
            uIObject.moveToUIDomain(this.getUIDomain());
        }
        this.getUIDomain().updateConstruct(uIObject);
        ((ConstructEditing)((Object)this.mainPanel)).setUIConstructOnly(uIObject);
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        if (editableObject == this.getUIConstruct() && string.equals("name") && this.getUIDomain() != null) {
            this.getUIConstruct().noteChange();
            this.getUIDomain().updateConstruct(this.getUIConstruct());
        }
    }

    public List getVarsToOffer() {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
            return uIRefinement.getVariableDeclarations();
        }
        catch (Exception exception) {
            Debug.describeException(exception);
            return null;
        }
    }

    public String addVariableDeclaration(String string) {
        VariableDeclaration variableDeclaration = IVUtil.makeVariableDeclaration(string);
        if (variableDeclaration != null) {
            try {
                UIRefinement uIRefinement = (UIRefinement)this.getUIConstruct();
                ArrayList<VariableDeclaration> arrayList = uIRefinement.getVariableDeclarations();
                if (arrayList == null) {
                    arrayList = new ArrayList<VariableDeclaration>();
                }
                arrayList.add(variableDeclaration);
                uIRefinement.setVariableDeclarations(arrayList);
                return variableDeclaration.getName().toString();
            }
            catch (Exception exception) {
                Debug.describeException(exception);
                return "";
            }
        }
        return "";
    }

    public void newConstruct() {
        this.setUIConstruct(this.makeNewConstruct());
    }

    public abstract void refresh();

    public abstract UIObject makeNewConstruct();

    protected abstract UIObject cloneConstruct(UIObject var1);

    public abstract boolean frameActionPerformed(ActionEvent var1);

    public abstract void actionPerformed(ActionEvent var1);

    protected abstract UIObject noteConstruct();

    protected class JModifyDialog
    extends JDialog {
        UIObject uio;
        AConstructFramePanel cPanel;
        String topString;
        String[] message;
        Object[] options;
        JLabel topLabel;
        JToggleButton askToggle;
        JToggleButton modToggle;
        JToggleButton discardToggle;
        ButtonGroup bg;
        MouseListener ml;
        JPanel butPanel;
        JPanel topPanel;

        protected JModifyDialog(JFrame jFrame, AConstructFramePanel aConstructFramePanel2, Icon icon) {
            this(jFrame, aConstructFramePanel2);
            this.topLabel.setHorizontalTextPosition(2);
            this.topLabel.setIcon(icon);
        }

        protected JModifyDialog(JFrame jFrame, AConstructFramePanel aConstructFramePanel2) {
            super((Frame)jFrame, true);
            this.topString = "Modify draft?";
            this.message = new String[]{"You have made changes in the editor.", "Do you want to:-", "- Modify: put the changes into the draft, then continue?", "- Discard: continue without noting changes?", "- Cancel: Do nothing?"};
            this.options = new Object[]{"Modify", "Discard", "Cancel"};
            this.askToggle = new JCheckBox("Always ask", true);
            this.modToggle = new JCheckBox("Always modify", false);
            this.discardToggle = new JCheckBox("Always discard", false);
            this.bg = new ButtonGroup();
            this.setDefaultCloseOperation(0);
            this.setLocationRelativeTo(aConstructFramePanel2);
            this.cPanel = aConstructFramePanel2;
            this.ml = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Component component = mouseEvent.getComponent();
                    if (!AbstractButton.class.isInstance(component)) {
                        return;
                    }
                    AbstractButton abstractButton = (AbstractButton)component;
                    String string = abstractButton.getActionCommand();
                    if (string.equals("Modify")) {
                        JModifyDialog.this.modify();
                    } else if (string.equals("Discard")) {
                        JModifyDialog.this.discard();
                    } else if (string.equals("Cancel")) {
                        JModifyDialog.this.cancel();
                    }
                }
            };
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.topPanel = new JPanel();
            this.butPanel = new IXButPanel(this.ml, 0, this.options);
            this.bg.add(this.askToggle);
            this.bg.add(this.modToggle);
            this.bg.add(this.discardToggle);
            this.askToggle.setActionCommand("");
            this.modToggle.setActionCommand("always");
            this.discardToggle.setActionCommand("never");
            this.topLabel = new JLabel(this.topString);
            new BoxLayout(jPanel, 0);
            GridLayout gridLayout = new GridLayout(this.message.length, 1);
            jPanel2.setLayout(gridLayout);
            for (int i = 0; i < this.message.length; ++i) {
                jPanel2.add(new JLabel(this.message[i]));
            }
            jPanel.add(this.askToggle);
            jPanel.add(this.modToggle);
            jPanel.add(this.discardToggle);
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(borderLayout.getVgap() + 10);
            this.topPanel.setLayout(borderLayout);
            this.topPanel.add((Component)jPanel2, "Center");
            this.topPanel.add((Component)jPanel, "South");
            BorderLayout borderLayout2 = new BorderLayout();
            borderLayout2.setVgap(borderLayout2.getVgap() + 10);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.topLabel, "North");
            this.getContentPane().add((Component)this.topPanel, "Center");
            this.getContentPane().add((Component)this.butPanel, "South");
            this.pack();
            this.setSize(this.getWidth(), this.getHeight() + 1);
            this.validate();
        }

        public void ask(UIObject uIObject) {
            this.uio = uIObject;
            this.topLabel.setText(this.topString + " (" + uIObject.getName() + ")");
            this.setVisible(true);
        }

        private void modify() {
            this.setAlways();
            if (this.uio == null) {
                return;
            }
            AConstructFramePanel.this.noteDraftConstruct(this.uio);
            this.cPanel.doSwitch = true;
            this.dispose();
        }

        private void discard() {
            this.setAlways();
            if (this.uio == null) {
                return;
            }
            this.uio.loadFromDomain();
            ((ConstructEditing)((Object)this.cPanel.mainPanel)).setUIConstructOnly(this.uio);
            ((ConstructEditing)((Object)this.cPanel.mainPanel)).loadFromObject();
            this.cPanel.doSwitch = true;
            this.dispose();
        }

        private void cancel() {
            this.cPanel.doSwitch = false;
            this.dispose();
        }

        private void setAlways() {
            ButtonModel buttonModel = this.bg.getSelection();
            String string = buttonModel.getActionCommand();
            if (string == null) {
                return;
            }
            this.cPanel.alwaysSave = string;
        }
    }

    protected class FieldValue {
        protected String field;
        protected Object value;

        protected FieldValue(String string, Object object) {
            this.field = string;
            this.value = object;
        }
    }
}

